<?php

/**
 * i-Educar - Sistema de gesto escolar
 *
 * Copyright (C) 2006  Prefeitura Municipal de Itaja
 *                     <ctima@itajai.sc.gov.br>
 *
 * Este programa  software livre; voc pode redistribu-lo e/ou modific-lo
 * sob os termos da Licena Pblica Geral GNU conforme publicada pela Free
 * Software Foundation; tanto a verso 2 da Licena, como (a seu critrio)
 * qualquer verso posterior.
 *
 * Este programa  distribudo na expectativa de que seja til, porm, SEM
 * NENHUMA GARANTIA; nem mesmo a garantia implcita de COMERCIABILIDADE OU
 * ADEQUAO A UMA FINALIDADE ESPECFICA. Consulte a Licena Pblica Geral
 * do GNU para mais detalhes.
 *
 * Voc deve ter recebido uma cpia da Licena Pblica Geral do GNU junto
 * com este programa; se no, escreva para a Free Software Foundation, Inc., no
 * endereo 59 Temple Street, Suite 330, Boston, MA 02111-1307 USA.
 *
 * @author      Eriksen Costa Paixo <eriksen.paixao_bs@cobra.com.br>
 * @category    i-Educar
 * @license     @@license@@
 * @package     RegraAvaliacao
 * @subpackage  Modules
 * @since       Arquivo disponvel desde a verso 1.1.0
 * @version     $Id$
 */

require_once 'Core/Controller/Page/ViewController.php';
require_once 'RegraAvaliacao/Model/RegraDataMapper.php';

/**
 * ViewController class.
 *
 * @author      Eriksen Costa Paixo <eriksen.paixao_bs@cobra.com.br>
 * @category    i-Educar
 * @license     @@license@@
 * @package     RegraAvaliacao
 * @subpackage  Modules
 * @since       Classe disponvel desde a verso 1.1.0
 * @version     @@package_version@@
 */
class ViewController extends Core_Controller_Page_ViewController
{
  protected $_dataMapper = 'RegraAvaliacao_Model_RegraDataMapper';
  protected $_titulo     = 'Detalhes da regra de avaliao';
  protected $_processoAp = 947;
  protected $_tableMap   = array(
    'Nome' => 'nome',
    'Sistema de nota' => 'tipoNota',
    'Tabela de arredondamento' => 'tabelaArredondamento',
    'Progresso' => 'tipoProgressao',
    'Mdia para promoo' => 'media',
    'Mdia exame para promoo' => 'mediaRecuperacao',
    'Frmula de clculo de mdia final' => 'formulaMedia',
    'Frmula de clculo de recuperao' => 'formulaRecuperacao',
    'Porcentagem presena' => 'porcentagemPresenca',
    'Parecer descritivo' => 'parecerDescritivo',
    'Tipo de presena' => 'tipoPresenca'
  );
  protected function _preRender(){

    Portabilis_View_Helper_Application::loadStylesheet($this, 'intranet/styles/localizacaoSistema.css');

    $localizacao = new LocalizacaoSistema();

    $localizacao->entradaCaminhos( array(
         $_SERVER['SERVER_NAME']."/intranet" => "In&iacute;cio",
         "educar_index.php"                  => "i-Educar - Escola",
         ""                                  => "Detalhe da regra de avalia&ccedil;&otilde;o"             
    ));
    $this->enviaLocalizacao($localizacao->montar());     
  }  
}
