<?php

/**
 * i-Educar - Sistema de gesto escolar
 *
 * Copyright (C) 2006  Prefeitura Municipal de Itaja
 *                     <ctima@itajai.sc.gov.br>
 *
 * Este programa  software livre; voc pode redistribu-lo e/ou modific-lo
 * sob os termos da Licena Pblica Geral GNU conforme publicada pela Free
 * Software Foundation; tanto a verso 2 da Licena, como (a seu critrio)
 * qualquer verso posterior.
 *
 * Este programa  distribudo na expectativa de que seja til, porm, SEM
 * NENHUMA GARANTIA; nem mesmo a garantia implcita de COMERCIABILIDADE OU
 * ADEQUAO A UMA FINALIDADE ESPECFICA. Consulte a Licena Pblica Geral
 * do GNU para mais detalhes.
 *
 * Voc deve ter recebido uma cpia da Licena Pblica Geral do GNU junto
 * com este programa; se no, escreva para a Free Software Foundation, Inc., no
 * endereo 59 Temple Street, Suite 330, Boston, MA 02111-1307 USA.
 *
 * @author      Eriksen Costa Paixo <eriksen.paixao_bs@cobra.com.br>
 * @category    i-Educar
 * @license     @@license@@
 * @package     TabelaArredondamento
 * @subpackage  Modules
 * @since       Arquivo disponvel desde a verso 1.1.0
 * @version     $Id$
 */

require_once 'CoreExt/DataMapper.php';
require_once 'TabelaArredondamento/Model/Tabela.php';
require_once 'RegraAvaliacao/Model/Nota/TipoValor.php';
require_once 'App/Model/IedFinder.php';

/**
 * TabelaArredondamento_Model_TabelaDataMapper class.
 *
 * @author      Eriksen Costa Paixo <eriksen.paixao_bs@cobra.com.br>
 * @category    i-Educar
 * @license     @@license@@
 * @package     TabelaArredondamento
 * @subpackage  Modules
 * @since       Classe disponvel desde a verso 1.1.0
 * @version     @@package_version@@
 */
class TabelaArredondamento_Model_TabelaDataMapper extends CoreExt_DataMapper
{
  protected $_entityClass = 'TabelaArredondamento_Model_Tabela';
  protected $_tableName   = 'tabela_arredondamento';
  protected $_tableSchema = 'modules';

  protected $_attributeMap = array(
    'instituicao' => 'instituicao_id',
    'tipoNota'    => 'tipo_nota'
  );

  /**
   * @var TabelaArredondamento_Model_TabelaValorDataMapper
   */
  protected $_tabelaValorDataMapper = NULL;

  /**
   * Setter.
   * @param TabelaArredondamento_Model_TabelaValorDataMapper $mapper
   * @return CoreExt_DataMapper Prov interface fluda
   */
  public function setTabelaValorDataMapper(TabelaArredondamento_Model_TabelaValorDataMapper $mapper)
  {
    $this->_tabelaValorDataMapper = $mapper;
    return $this;
  }

  /**
   * Getter.
   * @return TabelaArredondamento_Model_TabelaValorDataMappers
   */
  public function getTabelaValorDataMapper()
  {
    if (is_null($this->_tabelaValorDataMapper)) {
      require_once 'TabelaArredondamento/Model/TabelaValorDataMapper.php';
      $this->setTabelaValorDataMapper(new TabelaArredondamento_Model_TabelaValorDataMapper());
    }
    return $this->_tabelaValorDataMapper;
  }

  /**
   * Finder para instncias de TabelaArredondamento_Model_TabelaValor que tenham
   * referncias a instncia TabelaArredondamento_Model_Tabela passada como
   * parmetro.
   *
   * @param TabelaArredondamento_Model_Tabela $instance
   * @return array Um array de instncias TabelaArredondamento_Model_TabelaValor
   */
  public function findTabelaValor(TabelaArredondamento_Model_Tabela $instance)
  {
    $where = array(
      'tabelaArredondamento' => $instance->id
    );
    return $this->getTabelaValorDataMapper()->findAll(array(), $where);
  }
}