<?php

/**
 * i-Educar - Sistema de gesto escolar
 *
 * Copyright (C) 2006  Prefeitura Municipal de Itaja
 *                     <ctima@itajai.sc.gov.br>
 *
 * Este programa  software livre; voc pode redistribu-lo e/ou modific-lo
 * sob os termos da Licena Pblica Geral GNU conforme publicada pela Free
 * Software Foundation; tanto a verso 2 da Licena, como (a seu critrio)
 * qualquer verso posterior.
 *
 * Este programa  distribudo na expectativa de que seja til, porm, SEM
 * NENHUMA GARANTIA; nem mesmo a garantia implcita de COMERCIABILIDADE OU
 * ADEQUAO A UMA FINALIDADE ESPECFICA. Consulte a Licena Pblica Geral
 * do GNU para mais detalhes.
 *
 * Voc deve ter recebido uma cpia da Licena Pblica Geral do GNU junto
 * com este programa; se no, escreva para a Free Software Foundation, Inc., no
 * endereo 59 Temple Street, Suite 330, Boston, MA 02111-1307 USA.
 *
 * @author      Eriksen Costa Paixo <eriksen.paixao_bs@cobra.com.br>
 * @category    i-Educar
 * @license     @@license@@
 * @package     TabelaArredondamento
 * @subpackage  UnitTests
 * @since       Arquivo disponvel desde a verso 1.1.0
 * @version     $Id$
 */

require_once 'TabelaArredondamento/Model/TabelaDataMapper.php';
require_once 'TabelaArredondamento/Model/TabelaValor.php';
require_once 'TabelaArredondamento/Model/TabelaValorDataMapper.php';

/**
 * TabelaDataMapperTest class.
 *
 * @author      Eriksen Costa Paixo <eriksen.paixao_bs@cobra.com.br>
 * @category    i-Educar
 * @license     @@license@@
 * @package     TabelaArredondamento
 * @subpackage  UnitTests
 * @since       Classe disponvel desde a verso 1.1.0
 * @version     @@package_version@@
 */
class TabelaDataMapperTest extends UnitBaseTest
{
  protected $_mapper = NULL;

  protected function setUp()
  {
    $this->_mapper = new TabelaArredondamento_Model_TabelaDataMapper();
  }

  public function testGetterDeValorDataMapperInstanciaObjetoPorPadraoSeNenhumForConfigurado()
  {
    $this->assertType('TabelaArredondamento_Model_TabelaValorDataMapper', $this->_mapper->getTabelaValorDataMapper());
  }

  public function testFinderTabelaValor()
  {
    // Instncia de Tabela
    $instance = new TabelaArredondamento_Model_Tabela(array(
      'id' => 1, 'instituicao' => 1, 'tipoNota' => RegraAvaliacao_Model_Nota_TipoValor::NUMERICA
    ));

    // Prepara dados para o mock
    $data = array(
      'tabelaArredondamento' => 1,
      'nome'                 => NULL,
      'descricao'            => NULL,
      'valorMinimo'          => 0,
      'valorMaximo'          => 1
    );

    // Dados de retorno, popula para mock
    $returnValue = array();
    for ($i = 1; $i < 4; $i++) {
      $data['nome']      = $i;
      $data['descricao'] = '';
      $returnValue[] = new TabelaArredondamento_Model_TabelaValor($data);
      $data['valorMinimo'] = $data['valorMinimo'] + 1;
      $data['valorMaximo'] = $data['valorMaximo'] + 1;
    }

    // Expectativa do mock
    $mock = $this->getCleanMock('TabelaArredondamento_Model_TabelaValorDataMapper');
    $mock->expects($this->once())
         ->method('findAll')
         ->with(array(), array('tabelaArredondamento' => 1))
         ->will($this->returnValue($returnValue));

     // Chama o mtodo finder
     $this->_mapper->setTabelaValorDataMapper($mock);
     $returned = $this->_mapper->findTabelaValor($instance);

     // Asseres
     $this->assertEquals($returnValue[0], $returned[0]);
     $this->assertEquals($returnValue[1], $returned[1]);
     $this->assertEquals($returnValue[2], $returned[2]);
  }
}