<?php

/**
 * i-Educar - Sistema de gesto escolar
 *
 * Copyright (C) 2006  Prefeitura Municipal de Itaja
 *                     <ctima@itajai.sc.gov.br>
 *
 * Este programa  software livre; voc pode redistribu-lo e/ou modific-lo
 * sob os termos da Licena Pblica Geral GNU conforme publicada pela Free
 * Software Foundation; tanto a verso 2 da Licena, como (a seu critrio)
 * qualquer verso posterior.
 *
 * Este programa  distribudo na expectativa de que seja til, porm, SEM
 * NENHUMA GARANTIA; nem mesmo a garantia implcita de COMERCIABILIDADE OU
 * ADEQUAO A UMA FINALIDADE ESPECFICA. Consulte a Licena Pblica Geral
 * do GNU para mais detalhes.
 *
 * Voc deve ter recebido uma cpia da Licena Pblica Geral do GNU junto
 * com este programa; se no, escreva para a Free Software Foundation, Inc., no
 * endereo 59 Temple Street, Suite 330, Boston, MA 02111-1307 USA.
 *
 * @author      Eriksen Costa Paixo <eriksen.paixao_bs@cobra.com.br>
 * @category    i-Educar
 * @license     @@license@@
 * @package     Transporte
 * @subpackage  UnitTests
 * @since       Arquivo disponvel desde a verso 1.2.0
 * @version     $Id$
 */

require_once 'Transporte/Model/Aluno.php';
require_once 'Transporte/Model/Responsavel.php';

/**
 * Transporte_Model_AlunoTest class.
 *
 * @author      Eriksen Costa Paixo <eriksen.paixao_bs@cobra.com.br>
 * @category    i-Educar
 * @license     @@license@@
 * @package     Transporte
 * @subpackage  UnitTests
 * @since       Classe disponvel desde a verso 1.2.0
 * @version     @@package_version@@
 */
class Transporte_Model_AlunoTest extends UnitBaseTest
{
  protected $_entity = NULL;

  protected function setUp()
  {
    $this->_entity = new Transporte_Model_Aluno();
  }

  public function testEntityValidators()
  {
    // Recupera os objetos CoreExt_Validate
    $validators = $this->_entity->getDefaultValidatorCollection();
    $this->assertType('CoreExt_Validate_Numeric', $validators['aluno']);
    $this->assertType('CoreExt_Validate_Choice',  $validators['responsavel']);
    $this->assertType('CoreExt_Validate_Numeric', $validators['user']);

    // Verifica se a opo 'choices' corresponde aos valores do Enum Responsavel.
    $responsavel = Transporte_Model_Responsavel::getInstance();
    $this->assertEquals(
      $responsavel->getKeys(), $validators['responsavel']->getOption('choices')
    );
  }
}