<?php

/**
 * i-Educar - Sistema de gesto escolar
 *
 * Copyright (C) 2006  Prefeitura Municipal de Itaja
 *                     <ctima@itajai.sc.gov.br>
 *
 * Este programa  software livre; voc pode redistribu-lo e/ou modific-lo
 * sob os termos da Licena Pblica Geral GNU conforme publicada pela Free
 * Software Foundation; tanto a verso 2 da Licena, como (a seu critrio)
 * qualquer verso posterior.
 *
 * Este programa  distribudo na expectativa de que seja til, porm, SEM
 * NENHUMA GARANTIA; nem mesmo a garantia implcita de COMERCIABILIDADE OU
 * ADEQUAO A UMA FINALIDADE ESPECFICA. Consulte a Licena Pblica Geral
 * do GNU para mais detalhes.
 *
 * Voc deve ter recebido uma cpia da Licena Pblica Geral do GNU junto
 * com este programa; se no, escreva para a Free Software Foundation, Inc., no
 * endereo 59 Temple Street, Suite 330, Boston, MA 02111-1307 USA.
 *
 * @author      Lucas D'Avila <lucasdavila@portabilis.com.br>
 * @category    i-Educar
 * @license     @@license@@
 * @package     Usuario
 * @subpackage  Modules
 * @since       Arquivo disponvel desde a verso 1.1.0
 * @version     $Id$
 */

require_once 'CoreExt/DataMapper.php';
require_once 'Usuario/Model/Funcionario.php';

/**
 * Usuario_Model_FuncionarioDataMapper class.
 *
 * @author      Lucas D'Avila <lucasdavila@portabilis.com.br>
 * @category    i-Educar
 * @license     @@license@@
 * @package     Usuario
 * @subpackage  Modules
 * @since       Classe disponvel desde a verso 1.1.0
 * @version     @@package_version@@
 */
class Usuario_Model_FuncionarioDataMapper extends CoreExt_DataMapper
{
  protected $_entityClass = 'Usuario_Model_Funcionario';
  protected $_tableName   = 'funcionario';
  protected $_tableSchema = 'portal';

  protected $_attributeMap = array(
    #'ref_cod_pessoa_fj' => 'ref_cod_pessoa_fj',
    #'matricula'         => 'matricula',
    #'email'             => 'email',
    #'data_troca_senha'  => 'data_troca_senha'
  );

  protected $_notPersistable = array(
    #'ippes'
  );

  protected $_primaryKey = array('ref_cod_pessoa_fj');

  protected function _getFindStatment($pkey)
  {
    if (!is_array($pkey))
      $pkey = array("ref_cod_pessoa_fj" => $pkey);

    return parent::_getFindStatment($pkey);
  }
}
