<?php

/**
 * i-Educar - Sistema de gesto escolar
 *
 * Copyright (C) 2006  Prefeitura Municipal de Itaja
 *                     <ctima@itajai.sc.gov.br>
 *
 * Este programa  software livre; voc pode redistribu-lo e/ou modific-lo
 * sob os termos da Licena Pblica Geral GNU conforme publicada pela Free
 * Software Foundation; tanto a verso 2 da Licena, como (a seu critrio)
 * qualquer verso posterior.
 *
 * Este programa  distribudo na expectativa de que seja til, porm, SEM
 * NENHUMA GARANTIA; nem mesmo a garantia implcita de COMERCIABILIDADE OU
 * ADEQUAO A UMA FINALIDADE ESPECFICA. Consulte a Licena Pblica Geral
 * do GNU para mais detalhes.
 *
 * Voc deve ter recebido uma cpia da Licena Pblica Geral do GNU junto
 * com este programa; se no, escreva para a Free Software Foundation, Inc., no
 * endereo 59 Temple Street, Suite 330, Boston, MA 02111-1307 USA.
 *
 * @author    Eriksen Costa Paixo <eriksen.paixao_bs@cobra.com.br>
 * @category  i-Educar
 * @license   @@license@@
 * @package   IntegrationTests
 * @since     Arquivo disponvel desde a verso 1.1.0
 * @version   $Id$
 */

/**
 * CustomPdo class.
 *
 * Sobrescreve mtodos especficos de clsBanco para permitir testes de
 * integrao com o DbUnit, usando uma conexo Pdo por trs das cenas.
 *
 * Os mtodos sobrescritos tem comportamento semelhante ao original, exceto
 * que, ao invs de usar uma conexo ext/pgsql, a ext/pdo_pgsql  utilizada.
 *
 * @author    Eriksen Costa Paixo <eriksen.paixao_bs@cobra.com.br>
 * @category  i-Educar
 * @license   @@license@@
 * @package   IntegrationTests
 * @since     Classe disponvel desde a verso 1.1.0
 * @todo      Adicionar a verificao a extenso mbstring antes de fazer a
 *   converso em _decodeUtf8 j que no  padro no PHP (podendo ser
 *   desabilitada). Como  usada apenas para os testes, no interfere no uso
 *   da aplicao.
 * @version   @@package_version@@
 */
class CustomPdo extends clsBanco
{
  /**
   * Objeto PDO.
   * @var PDO
   */
  protected $_pdo = NULL;

  /**
   * Result set PDOStatment.
   * @var PDOStatment
   */
  protected $_rs  = NULL;

  /**
   * Array associativo de um registro de tabela de banco de dados.
   * @var array
   */
  protected $_row = array();

  /**
   * Modo de fetch utilizado por PDO::query().
   * @var int
   */
  protected $_fetchMode = PDO::FETCH_ASSOC;

  /**
   * Construtor.
   *
   * @param string $dsn
   * @param string $username
   * @param string $password
   * @param array  $driverOptions
   */
  public function __construct($dsn = '', $username = '', $password = '',
    array $driverOptions = array())
  {
    $this->_pdo = new PDO($dsn, $username, $password, $driverOptions);
  }

  /**
   * Retorna a instncia PDO atual.
   * @return PDO
   */
  public function getPdo()
  {
    return $this->_pdo;
  }

  /**
   * Sobrescreve o mtodo Consulta(), usando a mesma conexo PDO utilizada
   * pelo DbUnit.
   *
   * @param  string $sql
   * @param  bool   $reescrever
   * @return CustomPdo Prov interface fluda
   * @see    intranet/include/clsBancoSQL_#Consulta($consulta)
   */
  public function Consulta($sql, $reescrever = TRUE)
  {
    $this->_rs = $this->_pdo->query($sql);
    return $this;
  }

  /**
   * Move o ponteiro e retorna uma registro do result set PDOStatment.
   *
   * @return mixed|bool Retorna FALSE em caso de erro
   * @see intranet/include/clsBancoSQL_#ProximoRegistro()
   */
  public function ProximoRegistro()
  {
    $row = $this->_rs->fetch($this->_fetchMode);
    if (is_array($row)) {
      array_walk_recursive($row, array($this, '_decodeUtf8'));
    }
    return $this->_row = $row;
  }

  /**
   * Retorna o registro atual indicado por ProximoRegistro();
   *
   * @return mixed|bool
   * @see intranet/include/clsBancoSQL_#Tupla()
   */
  public function Tupla()
  {
    $row = $this->_row;
    return $row;
  }

  /**
   * Callback para ProximoRegistro(), converte uma referncia para ISO-8859-1
   * caso esteja em UTF-8. Isso  feito pois o SQLite no permite mudar o
   * encoding de uma conexo ativa para ISO-8859-1.
   *
   * @link http://www.sqlite.org/pragma.html Veja PRAGMA encoding para mais
   *   informaes sobre os encodings suportados pelo SQLite
   * @see  Docblock de CustomPdo para mais informaes sobre mbstring
   */
  protected function _decodeUtf8(&$item, $key)
  {
    if ('UTF-8' == ($actual = mb_detect_encoding($item))) {
      $item = utf8_decode($item);
    }
  }
}