<?php

/**
 * i-Educar - Sistema de gesto escolar
 *
 * Copyright (C) 2006  Prefeitura Municipal de Itaja
 *                     <ctima@itajai.sc.gov.br>
 *
 * Este programa  software livre; voc pode redistribu-lo e/ou modific-lo
 * sob os termos da Licena Pblica Geral GNU conforme publicada pela Free
 * Software Foundation; tanto a verso 2 da Licena, como (a seu critrio)
 * qualquer verso posterior.
 *
 * Este programa  distribudo na expectativa de que seja til, porm, SEM
 * NENHUMA GARANTIA; nem mesmo a garantia implcita de COMERCIABILIDADE OU
 * ADEQUAO A UMA FINALIDADE ESPECFICA. Consulte a Licena Pblica Geral
 * do GNU para mais detalhes.
 *
 * Voc deve ter recebido uma cpia da Licena Pblica Geral do GNU junto
 * com este programa; se no, escreva para a Free Software Foundation, Inc., no
 * endereo 59 Temple Street, Suite 330, Boston, MA 02111-1307 USA.
 *
 * @author    Eriksen Costa Paixo <eriksen.paixao_bs@cobra.com.br>
 * @category  i-Educar
 * @license   @@license@@
 * @package   IntegrationTests
 * @since     Arquivo disponvel desde a verso 1.1.0
 * @version   $Id$
 */

require_once 'PHPUnit/Extensions/Database/TestCase.php';
require_once 'CoreExt/DataMapper.php';

/**
 * IntegrationBaseTest abstract class.
 *
 * Cria um ambiente de testes de integrao com um banco de dados sqlite em
 * memria. til para os testes dos novos componentes de domnio.
 *
 * @author    Eriksen Costa Paixo <eriksen.paixao_bs@cobra.com.br>
 * @category  i-Educar
 * @license   @@license@@
 * @package   IntegrationTests
 * @since     Classe disponvel desde a verso 1.1.0
 * @version   @@package_version@@
 */
abstract class IntegrationBaseTest extends PHPUnit_Extensions_Database_TestCase
{
  /**
   * Objeto de conexo com o banco de dados que ser utilizado tanto pelas
   * classes da aplicao quanto pelos testes de integrao.
   *
   * @var CustomPdo
   */
  protected $db = NULL;

  /**
   * Construtor.
   */
  public function __construct()
  {
    $this->db = new CustomPdo('sqlite::memory:');
  }

  /**
   * Usa o setUp() para configurar a todas as instncias de CoreExt_DataMapper
   * que usem o adapter de banco dessa classe.
   */
  protected function setUp()
  {
    parent::setUp();
    CoreExt_DataMapper::setDefaultDbAdapter($this->getDbAdapter());
  }

  /**
   * Getter.
   * @return CustomPdo
   */
  protected function getDbAdapter()
  {
    return $this->db;
  }

  /**
   * Retorna a conexo usada pelos testes de integrao do DbUnit. Note que
   * a conexo  criada com o objeto PDO encapsulado em CustomPdo.
   *
   * @return PHPUnit_Extensions_Database_DB_DefaultDatabaseConnection
   */
  protected function getConnection()
  {
    return $this->createDefaultDBConnection($this->db->getPdo(), 'testdb');
  }

  /**
   * Retorna o caminho absoluto para um arquivo fixture em unit/CoreExt/.
   *
   * @param string $filename
   * @return string
   */
  public function getFixture($filename)
  {
    $path = dirname(__FILE__);
    return $path . '/unit/CoreExt/_fixtures/' . $filename;
  }

/**
   * Retorna o caminho absoluto para um arquivo fixture dentro do diretrio
   * _tests de um mdulo.
   *
   * @param  string $filename
   * @return string
   */
  public function getFixtureForModule($filename, $module)
  {
    $path = PROJECT_ROOT . DS . 'modules' . DS . $module . DS . '_tests';
    return $path . DS . $filename;
  }
}