<?php

/**
 * i-Educar - Sistema de gesto escolar
 *
 * Copyright (C) 2006  Prefeitura Municipal de Itaja
 *                     <ctima@itajai.sc.gov.br>
 *
 * Este programa  software livre; voc pode redistribu-lo e/ou modific-lo
 * sob os termos da Licena Pblica Geral GNU conforme publicada pela Free
 * Software Foundation; tanto a verso 2 da Licena, como (a seu critrio)
 * qualquer verso posterior.
 *
 * Este programa  distribudo na expectativa de que seja til, porm, SEM
 * NENHUMA GARANTIA; nem mesmo a garantia implcita de COMERCIABILIDADE OU
 * ADEQUAO A UMA FINALIDADE ESPECFICA. Consulte a Licena Pblica Geral
 * do GNU para mais detalhes.
 *
 * Voc deve ter recebido uma cpia da Licena Pblica Geral do GNU junto
 * com este programa; se no, escreva para a Free Software Foundation, Inc., no
 * endereo 59 Temple Street, Suite 330, Boston, MA 02111-1307 USA.
 *
 * @author    Eriksen Costa Paixo <eriksen.paixao_bs@cobra.com.br>
 * @category  i-Educar
 * @license   @@license@@
 * @package   Tests
 * @since     Arquivo disponvel desde a verso 1.1.0
 * @version   $Id$
 */

/**
 * Arquivo de bootstrap para os testes do projeto. Configura o include_path e
 * inclui alguns arquivos necessrios nos testes unitrios e funcionais.
 */

error_reporting(E_ALL ^ E_STRICT);

// Diretrio raiz do projeto.
$root = realpath(dirname(__FILE__) . '/../');

// Adiciona os diretrios tests/unit, tests/functional, tests/, ./ e intranet/
// ao include_path.
$paths = array();
$paths[] = join(DIRECTORY_SEPARATOR, array($root, 'tests', 'unit'));
$paths[] = join(DIRECTORY_SEPARATOR, array($root, 'tests', 'functional'));
$paths[] = join(DIRECTORY_SEPARATOR, array($root, 'tests'));
$paths[] = join(DIRECTORY_SEPARATOR, array($root, '.'));
$paths[] = join(DIRECTORY_SEPARATOR, array($root, 'intranet'));

// Configura o include_path.
set_include_path(join(PATH_SEPARATOR, $paths) . PATH_SEPARATOR . get_include_path());

// Altera as configuraes de session para os testes. No usa cookies para
// permitir o teste de CoreExt_Session, j que o test runner do PHPUnit faz
// sada de buffer.
ini_set('session.use_cookies', 0);

// Arquivos em intranet/ usam includes com caminho relativo, muda diretrio
// atual para evitar warnings e errors.
chdir($root . '/intranet');
unset($root, $paths);

require_once 'include/clsBanco.inc.php';
require_once 'CustomPdo.php';
require_once 'TestCollector.php';
require_once 'UnitBaseTest.class.php';
require_once 'IntegrationBaseTest.php';
require_once 'FunctionalBaseTest.class.php';