<?php

/**
 * i-Educar - Sistema de gesto escolar
 *
 * Copyright (C) 2006  Prefeitura Municipal de Itaja
 *                     <ctima@itajai.sc.gov.br>
 *
 * Este programa  software livre; voc pode redistribu-lo e/ou modific-lo
 * sob os termos da Licena Pblica Geral GNU conforme publicada pela Free
 * Software Foundation; tanto a verso 2 da Licena, como (a seu critrio)
 * qualquer verso posterior.
 *
 * Este programa  distribudo na expectativa de que seja til, porm, SEM
 * NENHUMA GARANTIA; nem mesmo a garantia implcita de COMERCIABILIDADE OU
 * ADEQUAO A UMA FINALIDADE ESPECFICA. Consulte a Licena Pblica Geral
 * do GNU para mais detalhes.
 *
 * Voc deve ter recebido uma cpia da Licena Pblica Geral do GNU junto
 * com este programa; se no, escreva para a Free Software Foundation, Inc., no
 * endereo 59 Temple Street, Suite 330, Boston, MA 02111-1307 USA.
 *
 * @author    Eriksen Costa Paixo <eriksen.paixao_bs@cobra.com.br>
 * @category  i-Educar
 * @license   @@license@@
 * @package   UnitTests
 * @since     Arquivo disponvel desde a verso 1.1.0
 * @version   $Id$
 */

require_once 'App/AllTests.php';
require_once 'Core/AllTests.php';
require_once 'CoreExt/AllTests.php';
require_once 'Utils/AllTests.php';
require_once 'Modules/AllTests.php';

/**
 * Unit_AllTests class.
 *
 * Arquivo de definio de sute de testes unitrios.
 *
 * @author    Eriksen Costa Paixo <eriksen.paixao_bs@cobra.com.br>
 * @category  i-Educar
 * @license   @@license@@
 * @package   UnitTests
 * @since     Classe disponvel desde a verso 1.1.0
 * @version   @@package_version@@
 */
class Unit_AllTests
{
  public static function suite()
  {
    $suite = new PHPUnit_Framework_TestSuite('Sute de testes unitrios do projeto');
    $suite->addTest(App_AllTests::suite());
    $suite->addTest(Core_AllTests::suite());
    $suite->addTest(CoreExt_AllTests::suite());
    $suite->addTest(Utils_AllTests::suite());
    $suite->addTest(Modules_AllTests::suite());
    return $suite;
  }
}