<?php

/**
 * i-Educar - Sistema de gesto escolar
 *
 * Copyright (C) 2006  Prefeitura Municipal de Itaja
 *                     <ctima@itajai.sc.gov.br>
 *
 * Este programa  software livre; voc pode redistribu-lo e/ou modific-lo
 * sob os termos da Licena Pblica Geral GNU conforme publicada pela Free
 * Software Foundation; tanto a verso 2 da Licena, como (a seu critrio)
 * qualquer verso posterior.
 *
 * Este programa  distribudo na expectativa de que seja til, porm, SEM
 * NENHUMA GARANTIA; nem mesmo a garantia implcita de COMERCIABILIDADE OU
 * ADEQUAO A UMA FINALIDADE ESPECFICA. Consulte a Licena Pblica Geral
 * do GNU para mais detalhes.
 *
 * Voc deve ter recebido uma cpia da Licena Pblica Geral do GNU junto
 * com este programa; se no, escreva para a Free Software Foundation, Inc., no
 * endereo 59 Temple Street, Suite 330, Boston, MA 02111-1307 USA.
 *
 * @author      Eriksen Costa Paixo <eriksen.paixao_bs@cobra.com.br>
 * @category    i-Educar
 * @license     @@license@@
 * @package     App_Date
 * @subpackage  UnitTests
 * @since       Arquivo disponvel desde a verso 1.2.0
 * @version     $Id$
 */

require_once 'App/Date/Utils.php';

/**
 * App_Date_UtilsTest class.
 *
 * @author      Eriksen Costa Paixo <eriksen.paixao_bs@cobra.com.br>
 * @category    i-Educar
 * @license     @@license@@
 * @package     App_Date
 * @subpackage  UnitTests
 * @since       Classe disponvel desde a verso 1.2.0
 * @version     @@package_version@@
 */
class App_Date_UtilsTest extends UnitBaseTest
{
  public function testDatesYearAtLeast()
  {
    $dates = array(
      '01/01/2000',
      '01/02/2000'
    );

    try {
      App_Date_Utils::datesYearAtLeast($dates, 2001, 1);
      $this->fail('::datesYearAtLeast() deveria lanar App_Date_Exception.');
    }
    catch (App_Date_Exception $e) {
      $this->assertEquals(
        'Ao menos "1" das datas informadas deve ser do ano "2001". Datas: "01/01/2000", "01/02/2000".',
        $e->getMessage(),
        ''
      );
    }

    $this->assertTrue(
      App_Date_Utils::datesYearAtLeast($dates, 2000, 2),
      '::datesYearAtLeast() retorna "TRUE" quando uma das datas  do ano esperado.'
    );
  }
}