<?php

/**
 * i-Educar - Sistema de gesto escolar
 *
 * Copyright (C) 2006  Prefeitura Municipal de Itaja
 *                     <ctima@itajai.sc.gov.br>
 *
 * Este programa  software livre; voc pode redistribu-lo e/ou modific-lo
 * sob os termos da Licena Pblica Geral GNU conforme publicada pela Free
 * Software Foundation; tanto a verso 2 da Licena, como (a seu critrio)
 * qualquer verso posterior.
 *
 * Este programa  distribudo na expectativa de que seja til, porm, SEM
 * NENHUMA GARANTIA; nem mesmo a garantia implcita de COMERCIABILIDADE OU
 * ADEQUAO A UMA FINALIDADE ESPECFICA. Consulte a Licena Pblica Geral
 * do GNU para mais detalhes.
 *
 * Voc deve ter recebido uma cpia da Licena Pblica Geral do GNU junto
 * com este programa; se no, escreva para a Free Software Foundation, Inc., no
 * endereo 59 Temple Street, Suite 330, Boston, MA 02111-1307 USA.
 *
 * @author      Eriksen Costa Paixo <eriksen.paixao_bs@cobra.com.br>
 * @category    i-Educar
 * @license     @@license@@
 * @package     Core
 * @subpackage  UnitTests
 * @since       Arquivo disponvel desde a verso 1.0.1
 * @version     $Id$
 */

require_once 'include/pmieducar/clsPmieducarClienteSuspensao.inc.php';

/**
 * clsBancoTest class.
 *
 * @author      Eriksen Costa Paixo <eriksen.paixao_bs@cobra.com.br>
 * @category    i-Educar
 * @license     @@license@@
 * @package     Core
 * @subpackage  UnitTests
 * @since       Classe disponvel desde a verso 1.0.1
 * @todo        Subclassificar classe como IntegrationBaseTest
 * @version     @@package_version@@
 */
class ClsBancoTest extends UnitBaseTest
{
  public function testDoCountFromObj()
  {
    $db = new clsBanco();
    $db->Conecta();

    $obj = new clsPmieducarClienteSuspensao();
    $this->assertNotEquals(TRUE, is_null($db->doCountFromObj($obj)));
  }

  public function testConexao()
  {
    $db = new clsBanco();
    $db->Conecta();

    $this->assertTrue((bool) $db->bLink_ID);
  }

  public function testFormatacaoDeValoresBooleanos()
  {
    $data = array(
      'id' => 1,
      'hasChild' => TRUE
    );

    $db = new clsBanco();
    $formatted = $db->formatValues($data);
    $this->assertSame('t', $formatted['hasChild']);

    $data['hasChild'] = FALSE;
    $formatted = $db->formatValues($data);
    $this->assertSame('f', $formatted['hasChild']);
  }

  public function testOpcaoDeLancamentoDeExcecaoEFalsePorPadrao()
  {
    $db = new clsBanco();
    $this->assertFalse($db->getThrowException());
  }

  public function testConfiguracaoDeOpcaoDeLancamentoDeExcecao()
  {
    $db = new clsBanco();
    $db->setThrowException(TRUE);
    $this->assertTrue($db->getThrowException());
  }

  public function testFetchTipoArrayDeResultadosDeUmaQuery()
  {
    $db = new clsBanco();

    $db->Consulta("SELECT spcname, spcowner, spclocation, spcacl FROM pg_tablespace");
    $row = $db->ProximoRegistro();
    $row = $db->Tupla();
    $this->assertNotNull($row[0]);
    $this->assertNotNull($row['spcname']);
  }

  public function testFetchTipoAssocDeResultadosDeUmaQuery()
  {
    $db = new clsBanco(array('fetchMode' => clsBanco::FETCH_ASSOC));

    $db->Consulta("SELECT spcname, spcowner, spclocation, spcacl FROM pg_tablespace");
    $row = $db->ProximoRegistro();
    $row = $db->Tupla();
    $this->assertFalse(array_key_exists(0, $row));
    $this->assertNotNull($row['spcname']);
  }
}