<?php

/**
 * i-Educar - Sistema de gesto escolar
 *
 * Copyright (C) 2006  Prefeitura Municipal de Itaja
 *                     <ctima@itajai.sc.gov.br>
 *
 * Este programa  software livre; voc pode redistribu-lo e/ou modific-lo
 * sob os termos da Licena Pblica Geral GNU conforme publicada pela Free
 * Software Foundation; tanto a verso 2 da Licena, como (a seu critrio)
 * qualquer verso posterior.
 *
 * Este programa  distribudo na expectativa de que seja til, porm, SEM
 * NENHUMA GARANTIA; nem mesmo a garantia implcita de COMERCIABILIDADE OU
 * ADEQUAO A UMA FINALIDADE ESPECFICA. Consulte a Licena Pblica Geral
 * do GNU para mais detalhes.
 *
 * Voc deve ter recebido uma cpia da Licena Pblica Geral do GNU junto
 * com este programa; se no, escreva para a Free Software Foundation, Inc., no
 * endereo 59 Temple Street, Suite 330, Boston, MA 02111-1307 USA.
 *
 * @author      Eriksen Costa Paixo <eriksen.paixao_bs@cobra.com.br>
 * @category    i-Educar
 * @license     @@license@@
 * @package     Core
 * @subpackage  UnitTests
 * @since       Arquivo disponvel desde a verso 1.1.0
 * @version     $Id$
 */

require_once 'clsConfigItajai.inc.php';


/**
 * clsConfigItajaiTest class.
 *
 * @author      Eriksen Costa Paixo <eriksen.paixao_bs@cobra.com.br>
 * @category    i-Educar
 * @license     @@license@@
 * @package     Core
 * @subpackage  UnitTests
 * @since       Classe disponvel desde a verso 1.0.1
 * @version     @@package_version@@
 */
class ClsConfigItajai extends UnitBaseTest
{
  protected $config = NULL;

  protected function setUp()
  {
    $this->config = new clsConfig();
  }

  public function testConfigInstituicao()
  {
    $this->assertEquals('i-Educar - ', $this->config->_instituicao);
  }

  public function testArrayConfigHasEmailsAdministradores()
  {
    $this->assertTrue((bool) count($this->config->arrayConfig['ArrStrEmailsAdministradores']));
  }

  public function testArrayCheckEmailAdministradores()
  {
    $this->assertEquals('seu.email@example.com',
      $this->config->arrayConfig['ArrStrEmailsAdministradores'][0]);
  }

  public function testArrayConfigDirectoryTemplates()
  {
    $this->assertEquals('templates/', $this->config->arrayConfig['strDirTemplates']);
  }

  public function testArrayConfigIntSegundosQuerySql()
  {
    $this->assertEquals(3, $this->config->arrayConfig['intSegundosQuerySQL']);
  }

  public function testArrayConfigIntSegundosPagina()
  {
    $this->assertEquals(5, $this->config->arrayConfig['intSegundosProcessaPagina']);
  }
}