<?php

/**
 * i-Educar - Sistema de gesto escolar
 *
 * Copyright (C) 2006  Prefeitura Municipal de Itaja
 *                     <ctima@itajai.sc.gov.br>
 *
 * Este programa  software livre; voc pode redistribu-lo e/ou modific-lo
 * sob os termos da Licena Pblica Geral GNU conforme publicada pela Free
 * Software Foundation; tanto a verso 2 da Licena, como (a seu critrio)
 * qualquer verso posterior.
 *
 * Este programa  distribudo na expectativa de que seja til, porm, SEM
 * NENHUMA GARANTIA; nem mesmo a garantia implcita de COMERCIABILIDADE OU
 * ADEQUAO A UMA FINALIDADE ESPECFICA. Consulte a Licena Pblica Geral
 * do GNU para mais detalhes.
 *
 * Voc deve ter recebido uma cpia da Licena Pblica Geral do GNU junto
 * com este programa; se no, escreva para a Free Software Foundation, Inc., no
 * endereo 59 Temple Street, Suite 330, Boston, MA 02111-1307 USA.
 *
 * @author      Eriksen Costa Paixo <eriksen.paixao_bs@cobra.com.br>
 * @category    i-Educar
 * @license     @@license@@
 * @package     CoreExt_Controller
 * @subpackage  UnitTests
 * @since       Arquivo disponvel desde a verso 1.1.0
 * @version     $Id$
 */

require_once 'CoreExt/Controller/Request.php';

/**
 * CoreExt_Controller_RequestTest class.
 *
 * @author      Eriksen Costa Paixo <eriksen.paixao_bs@cobra.com.br>
 * @category    i-Educar
 * @license     @@license@@
 * @package     CoreExt_Controller
 * @subpackage  UnitTests
 * @since       Classe disponvel desde a verso 1.1.0
 * @version     @@package_version@@
 */
class CoreExt_Controller_RequestTest extends UnitBaseTest
{
  protected $_request = NULL;

  protected function setUp()
  {
    $this->_request = new CoreExt_Controller_Request();
  }

  /**
   * @expectedException InvalidArgumentException
   */
  public function testOpcaoDeConfiguracaoNaoExistenteLancaExcecao()
  {
    $this->_request->setOptions(array('foo' => 'bar'));
  }

  public function testRetornaNullCasoNaoEstejaSetadoNasSuperglobaisGetPostCookieEServer()
  {
    $this->assertNull($this->_request->get('foo'));
  }

  public function testVariavelEstaSetada()
  {
    $_GET['name'] = 'Foo';
    $this->assertTrue(isset($this->_request->name));
    unset($_GET['name']);
    $this->assertFalse(isset($this->_request->name));
  }

  public function testRecuperaParametroDeRequisicaoGet()
  {
    $_GET['name'] = 'Foo';
    $this->assertEquals($_GET['name'], $this->_request->get('name'));
  }

  public function testRecuperaParametroDeRequisicaoPost()
  {
    $_POST['name'] = 'Foo';
    $this->assertEquals($_POST['name'], $this->_request->get('name'));
  }

  public function testRecuperaParametroDoCookie()
  {
    $_COOKIE['name'] = 'Foo';
    $this->assertEquals($_COOKIE['name'], $this->_request->get('name'));
  }

  public function testRecuperaParametroDoServer() {
    $_SERVER['REQUEST_URI'] = 'http://www.example.com/controller';
    $this->assertEquals($_SERVER['REQUEST_URI'], $this->_request->get('REQUEST_URI'));
  }

  public function testConfiguraBaseurlComSchemeEHostPorPadrao() {
    $_SERVER['REQUEST_URI'] = 'http://www.example.com/controller';
    $this->assertEquals('http://www.example.com', $this->_request->getBaseurl());
  }
}