<?php

/**
 * i-Educar - Sistema de gesto escolar
 *
 * Copyright (C) 2006  Prefeitura Municipal de Itaja
 *                     <ctima@itajai.sc.gov.br>
 *
 * Este programa  software livre; voc pode redistribu-lo e/ou modific-lo
 * sob os termos da Licena Pblica Geral GNU conforme publicada pela Free
 * Software Foundation; tanto a verso 2 da Licena, como (a seu critrio)
 * qualquer verso posterior.
 *
 * Este programa  distribudo na expectativa de que seja til, porm, SEM
 * NENHUMA GARANTIA; nem mesmo a garantia implcita de COMERCIABILIDADE OU
 * ADEQUAO A UMA FINALIDADE ESPECFICA. Consulte a Licena Pblica Geral
 * do GNU para mais detalhes.
 *
 * Voc deve ter recebido uma cpia da Licena Pblica Geral do GNU junto
 * com este programa; se no, escreva para a Free Software Foundation, Inc., no
 * endereo 59 Temple Street, Suite 330, Boston, MA 02111-1307 USA.
 *
 * @author      Eriksen Costa Paixo <eriksen.paixao_bs@cobra.com.br>
 * @category    i-Educar
 * @license     @@license@@
 * @package     CoreExt_Session
 * @subpackage  UnitTests
 * @since       Arquivo disponvel desde a verso 1.1.0
 * @version     $Id$
 */

require_once 'CoreExt/Session/Storage/Default.php';

/**
 * CoreExt_Session_Storage_DefaultTest class.
 *
 * @backupGlobals disabled
 *
 * @author      Eriksen Costa Paixo <eriksen.paixao_bs@cobra.com.br>
 * @category    i-Educar
 * @license     @@license@@
 * @package     CoreExt_Session
 * @subpackage  UnitTests
 * @since       Classe disponvel desde a verso 1.1.0
 * @todo        Verificar se o problema de envio de headers ocorre em verses
 *   mais recentes do PHPUnit (> 3.4.0), ver ticket PHPUnit #946 relacionado:
 *   {@link http://www.phpunit.de/ticket/946 Tap Output makes Session Tests fail}
 * @version     @@package_version@@
 */
class CoreExt_Session_Storage_DefaultTest extends UnitBaseTest
{
  protected $_storage = NULL;
  protected static $_oldSessionId = NULL;
  protected static $_newSessionId = NULL;

  public function __construct()
  {
    static $iniSet = FALSE;
    $this->_storage = new CoreExt_Session_Storage_Default();

    // Workaround para testar o regenerate de session, j que em um test case
    // a funo iria lanar um erro de "headers already sent", que ocorre no
    // arquivo PHPUnit/Util/Printer.php:173.
    // Depende da configurao session.use_cookies definida em bootstrap.php
    if (FALSE == $iniSet) {
      self::$_oldSessionId = $this->_storage->getSessionId();
      $this->_storage->regenerate(TRUE);
      self::$_newSessionId = $this->_storage->getSessionId();

      $iniSet = TRUE;
    }
  }

  public function testInstanciaESubclasseDeCountable()
  {
    $this->assertType('Countable', $this->_storage);
  }

  public function testEscreveDadosNaSession()
  {
    $this->_storage->write('foo', 'bar');
    $this->_storage->write('foo/1', 'bar/1');
    $this->_storage->write('foo/2', 'bar/2');
    $this->_storage->write('foo/3', 'bar/3');

    // Verifica usando o array global $_SESSION
    $this->assertEquals('bar', $_SESSION['foo']);
    $this->assertEquals('bar/1', $_SESSION['foo/1']);
    $this->assertEquals('bar/2', $_SESSION['foo/2']);
  }

  /**
   * @depends testEscreveDadosNaSession
   */
  public function testLerDadosArmazenadosNaSession()
  {
    $this->assertEquals('bar', $this->_storage->read('foo'));
    $this->assertEquals('bar/1', $this->_storage->read('foo/1'));
    $this->assertEquals('bar/2', $this->_storage->read('foo/2'));
    $this->assertEquals('bar/3', $this->_storage->read('foo/3'));
  }

  /**
   * @depends testEscreveDadosNaSession
   */
  public function testCountable()
  {
    $this->assertEquals(4, count($this->_storage));
  }

  public function testRemoveIndiceDaSession()
  {
    $this->_storage->remove('bar/3');
    $this->assertNull($this->_storage->read('bar/3'));
  }

  public function testIndiceNaoExistenteNaSessionRetornaNull()
  {
    $this->assertNull($this->_storage->read('null'));
  }

  public function testRegeneraIdDaSession()
  {
    $this->assertNotEquals(self::$_oldSessionId, self::$_newSessionId);
  }
}