<?php

/**
 * i-Educar - Sistema de gesto escolar
 *
 * Copyright (C) 2006  Prefeitura Municipal de Itaja
 *                     <ctima@itajai.sc.gov.br>
 *
 * Este programa  software livre; voc pode redistribu-lo e/ou modific-lo
 * sob os termos da Licena Pblica Geral GNU conforme publicada pela Free
 * Software Foundation; tanto a verso 2 da Licena, como (a seu critrio)
 * qualquer verso posterior.
 *
 * Este programa  distribudo na expectativa de que seja til, porm, SEM
 * NENHUMA GARANTIA; nem mesmo a garantia implcita de COMERCIABILIDADE OU
 * ADEQUAO A UMA FINALIDADE ESPECFICA. Consulte a Licena Pblica Geral
 * do GNU para mais detalhes.
 *
 * Voc deve ter recebido uma cpia da Licena Pblica Geral do GNU junto
 * com este programa; se no, escreva para a Free Software Foundation, Inc., no
 * endereo 59 Temple Street, Suite 330, Boston, MA 02111-1307 USA.
 *
 * @author      Eriksen Costa Paixo <eriksen.paixao_bs@cobra.com.br>
 * @category    i-Educar
 * @license     @@license@@
 * @package     CoreExt_Validate
 * @subpackage  UnitTests
 * @since       Arquivo disponvel desde a verso 1.1.0
 * @version     $Id$
 */

require_once 'CoreExt/Validate/ChoiceMultiple.php';

/**
 * CoreExt_Validate_ChoiceMultipleTest class.
 *
 * @author      Eriksen Costa Paixo <eriksen.paixao_bs@cobra.com.br>
 * @category    i-Educar
 * @license     @@license@@
 * @package     CoreExt_Validate
 * @subpackage  UnitTests
 * @since       Classe disponvel desde a verso 1.1.0
 * @version     @@package_version@@
 */
class CoreExt_Validate_ChoiceMultipleTest extends UnitBaseTest
{
  protected $_validator = NULL;

  protected $_choices = array(
    'bit' => array(0, 1),
    'various' => array('sim', 'no', 'nda')
  );

  protected function setUp()
  {
    $this->_validator = new CoreExt_Validate_ChoiceMultiple();
  }

  public function testEscolhaMultiplaValida()
  {
    $this->_validator->setOptions(array('choices' => $this->_choices['bit']));
    $this->assertTrue($this->_validator->isValid(array(0, 1)));

    // Testa com valor igual, mas tipo de dado diferente
    $this->assertTrue($this->_validator->isValid(array('0', '1')));
  }

  public function testEscolhaMultiplaInvalidaLancaExcecao()
  {
    $this->_validator->setOptions(array('choices' => $this->_choices['bit']));
    try {
      $this->_validator->isValid(array(0, 2, 3));
      $this->fail("CoreExt_Validate_ChoiceMultiple deveria ter lanado exceo.");
    }
    catch (Exception $e) {
      $this->assertEquals('As opes "2, 3" no existem.', $e->getMessage());
    }

    // 'a' e '0a' normalmente seriam avaliados como '0' e '1' mas no queremos
    // esse tipo de comportamento.
    try {
      $this->_validator->isValid(array(0, 'a', '1a'));
      $this->fail("CoreExt_Validate_ChoiceMultiple deveria ter lanado exceo.");
    }
    catch (Exception $e) {
      $this->assertEquals('As opes "a, 1a" no existem.', $e->getMessage());
    }
  }
}