<?php

/**
 * i-Educar - Sistema de gesto escolar
 *
 * Copyright (C) 2006  Prefeitura Municipal de Itaja
 *                     <ctima@itajai.sc.gov.br>
 *
 * Este programa  software livre; voc pode redistribu-lo e/ou modific-lo
 * sob os termos da Licena Pblica Geral GNU conforme publicada pela Free
 * Software Foundation; tanto a verso 2 da Licena, como (a seu critrio)
 * qualquer verso posterior.
 *
 * Este programa  distribudo na expectativa de que seja til, porm, SEM
 * NENHUMA GARANTIA; nem mesmo a garantia implcita de COMERCIABILIDADE OU
 * ADEQUAO A UMA FINALIDADE ESPECFICA. Consulte a Licena Pblica Geral
 * do GNU para mais detalhes.
 *
 * Voc deve ter recebido uma cpia da Licena Pblica Geral do GNU junto
 * com este programa; se no, escreva para a Free Software Foundation, Inc., no
 * endereo 59 Temple Street, Suite 330, Boston, MA 02111-1307 USA.
 *
 * @author      Eriksen Costa Paixo <eriksen.paixao_bs@cobra.com.br>
 * @category    i-Educar
 * @license     @@license@@
 * @package     CoreExt_Validate
 * @subpackage  UnitTests
 * @since       Arquivo disponvel desde a verso 1.1.0
 * @version     $Id$
 */

require_once 'CoreExt/Validate/Choice.php';

/**
 * CoreExt_Validate_ChoiceTest class.
 *
 * @author      Eriksen Costa Paixo <eriksen.paixao_bs@cobra.com.br>
 * @category    i-Educar
 * @license     @@license@@
 * @package     CoreExt_Validate
 * @subpackage  UnitTests
 * @since       Classe disponvel desde a verso 1.1.0
 * @version     @@package_version@@
 */
class CoreExt_Validate_ChoiceTest extends UnitBaseTest
{
  protected $_validator = NULL;

  protected $_choices = array(
    'bit' => array(0, 1),
    'various' => array('sim', 'no', 'nda')
  );

  protected function setUp()
  {
    $this->_validator = new CoreExt_Validate_Choice();
  }

  public function testValidaSeNenhumaOpcaoPadraoForInformada()
  {
    $this->assertTrue($this->_validator->isValid(0));
  }

  public function testEscolhaValida()
  {
    $this->_validator->setOptions(array('choices' => $this->_choices['bit']));
    $this->assertTrue($this->_validator->isValid(0), 'Falhou na assero "0" numrico.');
    $this->assertTrue($this->_validator->isValid(1), 'Falhou na assero "1" numrico.');

    // Teste para verificar como reage a tipos diferentes
    $this->assertTrue($this->_validator->isValid('0'), 'Falhou na assero "0" string.');
    $this->assertTrue($this->_validator->isValid('1'), 'Falhou na assero "1" string.');

    $this->_validator->setOptions(array('choices' => $this->_choices['various']));
    $this->assertTrue($this->_validator->isValid('sim'));
    $this->assertTrue($this->_validator->isValid('no'));
    $this->assertTrue($this->_validator->isValid('nda'));
  }

  public function testEscolhaInvalidaLancaExcecao()
  {
    $this->_validator->setOptions(array('choices' => $this->_choices['bit']));
    try {
      $this->_validator->isValid(2);
      $this->fail("CoreExt_Validate_Choice deveria ter lanado exceo.");
    }
    catch (Exception $e) {
      $this->assertEquals('A opo "2" no existe.', $e->getMessage());
    }

    // 'a' normalmente seria avaliado como 0, mas queremos garantir que isso
    // no ocorra, por isso transformamos tudo em string em _validate().
    try {
      $this->_validator->isValid('a');
      $this->fail("CoreExt_Validate_Choice deveria ter lanado exceo.");
    }
    catch (Exception $e) {
      $this->assertEquals('A opo "a" no existe.', $e->getMessage());
    }

    try {
      $this->_validator->isValid('0a');
      $this->fail("CoreExt_Validate_Choice deveria ter lanado exceo.");
    }
    catch (Exception $e) {
      $this->assertEquals('A opo "0a" no existe.', $e->getMessage());
    }
  }
}