<?php

/**
 * i-Educar - Sistema de gesto escolar
 *
 * Copyright (C) 2006  Prefeitura Municipal de Itaja
 *                     <ctima@itajai.sc.gov.br>
 *
 * Este programa  software livre; voc pode redistribu-lo e/ou modific-lo
 * sob os termos da Licena Pblica Geral GNU conforme publicada pela Free
 * Software Foundation; tanto a verso 2 da Licena, como (a seu critrio)
 * qualquer verso posterior.
 *
 * Este programa  distribudo na expectativa de que seja til, porm, SEM
 * NENHUMA GARANTIA; nem mesmo a garantia implcita de COMERCIABILIDADE OU
 * ADEQUAO A UMA FINALIDADE ESPECFICA. Consulte a Licena Pblica Geral
 * do GNU para mais detalhes.
 *
 * Voc deve ter recebido uma cpia da Licena Pblica Geral do GNU junto
 * com este programa; se no, escreva para a Free Software Foundation, Inc., no
 * endereo 59 Temple Street, Suite 330, Boston, MA 02111-1307 USA.
 *
 * @author      Eriksen Costa Paixo <eriksen.paixao_bs@cobra.com.br>
 * @category    i-Educar
 * @license     @@license@@
 * @package     CoreExt_Validate
 * @subpackage  UnitTests
 * @since       Arquivo disponvel desde a verso 1.1.0
 * @version     $Id$
 */

require_once 'CoreExt/_stub/Validate.php';
require_once 'CoreExt/Validate/String.php';

/**
 * CoreExt_ValidateTest class.
 *
 * @author      Eriksen Costa Paixo <eriksen.paixao_bs@cobra.com.br>
 * @category    i-Educar
 * @license     @@license@@
 * @package     CoreExt_Validate
 * @subpackage  UnitTests
 * @since       Classe disponvel desde a verso 1.1.0
 * @version     @@package_version@@
 */
class CoreExt_ValidateTest extends UnitBaseTest
{
  protected $_validator = NULL;

  protected function setUp()
  {
    $this->_validator = new CoreExt_ValidateStub();
  }

  /**
   * @expectedException InvalidArgumentException
   */
  public function testOpcaoDeConfiguracaoNaoExistenteLancaExcecao()
  {
    $this->_validator->setOptions(array('invalidOption' => TRUE));
  }

  public function testConfiguraOpcaoDoValidator()
  {
    $this->_validator->setOptions(array('required' => FALSE));

    $options = $this->_validator->getOptions();
    $this->assertFalse($options['required']);

    $this->assertFalse($this->_validator->getOption('required'));
  }

  /**
   * @expectedException Exception
   */
  public function testValorStringSomenteEspacoRequerido()
  {
    // Um espao ASCII
    $this->assertTrue($this->_validator->isValid(' '));
  }

  /**
   * @expectedException Exception
   */
  public function testValorNuloLancaExcecao()
  {
    $this->assertTrue($this->_validator->isValid(NULL));
  }

  /**
   * @expectedException Exception
   */
  public function testValorArrayVazioLancaExcecao()
  {
    $this->assertTrue($this->_validator->isValid(array()));
  }

  public function testValorNaoObrigatorioComConfiguracaoNaInstanciacao()
  {
    $validator = new CoreExt_Validate_String(array('required' => FALSE));
    $this->assertTrue($validator->isValid(''));
  }

  public function testValorNaoObrigatorioComConfiguracaoViaMetodo()
  {
    $this->_validator->setOptions(array('required' => FALSE));
    $this->assertTrue($this->_validator->isValid(''));
  }
}