<?php

/**
 * i-Educar - Sistema de gesto escolar
 *
 * Copyright (C) 2006  Prefeitura Municipal de Itaja
 *                     <ctima@itajai.sc.gov.br>
 *
 * Este programa  software livre; voc pode redistribu-lo e/ou modific-lo
 * sob os termos da Licena Pblica Geral GNU conforme publicada pela Free
 * Software Foundation; tanto a verso 2 da Licena, como (a seu critrio)
 * qualquer verso posterior.
 *
 * Este programa  distribudo na expectativa de que seja til, porm, SEM
 * NENHUMA GARANTIA; nem mesmo a garantia implcita de COMERCIABILIDADE OU
 * ADEQUAO A UMA FINALIDADE ESPECFICA. Consulte a Licena Pblica Geral
 * do GNU para mais detalhes.
 *
 * Voc deve ter recebido uma cpia da Licena Pblica Geral do GNU junto
 * com este programa; se no, escreva para a Free Software Foundation, Inc., no
 * endereo 59 Temple Street, Suite 330, Boston, MA 02111-1307 USA.
 *
 * @author      Eriksen Costa Paixo <eriksen.paixao_bs@cobra.com.br>
 * @category    i-Educar
 * @license     @@license@@
 * @package     CoreExt_DataMapper
 * @subpackage  UnitTests
 * @since       Arquivo disponvel desde a verso 1.1.0
 * @version     $Id$
 */

require_once 'CoreExt/DataMapper.php';
require_once 'CoreExt/_stub/EntityCompound.php';

/**
 * CoreExt_EntityCompoundDataMapperStub class.
 *
 * Entidade para testes de integrao do componente CoreExt_DataMapper com
 * o banco de dados.
 *
 * @author      Eriksen Costa Paixo <eriksen.paixao_bs@cobra.com.br>
 * @category    i-Educar
 * @license     @@license@@
 * @package     CoreExt_DataMapper
 * @subpackage  UnitTests
 * @since       Classe disponvel desde a verso 1.1.0
 * @version     @@package_version@@
 */
class CoreExt_EntityCompoundDataMapperStub extends CoreExt_DataMapper
{
  protected $_entityClass = 'CoreExt_EntityCompoundStub';
  protected $_tableName   = 'matricula';
  protected $_tableSchema = '';

  protected $_attributeMap = array(
    'pessoa' => 'pessoa_id',
    'curso' => 'curso_id'
  );

  protected $_primaryKey = array(
    'pessoa', 'curso'
  );

  /**
   * Cria a tabela pessoa para testes de integrao.
   *
   * SQL compatvel com SQLite.
   *
   * @param  clsBancoPdo $db
   * @return mixed Retorna FALSE em caso de erro
   */
  public static function createTable(clsBanco $db)
  {
    $sql = "
CREATE TABLE matricula(
  pessoa_id integer NOT NULL,
  curso_id integer NOT NULL,
  confirmado char(1) NULL DEFAULT 't',
  PRIMARY KEY(pessoa_id, curso_id)
);";

    return $db->Consulta($sql);
  }
}