<?php

/**
 * i-Educar - Sistema de gesto escolar
 *
 * Copyright (C) 2006  Prefeitura Municipal de Itaja
 *                     <ctima@itajai.sc.gov.br>
 *
 * Este programa  software livre; voc pode redistribu-lo e/ou modific-lo
 * sob os termos da Licena Pblica Geral GNU conforme publicada pela Free
 * Software Foundation; tanto a verso 2 da Licena, como (a seu critrio)
 * qualquer verso posterior.
 *
 * Este programa  distribudo na expectativa de que seja til, porm, SEM
 * NENHUMA GARANTIA; nem mesmo a garantia implcita de COMERCIABILIDADE OU
 * ADEQUAO A UMA FINALIDADE ESPECFICA. Consulte a Licena Pblica Geral
 * do GNU para mais detalhes.
 *
 * Voc deve ter recebido uma cpia da Licena Pblica Geral do GNU junto
 * com este programa; se no, escreva para a Free Software Foundation, Inc., no
 * endereo 59 Temple Street, Suite 330, Boston, MA 02111-1307 USA.
 *
 * @author      Eriksen Costa Paixo <eriksen.paixao_bs@cobra.com.br>
 * @category    i-Educar
 * @license     @@license@@
 * @package     CoreExt_DataMapper
 * @subpackage  UnitTests
 * @since       Arquivo disponvel desde a verso 1.1.0
 * @version     $Id: /ieducar/branches/1.1.0-dev/ieducar/tests/unit/CoreExt/_stub/Entity.php 586 2009-10-14T23:26:48.478692Z eriksen  $
 */

require_once 'CoreExt/DataMapper.php';
require_once 'CoreExt/_stub/Entity.php';

/**
 * CoreExt_EntityDataMapperStub class.
 *
 * Entidade para testes de integrao do componente CoreExt_DataMapper com
 * o banco de dados.
 *
 * @author      Eriksen Costa Paixo <eriksen.paixao_bs@cobra.com.br>
 * @category    i-Educar
 * @license     @@license@@
 * @package     CoreExt_DataMapper
 * @subpackage  UnitTests
 * @since       Classe disponvel desde a verso 1.1.0
 * @version     @@package_version@@
 */
class CoreExt_EntityDataMapperStub extends CoreExt_DataMapper
{
  protected $_entityClass = 'CoreExt_EntityStub';
  protected $_tableName   = 'pessoa';
  protected $_tableSchema = '';

  protected $_attributeMap = array(
    'estadoCivil' => 'estado_civil'
  );

  /**
   * Cria a tabela pessoa para testes de integrao.
   *
   * SQL compatvel com SQLite.
   *
   * @param  clsBancoPdo $db
   * @return mixed Retorna FALSE em caso de erro
   */
  public static function createTable(clsBanco $db)
  {
    $sql = "
CREATE TABLE pessoa(
  id integer primary key,
  nome character varying(100) NOT NULL,
  estado_civil character varying(20) NOT NULL DEFAULT 'solteiro',
  doador char(1) NULL DEFAULT 't'
);";

    return $db->Consulta($sql);
  }
}