(function ($) {
	$.extend($.summernote.lang, {
		'bg-BG': {
			font: {
				bold: 'Удебелен',
				italic: 'Наклонен',
				underline: 'Подчертан',
				clear: 'Изчисти стиловете',
				height: 'Височина',
				name: 'Шрифт',
				strikethrough: 'Задраскано',
				subscript: 'Долен индекс',
				superscript: 'Горен индекс',
				size: 'Размер на шрифта'
			},
			image: {
				image: 'Изображение',
				insert: 'Постави картинка',
				resizeFull: 'Цял размер',
				resizeHalf: 'Размер на 50%',
				resizeQuarter: 'Размер на 25%',
				floatLeft: 'Подравни в ляво',
				floatRight: 'Подравни в дясно',
				floatNone: 'Без подравняване',
				dragImageHere: 'Пуснете изображението тук',
				selectFromFiles: 'Изберете файл',
				url: 'URL адрес на изображение',
				remove: 'Премахни изображение'
			},
			link: {
				link: 'Връзка',
				insert: 'Добави връзка',
				unlink: 'Премахни връзка',
				edit: 'Промени',
				textToDisplay: 'Текст за показване',
				url: 'URL адрес',
				openInNewWindow: 'Отвори в нов прозорец'
			},
			table: {
				table: 'Таблица'
			},
			hr: {
				insert: 'Добави хоризонтална линия'
			},
			style: {
				style: 'Стил',
				p: 'Нормален',
				blockquote: 'Цитат',
				pre: 'Код',
				h1: 'Заглавие 1',
				h2: 'Заглавие 2',
				h3: 'Заглавие 3',
				h4: 'Заглавие 4',
				h5: 'Заглавие 5',
				h6: 'Заглавие 6'
			},
			lists: {
				unordered: 'Символен списък',
				ordered: 'Цифров списък'
			},
			options: {
				help: 'Помощ',
				fullscreen: 'На цял екран',
				codeview: 'Преглед на код'
			},
			paragraph: {
				paragraph: 'Параграф',
				outdent: 'Намаляване на отстъпа',
				indent: 'Абзац',
				left: 'Подравняване в ляво',
				center: 'Център',
				right: 'Подравняване в дясно',
				justify: 'Разтягане по ширина'
			},
			color: {
				recent: 'Последния избран цвят',
				more: 'Още цветове',
				background: 'Цвят на фона',
				foreground: 'Цвят на шрифта',
				transparent: 'Прозрачен',
				setTransparent: 'Направете прозрачен',
				reset: 'Възстанови',
				resetToDefault: 'Възстанови оригиналните'
			},
			shortcut: {
				shortcuts: 'Клавишни комбинации',
				close: 'Затвори',
				textFormatting: 'Форматиране на текста',
				action: 'Действие',
				paragraphFormatting: 'Форматиране на параграф',
				documentStyle: 'Стил на документа'
			},
			history: {
				undo: 'Назад',
				redo: 'Напред'
			}
		},
		'pt-BR': {
			font: {
				bold: 'Negrito',
				italic: 'Itálico',
				underline: 'Sublinhado',
				clear: 'Remover estilo da fonte',
				height: 'Altura da linha',
				name: 'Fonte',
				strikethrough: 'Riscado',
				size: 'Tamanho da fonte'
			},
			image: {
				image: 'Imagem',
				insert: 'Inserir imagem',
				resizeFull: 'Redimensionar Completamente',
				resizeHalf: 'Redimensionar pela Metade',
				resizeQuarter: 'Redimensionar um Quarto',
				floatLeft: 'Flutuar para Esquerda',
				floatRight: 'Flutuar para Direira',
				floatNone: 'Não Flutuar',
				dragImageHere: 'Arraste uma imagem para cá',
				selectFromFiles: 'Selecione a partir dos arquivos',
				url: 'URL da imagem'
			},
			video: {
				video: 'Vídeo',
				videoLink: 'Link para vídeo',
				insert: 'Inserir vídeo',
				url: 'URL do vídeo?',
				providers: '(YouTube, Vimeo, Vine, Instagram, DailyMotion ou Youku)'
			},
			link: {
				link: 'Link',
				insert: 'Inserir link',
				unlink: 'Remover link',
				edit: 'Editar',
				textToDisplay: 'Texto para exibir',
				url: 'Para qual URL esse link leva?',
				openInNewWindow: 'Abrir em uma nova janela'
			},
			table: {
				table: 'Tabela'
			},
			hr: {
				insert: 'Inserir linha horizontal'
			},
			style: {
				style: 'Estilo',
				normal: 'Normal',
				blockquote: 'Citação',
				pre: 'Código',
				h1: 'Título 1',
				h2: 'Título 2',
				h3: 'Título 3',
				h4: 'Título 4',
				h5: 'Título 5',
				h6: 'Título 6'
			},
			lists: {
				unordered: 'Lista com marcadores',
				ordered: 'Lista numerada'
			},
			options: {
				help: 'Ajuda',
				fullscreen: 'Tela cheia',
				codeview: 'Ver código-fonte'
			},
			paragraph: {
				paragraph: 'Parágrafo',
				outdent: 'Menor tabulação',
				indent: 'Maior tabulação',
				left: 'Alinhar à esquerda',
				center: 'Alinhar ao centro',
				right: 'Alinha à direita',
				justify: 'Justificado'
			},
			color: {
				recent: 'Cor recente',
				more: 'Mais cores',
				background: 'Fundo',
				foreground: 'Fonte',
				transparent: 'Transparente',
				setTransparent: 'Fundo transparente',
				reset: 'Restaurar',
				resetToDefault: 'Restaurar padrão'
			},
			shortcut: {
				shortcuts: 'Atalhos do teclado',
				close: 'Fechar',
				textFormatting: 'Formatação de texto',
				action: 'Ação',
				paragraphFormatting: 'Formatação de parágrafo',
				documentStyle: 'Estilo de documento'
			},
			history: {
				undo: 'Desfazer',
				redo: 'Refazer'
			},
			help: {
				'insertParagraph': 'Inserir Parágrafo',
				'undo': 'Desfazer o último comando',
				'redo': 'Refazer o último comando',
				'tab': 'Tab',
				'untab': 'Desfazer tab',
				'bold': 'Colocar em negrito',
				'italic': 'Colocar em itálico',
				'underline': 'Sublinhado',
				'strikethrough': 'Tachado',
				'removeFormat': 'Remover estilo',
				'justifyLeft': 'Alinhar à esquerda',
				'justifyCenter': 'Centralizar',
				'justifyRight': 'Alinhar à esquerda',
				'justifyFull': 'Justificar',
				'insertUnorderedList': 'Lista não ordenada',
				'insertOrderedList': 'Lista ordenada',
				'outdent': 'Recuar parágrafo atual',
				'indent': 'Avançar parágrafo atual',
				'formatPara': 'Alterar formato do bloco para parágrafo(tag P)',
				'formatH1': 'Alterar formato do bloco para H1',
				'formatH2': 'Alterar formato do bloco para H2',
				'formatH3': 'Alterar formato do bloco para H3',
				'formatH4': 'Alterar formato do bloco para H4',
				'formatH5': 'Alterar formato do bloco para H5',
				'formatH6': 'Alterar formato do bloco para H6',
				'insertHorizontalRule': 'Inserir régua horizontal',
				'linkDialog.show': 'Inserir um Hiperlink'
			}
		},
		'ca-ES': {
			font: {
				bold: 'Negreta',
				italic: 'Cursiva',
				underline: 'Subratllat',
				clear: 'Treure estil de lletra',
				height: 'Alçada de línia',
				name: 'Font',
				strikethrough: 'Ratllat',
				subscript: 'Subíndex',
				superscript: 'Superíndex',
				size: 'Mida de lletra'
			},
			image: {
				image: 'Imatge',
				insert: 'Inserir imatge',
				resizeFull: 'Redimensionar a mida completa',
				resizeHalf: 'Redimensionar a la meitat',
				resizeQuarter: 'Redimensionar a un quart',
				floatLeft: 'Alinear a l\'esquerra',
				floatRight: 'Alinear a la dreta',
				floatNone: 'No alinear',
				shapeRounded: 'Forma: Arrodonit',
				shapeCircle: 'Forma: Cercle',
				shapeThumbnail: 'Forma: Marc',
				shapeNone: 'Forma: Cap',
				dragImageHere: 'Arrossegueu una imatge o text aquí',
				dropImage: 'Deixa anar aquí una imatge o un text',
				selectFromFiles: 'Seleccioneu des dels arxius',
				maximumFileSize: 'Mida màxima de l\'arxiu',
				maximumFileSizeError: 'La mida màxima de l\'arxiu s\'ha superat.',
				url: 'URL de la imatge',
				remove: 'Eliminar imatge'
			},
			video: {
				video: 'Vídeo',
				videoLink: 'Enllaç del vídeo',
				insert: 'Inserir vídeo',
				url: 'URL del vídeo?',
				providers: '(YouTube, Vimeo, Vine, Instagram, DailyMotion o Youku)'
			},
			link: {
				link: 'Enllaç',
				insert: 'Inserir enllaç',
				unlink: 'Treure enllaç',
				edit: 'Editar',
				textToDisplay: 'Text per mostrar',
				url: 'Cap a quina URL porta l\'enllaç?',
				openInNewWindow: 'Obrir en una finestra nova'
			},
			table: {
				table: 'Taula'
			},
			hr: {
				insert: 'Inserir línia horitzontal'
			},
			style: {
				style: 'Estil',
				p: 'p',
				blockquote: 'Cita',
				pre: 'Codi',
				h1: 'Títol 1',
				h2: 'Títol 2',
				h3: 'Títol 3',
				h4: 'Títol 4',
				h5: 'Títol 5',
				h6: 'Títol 6'
			},
			lists: {
				unordered: 'Llista desendreçada',
				ordered: 'Llista endreçada'
			},
			options: {
				help: 'Ajut',
				fullscreen: 'Pantalla sencera',
				codeview: 'Veure codi font'
			},
			paragraph: {
				paragraph: 'Paràgraf',
				outdent: 'Menys tabulació',
				indent: 'Més tabulació',
				left: 'Alinear a l\'esquerra',
				center: 'Alinear al mig',
				right: 'Alinear a la dreta',
				justify: 'Justificar'
			},
			color: {
				recent: 'Últim color',
				more: 'Més colors',
				background: 'Color de fons',
				foreground: 'Color de lletra',
				transparent: 'Transparent',
				setTransparent: 'Establir transparent',
				reset: 'Restablir',
				resetToDefault: 'Restablir per defecte'
			},
			shortcut: {
				shortcuts: 'Dreceres de teclat',
				close: 'Tancar',
				textFormatting: 'Format de text',
				action: 'Acció',
				paragraphFormatting: 'Format de paràgraf',
				documentStyle: 'Estil del document',
				extraKeys: 'Tecles adicionals'
			},
			help : {
				'insertParagraph': 'Inserir paràgraf',
				'undo': 'Desfer l\'última acció',
				'redo': 'Refer l\'última acció',
				'tab': 'Tabular',
				'untab': 'Eliminar tabulació',
				'bold': 'Establir estil negreta',
				'italic': 'Establir estil cursiva',
				'underline': 'Establir estil subratllat',
				'strikethrough': 'Establir estil ratllat',
				'removeFormat': 'Netejar estil',
				'justifyLeft': 'Alinear a l\'esquerra',
				'justifyCenter': 'Alinear al centre',
				'justifyRight': 'Alinear a la dreta',
				'justifyFull': 'Justificar',
				'insertUnorderedList': 'Inserir llista desendreçada',
				'insertOrderedList': 'Inserir llista endreçada',
				'outdent': 'Reduïr tabulació del paràgraf',
				'indent': 'Augmentar tabulació del paràgraf',
				'formatPara': 'Canviar l\'estil del bloc com a un paràgraf (etiqueta P)',
				'formatH1': 'Canviar l\'estil del bloc com a un H1',
				'formatH2': 'Canviar l\'estil del bloc com a un H2',
				'formatH3': 'Canviar l\'estil del bloc com a un H3',
				'formatH4': 'Canviar l\'estil del bloc com a un H4',
				'formatH5': 'Canviar l\'estil del bloc com a un H5',
				'formatH6': 'Canviar l\'estil del bloc com a un H6',
				'insertHorizontalRule': 'Inserir una línia horitzontal',
				'linkDialog.show': 'Mostrar panel d\'enllaços'
			},
			history: {
				undo: 'Desfer',
				redo: 'Refer'
			},
			specialChar: {
				specialChar: 'CARÀCTERS ESPECIALS',
				select: 'Selecciona caràcters especials'
			}
		},
		'cs-CZ': {
			font: {
				bold: 'Tučné',
				italic: 'Kurzíva',
				underline: 'Podtržené',
				clear: 'Odstranit styl písma',
				height: 'Výška řádku',
				strikethrough: 'Přeškrtnuté',
				size: 'Velikost písma'
			},
			image: {
				image: 'Obrázek',
				insert: 'Vložit obrázek',
				resizeFull: 'Původní velikost',
				resizeHalf: 'Poloviční velikost',
				resizeQuarter: 'Čtvrteční velikost',
				floatLeft: 'Umístit doleva',
				floatRight: 'Umístit doprava',
				floatNone: 'Neobtékat textem',
				dragImageHere: 'Přetáhnout sem obrázek',
				selectFromFiles: 'Vybrat soubor',
				url: 'URL obrázku'
			},
			video: {
				video: 'Video',
				videoLink: 'Odkaz videa',
				insert: 'Vložit video',
				url: 'URL videa?',
				providers: '(YouTube, Vimeo, Vine, Instagram, DailyMotion nebo Youku)'
			},
			link: {
				link: 'Odkaz',
				insert: 'Vytvořit odkaz',
				unlink: 'Zrušit odkaz',
				edit: 'Upravit',
				textToDisplay: 'Zobrazovaný text',
				url: 'Na jaké URL má tento odkaz vést?',
				openInNewWindow: 'Otevřít v novém okně'
			},
			table: {
				table: 'Tabulka'
			},
			hr: {
				insert: 'Vložit vodorovnou čáru'
			},
			style: {
				style: 'Styl',
				p: 'Normální',
				blockquote: 'Citace',
				pre: 'Kód',
				h1: 'Nadpis 1',
				h2: 'Nadpis 2',
				h3: 'Nadpis 3',
				h4: 'Nadpis 4',
				h5: 'Nadpis 5',
				h6: 'Nadpis 6'
			},
			lists: {
				unordered: 'Odrážkový seznam',
				ordered: 'Číselný seznam'
			},
			options: {
				help: 'Nápověda',
				fullscreen: 'Celá obrazovka',
				codeview: 'HTML kód'
			},
			paragraph: {
				paragraph: 'Odstavec',
				outdent: 'Zvětšit odsazení',
				indent: 'Zmenšit odsazení',
				left: 'Zarovnat doleva',
				center: 'Zarovnat na střed',
				right: 'Zarovnat doprava',
				justify: 'Zarovnat oboustranně'
			},
			color: {
				recent: 'Aktuální barva',
				more: 'Další barvy',
				background: 'Barva pozadí',
				foreground: 'Barva písma',
				transparent: 'Průhlednost',
				setTransparent: 'Nastavit průhlednost',
				reset: 'Obnovit',
				resetToDefault: 'Obnovit výchozí'
			},
			shortcut: {
				shortcuts: 'Klávesové zkratky',
				close: 'Zavřít',
				textFormatting: 'Formátování textu',
				action: 'Akce',
				paragraphFormatting: 'Formátování odstavce',
				documentStyle: 'Styl dokumentu'
			},
			history: {
				undo: 'Krok vzad',
				redo: 'Krok vpřed'
			}

		},
		'da-DK': {
			font: {
				bold: 'Fed',
				italic: 'Kursiv',
				underline: 'Understreget',
				clear: 'Fjern formatering',
				height: 'Højde',
				name: 'Skrifttype',
				strikethrough: 'Gennemstreget',
				subscript: 'Sænket skrift',
				superscript: 'Hævet skrift',
				size: 'Skriftstørrelse'
			},
			image: {
				image: 'Billede',
				insert: 'Indsæt billede',
				resizeFull: 'Original størrelse',
				resizeHalf: 'Halv størrelse',
				resizeQuarter: 'Kvart størrelse',
				floatLeft: 'Venstrestillet',
				floatRight: 'Højrestillet',
				floatNone: 'Fjern formatering',
				shapeRounded: 'Form: Runde kanter',
				shapeCircle: 'Form: Cirkel',
				shapeThumbnail: 'Form: Miniature',
				shapeNone: 'Form: Ingen',
				dragImageHere: 'Træk billede hertil',
				dropImage: 'Slip billede',
				selectFromFiles: 'Vælg billed-fil',
				maximumFileSize: 'Maks fil størrelse',
				maximumFileSizeError: 'Filen er større end maks tilladte fil størrelse!',
				url: 'Billede URL',
				remove: 'Fjern billede'
			},
			video: {
				video: 'Video',
				videoLink: 'Video Link',
				insert: 'Indsæt Video',
				url: 'Video URL?',
				providers: '(YouTube, Vimeo, Vine, Instagram, DailyMotion eller Youku)'
			},
			link: {
				link: 'Link',
				insert: 'Indsæt link',
				unlink: 'Fjern link',
				edit: 'Rediger',
				textToDisplay: 'Visningstekst',
				url: 'Hvor skal linket pege hen?',
				openInNewWindow: 'Åbn i nyt vindue'
			},
			table: {
				table: 'Tabel'
			},
			hr: {
				insert: 'Indsæt horisontal linje'
			},
			style: {
				style: 'Stil',
				p: 'p',
				blockquote: 'Citat',
				pre: 'Kode',
				h1: 'Overskrift 1',
				h2: 'Overskrift 2',
				h3: 'Overskrift 3',
				h4: 'Overskrift 4',
				h5: 'Overskrift 5',
				h6: 'Overskrift 6'
			},
			lists: {
				unordered: 'Punktopstillet liste',
				ordered: 'Nummereret liste'
			},
			options: {
				help: 'Hjælp',
				fullscreen: 'Fuld skærm',
				codeview: 'HTML-Visning'
			},
			paragraph: {
				paragraph: 'Afsnit',
				outdent: 'Formindsk indryk',
				indent: 'Forøg indryk',
				left: 'Venstrestillet',
				center: 'Centreret',
				right: 'Højrestillet',
				justify: 'Blokjuster'
			},
			color: {
				recent: 'Nyligt valgt farve',
				more: 'Flere farver',
				background: 'Baggrund',
				foreground: 'Forgrund',
				transparent: 'Transparent',
				setTransparent: 'Sæt transparent',
				reset: 'Nulstil',
				resetToDefault: 'Gendan standardindstillinger'
			},
			shortcut: {
				shortcuts: 'Genveje',
				close: 'Luk',
				textFormatting: 'Tekstformatering',
				action: 'Handling',
				paragraphFormatting: 'Afsnitsformatering',
				documentStyle: 'Dokumentstil'
			},
			history: {
				undo: 'Fortryd',
				redo: 'Annuller fortryd'
			}

		},
		'de-DE': {
	  font: {
		bold: 'Fett',
		italic: 'Kursiv',
		underline: 'Unterstreichen',
		clear: 'Zurücksetzen',
		height: 'Zeilenhöhe',
		strikethrough: 'Durchgestrichen',
		size: 'Schriftgröße'
	  },
	  image: {
		image: 'Grafik',
		insert: 'Grafik einfügen',
		resizeFull: 'Originalgröße',
		resizeHalf: 'Größe 1/2',
		resizeQuarter: 'Größe 1/4',
		floatLeft: 'Linksbündig',
		floatRight: 'Rechtsbündig',
		floatNone: 'Kein Textfluss',
		shapeRounded: 'Rahmen: Abgerundet',
		shapeCircle: 'Rahmen: Kreisförmig',
		shapeThumbnail: 'Rahmen: Thumbnail',
		shapeNone: 'Kein Rahmen',
		dragImageHere: 'Ziehen Sie ein Bild mit der Maus hierher',
		selectFromFiles: 'Wählen Sie eine Datei aus',
		maximumFileSize: 'Maximale Dateigröße',
		maximumFileSizeError: 'Maximale Dateigröße überschritten',
		url: 'Grafik URL',
		remove: 'Grafik entfernen'
	  },
	  video: {
		video: 'Video',
		videoLink: 'Video Link',
		insert: 'Video einfügen',
		url: 'Video URL?',
		providers: '(YouTube, Vimeo, Vine, Instagram, DailyMotion oder Youku)'
	  },
	  link: {
		link: 'Link',
		insert: 'Link einfügen',
		unlink: 'Link entfernen',
		edit: 'Editieren',
		textToDisplay: 'Anzeigetext',
		url: 'Ziel des Links?',
		openInNewWindow: 'In einem neuen Fenster öffnen'
	  },
	  table: {
		table: 'Tabelle'
	  },
	  hr: {
		insert: 'Eine horizontale Linie einfügen'
	  },
	  style: {
		style: 'Stil',
		p: 'p',
		blockquote: 'Zitat',
		pre: 'Quellcode',
		h1: 'Überschrift 1',
		h2: 'Überschrift 2',
		h3: 'Überschrift 3',
		h4: 'Überschrift 4',
		h5: 'Überschrift 5',
		h6: 'Überschrift 6'
	  },
	  lists: {
		unordered: 'Aufzählung',
		ordered: 'Nummerierung'
	  },
	  options: {
		help: 'Hilfe',
		fullscreen: 'Vollbild',
		codeview: 'HTML-Code anzeigen'
	  },
	  paragraph: {
		paragraph: 'Absatz',
		outdent: 'Einzug vergrößern',
		indent: 'Einzug verkleinern',
		left: 'Links ausrichten',
		center: 'Zentriert ausrichten',
		right: 'Rechts ausrichten',
		justify: 'Blocksatz'
	  },
	  color: {
		recent: 'Letzte Farbe',
		more: 'Mehr Farben',
		background: 'Hintergrundfarbe',
		foreground: 'Schriftfarbe',
		transparent: 'Transparenz',
		setTransparent: 'Transparenz setzen',
		reset: 'Zurücksetzen',
		resetToDefault: 'Auf Standard zurücksetzen'
	  },
	  shortcut: {
		shortcuts: 'Tastenkürzel',
		close: 'Schließen',
		textFormatting: 'Textformatierung',
		action: 'Aktion',
		paragraphFormatting: 'Absatzformatierung',
		documentStyle: 'Dokumentenstil'
	  },
	  history: {
		undo: 'Rückgängig',
		redo: 'Wiederholen'
	  }

	},
	'es-ES': {
      font: {
        bold: 'Negrita',
        italic: 'Cursiva',
        underline: 'Subrayado',
        clear: 'Quitar estilo de fuente',
        height: 'Altura de línea',
        name: 'Fuente',
        strikethrough: 'Tachado',
        superscript: 'Superíndice',
        subscript: 'Subíndice',
        size: 'Tamaño de la fuente'
      },
      image: {
        image: 'Imagen',
        insert: 'Insertar imagen',
        resizeFull: 'Redimensionar a tamaño completo',
        resizeHalf: 'Redimensionar a la mitad',
        resizeQuarter: 'Redimensionar a un cuarto',
        floatLeft: 'Flotar a la izquierda',
        floatRight: 'Flotar a la derecha',
        floatNone: 'No flotar',
        shapeRounded: 'Forma: Redondeado',
        shapeCircle: 'Forma: Círculo',
        shapeThumbnail: 'Forma: Marco',
        shapeNone: 'Forma: Ninguna',
        dragImageHere: 'Arrastrar una imagen o texto aquí',
        dropImage: 'Suelta la imagen o texto',
        selectFromFiles: 'Seleccionar desde los archivos',
        maximumFileSize: 'Tamaño máximo del archivo',
        maximumFileSizeError: 'Has superado el tamaño máximo del archivo.',
        url: 'URL de la imagen',
        remove: 'Eliminar imagen'
      },
      video: {
        video: 'Vídeo',
        videoLink: 'Link del vídeo',
        insert: 'Insertar vídeo',
        url: '¿URL del vídeo?',
        providers: '(YouTube, Vimeo, Vine, Instagram, DailyMotion o Youku)'
      },
      link: {
        link: 'Link',
        insert: 'Insertar link',
        unlink: 'Quitar link',
        edit: 'Editar',
        textToDisplay: 'Texto para mostrar',
        url: '¿Hacia que URL lleva el link?',
        openInNewWindow: 'Abrir en una nueva ventana'
      },
      table: {
        table: 'Tabla'
      },
      hr: {
        insert: 'Insertar línea horizontal'
      },
      style: {
        style: 'Estilo',
        p: 'p',
        blockquote: 'Cita',
        pre: 'Código',
        h1: 'Título 1',
        h2: 'Título 2',
        h3: 'Título 3',
        h4: 'Título 4',
        h5: 'Título 5',
        h6: 'Título 6'
      },
      lists: {
        unordered: 'Lista desordenada',
        ordered: 'Lista ordenada'
      },
      options: {
        help: 'Ayuda',
        fullscreen: 'Pantalla completa',
        codeview: 'Ver código fuente'
      },
      paragraph: {
        paragraph: 'Párrafo',
        outdent: 'Menos tabulación',
        indent: 'Más tabulación',
        left: 'Alinear a la izquierda',
        center: 'Alinear al centro',
        right: 'Alinear a la derecha',
        justify: 'Justificar'
      },
      color: {
        recent: 'Último color',
        more: 'Más colores',
        background: 'Color de fondo',
        foreground: 'Color de fuente',
        transparent: 'Transparente',
        setTransparent: 'Establecer transparente',
        reset: 'Restaurar',
        resetToDefault: 'Restaurar por defecto'
      },
      shortcut: {
        shortcuts: 'Atajos de teclado',
        close: 'Cerrar',
        textFormatting: 'Formato de texto',
        action: 'Acción',
        paragraphFormatting: 'Formato de párrafo',
        documentStyle: 'Estilo de documento',
        extraKeys: 'Teclas adicionales'
      },
      help : {
        'insertParagraph': 'Insertar párrafo',
        'undo': 'Deshacer última acción',
        'redo': 'Rehacer última acción',
        'tab': 'Tabular',
        'untab': 'Eliminar tabulación',
        'bold': 'Establecer estilo negrita',
        'italic': 'Establecer estilo cursiva',
        'underline': 'Establecer estilo subrayado',
        'strikethrough': 'Establecer estilo tachado',
        'removeFormat': 'Limpiar estilo',
        'justifyLeft': 'Alinear a la izquierda',
        'justifyCenter': 'Alinear al centro',
        'justifyRight': 'Alinear a la derecha',
        'justifyFull': 'Justificar',
        'insertUnorderedList': 'Insertar lista desordenada',
        'insertOrderedList': 'Insertar lista ordenada',
        'outdent': 'Reducir tabulación del párrafo',
        'indent': 'Aumentar tabulación del párrafo',
        'formatPara': 'Cambiar estilo del bloque a párrafo (etiqueta P)',
        'formatH1': 'Cambiar estilo del bloque a H1',
        'formatH2': 'Cambiar estilo del bloque a H2',
        'formatH3': 'Cambiar estilo del bloque a H3',
        'formatH4': 'Cambiar estilo del bloque a H4',
        'formatH5': 'Cambiar estilo del bloque a H5',
        'formatH6': 'Cambiar estilo del bloque a H6',
        'insertHorizontalRule': 'Insertar línea horizontal',
        'linkDialog.show': 'Mostrar panel enlaces'
      },
      history: {
        undo: 'Deshacer',
        redo: 'Rehacer'
      },
      specialChar: {
        specialChar: 'CARACTERES ESPECIALES',
        select: 'Selecciona Caracteres especiales'
      }
    },
    'es-EU': {
      font: {
        bold: 'Lodia',
        italic: 'Etzana',
        underline: 'Azpimarratua',
        clear: 'Estiloa kendu',
        height: 'Lerro altuera',
        name: 'Tipografia',
        strikethrough: 'Marratua',
        size: 'Letren neurria'
      },
      image: {
        image: 'Irudia',
        insert: 'Irudi bat txertatu',
        resizeFull: 'Jatorrizko neurrira aldatu',
        resizeHalf: 'Neurria erdira aldatu',
        resizeQuarter: 'Neurria laurdenera aldatu',
        floatLeft: 'Ezkerrean kokatu',
        floatRight: 'Eskuinean kokatu',
        floatNone: 'Kokapenik ez ezarri',
        dragImageHere: 'Irudi bat ezarri hemen',
        selectFromFiles: 'Zure fitxategi bat aukeratu',
        url: 'Irudiaren URL helbidea'
      },
      video: {
        video: 'Bideoa',
        videoLink: 'Bideorako esteka',
        insert: 'Bideo berri bat txertatu',
        url: 'Bideoaren URL helbidea',
        providers: '(YouTube, Vimeo, Vine, Instagram edo DailyMotion)'
      },
      link: {
        link: 'Esteka',
        insert: 'Esteka bat txertatu',
        unlink: 'Esteka ezabatu',
        edit: 'Editatu',
        textToDisplay: 'Estekaren testua',
        url: 'Estekaren URL helbidea',
        openInNewWindow: 'Leiho berri batean ireki'
      },
      table: {
        table: 'Taula' //Tabla
      },
      hr: {
        insert: 'Marra horizontala txertatu' //Insertar línea horizontal
      },
      style: {
        style: 'Estiloa',
        p: 'p',
        blockquote: 'Aipamena',
        pre: 'Kodea',
        h1: '1. izenburua',
        h2: '2. izenburua',
        h3: '3. izenburua',
        h4: '4. izenburua',
        h5: '5. izenburua',
        h6: '6. izenburua'
      },
      lists: {
        unordered: 'Ordenatu gabeko zerrenda',
        ordered: 'Zerrenda ordenatua'
      },
      options: {
        help: 'Laguntza',
        fullscreen: 'Pantaila osoa',
        codeview: 'Kodea ikusi'
      },
      paragraph: {
        paragraph: 'Paragrafoa',
        outdent: 'Koska txikiagoa',
        indent: 'Koska handiagoa',
        left: 'Ezkerrean kokatu',
        center: 'Erdian kokatu',
        right: 'Eskuinean kokatu',
        justify: 'Justifikatu'
      },
      color: {
        recent: 'Azken kolorea',
        more: 'Kolore gehiago',
        background: 'Atzeko planoa',
        foreground: 'Aurreko planoa',
        transparent: 'Gardena',
        setTransparent: 'Gardendu',
        reset: 'Lehengoratu',
        resetToDefault: 'Berrezarri lehenetsia'
      },
      shortcut: {
        shortcuts: 'Lasterbideak',
        close: 'Itxi',
        textFormatting: 'Testuaren formatua',
        action: 'Ekintza',
        paragraphFormatting: 'Paragrafoaren formatua',
        documentStyle: 'Dokumentuaren estiloa'
      },
      history: {
        undo: 'Desegin',
        redo: 'Berregin'
      }
    },
    'fa-IR': {
      font: {
        bold: 'درشت',
        italic: 'خمیده',
        underline: 'میان خط',
        clear: 'پاک کردن فرمت فونت',
        height: 'فاصله ی خطی',
        name: 'اسم فونت',
        strikethrough: 'Strike',
        size: 'اندازه ی فونت'
      },
      image: {
        image: 'تصویر',
        insert: 'وارد کردن تصویر',
        resizeFull: 'تغییر به اندازه ی کامل',
        resizeHalf: 'تغییر به اندازه نصف',
        resizeQuarter: 'تغییر به اندازه یک چهارم',
        floatLeft: 'چسباندن به چپ',
        floatRight: 'چسباندن به راست',
        floatNone: 'بدون چسبندگی',
        dragImageHere: 'یک تصویر را اینجا بکشید',
        selectFromFiles: 'فایل ها را انتخاب کنید',
        url: 'آدرس تصویر',
        remove: 'حذف تصویر'
      },
      video: {
        video: 'ویدیو',
        videoLink: 'لینک ویدیو',
        insert: 'افزودن ویدیو',
        url: 'آدرس ویدیو ؟',
        providers: '(YouTube, Vimeo, Vine, Instagram, DailyMotion یا Youku)'
      },
      link: {
        link: 'لینک',
        insert: 'اضافه کردن لینک',
        unlink: 'حذف لینک',
        edit: 'ویرایش',
        textToDisplay: 'متن جهت نمایش',
        url: 'این لینک به چه آدرسی باید برود ؟',
        openInNewWindow: 'در یک پنجره ی جدید باز شود'
      },
      table: {
        table: 'جدول'
      },
      hr: {
        insert: 'افزودن خط افقی'
      },
      style: {
        style: 'استیل',
        p: 'نرمال',
        blockquote: 'نقل قول',
        pre: 'کد',
        h1: 'سرتیتر 1',
        h2: 'سرتیتر 2',
        h3: 'سرتیتر 3',
        h4: 'سرتیتر 4',
        h5: 'سرتیتر 5',
        h6: 'سرتیتر 6'
      },
      lists: {
        unordered: 'لیست غیر ترتیبی',
        ordered: 'لیست ترتیبی'
      },
      options: {
        help: 'راهنما',
        fullscreen: 'نمایش تمام صفحه',
        codeview: 'مشاهده ی کد'
      },
      paragraph: {
        paragraph: 'پاراگراف',
        outdent: 'کاهش تو رفتگی',
        indent: 'افزایش تو رفتگی',
        left: 'چپ چین',
        center: 'میان چین',
        right: 'راست چین',
        justify: 'بلوک چین'
      },
      color: {
        recent: 'رنگ اخیرا استفاده شده',
        more: 'رنگ بیشتر',
        background: 'رنگ پس زمینه',
        foreground: 'رنگ متن',
        transparent: 'بی رنگ',
        setTransparent: 'تنظیم حالت بی رنگ',
        reset: 'بازنشاندن',
        resetToDefault: 'حالت پیش فرض'
      },
      shortcut: {
        shortcuts: 'دکمه های میان بر',
        close: 'بستن',
        textFormatting: 'فرمت متن',
        action: 'عملیات',
        paragraphFormatting: 'فرمت پاراگراف',
        documentStyle: 'استیل سند'
      },
      history: {
        undo: 'واچیدن',
        redo: 'بازچیدن'
      }
    },
    'fi-FI': {
      font: {
        bold: 'Lihavoitu',
        italic: 'Kursiivi',
        underline: 'Alleviivaa',
        clear: 'Tyhjennä muotoilu',
        height: 'Riviväli',
        name: 'Kirjasintyyppi',
        strikethrough: 'Yliviivaus',
        size: 'Kirjasinkoko'
      },
      image: {
        image: 'Kuva',
        insert: 'Lisää kuva',
        resizeFull: 'Koko leveys',
        resizeHalf: 'Puolikas leveys',
        resizeQuarter: 'Neljäsosa leveys',
        floatLeft: 'Sijoita vasemmalle',
        floatRight: 'Sijoita oikealle',
        floatNone: 'Ei sijoitusta',
        dragImageHere: 'Vedä kuva tähän',
        selectFromFiles: 'Valitse tiedostoista',
        url: 'URL-osoitteen mukaan',
        remove: 'Poista kuva'
      },
      video: {
        video: 'Video',
        videoLink: 'Linkki videoon',
        insert: 'Lisää video',
        url: 'Videon URL-osoite?',
        providers: '(YouTube, Vimeo, Vine, Instagram, DailyMotion tai Youku)'
      },
      link: {
        link: 'Linkki',
        insert: 'Lisää linkki',
        unlink: 'Poista linkki',
        edit: 'Muokkaa',
        textToDisplay: 'Näytettävä teksti',
        url: 'Linkin URL-osoite?',
        openInNewWindow: 'Avaa uudessa ikkunassa'
      },
      table: {
        table: 'Taulukko'
      },
      hr: {
        insert: 'Lisää vaakaviiva'
      },
      style: {
        style: 'Tyyli',
        p: 'Normaali',
        blockquote: 'Lainaus',
        pre: 'Koodi',
        h1: 'Otsikko 1',
        h2: 'Otsikko 2',
        h3: 'Otsikko 3',
        h4: 'Otsikko 4',
        h5: 'Otsikko 5',
        h6: 'Otsikko 6'
      },
      lists: {
        unordered: 'Luettelomerkitty luettelo',
        ordered: 'Numeroitu luettelo'
      },
      options: {
        help: 'Ohje',
        fullscreen: 'Koko näyttö',
        codeview: 'HTML-näkymä'
      },
      paragraph: {
        paragraph: 'Kappale',
        outdent: 'Pienennä sisennystä',
        indent: 'Suurenna sisennystä',
        left: 'Tasaus vasemmalle',
        center: 'Keskitä',
        right: 'Tasaus oikealle',
        justify: 'Tasaa'
      },
      color: {
        recent: 'Viimeisin väri',
        more: 'Lisää värejä',
        background: 'Taustaväri',
        foreground: 'Tekstin väri',
        transparent: 'Läpinäkyvä',
        setTransparent: 'Aseta läpinäkyväksi',
        reset: 'Palauta',
        resetToDefault: 'Palauta oletusarvoksi'
      },
      shortcut: {
        shortcuts: 'Pikanäppäimet',
        close: 'Sulje',
        textFormatting: 'Tekstin muotoilu',
        action: 'Toiminto',
        paragraphFormatting: 'Kappaleen muotoilu',
        documentStyle: 'Asiakirjan tyyli'
      },
      history: {
        undo: 'Kumoa',
        redo: 'Toista'
      }
    },
    'fr-FR': {
      font: {
        bold: 'Gras',
        italic: 'Italique',
        underline: 'Souligné',
        clear: 'Effacer la mise en forme',
        height: 'Interligne',
        name: 'Famille de police',
        strikethrough: 'Barré',
        superscript: 'Exposant',
        subscript: 'Indice',
        size: 'Taille de police'
      },
      image: {
        image: 'Image',
        insert: 'Insérer une image',
        resizeFull: 'Taille originale',
        resizeHalf: 'Redimensionner à 50 %',
        resizeQuarter: 'Redimensionner à 25 %',
        floatLeft: 'Aligné à gauche',
        floatRight: 'Aligné à droite',
        floatNone: 'Pas d\'alignement',
        shapeRounded: 'Forme: Rectangle arrondie',
        shapeCircle: 'Forme: Cercle',
        shapeThumbnail: 'Forme: Vignette',
        shapeNone: 'Forme: Aucune',
        dragImageHere: 'Faites glisser une image ou un texte dans ce cadre',
        dropImage: 'Lachez l\'image ou le texte',
        selectFromFiles: 'Choisir un fichier',
        maximumFileSize: 'Taille de fichier maximale',
        maximumFileSizeError: 'Taille maximale du fichier dépassée',
        url: 'URL de l\'image',
        remove: 'Supprimer l\'image'
      },
      video: {
        video: 'Vidéo',
        videoLink: 'Lien vidéo',
        insert: 'Insérer une vidéo',
        url: 'URL de la vidéo',
        providers: '(YouTube, Vimeo, Vine, Instagram, DailyMotion ou Youku)'
      },
      link: {
        link: 'Lien',
        insert: 'Insérer un lien',
        unlink: 'Supprimer un lien',
        edit: 'Modifier',
        textToDisplay: 'Texte à afficher',
        url: 'URL du lien',
        openInNewWindow: 'Ouvrir dans une nouvelle fenêtre'
      },
      table: {
        table: 'Tableau'
      },
      hr: {
        insert: 'Insérer une ligne horizontale'
      },
      style: {
        style: 'Style',
        p: 'p',
        blockquote: 'Citation',
        pre: 'Code source',
        h1: 'Titre 1',
        h2: 'Titre 2',
        h3: 'Titre 3',
        h4: 'Titre 4',
        h5: 'Titre 5',
        h6: 'Titre 6'
      },
      lists: {
        unordered: 'Liste à puces',
        ordered: 'Liste numérotée'
      },
      options: {
        help: 'Aide',
        fullscreen: 'Plein écran',
        codeview: 'Afficher le code HTML'
      },
      paragraph: {
        paragraph: 'Paragraphe',
        outdent: 'Diminuer le retrait',
        indent: 'Augmenter le retrait',
        left: 'Aligner à gauche',
        center: 'Centrer',
        right: 'Aligner à droite',
        justify: 'Justifier'
      },
      color: {
        recent: 'Dernière couleur sélectionnée',
        more: 'Plus de couleurs',
        background: 'Couleur de fond',
        foreground: 'Couleur de police',
        transparent: 'Transparent',
        setTransparent: 'Définir la transparence',
        reset: 'Restaurer',
        resetToDefault: 'Restaurer la couleur par défaut'
      },
      shortcut: {
        shortcuts: 'Raccourcis',
        close: 'Fermer',
        textFormatting: 'Mise en forme du texte',
        action: 'Action',
        paragraphFormatting: 'Mise en forme des paragraphes',
        documentStyle: 'Style du document',
        extraKeys: 'Touches supplémentaires'
      },
      history: {
        undo: 'Annuler la dernière action',
        redo: 'Restaurer la dernière action annulée'
      }

    },
    'gl-ES': {
      font: {
        bold: 'Negrita',
        italic: 'Cursiva',
        underline: 'Subliñado',
        clear: 'Quitar estilo de fonte',
        height: 'Altura de liña',
        name: 'Fonte',
        strikethrough: 'Riscado',
        superscript: 'Superíndice',
        subscript: 'Subíndice',
        size: 'Tamaño da fonte'
      },
      image: {
        image: 'Imaxe',
        insert: 'Inserir imaxe',
        resizeFull: 'Redimensionar a tamaño completo',
        resizeHalf: 'Redimensionar á metade',
        resizeQuarter: 'Redimensionar a un cuarto',
        floatLeft: 'Flotar á esquerda',
        floatRight: 'Flotar á dereita',
        floatNone: 'Non flotar',
        shapeRounded: 'Forma: Redondeado',
        shapeCircle: 'Forma: Círculo',
        shapeThumbnail: 'Forma: Marco',
        shapeNone: 'Forma: Ningunha',
        dragImageHere: 'Arrastrar unha imaxe ou texto aquí',
        dropImage: 'Solta a imaxe ou texto',
        selectFromFiles: 'Seleccionar desde os arquivos',
        maximumFileSize: 'Tamaño máximo do arquivo',
        maximumFileSizeError: 'Superaches o tamaño máximo do arquivo.',
        url: 'URL da imaxe',
        remove: 'Eliminar imaxe'
      },
      video: {
        video: 'Vídeo',
        videoLink: 'Ligazón do vídeo',
        insert: 'Insertar vídeo',
        url: 'URL do vídeo?',
        providers: '(YouTube, Vimeo, Vine, Instagram, DailyMotion, o Youku)'
      },
      link: {
        link: 'Ligazón',
        insert: 'Inserir Ligazón',
        unlink: 'Quitar Ligazón',
        edit: 'Editar',
        textToDisplay: 'Texto para amosar',
        url: 'Cara a que URL leva a ligazón?',
        openInNewWindow: 'Abrir nunha nova xanela'
      },
      table: {
        table: 'Táboa'
      },
      hr: {
        insert: 'Inserir liña horizontal'
      },
      style: {
        style: 'Estilo',
        normal: 'Normal',
        blockquote: 'Cita',
        pre: 'Código',
        h1: 'Título 1',
        h2: 'Título 2',
        h3: 'Título 3',
        h4: 'Título 4',
        h5: 'Título 5',
        h6: 'Título 6'
      },
      lists: {
        unordered: 'Lista desordenada',
        ordered: 'Lista ordenada'
      },
      options: {
        help: 'Axuda',
        fullscreen: 'Pantalla completa',
        codeview: 'Ver código fonte'
      },
      paragraph: {
        paragraph: 'Parágrafo',
        outdent: 'Menos tabulación',
        indent: 'Máis tabulación',
        left: 'Aliñar á esquerda',
        center: 'Aliñar ao centro',
        right: 'Aliñar á dereita',
        justify: 'Xustificar'
      },
      color: {
        recent: 'Última cor',
        more: 'Máis cores',
        background: 'Cor de fondo',
        foreground: 'Cor de fuente',
        transparent: 'Transparente',
        setTransparent: 'Establecer transparente',
        reset: 'Restaurar',
        resetToDefault: 'Restaurar por defecto'
      },
      shortcut: {
        shortcuts: 'Atallos de teclado',
        close: 'Pechar',
        textFormatting: 'Formato de texto',
        action: 'Acción',
        paragraphFormatting: 'Formato de parágrafo',
        documentStyle: 'Estilo de documento',
        extraKeys: 'Teclas adicionais'
      },
      help : {
        'insertParagraph': 'Inserir parágrafo',
        'undo': 'Desfacer última acción',
        'redo': 'Refacer última acción',
        'tab': 'Tabular',
        'untab': 'Eliminar tabulación',
        'bold': 'Establecer estilo negrita',
        'italic': 'Establecer estilo cursiva',
        'underline': 'Establecer estilo subliñado',
        'strikethrough': 'Establecer estilo riscado',
        'removeFormat': 'Limpar estilo',
        'justifyLeft': 'Aliñar á esquerda',
        'justifyCenter': 'Aliñar ao centro',
        'justifyRight': 'Aliñar á dereita',
        'justifyFull': 'Xustificar',
        'insertUnorderedList': 'Inserir lista desordenada',
        'insertOrderedList': 'Inserir lista ordenada',
        'outdent': 'Reducir tabulación do parágrafo',
        'indent': 'Aumentar tabulación do parágrafo',
        'formatPara': 'Mudar estilo do bloque a parágrafo (etiqueta P)',
        'formatH1': 'Mudar estilo do bloque a H1',
        'formatH2': 'Mudar estilo do bloque a H2',
        'formatH3': 'Mudar estilo do bloque a H3',
        'formatH4': 'Mudar estilo do bloque a H4',
        'formatH5': 'Mudar estilo do bloque a H5',
        'formatH6': 'Mudar estilo do bloque a H6',
        'insertHorizontalRule': 'Inserir liña horizontal',
        'linkDialog.show': 'Amosar panel ligazóns'
      },
      history: {
        undo: 'Desfacer',
        redo: 'Refacer'
      },
      specialChar: {
        specialChar: 'CARACTERES ESPECIAIS',
        select: 'Selecciona Caracteres especiais'
      }
    },
    'he-IL': {
      font: {
        bold: 'מודגש',
        italic: 'נטוי',
        underline: 'קו תחתון',
        clear: 'נקה עיצוב',
        height: 'גובה',
        name: 'גופן',
        strikethrough: 'קו חוצה',
        subscript: 'כתב תחתי',
        superscript: 'כתב עילי',
        size: 'גודל גופן'
      },
      image: {
        image: 'תמונה',
        insert: 'הוסף תמונה',
        resizeFull: 'גודל מלא',
        resizeHalf: 'להקטין לחצי',
        resizeQuarter: 'להקטין לרבע',
        floatLeft: 'יישור לשמאל',
        floatRight: 'יישור לימין',
        floatNone: 'ישר',
        dragImageHere: 'גרור תמונה לכאן',
        selectFromFiles: 'בחר מתוך קבצים',
        url: 'נתיב לתמונה',
        remove: 'הסר תמונה'
      },
      video: {
        video: 'סרטון',
        videoLink: 'קישור לסרטון',
        insert: 'הוסף סרטון',
        url: 'קישור לסרטון',
        providers: '(YouTube, Vimeo, Vine, Instagram, DailyMotion או Youku)'
      },
      link: {
        link: 'קישור',
        insert: 'הוסף קישור',
        unlink: 'הסר קישור',
        edit: 'ערוך',
        textToDisplay: 'טקסט להציג',
        url: 'קישור',
        openInNewWindow: 'פתח בחלון חדש'
      },
      table: {
        table: 'טבלה'
      },
      hr: {
        insert: 'הוסף קו'
      },
      style: {
        style: 'עיצוב',
        p: 'טקסט רגיל',
        blockquote: 'ציטוט',
        pre: 'קוד',
        h1: 'כותרת 1',
        h2: 'כותרת 2',
        h3: 'כותרת 3',
        h4: 'כותרת 4',
        h5: 'כותרת 5',
        h6: 'כותרת 6'
      },
      lists: {
        unordered: 'רשימת תבליטים',
        ordered: 'רשימה ממוספרת'
      },
      options: {
        help: 'עזרה',
        fullscreen: 'מסך מלא',
        codeview: 'תצוגת קוד'
      },
      paragraph: {
        paragraph: 'פסקה',
        outdent: 'הקטן כניסה',
        indent: 'הגדל כניסה',
        left: 'יישור לשמאל',
        center: 'יישור למרכז',
        right: 'יישור לימין',
        justify: 'מיושר'
      },
      color: {
        recent: 'צבע טקסט אחרון',
        more: 'עוד צבעים',
        background: 'צבע רקע',
        foreground: 'צבע טקסט',
        transparent: 'שקוף',
        setTransparent: 'קבע כשקוף',
        reset: 'איפוס',
        resetToDefault: 'אפס לברירת מחדל'
      },
      shortcut: {
        shortcuts: 'קיצורי מקלדת',
        close: 'סגור',
        textFormatting: 'עיצוב הטקסט',
        action: 'פעולה',
        paragraphFormatting: 'סגנונות פסקה',
        documentStyle: 'עיצוב המסמך',
        extraKeys: 'קיצורים נוספים'
      },
      history: {
        undo: 'בטל פעולה',
        redo: 'בצע שוב'
      }
    },
    'hr-HR': {
      font: {
        bold: 'Podebljano',
        italic: 'Kurziv',
        underline: 'Podvučeno',
        clear: 'Ukloni stilove fonta',
        height: 'Visina linije',
        strikethrough: 'Precrtano',
        size: 'Veličina fonta'
      },
      image: {
        image: 'Slika',
        insert: 'Ubaci sliku',
        resizeFull: 'Puna veličina',
        resizeHalf: 'Umanji na 50%',
        resizeQuarter: 'Umanji na 25%',
        floatLeft: 'Poravnaj lijevo',
        floatRight: 'Poravnaj desno',
        floatNone: 'Bez poravnanja',
        dragImageHere: 'Povuci sliku ovdje',
        selectFromFiles: 'Izaberi iz datoteke',
        url: 'Adresa slike',
        remove: 'Ukloni sliku'
      },
      video: {
        video: 'Video',
        videoLink: 'Veza na video',
        insert: 'Ubaci video',
        url: 'URL video',
        providers: '(YouTube, Vimeo, Vine, Instagram, DailyMotion ili Youku)'
      },
      link: {
        link: 'Veza',
        insert: 'Ubaci vezu',
        unlink: 'Ukloni vezu',
        edit: 'Uredi',
        textToDisplay: 'Tekst za prikaz',
        url: 'Internet adresa',
        openInNewWindow: 'Otvori u novom prozoru'
      },
      table: {
        table: 'Tablica'
      },
      hr: {
        insert: 'Ubaci horizontalnu liniju'
      },
      style: {
        style: 'Stil',
        p: 'pni',
        blockquote: 'Citat',
        pre: 'Kôd',
        h1: 'Naslov 1',
        h2: 'Naslov 2',
        h3: 'Naslov 3',
        h4: 'Naslov 4',
        h5: 'Naslov 5',
        h6: 'Naslov 6'
      },
      lists: {
        unordered: 'Obična lista',
        ordered: 'Numerirana lista'
      },
      options: {
        help: 'Pomoć',
        fullscreen: 'Preko cijelog ekrana',
        codeview: 'Izvorni kôd'
      },
      paragraph: {
        paragraph: 'Paragraf',
        outdent: 'Smanji uvlačenje',
        indent: 'Povećaj uvlačenje',
        left: 'Poravnaj lijevo',
        center: 'Centrirano',
        right: 'Poravnaj desno',
        justify: 'Poravnaj obostrano'
      },
      color: {
        recent: 'Posljednja boja',
        more: 'Više boja',
        background: 'Boja pozadine',
        foreground: 'Boja teksta',
        transparent: 'Prozirna',
        setTransparent: 'Prozirna',
        reset: 'Poništi',
        resetToDefault: 'Podrazumijevana'
      },
      shortcut: {
        shortcuts: 'Prečice s tipkovnice',
        close: 'Zatvori',
        textFormatting: 'Formatiranje teksta',
        action: 'Akcija',
        paragraphFormatting: 'Formatiranje paragrafa',
        documentStyle: 'Stil dokumenta',
        extraKeys: 'Dodatne kombinacije'
      },
      history: {
        undo: 'Poništi',
        redo: 'Ponovi'
      }
    },
    'hu-HU': {
      font: {
        bold: 'Félkövér',
        italic: 'Dőlt',
        underline: 'Aláhúzott',
        clear: 'Formázás törlése',
        height: 'Sorköz',
        name: 'Betűtípus',
        strikethrough: 'Áthúzott',
        size: 'Betűméret'
      },
      image: {
        image: 'Kép',
        insert: 'Kép beszúrása',
        resizeFull: 'Átméretezés teljes méretre',
        resizeHalf: 'Átméretezés felére',
        resizeQuarter: 'Átméretezés negyedére',
        floatLeft: 'Igazítás balra',
        floatRight: 'Igazítás jobbra',
        floatNone: 'Igazítás törlése',
        dragImageHere: 'Ide húzhat képet vagy szöveget',
        dropImage: 'Engedje el a képet vagy szöveget',
        selectFromFiles: 'Fájlok kiválasztása',
        url: 'Kép URL címe',
        remove: 'Kép törlése'
      },
      video: {
        video: 'Videó',
        videoLink: 'Videó hivatkozás',
        insert: 'Videó beszúrása',
        url: 'Videó URL címe',
        providers: '(YouTube, Vimeo, Vine, Instagram, DailyMotion vagy Youku)'
      },
      link: {
        link: 'Hivatkozás',
        insert: 'Hivatkozás beszúrása',
        unlink: 'Hivatkozás megszüntetése',
        edit: 'Szerkesztés',
        textToDisplay: 'Megjelenítendő szöveg',
        url: 'Milyen URL címre hivatkozzon?',
        openInNewWindow: 'Megnyitás új ablakban'
      },
      table: {
        table: 'Táblázat'
      },
      hr: {
        insert: 'Elválasztó vonal beszúrása'
      },
      style: {
        style: 'Stílus',
        p: 'Normál',
        blockquote: 'Idézet',
        pre: 'Kód',
        h1: 'Fejléc 1',
        h2: 'Fejléc 2',
        h3: 'Fejléc 3',
        h4: 'Fejléc 4',
        h5: 'Fejléc 5',
        h6: 'Fejléc 6'
      },
      lists: {
        unordered: 'Listajeles lista',
        ordered: 'Számozott lista'
      },
      options: {
        help: 'Súgó',
        fullscreen: 'Teljes képernyő',
        codeview: 'Kód nézet'
      },
      paragraph: {
        paragraph: 'Bekezdés',
        outdent: 'Behúzás csökkentése',
        indent: 'Behúzás növelése',
        left: 'Igazítás balra',
        center: 'Igazítás középre',
        right: 'Igazítás jobbra',
        justify: 'Sorkizárt'
      },
      color: {
        recent: 'Jelenlegi szín',
        more: 'További színek',
        background: 'Háttérszín',
        foreground: 'Betűszín',
        transparent: 'Átlátszó',
        setTransparent: 'Átlászóság beállítása',
        reset: 'Visszaállítás',
        resetToDefault: 'Alaphelyzetbe állítás'
      },
      shortcut: {
        shortcuts: 'Gyorsbillentyű',
        close: 'Bezárás',
        textFormatting: 'Szöveg formázása',
        action: 'Művelet',
        paragraphFormatting: 'Bekezdés formázása',
        documentStyle: 'Dokumentumstílus'
      },
      help: {
        'insertParagraph': 'Új bekezdés',
        'undo': 'Visszavonás',
        'redo': 'Újra',
        'tab': 'Behúzás növelése',
        'untab': 'Behúzás csökkentése',
        'bold': 'Félkövérre állítás',
        'italic': 'Dőltre állítás',
        'underline': 'Aláhúzás',
        'strikethrough': 'Áthúzás',
        'removeFormat': 'Formázás törlése',
        'justifyLeft': 'Balra igazítás',
        'justifyCenter': 'Középre igazítás',
        'justifyRight': 'Jobbra igazítás',
        'justifyFull': 'Sorkizárt',
        'insertUnorderedList': 'Számozatlan lista be/ki',
        'insertOrderedList': 'Számozott lista be/ki',
        'outdent': 'Jelenlegi bekezdés behúzásának megszüntetése',
        'indent': 'Jelenlegi bekezdés behúzása',
        'formatPara': 'Blokk formázása bekezdésként (P tag)',
        'formatH1': 'Blokk formázása, mint Fejléc 1',
        'formatH2': 'Blokk formázása, mint Fejléc 2',
        'formatH3': 'Blokk formázása, mint Fejléc 3',
        'formatH4': 'Blokk formázása, mint Fejléc 4',
        'formatH5': 'Blokk formázása, mint Fejléc 5',
        'formatH6': 'Blokk formázása, mint Fejléc 6',
        'insertHorizontalRule': 'Vízszintes vonal beszúrása',
        'linkDialog.show': 'Link párbeszédablak megjelenítése'
      },
      history: {
        undo: 'Visszavonás',
        redo: 'Újra'
      }

    },
    'id-ID': {
      font: {
        bold: 'Tebal',
        italic: 'Miring',
        underline: 'Garis bawah',
        clear: 'Bersihkan gaya',
        height: 'Jarak baris',
        strikethrough: 'Coret',
        size: 'Ukuran font'
      },
      image: {
        image: 'Gambar',
        insert: 'Sisipkan gambar',
        resizeFull: 'Ukuran penuh',
        resizeHalf: 'Ukuran 50%',
        resizeQuarter: 'Ukuran 25%',
        floatLeft: 'Rata kiri',
        floatRight: 'Rata kanan',
        floatNone: 'Tidak ada perataan',
        dragImageHere: 'Tarik gambar pada area ini',
        selectFromFiles: 'Pilih gambar dari berkas',
        url: 'URL gambar',
        remove: 'Hapus Gambar'
      },
      video: {
        video: 'Video',
        videoLink: 'Link video',
        insert: 'Sisipkan video',
        url: 'Tautan video',
        providers: '(YouTube, Vimeo, Vine, Instagram, DailyMotion atau Youku)'
      },
      link: {
        link: 'Tautan',
        insert: 'Tambah tautan',
        unlink: 'Hapus tautan',
        edit: 'Edit',
        textToDisplay: 'Tampilan teks',
        url: 'Tautan tujuan',
        openInNewWindow: 'Buka di jendela baru'
      },
      table: {
        table: 'Tabel'
      },
      hr: {
        insert: 'Masukkan garis horizontal'
      },
      style: {
        style: 'Gaya',
        p: 'p',
        blockquote: 'Kutipan',
        pre: 'Kode',
        h1: 'Heading 1',
        h2: 'Heading 2',
        h3: 'Heading 3',
        h4: 'Heading 4',
        h5: 'Heading 5',
        h6: 'Heading 6'
      },
      lists: {
        unordered: 'Pencacahan',
        ordered: 'Penomoran'
      },
      options: {
        help: 'Bantuan',
        fullscreen: 'Layar penuh',
        codeview: 'Kode HTML'
      },
      paragraph: {
        paragraph: 'Paragraf',
        outdent: 'Outdent',
        indent: 'Indent',
        left: 'Rata kiri',
        center: 'Rata tengah',
        right: 'Rata kanan',
        justify: 'Rata kanan kiri'
      },
      color: {
        recent: 'Warna sekarang',
        more: 'Selengkapnya',
        background: 'Warna latar',
        foreground: 'Warna font',
        transparent: 'Transparan',
        setTransparent: 'Atur transparansi',
        reset: 'Atur ulang',
        resetToDefault: 'Kembalikan kesemula'
      },
      shortcut: {
        shortcuts: 'Jalan pintas',
        close: 'Keluar',
        textFormatting: 'Format teks',
        action: 'Aksi',
        paragraphFormatting: 'Format paragraf',
        documentStyle: 'Gaya dokumen'
      },
      history: {
        undo: 'Kembali',
        redo: 'Ulang'
      }
    },
    'it-IT': {
      font: {
        bold: 'Testo in grassetto',
        italic: 'Testo in corsivo',
        underline: 'Testo sottolineato',
        clear: 'Elimina la formattazione del testo',
        height: 'Altezza della linea di testo',
        name: 'Famiglia Font',
        strikethrough: 'Testo barrato',
        size: 'Dimensione del carattere'
      },
      image: {
        image: 'Immagine',
        insert: 'Inserisci Immagine',
        resizeFull: 'Dimensioni originali',
        resizeHalf: 'Ridimensiona al 50%',
        resizeQuarter: 'Ridimensiona al 25%',
        floatLeft: 'Posiziona a sinistra',
        floatRight: 'Posiziona a destra',
        floatNone: 'Nessun posizionamento',
        dragImageHere: 'Trascina qui un\'immagine',
        selectFromFiles: 'Scegli dai Documenti',
        url: 'URL dell\'immagine',
        remove: 'Rimuovi immagine'
      },
      video: {
        video: 'Video',
        videoLink: 'Collegamento ad un Video',
        insert: 'Inserisci Video',
        url: 'URL del Video',
        providers: '(YouTube, Vimeo, Vine, Instagram, DailyMotion o Youku)'
      },
      link: {
        link: 'Collegamento',
        insert: 'Inserisci Collegamento',
        unlink: 'Elimina collegamento',
        edit: 'Modifica collegamento',
        textToDisplay: 'Testo del collegamento',
        url: 'URL del collegamento',
        openInNewWindow: 'Apri in una nuova finestra'
      },
      table: {
        table: 'Tabella'
      },
      hr: {
        insert: 'Inserisce una linea di separazione'
      },
      style: {
        style: 'Stili',
        p: 'pe',
        blockquote: 'Citazione',
        pre: 'Codice',
        h1: 'Titolo 1',
        h2: 'Titolo 2',
        h3: 'Titolo 3',
        h4: 'Titolo 4',
        h5: 'Titolo 5',
        h6: 'Titolo 6'
      },
      lists: {
        unordered: 'Elenco non ordinato',
        ordered: 'Elenco ordinato'
      },
      options: {
        help: 'Aiuto',
        fullscreen: 'Modalità a tutto schermo',
        codeview: 'Visualizza codice'
      },
      paragraph: {
        paragraph: 'Paragrafo',
        outdent: 'Diminuisce il livello di rientro',
        indent: 'Aumenta il livello di rientro',
        left: 'Allinea a sinistra',
        center: 'Centra',
        right: 'Allinea a destra',
        justify: 'Giustifica (allinea a destra e sinistra)'
      },
      color: {
        recent: 'Ultimo colore utilizzato',
        more: 'Altri colori',
        background: 'Colore di sfondo',
        foreground: 'Colore',
        transparent: 'Trasparente',
        setTransparent: 'Trasparente',
        reset: 'Reimposta',
        resetToDefault: 'Reimposta i colori'
      },
      shortcut: {
        shortcuts: 'Scorciatoie da tastiera',
        close: 'Chiudi',
        textFormatting: 'Formattazione testo',
        action: 'Azioni',
        paragraphFormatting: 'Formattazione paragrafo',
        documentStyle: 'Stili'
      },
      history: {
        undo: 'Annulla',
        redo: 'Ripristina'
      }
    },
    'ja-JP': {
      font: {
        bold: '太字',
        italic: '斜体',
        underline: '下線',
        clear: 'クリア',
        height: '文字高',
        name: 'フォント',
        strikethrough: '取り消し線',
        size: '大きさ'
      },
      image: {
        image: '画像',
        insert: '画像挿入',
        resizeFull: '最大化',
        resizeHalf: '1/2',
        resizeQuarter: '1/4',
        floatLeft: '左寄せ',
        floatRight: '右寄せ',
        floatNone: '寄せ解除',
        dragImageHere: 'ここに画像をドラッグしてください',
        selectFromFiles: '画像ファイルを選ぶ',
        url: 'URLから画像を挿入する',
        remove: '画像を削除する'
      },
      video: {
        video: '動画',
        videoLink: '動画リンク',
        insert: '動画挿入',
        url: '動画のURL',
        providers: '(YouTube, Vimeo, Vine, Instagram, DailyMotion, Youku)'
      },
      link: {
        link: 'リンク',
        insert: 'リンク挿入',
        unlink: 'リンク解除',
        edit: '編集',
        textToDisplay: 'リンク文字列',
        url: 'URLを入力してください',
        openInNewWindow: '新しいウィンドウで開く'
      },
      table: {
        table: 'テーブル'
      },
      hr: {
        insert: '水平線の挿入'
      },
      style: {
        style: 'スタイル',
        p: '標準',
        blockquote: '引用',
        pre: 'コード',
        h1: '見出し1',
        h2: '見出し2',
        h3: '見出し3',
        h4: '見出し4',
        h5: '見出し5',
        h6: '見出し6'
      },
      lists: {
        unordered: '通常リスト',
        ordered: '番号リスト'
      },
      options: {
        help: 'ヘルプ',
        fullscreen: 'フルスクリーン',
        codeview: 'コード表示'
      },
      paragraph: {
        paragraph: '文章',
        outdent: '字上げ',
        indent: '字下げ',
        left: '左寄せ',
        center: '中央寄せ',
        right: '右寄せ',
        justify: '均等割付'
      },
      color: {
        recent: '現在の色',
        more: 'もっと見る',
        background: '背景色',
        foreground: '文字色',
        transparent: '透過率',
        setTransparent: '透過率を設定',
        reset: '標準',
        resetToDefault: '標準に戻す'
      },
      shortcut: {
        shortcuts: 'ショートカット',
        close: '閉じる',
        textFormatting: '文字フォーマット',
        action: 'アクション',
        paragraphFormatting: '文章フォーマット',
        documentStyle: 'ドキュメント形式'
      },
      history: {
        undo: '元に戻す',
        redo: 'やり直す'
      },
      help: {
        'insertParagraph': '改行挿入',
        'undo': '一旦、行った操作を戻す',
        'redo': '最後のコマンドをやり直す',
        'tab': 'Tab',
        'untab': 'タブ戻し',
        'bold': '太文字',
        'italic': '斜体',
        'underline': '下線',
        'strikethrough': '取り消し線',
        'removeFormat': '装飾を戻す',
        'justifyLeft': '左寄せ',
        'justifyCenter': '真ん中寄せ',
        'justifyRight': '右寄せ',
        'justifyFull': 'すべてを整列',
        'insertUnorderedList': '行頭に●を挿入',
        'insertOrderedList': '行頭に番号を挿入',
        'outdent': '字下げを戻す（アウトデント）',
        'indent': '字下げする（インデント）',
        'formatPara': '段落(P tag)指定',
        'formatH1': 'H1指定',
        'formatH2': 'H2指定',
        'formatH3': 'H3指定',
        'formatH4': 'H4指定',
        'formatH5': 'H5指定',
        'formatH6': 'H6指定',
        'insertHorizontalRule': '&lt;hr /&gt;を挿入',
        'linkDialog.show': 'リンク挿入'
      }
    },
    'ko-KR': {
      font: {
        bold: '굵게',
        italic: '기울임꼴',
        underline: '밑줄',
        clear: '글자 효과 없애기',
        height: '줄간격',
        name: '글꼴',
        superscript: '위 첨자',
        subscript: '아래 첨자',
        strikethrough: '취소선',
        size: '글자 크기'
      },
      image: {
        image: '사진',
        insert: '사진 추가',
        resizeFull: '100% 크기로 변경',
        resizeHalf: '50% 크기로 변경',
        resizeQuarter: '25% 크기로 변경',
        floatLeft: '왼쪽 정렬',
        floatRight: '오른쪽 정렬',
        floatNone: '정렬하지 않음',
        shapeRounded: '스타일: 둥근 모서리',
        shapeCircle: '스타일: 원형',
        shapeThumbnail: '스타일: 액자',
        shapeNone: '스타일: 없음',
        dragImageHere: '텍스트 혹은 사진을 이곳으로 끌어오세요',
        dropImage: '텍스트 혹은 사진을 내려놓으세요',
        selectFromFiles: '파일 선택',
        url: '사진 URL',
        remove: '사진 삭제'
      },
      video: {
        video: '동영상',
        videoLink: '동영상 링크',
        insert: '동영상 추가',
        url: '동영상 URL',
        providers: '(YouTube, Vimeo, Vine, Instagram, DailyMotion, Youku 사용 가능)'
      },
      link: {
        link: '링크',
        insert: '링크 추가',
        unlink: '링크 삭제',
        edit: '수정',
        textToDisplay: '링크에 표시할 내용',
        url: '이동할 URL',
        openInNewWindow: '새창으로 열기'
      },
      table: {
        table: '테이블'
      },
      hr: {
        insert: '구분선 추가'
      },
      style: {
        style: '스타일',
        p: '본문',
        blockquote: '인용구',
        pre: '코드',
        h1: '제목 1',
        h2: '제목 2',
        h3: '제목 3',
        h4: '제목 4',
        h5: '제목 5',
        h6: '제목 6'
      },
      lists: {
        unordered: '글머리 기호',
        ordered: '번호 매기기'
      },
      options: {
        help: '도움말',
        fullscreen: '전체 화면',
        codeview: '코드 보기'
      },
      paragraph: {
        paragraph: '문단 정렬',
        outdent: '내어쓰기',
        indent: '들여쓰기',
        left: '왼쪽 정렬',
        center: '가운데 정렬',
        right: '오른쪽 정렬',
        justify: '양쪽 정렬'
      },
      color: {
        recent: '마지막으로 사용한 색',
        more: '다른 색 선택',
        background: '배경색',
        foreground: '글자색',
        transparent: '투명',
        setTransparent: '투명',
        reset: '취소',
        resetToDefault: '기본 값으로 변경'
      },
      shortcut: {
        shortcuts: '키보드 단축키',
        close: '닫기',
        textFormatting: '글자 스타일 적용',
        action: '기능',
        paragraphFormatting: '문단 스타일 적용',
        documentStyle: '문서 스타일 적용'
      },
      history: {
        undo: '실행 취소',
        redo: '다시 실행'
      },
      specialChar: {
        specialChar: '특수문자',
        select: '특수문자를 선택하세요'
      }
    },
    'lt-LT': {
      font: {
        bold: 'Paryškintas',
        italic: 'Kursyvas',
        underline: 'Pabrėžtas',
        clear: 'Be formatavimo',
        height: 'Eilutės aukštis',
        name: 'Šrifto pavadinimas',
        strikethrough: 'Perbrauktas',
        superscript: 'Viršutinis',
        subscript: 'Indeksas',
        size: 'Šrifto dydis'
      },
      image: {
        image: 'Paveikslėlis',
        insert: 'Įterpti paveikslėlį',
        resizeFull: 'Pilnas dydis',
        resizeHalf: 'Sumažinti dydį 50%',
        resizeQuarter: 'Sumažinti dydį 25%',
        floatLeft: 'Kairinis lygiavimas',
        floatRight: 'Dešininis lygiavimas',
        floatNone: 'Jokio lygiavimo',
        shapeRounded: 'Forma: apvalūs kraštai',
        shapeCircle: 'Forma: apskritimas',
        shapeThumbnail: 'Forma: miniatiūra',
        shapeNone: 'Forma: jokia',
        dragImageHere: 'Vilkite paveikslėlį čia',
        selectFromFiles: 'Pasirinkite failą',
        maximumFileSize: 'Maskimalus failo dydis',
        maximumFileSizeError: 'Maskimalus failo dydis viršytas!',
        url: 'Paveikslėlio URL adresas',
        remove: 'Ištrinti paveikslėlį'
      },
      link: {
        link: 'Nuoroda',
        insert: 'Įterpti nuorodą',
        unlink: 'Pašalinti nuorodą',
        edit: 'Redaguoti',
        textToDisplay: 'Rodomas tekstas',
        url: 'Koks URL adresas yra susietas?',
        openInNewWindow: 'Atidaryti naujame lange'
      },
      table: {
        table: 'Lentelė'
      },
      hr: {
        insert: 'Įterpti horizontalią liniją'
      },
      style: {
        style: 'Stilius',
        p: 'pus',
        blockquote: 'Citata',
        pre: 'Kodas',
        h1: 'Antraštė 1',
        h2: 'Antraštė 2',
        h3: 'Antraštė 3',
        h4: 'Antraštė 4',
        h5: 'Antraštė 5',
        h6: 'Antraštė 6'
      },
      lists: {
        unordered: 'Suženklintasis sąrašas',
        ordered: 'Sunumeruotas sąrašas'
      },
      options: {
        help: 'Pagalba',
        fullscreen: 'Viso ekrano režimas',
        codeview: 'HTML kodo peržiūra'
      },
      paragraph: {
        paragraph: 'Pastraipa',
        outdent: 'Sumažinti įtrauką',
        indent: 'Padidinti įtrauką',
        left: 'Kairinė lygiuotė',
        center: 'Centrinė lygiuotė',
        right: 'Dešininė lygiuotė',
        justify: 'Abipusis išlyginimas'
      },
      color: {
        recent: 'Paskutinė naudota spalva',
        more: 'Daugiau spalvų',
        background: 'Fono spalva',
        foreground: 'Šrifto spalva',
        transparent: 'Permatoma',
        setTransparent: 'Nustatyti skaidrumo intensyvumą',
        reset: 'Atkurti',
        resetToDefault: 'Atstatyti numatytąją spalvą'
      },
      shortcut: {
        shortcuts: 'Spartieji klavišai',
        close: 'Uždaryti',
        textFormatting: 'Teksto formatavimas',
        action: 'Veiksmas',
        paragraphFormatting: 'Pastraipos formatavimas',
        documentStyle: 'Dokumento stilius',
        extraKeys: 'Papildomi klavišų deriniai'
      },
      history: {
        undo: 'Anuliuoti veiksmą',
        redo: 'Perdaryti veiksmą'
      }

    },
    'lv-LV': {
      font: {
        bold: 'Treknraksts',
        italic: 'Kursīvs',
        underline: 'Pasvītrots',
        clear: 'Noņemt formatējumu',
        height: 'Līnijas augstums',
        name: 'Fonts',
        strikethrough: 'Nosvītrots',
        superscript: 'Augšraksts',
        subscript: 'Apakšraksts',
        size: 'Fonta lielums'
      },
      image: {
        image: 'Attēls',
        insert: 'Ievietot attēlu',
        resizeFull: 'Pilns izmērts',
        resizeHalf: 'Samazināt 50%',
        resizeQuarter: 'Samazināt 25%',
        floatLeft: 'Līdzināt pa kreisi',
        floatRight: 'Līdzināt pa labi',
        floatNone: 'Nelīdzināt',
        shapeRounded: 'Forma: apaļām malām',
        shapeCircle: 'Forma: aplis',
        shapeThumbnail: 'Forma: rāmītis',
        shapeNone: 'Forma: orģināla',
        dragImageHere: 'Ievēlciet attēlu šeit',
        selectFromFiles: 'Izvēlēties failu',
        maximumFileSize: 'Maksimālais faila izmērs',
        maximumFileSizeError: 'Faila izmērs pārāk liels!',
        url: 'Attēla URL',
        remove: 'Dzēst attēlu'
      },
      link: {
        link: 'Saite',
        insert: 'Ievietot saiti',
        unlink: 'Noņemt saiti',
        edit: 'Rediģēt',
        textToDisplay: 'Saites saturs',
        url: 'Koks URL adresas yra susietas?',
        openInNewWindow: 'Atvērt jaunā logā'
      },
      table: {
        table: 'Tabula'
      },
      hr: {
        insert: 'Ievietot līniju'
      },
      style: {
        style: 'Stils',
        p: 'Parasts',
        blockquote: 'Citāts',
        pre: 'Kods',
        h1: 'Virsraksts h1',
        h2: 'Virsraksts h2',
        h3: 'Virsraksts h3',
        h4: 'Virsraksts h4',
        h5: 'Virsraksts h5',
        h6: 'Virsraksts h6'
      },
      lists: {
        unordered: 'Nenumurēts saraksts',
        ordered: 'Numurēts saraksts'
      },
      options: {
        help: 'Palīdzība',
        fullscreen: 'Pa visu ekrānu',
        codeview: 'HTML kods'
      },
      paragraph: {
        paragraph: 'Paragrāfs',
        outdent: 'Samazināt atkāpi',
        indent: 'Palielināt atkāpi',
        left: 'Līdzināt pa kreisi',
        center: 'Centrēt',
        right: 'Līdzināt pa labi',
        justify: 'Līdzināt gar abām malām'
      },
      color: {
        recent: 'Nesen izmantotās',
        more: 'Citas krāsas',
        background: 'Fona krāsa',
        foreground: 'Fonta krāsa',
        transparent: 'Caurspīdīgs',
        setTransparent: 'Iestatīt caurspīdīgumu',
        reset: 'Atjaunot',
        resetToDefault: 'Atjaunot noklusējumu'
      },
      shortcut: {
        shortcuts: 'Saīsnes',
        close: 'Aizvērt',
        textFormatting: 'Teksta formatēšana',
        action: 'Darbība',
        paragraphFormatting: 'Paragrāfa formatēšana',
        documentStyle: 'Dokumenta stils',
        extraKeys: 'Citas taustiņu kombinācijas'
      },
      history: {
        undo: 'Atsauks (undo)',
        redo: 'Atkārtot (redo)'
      },
      help: {
        insertParagraph: 'Ievietot Paragrāfu',
        undo: 'Atcelt iepriekšējo darbību',
        redo: 'Atkārtot atcelto darbību',
        tab: 'Atkāpe',
        untab: 'Samazināt atkāpi',
        bold: 'Pārvērst tekstu treknrakstā',
        italic: 'Pārvērst tekstu slīprakstā (kursīvā)',
        underline: 'Pasvītrot tekstu',
        strikethrough: 'Nosvītrot tekstu',
        removeFormat: 'Notīrīt stilu no teksta',
        justifyLeft: 'Līdzīnāt saturu pa kreisi',
        justifyCenter: 'Centrēt saturu',
        justifyRight: 'Līdzīnāt saturu pa labi',
        justifyFull: 'Izlīdzināt saturu gar abām malām',
        insertUnorderedList: 'Ievietot nenumurētu sarakstu',
        insertOrderedList: 'Ievietot numurētu sarakstu',
        outdent: 'Samazināt/noņemt atkāpi paragrāfam',
        indent: 'Uzlikt atkāpi paragrāfam',
        formatPara: 'Mainīt bloka tipu uz (p) Paragrāfu',
        formatH1: 'Mainīt bloka tipu uz virsrakstu H1',
        formatH2: 'Mainīt bloka tipu uz virsrakstu H2',
        formatH3: 'Mainīt bloka tipu uz virsrakstu H3',
        formatH4: 'Mainīt bloka tipu uz virsrakstu H4',
        formatH5: 'Mainīt bloka tipu uz virsrakstu H5',
        formatH6: 'Mainīt bloka tipu uz virsrakstu H6',
        insertHorizontalRule: 'Ievietot horizontālu līniju',
        'linkDialog.show': 'Parādīt saites logu'
      }
    },
    'nb-NO': {
      font: {
        bold: 'Fet',
        italic: 'Kursiv',
        underline: 'Understrek',
        clear: 'Fjern formatering',
        height: 'Linjehøyde',
        name: 'Skrifttype',
        strikethrough: 'Gjennomstrek',
        size: 'Skriftstørrelse'
      },
      image: {
        image: 'Bilde',
        insert: 'Sett inn bilde',
        resizeFull: 'Sett full størrelse',
        resizeHalf: 'Sett halv størrelse',
        resizeQuarter: 'Sett kvart størrelse',
        floatLeft: 'Flyt til venstre',
        floatRight: 'Flyt til høyre',
        floatNone: 'Fjern flyt',
        dragImageHere: 'Dra et bilde hit',
        selectFromFiles: 'Velg fra filer',
        url: 'Bilde-URL',
        remove: 'Fjern bilde'
      },
      video: {
        video: 'Video',
        videoLink: 'Videolenke',
        insert: 'Sett inn video',
        url: 'Video-URL',
        providers: '(YouTube, Vimeo, Vine, Instagram, DailyMotion eller Youku)'
      },
      link: {
        link: 'Lenke',
        insert: 'Sett inn lenke',
        unlink: 'Fjern lenke',
        edit: 'Rediger',
        textToDisplay: 'Visningstekst',
        url: 'Til hvilken URL skal denne lenken peke?',
        openInNewWindow: 'Åpne i nytt vindu'
      },
      table: {
        table: 'Tabell'
      },
      hr: {
        insert: 'Sett inn horisontal linje'
      },
      style: {
        style: 'Stil',
        p: 'p',
        blockquote: 'Sitat',
        pre: 'Kode',
        h1: 'Overskrift 1',
        h2: 'Overskrift 2',
        h3: 'Overskrift 3',
        h4: 'Overskrift 4',
        h5: 'Overskrift 5',
        h6: 'Overskrift 6'
      },
      lists: {
        unordered: 'Punktliste',
        ordered: 'Nummerert liste'
      },
      options: {
        help: 'Hjelp',
        fullscreen: 'Fullskjerm',
        codeview: 'HTML-visning'
      },
      paragraph: {
        paragraph: 'Avsnitt',
        outdent: 'Tilbakerykk',
        indent: 'Innrykk',
        left: 'Venstrejustert',
        center: 'Midtstilt',
        right: 'Høyrejustert',
        justify: 'Blokkjustert'
      },
      color: {
        recent: 'Nylig valgt farge',
        more: 'Flere farger',
        background: 'Bakgrunnsfarge',
        foreground: 'Skriftfarge',
        transparent: 'Gjennomsiktig',
        setTransparent: 'Sett gjennomsiktig',
        reset: 'Nullstill',
        resetToDefault: 'Nullstill til standard'
      },
      shortcut: {
        shortcuts: 'Hurtigtaster',
        close: 'Lukk',
        textFormatting: 'Tekstformatering',
        action: 'Handling',
        paragraphFormatting: 'Avsnittsformatering',
        documentStyle: 'Dokumentstil'
      },
      history: {
        undo: 'Angre',
        redo: 'Gjør om'
      }
    },
    'nl-NL': {
      font: {
        bold: 'Vet',
        italic: 'Cursief',
        underline: 'Onderstrepen',
        clear: 'Stijl verwijderen',
        height: 'Regelhoogte',
        name: 'Lettertype',
        strikethrough: 'Doorhalen',
        size: 'Tekstgrootte'
      },
      image: {
        image: 'Afbeelding',
        insert: 'Afbeelding invoegen',
        resizeFull: 'Volledige breedte',
        resizeHalf: 'Halve breedte',
        resizeQuarter: 'Kwart breedte',
        floatLeft: 'Links uitlijnen',
        floatRight: 'Rechts uitlijnen',
        floatNone: 'Geen uitlijning',
        dragImageHere: 'Sleep hier een afbeelding naar toe',
        selectFromFiles: 'Selecteer een bestand',
        url: 'URL van de afbeelding',
        remove: 'Verwijder afbeelding'
      },
      video: {
        video: 'Video',
        videoLink: 'Video link',
        insert: 'Video invoegen',
        url: 'URL van de video',
        providers: '(YouTube, Vimeo, Vine, Instagram, DailyMotion of Youku)'
      },
      link: {
        link: 'Link',
        insert: 'Link invoegen',
        unlink: 'Link verwijderen',
        edit: 'Wijzigen',
        textToDisplay: 'Tekst van link',
        url: 'Naar welke URL moet deze link verwijzen?',
        openInNewWindow: 'Open in nieuw venster'
      },
      table: {
        table: 'Tabel'
      },
      hr: {
        insert: 'Horizontale lijn invoegen'
      },
      style: {
        style: 'Stijl',
        p: 'Normaal',
        blockquote: 'Quote',
        pre: 'Code',
        h1: 'Kop 1',
        h2: 'Kop 2',
        h3: 'Kop 3',
        h4: 'Kop 4',
        h5: 'Kop 5',
        h6: 'Kop 6'
      },
      lists: {
        unordered: 'Ongeordende lijst',
        ordered: 'Geordende lijst'
      },
      options: {
        help: 'Help',
        fullscreen: 'Volledig scherm',
        codeview: 'Bekijk Code'
      },
      paragraph: {
        paragraph: 'Paragraaf',
        outdent: 'Inspringen verkleinen',
        indent: 'Inspringen vergroten',
        left: 'Links uitlijnen',
        center: 'Centreren',
        right: 'Rechts uitlijnen',
        justify: 'Uitvullen'
      },
      color: {
        recent: 'Recente kleur',
        more: 'Meer kleuren',
        background: 'Achtergrond kleur',
        foreground: 'Tekst kleur',
        transparent: 'Transparant',
        setTransparent: 'Transparant',
        reset: 'Standaard',
        resetToDefault: 'Standaard kleur'
      },
      shortcut: {
        shortcuts: 'Toetsencombinaties',
        close: 'sluiten',
        textFormatting: 'Tekststijlen',
        action: 'Acties',
        paragraphFormatting: 'Paragraafstijlen',
        documentStyle: 'Documentstijlen'
      },
      history: {
        undo: 'Ongedaan maken',
        redo: 'Opnieuw doorvoeren'
      }
    },
    'pl-PL': {
      font: {
        bold: 'Pogrubienie',
        italic: 'Pochylenie',
        underline: 'Podkreślenie',
        clear: 'Usuń formatowanie',
        height: 'Interlinia',
        name: 'Czcionka',
        strikethrough: 'Przekreślenie',
        size: 'Rozmiar'
      },
      image: {
        image: 'Grafika',
        insert: 'Wstaw grafikę',
        resizeFull: 'Zmień rozmiar na 100%',
        resizeHalf: 'Zmień rozmiar na 50%',
        resizeQuarter: 'Zmień rozmiar na 25%',
        floatLeft: 'Po lewej',
        floatRight: 'Po prawej',
        floatNone: 'Równo z tekstem',
        shapeRounded: 'Kształt: zaokrąglone',
        shapeCircle: 'Kształt: okrąg',
        shapeThumbnail: 'Kształt: miniatura',
        shapeNone: 'Kształt: brak',
        dragImageHere: 'Przeciągnij grafikę lub tekst tutaj',
        dropImage: 'Przeciągnij grafikę lub tekst',
        selectFromFiles: 'Wybierz z dysku',
        maximumFileSize: 'Limit wielkości pliku',
        maximumFileSizeError: 'Przekroczono limit wielkości pliku.',
        url: 'Adres URL grafiki',
        remove: 'Usuń grafikę'
      },
      video: {
        video: 'Wideo',
        videoLink: 'Adres wideo',
        insert: 'Wstaw wideo',
        url: 'Adres wideo',
        providers: '(YouTube, Vimeo, Vine, Instagram, DailyMotion lub Youku)'
      },
      link: {
        link: 'Odnośnik',
        insert: 'Wstaw odnośnik',
        unlink: 'Usuń odnośnik',
        edit: 'Edytuj',
        textToDisplay: 'Tekst do wyświetlenia',
        url: 'Na jaki adres URL powinien przenosić ten odnośnik?',
        openInNewWindow: 'Otwórz w nowym oknie'
      },
      table: {
        table: 'Tabela'
      },
      hr: {
        insert: 'Wstaw poziomą linię'
      },
      style: {
        style: 'Style',
        p: 'pny',
        blockquote: 'Cytat',
        pre: 'Kod',
        h1: 'Nagłówek 1',
        h2: 'Nagłówek 2',
        h3: 'Nagłówek 3',
        h4: 'Nagłówek 4',
        h5: 'Nagłówek 5',
        h6: 'Nagłówek 6'
      },
      lists: {
        unordered: 'Lista wypunktowana',
        ordered: 'Lista numerowana'
      },
      options: {
        help: 'Pomoc',
        fullscreen: 'Pełny ekran',
        codeview: 'Źródło'
      },
      paragraph: {
        paragraph: 'Akapit',
        outdent: 'Zmniejsz wcięcie',
        indent: 'Zwiększ wcięcie',
        left: 'Wyrównaj do lewej',
        center: 'Wyrównaj do środka',
        right: 'Wyrównaj do prawej',
        justify: 'Wyrównaj do lewej i prawej'
      },
      color: {
        recent: 'Ostani kolor',
        more: 'Więcej kolorów',
        background: 'Tło',
        foreground: 'Czcionka',
        transparent: 'Przeźroczysty',
        setTransparent: 'Przeźroczyste',
        reset: 'Reset',
        resetToDefault: 'Domyślne'
      },
      shortcut: {
        shortcuts: 'Skróty klawiaturowe',
        close: 'Zamknij',
        textFormatting: 'Formatowanie tekstu',
        action: 'Akcja',
        paragraphFormatting: 'Formatowanie akapitu',
        documentStyle: 'Styl dokumentu',
        extraKeys: 'Dodatkowe klawisze'
      },
      history: {
        undo: 'Cofnij',
        redo: 'Ponów'
      }
    },
    'pt-PT': {
      font: {
        bold: 'Negrito',
        italic: 'Itálico',
        underline: 'Sublinhado',
        clear: 'Remover estilo da fonte',
        height: 'Altura da linha',
        name: 'Fonte',
        strikethrough: 'Riscado',
        size: 'Tamanho da fonte'
      },
      image: {
        image: 'Imagem',
        insert: 'Inserir imagem',
        resizeFull: 'Redimensionar Completo',
        resizeHalf: 'Redimensionar Metade',
        resizeQuarter: 'Redimensionar Um Quarto',
        floatLeft: 'Float Esquerda',
        floatRight: 'Float Direita',
        floatNone: 'Sem Float',
        dragImageHere: 'Arraste uma imagem para aqui',
        selectFromFiles: 'Selecione a partir dos arquivos',
        url: 'Endereço da imagem'
      },
      video: {
        video: 'Vídeo',
        videoLink: 'Link para vídeo',
        insert: 'Inserir vídeo',
        url: 'URL do vídeo?',
        providers: '(YouTube, Vimeo, Vine, Instagram, DailyMotion ou Youku)'
      },
      link: {
        link: 'Link',
        insert: 'Inserir ligação',
        unlink: 'Remover ligação',
        edit: 'Editar',
        textToDisplay: 'Texto para exibir',
        url: 'Que endereço esta licação leva?',
        openInNewWindow: 'Abrir numa nova janela'
      },
      table: {
        table: 'Tabela'
      },
      hr: {
        insert: 'Inserir linha horizontal'
      },
      style: {
        style: 'Estilo',
        p: 'p',
        blockquote: 'Citação',
        pre: 'Código',
        h1: 'Título 1',
        h2: 'Título 2',
        h3: 'Título 3',
        h4: 'Título 4',
        h5: 'Título 5',
        h6: 'Título 6'
      },
      lists: {
        unordered: 'Lista com marcadores',
        ordered: 'Lista numerada'
      },
      options: {
        help: 'Ajuda',
        fullscreen: 'Janela Completa',
        codeview: 'Ver código-fonte'
      },
      paragraph: {
        paragraph: 'Parágrafo',
        outdent: 'Menor tabulação',
        indent: 'Maior tabulação',
        left: 'Alinhar à esquerda',
        center: 'Alinhar ao centro',
        right: 'Alinha à direita',
        justify: 'Justificado'
      },
      color: {
        recent: 'Cor recente',
        more: 'Mais cores',
        background: 'Fundo',
        foreground: 'Fonte',
        transparent: 'Transparente',
        setTransparent: 'Fundo transparente',
        reset: 'Restaurar',
        resetToDefault: 'Restaurar padrão'
      },
      shortcut: {
        shortcuts: 'Atalhos do teclado',
        close: 'Fechar',
        textFormatting: 'Formatação de texto',
        action: 'Ação',
        paragraphFormatting: 'Formatação de parágrafo',
        documentStyle: 'Estilo de documento'
      },
      history: {
        undo: 'Desfazer',
        redo: 'Refazer'
      }
    },
    'ro-RO': {
      font: {
        bold: 'Îngroșat',
        italic: 'Înclinat',
        underline: 'Subliniat',
        clear: 'Înlătură formatare font',
        height: 'Înălțime rând',
        strikethrough: 'Tăiat',
        size: 'Dimensiune font'
      },
      image: {
        image: 'Imagine',
        insert: 'Inserează imagine',
        resizeFull: 'Redimensionează complet',
        resizeHalf: 'Redimensionează 1/2',
        resizeQuarter: 'Redimensionează 1/4',
        floatLeft: 'Aliniere la stânga',
        floatRight: 'Aliniere la dreapta',
        floatNone: 'Fară aliniere',
        dragImageHere: 'Trage o imagine aici',
        selectFromFiles: 'Alege din fişiere',
        url: 'URL imagine'
      },
      video: {
        video: 'Video',
        videoLink: 'Link video',
        insert: 'Inserează video',
        url: 'URL video?',
        providers: '(YouTube, Vimeo, Vine, Instagram, DailyMotion sau Youku)'
      },
      link: {
        link: 'Link',
        insert: 'Inserează link',
        unlink: 'Înlătură link',
        edit: 'Editează',
        textToDisplay: 'Text ce va fi afişat',
        url: 'Deschidere în fereastra nouă?'
      },
      table: {
        table: 'Tabel'
      },
      hr: {
        insert: 'Inserează o linie orizontală'
      },
      style: {
        style: 'Stil',
        p: 'p',
        blockquote: 'Citat',
        pre: 'Preformatat',
        h1: 'Titlu 1',
        h2: 'Titlu 2',
        h3: 'Titlu 3',
        h4: 'Titlu 4',
        h5: 'Titlu 5',
        h6: 'Titlu 6'
      },
      lists: {
        unordered: 'Listă neordonată',
        ordered: 'Listă ordonată'
      },
      options: {
        help: 'Ajutor',
        fullscreen: 'Măreşte',
        codeview: 'Sursă'
      },
      paragraph: {
        paragraph: 'Paragraf',
        outdent: 'Creşte identarea',
        indent: 'Scade identarea',
        left: 'Aliniere la stânga',
        center: 'Aliniere centrală',
        right: 'Aliniere la dreapta',
        justify: 'Aliniere în bloc'
      },
      color: {
        recent: 'Culoare recentă',
        more: 'Mai multe  culori',
        background: 'Culoarea fundalului',
        foreground: 'Culoarea textului',
        transparent: 'Transparent',
        setTransparent: 'Setează transparent',
        reset: 'Resetează',
        resetToDefault: 'Revino la iniţial'
      },
      shortcut: {
        shortcuts: 'Scurtături tastatură',
        close: 'Închide',
        textFormatting: 'Formatare text',
        action: 'Acţiuni',
        paragraphFormatting: 'Formatare paragraf',
        documentStyle: 'Stil paragraf'
      },
      history: {
        undo: 'Starea anterioară',
        redo: 'Starea ulterioară'
      }

    },
    'ru-RU': {
      font: {
        bold: 'Полужирный',
        italic: 'Курсив',
        underline: 'Подчёркнутый',
        clear: 'Убрать стили шрифта',
        height: 'Высота линии',
        name: 'Шрифт',
        strikethrough: 'Зачёркнутый',
        subscript: 'Нижний индекс',
        superscript: 'Верхний индекс',
        size: 'Размер шрифта'
      },
      image: {
        image: 'Картинка',
        insert: 'Вставить картинку',
        resizeFull: 'Восстановить размер',
        resizeHalf: 'Уменьшить до 50%',
        resizeQuarter: 'Уменьшить до 25%',
        floatLeft: 'Расположить слева',
        floatRight: 'Расположить справа',
        floatNone: 'Расположение по-умолчанию',
        shapeRounded: 'Форма: Закругленная',
        shapeCircle: 'Форма: Круг',
        shapeThumbnail: 'Форма: Миниатюра',
        shapeNone: 'Форма: Нет',
        dragImageHere: 'Перетащите сюда картинку',
        dropImage: 'Перетащите картинку',
        selectFromFiles: 'Выбрать из файлов',
        url: 'URL картинки',
        remove: 'Удалить картинку'
      },
      video: {
        video: 'Видео',
        videoLink: 'Ссылка на видео',
        insert: 'Вставить видео',
        url: 'URL видео',
        providers: '(YouTube, Vimeo, Vine, Instagram, DailyMotion или Youku)'
      },
      link: {
        link: 'Ссылка',
        insert: 'Вставить ссылку',
        unlink: 'Убрать ссылку',
        edit: 'Редактировать',
        textToDisplay: 'Отображаемый текст',
        url: 'URL для перехода',
        openInNewWindow: 'Открывать в новом окне'
      },
      table: {
        table: 'Таблица'
      },
      hr: {
        insert: 'Вставить горизонтальную линию'
      },
      style: {
        style: 'Стиль',
        p: 'Нормальный',
        blockquote: 'Цитата',
        pre: 'Код',
        h1: 'Заголовок 1',
        h2: 'Заголовок 2',
        h3: 'Заголовок 3',
        h4: 'Заголовок 4',
        h5: 'Заголовок 5',
        h6: 'Заголовок 6'
      },
      lists: {
        unordered: 'Маркированный список',
        ordered: 'Нумерованный список'
      },
      options: {
        help: 'Помощь',
        fullscreen: 'На весь экран',
        codeview: 'Исходный код'
      },
      paragraph: {
        paragraph: 'Параграф',
        outdent: 'Уменьшить отступ',
        indent: 'Увеличить отступ',
        left: 'Выровнять по левому краю',
        center: 'Выровнять по центру',
        right: 'Выровнять по правому краю',
        justify: 'Растянуть по ширине'
      },
      color: {
        recent: 'Последний цвет',
        more: 'Еще цвета',
        background: 'Цвет фона',
        foreground: 'Цвет шрифта',
        transparent: 'Прозрачный',
        setTransparent: 'Сделать прозрачным',
        reset: 'Сброс',
        resetToDefault: 'Восстановить умолчания'
      },
      shortcut: {
        shortcuts: 'Сочетания клавиш',
        close: 'Закрыть',
        textFormatting: 'Форматирование текста',
        action: 'Действие',
        paragraphFormatting: 'Форматирование параграфа',
        documentStyle: 'Стиль документа',
        extraKeys: 'Дополнительные комбинации'
      },
      history: {
        undo: 'Отменить',
        redo: 'Повтор'
      }
    },
    'sk-SK': {
      font: {
        bold: 'Tučné',
        italic: 'Kurzíva',
        underline: 'Podčiarknutie',
        clear: 'Odstrániť štýl písma',
        height: 'Výška riadku',
        strikethrough: 'Prečiarknuté',
        size: 'Veľkosť písma'
      },
      image: {
        image: 'Obrázok',
        insert: 'Vložiť obrázok',
        resizeFull: 'Pôvodná veľkosť',
        resizeHalf: 'Polovičná veľkosť',
        resizeQuarter: 'Štvrtinová veľkosť',
        floatLeft: 'Umiestniť doľava',
        floatRight: 'Umiestniť doprava',
        floatNone: 'Bez zarovnania',
        dragImageHere: 'Pretiahnuť sem obrázok',
        selectFromFiles: 'Vybrať súbor',
        url: 'URL obrázku'
      },
      video: {
        video: 'Video',
        videoLink: 'Odkaz videa',
        insert: 'Vložiť video',
        url: 'URL videa?',
        providers: '(YouTube, Vimeo, Vine, Instagram, DailyMotion alebo Youku)'
      },
      link: {
        link: 'Odkaz',
        insert: 'Vytvoriť odkaz',
        unlink: 'Zrušiť odkaz',
        edit: 'Upraviť',
        textToDisplay: 'Zobrazovaný text',
        url: 'Na akú URL adresu má tento odkaz viesť?',
        openInNewWindow: 'Otvoriť v novom okne'
      },
      table: {
        table: 'Tabuľka'
      },
      hr: {
        insert: 'Vložit vodorovnú čiaru'
      },
      style: {
        style: 'Štýl',
        p: 'Normálny',
        blockquote: 'Citácia',
        pre: 'Kód',
        h1: 'Nadpis 1',
        h2: 'Nadpis 2',
        h3: 'Nadpis 3',
        h4: 'Nadpis 4',
        h5: 'Nadpis 5',
        h6: 'Nadpis 6'
      },
      lists: {
        unordered: 'Odrážkový zoznam',
        ordered: 'Číselný zoznam'
      },
      options: {
        help: 'Pomoc',
        fullscreen: 'Celá obrazovka',
        codeview: 'HTML kód'
      },
      paragraph: {
        paragraph: 'Odsek',
        outdent: 'Zväčšiť odsadenie',
        indent: 'Zmenšiť odsadenie',
        left: 'Zarovnať doľava',
        center: 'Zarovnať na stred',
        right: 'Zarovnať doprava',
        justify: 'Zarovnať obojstranne'
      },
      color: {
        recent: 'Aktuálna farba',
        more: 'Dalšie farby',
        background: 'Farba pozadia',
        foreground: 'Farba písma',
        transparent: 'Priehľadnosť',
        setTransparent: 'Nastaviť priehľadnosť',
        reset: 'Obnoviť',
        resetToDefault: 'Obnoviť prednastavené'
      },
      shortcut: {
        shortcuts: 'Klávesové skratky',
        close: 'Zavrieť',
        textFormatting: 'Formátovanie textu',
        action: 'Akcia',
        paragraphFormatting: 'Formátovanie odseku',
        documentStyle: 'Štýl dokumentu'
      },
      history: {
        undo: 'Krok vzad',
        redo: 'Krok dopredu'
      }
    },
    'sl-SI': {
      font: {
        bold: 'Krepko',
        italic: 'Ležeče',
        underline: 'Podčrtano',
        clear: 'Počisti oblikovanje izbire',
        height: 'Razmik med vrsticami',
        name: 'Pisava',
        strikethrough: 'Prečrtano',
        subscript: 'Podpisano',
        superscript: 'Nadpisano',
        size: 'Velikost pisave'
      },
      image: {
        image: 'Slika',
        insert: 'Vstavi sliko',
        resizeFull: 'Razširi na polno velikost',
        resizeHalf: 'Razširi na polovico velikosti',
        resizeQuarter: 'Razširi na četrtino velikosti',
        floatLeft: 'Leva poravnava',
        floatRight: 'Desna poravnava',
        floatNone: 'Brez poravnave',
        dragImageHere: 'Sem povlecite sliko',
        selectFromFiles: 'Izberi sliko za nalaganje',
        url: 'URL naslov slike',
        remove: 'Odstrani sliko'
      },
      video: {
        video: 'Video',
        videoLink: 'Video povezava',
        insert: 'Vstavi video',
        url: 'Povezava do videa',
        providers: '(YouTube, Vimeo, Vine, Instagram, DailyMotion ali Youku)'
      },
      link: {
        link: 'Povezava',
        insert: 'Vstavi povezavo',
        unlink: 'Odstrani povezavo',
        edit: 'Uredi',
        textToDisplay: 'Prikazano besedilo',
        url: 'Povezava',
        openInNewWindow: 'Odpri v novem oknu'
      },
      table: {
        table: 'Tabela'
      },
      hr: {
        insert: 'Vstavi horizontalno črto'
      },
      style: {
        style: 'Slogi',
        p: 'Navadno besedilo',
        blockquote: 'Citat',
        pre: 'Koda',
        h1: 'Naslov 1',
        h2: 'Naslov 2',
        h3: 'Naslov 3',
        h4: 'Naslov 4',
        h5: 'Naslov 5',
        h6: 'Naslov 6'
      },
      lists: {
        unordered: 'Označen seznam',
        ordered: 'Oštevilčen seznam'
      },
      options: {
        help: 'Pomoč',
        fullscreen: 'Celozaslonski način',
        codeview: 'Pregled HTML kode'
      },
      paragraph: {
        paragraph: 'Slogi odstavka',
        outdent: 'Zmanjšaj odmik',
        indent: 'Povečaj odmik',
        left: 'Leva poravnava',
        center: 'Desna poravnava',
        right: 'Sredinska poravnava',
        justify: 'Obojestranska poravnava'
      },
      color: {
        recent: 'Uporabi zadnjo barvo',
        more: 'Več barv',
        background: 'Barva ozadja',
        foreground: 'Barva besedila',
        transparent: 'Brez barve',
        setTransparent: 'Brez barve',
        reset: 'Ponastavi',
        resetToDefault: 'Ponastavi na privzeto'
      },
      shortcut: {
        shortcuts: 'Bljižnice',
        close: 'Zapri',
        textFormatting: 'Oblikovanje besedila',
        action: 'Dejanja',
        paragraphFormatting: 'Oblikovanje odstavka',
        documentStyle: 'Oblikovanje naslova'
      },
      history: {
        undo: 'Razveljavi',
        redo: 'Uveljavi'
      }
    },
    'sr-RS': {
      font: {
        bold: 'Podebljano',
        italic: 'Kurziv',
        underline: 'Podvučeno',
        clear: 'Ukloni stilove fonta',
        height: 'Visina linije',
        strikethrough: 'Precrtano',
        size: 'Veličina fonta'
      },
      image: {
        image: 'Slika',
        insert: 'Umetni sliku',
        resizeFull: 'Puna veličina',
        resizeHalf: 'Umanji na 50%',
        resizeQuarter: 'Umanji na 25%',
        floatLeft: 'Uz levu ivicu',
        floatRight: 'Uz desnu ivicu',
        floatNone: 'Bez ravnanja',
        dragImageHere: 'Prevuci sliku ovde',
        selectFromFiles: 'Izaberi iz datoteke',
        url: 'Adresa slike',
        remove: 'Ukloni sliku'
      },
      video: {
        video: 'Video',
        videoLink: 'Veza ka videu',
        insert: 'Umetni video',
        url: 'URL video',
        providers: '(YouTube, Vimeo, Vine, Instagram, DailyMotion ili Youku)'
      },
      link: {
        link: 'Veza',
        insert: 'Umetni vezu',
        unlink: 'Ukloni vezu',
        edit: 'Uredi',
        textToDisplay: 'Tekst za prikaz',
        url: 'Internet adresa',
        openInNewWindow: 'Otvori u novom prozoru'
      },
      table: {
        table: 'Tabela'
      },
      hr: {
        insert: 'Umetni horizontalnu liniju'
      },
      style: {
        style: 'Stil',
        p: 'pni',
        blockquote: 'Citat',
        pre: 'Kod',
        h1: 'Zaglavlje 1',
        h2: 'Zaglavlje 2',
        h3: 'Zaglavlje 3',
        h4: 'Zaglavlje 4',
        h5: 'Zaglavlje 5',
        h6: 'Zaglavlje 6'
      },
      lists: {
        unordered: 'Obična lista',
        ordered: 'Numerisana lista'
      },
      options: {
        help: 'Pomoć',
        fullscreen: 'Preko celog ekrana',
        codeview: 'Izvorni kod'
      },
      paragraph: {
        paragraph: 'Paragraf',
        outdent: 'Smanji uvlačenje',
        indent: 'Povečaj uvlačenje',
        left: 'Poravnaj u levo',
        center: 'Centrirano',
        right: 'Poravnaj u desno',
        justify: 'Poravnaj obostrano'
      },
      color: {
        recent: 'Poslednja boja',
        more: 'Više boja',
        background: 'Boja pozadine',
        foreground: 'Boja teksta',
        transparent: 'Providna',
        setTransparent: 'Providna',
        reset: 'Opoziv',
        resetToDefault: 'Podrazumevana'
      },
      shortcut: {
        shortcuts: 'Prečice sa tastature',
        close: 'Zatvori',
        textFormatting: 'Formatiranje teksta',
        action: 'Akcija',
        paragraphFormatting: 'Formatiranje paragrafa',
        documentStyle: 'Stil dokumenta',
        extraKeys: 'Dodatne kombinacije'
      },
      history: {
        undo: 'Poništi',
        redo: 'Ponovi'
      }
    },
    'sr-RS': {
      font: {
        bold: 'Подебљано',
        italic: 'Курзив',
        underline: 'Подвучено',
        clear: 'Уклони стилове фонта',
        height: 'Висина линије',
        strikethrough: 'Прецртано',
        size: 'Величина фонта'
      },
      image: {
        image: 'Слика',
        insert: 'Уметни слику',
        resizeFull: 'Пуна величина',
        resizeHalf: 'Умањи на 50%',
        resizeQuarter: 'Умањи на 25%',
        floatLeft: 'Уз леву ивицу',
        floatRight: 'Уз десну ивицу',
        floatNone: 'Без равнања',
        dragImageHere: 'Превуци слику овде',
        selectFromFiles: 'Изабери из датотеке',
        url: 'Адреса слике',
        remove: 'Уклони слику'
      },
      video: {
        video: 'Видео',
        videoLink: 'Веза ка видеу',
        insert: 'Уметни видео',
        url: 'URL видео',
        providers: '(YouTube, Vimeo, Vine, Instagram, DailyMotion или Youku)'
      },
      link: {
        link: 'Веза',
        insert: 'Уметни везу',
        unlink: 'Уклони везу',
        edit: 'Уреди',
        textToDisplay: 'Текст за приказ',
        url: 'Интернет адреса',
        openInNewWindow: 'Отвори у новом прозору'
      },
      table: {
        table: 'Табела'
      },
      hr: {
        insert: 'Уметни хоризонталну линију'
      },
      style: {
        style: 'Стил',
        p: 'Нормални',
        blockquote: 'Цитат',
        pre: 'Код',
        h1: 'Заглавље 1',
        h2: 'Заглавље 2',
        h3: 'Заглавље 3',
        h4: 'Заглавље 4',
        h5: 'Заглавље 5',
        h6: 'Заглавље 6'
      },
      lists: {
        unordered: 'Обична листа',
        ordered: 'Нумерисана листа'
      },
      options: {
        help: 'Помоћ',
        fullscreen: 'Преко целог екрана',
        codeview: 'Изворни код'
      },
      paragraph: {
        paragraph: 'Параграф',
        outdent: 'Смањи увлачење',
        indent: 'Повечај увлачење',
        left: 'Поравнај у лево',
        center: 'Центрирано',
        right: 'Поравнај у десно',
        justify: 'Поравнај обострано'
      },
      color: {
        recent: 'Последња боја',
        more: 'Више боја',
        background: 'Боја позадине',
        foreground: 'Боја текста',
        transparent: 'Провидна',
        setTransparent: 'Провидна',
        reset: 'Опозив',
        resetToDefault: 'Подразумевана'
      },
      shortcut: {
        shortcuts: 'Пречице са тастатуре',
        close: 'Затвори',
        textFormatting: 'Форматирање текста',
        action: 'Акција',
        paragraphFormatting: 'Форматирање параграфа',
        documentStyle: 'Стил документа',
        extraKeys: 'Додатне комбинације'
      },
      history: {
        undo: 'Поништи',
        redo: 'Понови'
      }
    },
    'sv-SE': {
      font: {
        bold: 'Fet',
        italic: 'Kursiv',
        underline: 'Understruken',
        clear: 'Radera formatering',
        height: 'Radavstånd',
        name: 'Teckensnitt',
        strikethrough: 'Genomstruken',
        size: 'Teckenstorlek'
      },
      image: {
        image: 'Bild',
        insert: 'Infoga bild',
        resizeFull: 'Full storlek',
        resizeHalf: 'Halv storlek',
        resizeQuarter: 'En fjärdedel i storlek',
        floatLeft: 'Vänsterjusterad',
        floatRight: 'Högerjusterad',
        floatNone: 'Ingen justering',
        dragImageHere: 'Dra en bild hit',
        selectFromFiles: 'Välj från filer',
        url: 'Länk till bild',
        remove: 'Ta bort bild'
      },
      video: {
        video: 'Filmklipp',
        videoLink: 'Länk till filmklipp',
        insert: 'Infoga filmklipp',
        url: 'Länk till filmklipp',
        providers: '(YouTube, Vimeo, Vine, Instagram, DailyMotion eller Youku)'
      },
      link: {
        link: 'Länk',
        insert: 'Infoga länk',
        unlink: 'Ta bort länk',
        edit: 'Redigera',
        textToDisplay: 'Visningstext',
        url: 'Till vilken URL ska denna länk peka?',
        openInNewWindow: 'Öppna i ett nytt fönster'
      },
      table: {
        table: 'Tabell'
      },
      hr: {
        insert: 'Infoga horisontell linje'
      },
      style: {
        style: 'Stil',
        p: 'p',
        blockquote: 'Citat',
        pre: 'Kod',
        h1: 'Rubrik 1',
        h2: 'Rubrik 2',
        h3: 'Rubrik 3',
        h4: 'Rubrik 4',
        h5: 'Rubrik 5',
        h6: 'Rubrik 6'
      },
      lists: {
        unordered: 'Punktlista',
        ordered: 'Numrerad lista'
      },
      options: {
        help: 'Hjälp',
        fullscreen: 'Fullskärm',
        codeview: 'HTML-visning'
      },
      paragraph: {
        paragraph: 'Justera text',
        outdent: 'Minska indrag',
        indent: 'Öka indrag',
        left: 'Vänsterjusterad',
        center: 'Centrerad',
        right: 'Högerjusterad',
        justify: 'Justera text'
      },
      color: {
        recent: 'Senast använda färg',
        more: 'Fler färger',
        background: 'Bakgrundsfärg',
        foreground: 'Teckenfärg',
        transparent: 'Genomskinlig',
        setTransparent: 'Gör genomskinlig',
        reset: 'Nollställ',
        resetToDefault: 'Återställ till standard'
      },
      shortcut: {
        shortcuts: 'Kortkommandon',
        close: 'Stäng',
        textFormatting: 'Textformatering',
        action: 'Funktion',
        paragraphFormatting: 'Avsnittsformatering',
        documentStyle: 'Dokumentstil'
      },
      history: {
        undo: 'Ångra',
        redo: 'Gör om'
      }
    },
    'th-TH': {
			font: {
				bold: 'ตัวหนา',
				italic: 'ตัวเอียง',
				underline: 'ขีดเส้นใต้',
				clear: 'ล้างรูปแบบตัวอักษร',
				height: 'ความสูงบรรทัด',
				name: 'แบบตัวอักษร',
				strikethrough: 'ขีดฆ่า',
				subscript: 'ตัวห้อย',
				superscript: 'ตัวยก',
				size: 'ขนาดตัวอักษร'
			},
			image: {
				image: 'รูปภาพ',
				insert: 'แทรกรูปภาพ',
				resizeFull: 'ปรับขนาดเท่าจริง',
				resizeHalf: 'ปรับขนาดลง 50%',
				resizeQuarter: 'ปรับขนาดลง 25%',
				floatLeft: 'ชิดซ้าย',
				floatRight: 'ชิดขวา',
				floatNone: 'ไม่จัดตำแหน่ง',
				dragImageHere: 'ลากรูปภาพที่ต้องการไว้ที่นี่',
				selectFromFiles: 'เลือกไฟล์รูปภาพ',
				url: 'ที่อยู่ URL ของรูปภาพ',
				remove: 'ลบรูปภาพ'
			},
			video: {
				video: 'วีดีโอ',
				videoLink: 'ลิงก์ของวีดีโอ',
				insert: 'แทรกวีดีโอ',
				url: 'ที่อยู่ URL ของวีดีโอ?',
				providers: '(YouTube, Vimeo, Vine, Instagram, DailyMotion หรือ Youku)'
			},
			link: {
				link: 'ตัวเชื่อมโยง',
				insert: 'แทรกตัวเชื่อมโยง',
				unlink: 'ยกเลิกตัวเชื่อมโยง',
				edit: 'แก้ไข',
				textToDisplay: 'ข้อความที่ให้แสดง',
				url: 'ที่อยู่เว็บไซต์ที่ต้องการให้เชื่อมโยงไปถึง?',
				openInNewWindow: 'เปิดในหน้าต่างใหม่'
			},
			table: {
				table: 'ตาราง'
			},
			hr: {
				insert: 'แทรกเส้นคั่น'
			},
			style: {
				style: 'รูปแบบ',
				p: 'ปกติ',
				blockquote: 'ข้อความ',
				pre: 'โค้ด',
				h1: 'หัวข้อ 1',
				h2: 'หัวข้อ 2',
				h3: 'หัวข้อ 3',
				h4: 'หัวข้อ 4',
				h5: 'หัวข้อ 5',
				h6: 'หัวข้อ 6'
			},
			lists: {
				unordered: 'รายการแบบไม่มีลำดับ',
				ordered: 'รายการแบบมีลำดับ'
			},
			options: {
				help: 'ช่วยเหลือ',
				fullscreen: 'ขยายเต็มหน้าจอ',
				codeview: 'ซอร์สโค้ด'
			},
			paragraph: {
				paragraph: 'ย่อหน้า',
				outdent: 'เยื้องซ้าย',
				indent: 'เยื้องขวา',
				left: 'จัดหน้าชิดซ้าย',
				center: 'จัดหน้ากึ่งกลาง',
				right: 'จัดหน้าชิดขวา',
				justify: 'จัดบรรทัดเสมอกัน'
			},
			color: {
				recent: 'สีที่ใช้ล่าสุด',
				more: 'สีอื่นๆ',
				background: 'สีพื้นหลัง',
				foreground: 'สีพื้นหน้า',
				transparent: 'โปร่งแสง',
				setTransparent: 'ตั้งค่าความโปร่งแสง',
				reset: 'คืนค่า',
				resetToDefault: 'คืนค่ามาตรฐาน'
			},
			shortcut: {
				shortcuts: 'แป้นลัด',
				close: 'ปิด',
				textFormatting: 'การจัดรูปแบบข้อความ',
				action: 'การกระทำ',
				paragraphFormatting: 'การจัดรูปแบบย่อหน้า',
				documentStyle: 'รูปแบบของเอกสาร'
			},
			history: {
				undo: 'ยกเลิกการกระทำ',
				redo: 'ทำซ้ำการกระทำ'
			}
		},
		'tr-TR': {
      font: {
        bold: 'Kalın',
        italic: 'İtalik',
        underline: 'Altı çizili',
        clear: 'Temizle',
        height: 'Satır yüksekliği',
        name: 'Yazı Tipi',
        strikethrough: 'Üstü çizili',
        subscript: 'Alt Simge',
        superscript: 'Üst Simge',
        size: 'Yazı tipi boyutu'
      },
      image: {
        image: 'Resim',
        insert: 'Resim ekle',
        resizeFull: 'Orjinal boyut',
        resizeHalf: '1/2 boyut',
        resizeQuarter: '1/4 boyut',
        floatLeft: 'Sola hizala',
        floatRight: 'Sağa hizala',
        floatNone: 'Hizalamayı kaldır',
        shapeRounded: 'Şekil: Yuvarlatılmış Köşe',
        shapeCircle: 'Şekil: Daire',
        shapeThumbnail: 'Şekil: K.Resim',
        shapeNone: 'Şekil: Yok',
        dragImageHere: 'Buraya sürükleyin',
        dropImage: 'Resim veya metni bırakın',
        selectFromFiles: 'Dosya seçin',
        maximumFileSize: 'Maksimum dosya boyutu',
        maximumFileSizeError: 'Maksimum dosya boyutu aşıldı.',
        url: 'Resim bağlantısı',
        remove: 'Resimi Kaldır'
      },
      video: {
        video: 'Video',
        videoLink: 'Video bağlantısı',
        insert: 'Video ekle',
        url: 'Video bağlantısı?',
        providers: '(YouTube, Vimeo, Vine, Instagram, DailyMotion veya Youku)'
      },
      link: {
        link: 'Bağlantı',
        insert: 'Bağlantı ekle',
        unlink: 'Bağlantıyı kaldır',
        edit: 'Bağlantıyı düzenle',
        textToDisplay: 'Görüntülemek için',
        url: 'Bağlantı adresi?',
        openInNewWindow: 'Yeni pencerede aç'
      },
      table: {
        table: 'Tablo'
      },
      hr: {
        insert: 'Yatay çizgi ekle'
      },
      style: {
        style: 'Biçim',
        p: 'p',
        blockquote: 'Alıntı',
        pre: 'Önbiçimli',
        h1: 'Başlık 1',
        h2: 'Başlık 2',
        h3: 'Başlık 3',
        h4: 'Başlık 4',
        h5: 'Başlık 5',
        h6: 'Başlık 6'
      },
      lists: {
        unordered: 'Madde işaretli liste',
        ordered: 'Numaralı liste'
      },
      options: {
        help: 'Yardım',
        fullscreen: 'Tam ekran',
        codeview: 'HTML Kodu'
      },
      paragraph: {
        paragraph: 'Paragraf',
        outdent: 'Girintiyi artır',
        indent: 'Girintiyi azalt',
        left: 'Sola hizala',
        center: 'Ortaya hizala',
        right: 'Sağa hizala',
        justify: 'Yasla'
      },
      color: {
        recent: 'Son renk',
        more: 'Daha fazla renk',
        background: 'Arka plan rengi',
        foreground: 'Yazı rengi',
        transparent: 'Seffaflık',
        setTransparent: 'Şeffaflığı ayarla',
        reset: 'Sıfırla',
        resetToDefault: 'Varsayılanlara sıfırla'
      },
      shortcut: {
        shortcuts: 'Kısayollar',
        close: 'Kapat',
        textFormatting: 'Yazı biçimlendirme',
        action: 'Eylem',
        paragraphFormatting: 'Paragraf biçimlendirme',
        documentStyle: 'Biçim',
        extraKeys: 'İlave anahtarlar'
      },
      help: {
        'insertParagraph': 'Paragraf ekler',
        'undo': 'Son komudu geri alır',
        'redo': 'Son komudu yineler',
        'tab': 'Girintiyi artırır',
        'untab': 'Girintiyi azaltır',
        'bold': 'Kalın yazma stilini ayarlar',
        'italic': 'İtalik yazma stilini ayarlar',
        'underline': 'Altı çizgili yazma stilini ayarlar',
        'strikethrough': 'Üstü çizgili yazma stilini ayarlar',
        'removeFormat': 'Biçimlendirmeyi temizler',
        'justifyLeft': 'Yazıyı sola hizalar',
        'justifyCenter': 'Yazıyı ortalar',
        'justifyRight': 'Yazıyı sağa hizalar',
        'justifyFull': 'Yazıyı her iki tarafa yazlar',
        'insertUnorderedList': 'Madde işaretli liste ekler',
        'insertOrderedList': 'Numaralı liste ekler',
        'outdent': 'Aktif paragrafın girintisini azaltır',
        'indent': 'Aktif paragrafın girintisini artırır',
        'formatPara': 'Aktif bloğun biçimini paragraf (p) olarak değiştirir',
        'formatH1': 'Aktif bloğun biçimini başlık 1 (h1) olarak değiştirir',
        'formatH2': 'Aktif bloğun biçimini başlık 2 (h2) olarak değiştirir',
        'formatH3': 'Aktif bloğun biçimini başlık 3 (h3) olarak değiştirir',
        'formatH4': 'Aktif bloğun biçimini başlık 4 (h4) olarak değiştirir',
        'formatH5': 'Aktif bloğun biçimini başlık 5 (h5) olarak değiştirir',
        'formatH6': 'Aktif bloğun biçimini başlık 6 (h6) olarak değiştirir',
        'insertHorizontalRule': 'Yatay çizgi ekler',
        'linkDialog.show': 'Bağlantı ayar kutusunu gösterir'
      },
      history: {
        undo: 'Geri al',
        redo: 'Yinele'
      },
      specialChar: {
        specialChar: 'ÖZEL KARAKTERLER',
        select: 'Özel Karakterleri seçin'
      }
    },
    'uk-UA': {
      font: {
        bold: 'Напівжирний',
        italic: 'Курсив',
        underline: 'Підкреслений',
        clear: 'Прибрати стилі шрифту',
        height: 'Висота лінії',
        name: 'Шрифт',
        strikethrough: 'Закреслений',
        subscript: 'Нижній індекс',
        superscript: 'Верхній індекс',
        size: 'Розмір шрифту'
      },
      image: {
        image: 'Картинка',
        insert: 'Вставити картинку',
        resizeFull: 'Відновити розмір',
        resizeHalf: 'Зменшити до 50%',
        resizeQuarter: 'Зменшити до 25%',
        floatLeft: 'Розташувати ліворуч',
        floatRight: 'Розташувати праворуч',
        floatNone: 'Початкове розташування',
        shapeRounded: 'Форма: Заокруглена',
        shapeCircle: 'Форма: Коло',
        shapeThumbnail: 'Форма: Мініатюра',
        shapeNone: 'Форма: Немає',
        dragImageHere: 'Перетягніть сюди картинку',
        dropImage: 'Перетягніть картинку',
        selectFromFiles: 'Вибрати з файлів',
        url: 'URL картинки',
        remove: 'Видалити картинку'
      },
      video: {
        video: 'Відео',
        videoLink: 'Посилання на відео',
        insert: 'Вставити відео',
        url: 'URL відео',
        providers: '(YouTube, Vimeo, Vine, Instagram, DailyMotion чи Youku)'
      },
      link: {
        link: 'Посилання',
        insert: 'Вставити посилання',
        unlink: 'Прибрати посилання',
        edit: 'Редагувати',
        textToDisplay: 'Текст, що відображається',
        url: 'URL для переходу',
        openInNewWindow: 'Відкривати у новому вікні'
      },
      table: {
        table: 'Таблиця'
      },
      hr: {
        insert: 'Вставити горизонтальну лінію'
      },
      style: {
        style: 'Стиль',
        p: 'Нормальний',
        blockquote: 'Цитата',
        pre: 'Код',
        h1: 'Заголовок 1',
        h2: 'Заголовок 2',
        h3: 'Заголовок 3',
        h4: 'Заголовок 4',
        h5: 'Заголовок 5',
        h6: 'Заголовок 6'
      },
      lists: {
        unordered: 'Маркований список',
        ordered: 'Нумерований список'
      },
      options: {
        help: 'Допомога',
        fullscreen: 'На весь екран',
        codeview: 'Початковий код'
      },
      paragraph: {
        paragraph: 'Параграф',
        outdent: 'Зменшити відступ',
        indent: 'Збільшити відступ',
        left: 'Вирівняти по лівому краю',
        center: 'Вирівняти по центру',
        right: 'Вирівняти по правому краю',
        justify: 'Розтягнути по ширині'
      },
      color: {
        recent: 'Останній колір',
        more: 'Ще кольори',
        background: 'Колір фону',
        foreground: 'Колір шрифту',
        transparent: 'Прозорий',
        setTransparent: 'Зробити прозорим',
        reset: 'Відновити',
        resetToDefault: 'Відновити початкові'
      },
      shortcut: {
        shortcuts: 'Комбінації клавіш',
        close: 'Закрити',
        textFormatting: 'Форматування тексту',
        action: 'Дія',
        paragraphFormatting: 'Форматування параграфу',
        documentStyle: 'Стиль документу'
      },
      history: {
        undo: 'Відмінити',
        redo: 'Повторити'
      }
    },
    'vi-VN': {
      font: {
        bold: 'In Đậm',
        italic: 'In Nghiêng',
        underline: 'Gạch dưới',
        clear: 'Bỏ định dạng',
        height: 'Chiều cao dòng',
        name: 'Phông chữ',
        strikethrough: 'Gạch ngang',
        size: 'Cỡ chữ'
      },
      image: {
        image: 'Hình ảnh',
        insert: 'Chèn',
        resizeFull: '100%',
        resizeHalf: '50%',
        resizeQuarter: '25%',
        floatLeft: 'Trôi về trái',
        floatRight: 'Trôi về phải',
        floatNone: 'Không trôi',
        dragImageHere: 'Thả Ảnh ở vùng này',
        selectFromFiles: 'Chọn từ File',
        url: 'URL',
        remove: 'Xóa'
      },
      video: {
        video: 'Video',
        videoLink: 'Link đến Video',
        insert: 'Chèn Video',
        url: 'URL',
        providers: '(YouTube, Vimeo, Vine, Instagram, DailyMotion và Youku)'
      },
      link: {
        link: 'Link',
        insert: 'Chèn Link',
        unlink: 'Gỡ Link',
        edit: 'Sửa',
        textToDisplay: 'Văn bản hiển thị',
        url: 'URL',
        openInNewWindow: 'Mở ở Cửa sổ mới'
      },
      table: {
        table: 'Bảng'
      },
      hr: {
        insert: 'Chèn'
      },
      style: {
        style: 'Kiểu chữ',
        p: 'Chữ thường',
        blockquote: 'Đoạn trích',
        pre: 'Mã Code',
        h1: 'H1',
        h2: 'H2',
        h3: 'H3',
        h4: 'H4',
        h5: 'H5',
        h6: 'H6'
      },
      lists: {
        unordered: 'Liệt kê danh sách',
        ordered: 'Liệt kê theo thứ tự'
      },
      options: {
        help: 'Trợ giúp',
        fullscreen: 'Toàn Màn hình',
        codeview: 'Xem Code'
      },
      paragraph: {
        paragraph: 'Canh lề',
        outdent: 'Dịch sang trái',
        indent: 'Dịch sang phải',
        left: 'Canh trái',
        center: 'Canh giữa',
        right: 'Canh phải',
        justify: 'Canh đều'
      },
      color: {
        recent: 'Màu chữ',
        more: 'Mở rộng',
        background: 'Màu nền',
        foreground: 'Màu chữ',
        transparent: 'trong suốt',
        setTransparent: 'Nền trong suốt',
        reset: 'Thiết lập lại',
        resetToDefault: 'Trở lại ban đầu'
      },
      shortcut: {
        shortcuts: 'Phím tắt',
        close: 'Đóng',
        textFormatting: 'Định dạng Văn bản',
        action: 'Hành động',
        paragraphFormatting: 'Định dạng',
        documentStyle: 'Kiểu văn bản'
      },
      history: {
        undo: 'Lùi lại',
        redo: 'Làm lại'
      }
    },
    'zh-CN': {
      font: {
        bold: '粗体',
        italic: '斜体',
        underline: '下划线',
        clear: '清除格式',
        height: '行高',
        name: '字体',
        strikethrough: '删除线',
        subscript: '下标',
        superscript: '上标',
        size: '字号'
      },
      image: {
        image: '图片',
        insert: '插入图片',
        resizeFull: '缩放至 100%',
        resizeHalf: '缩放至 50%',
        resizeQuarter: '缩放至 25%',
        floatLeft: '靠左浮动',
        floatRight: '靠右浮动',
        floatNone: '取消浮动',
        shapeRounded: '形状: 圆角',
        shapeCircle: '形状: 圆',
        shapeThumbnail: '形状: 缩略图',
        shapeNone: '形状: 无',
        dragImageHere: '将图片拖拽至此处',
        selectFromFiles: '从本地上传',
        maximumFileSize: '文件大小最大值',
        maximumFileSizeError: '文件大小超出最大值。',
        url: '图片地址',
        remove: '移除图片'
      },
      video: {
        video: '视频',
        videoLink: '视频链接',
        insert: '插入视频',
        url: '视频地址',
        providers: '(优酷, Instagram, DailyMotion, Youtube等)'
      },
      link: {
        link: '链接',
        insert: '插入链接',
        unlink: '去除链接',
        edit: '编辑链接',
        textToDisplay: '显示文本',
        url: '链接地址',
        openInNewWindow: '在新窗口打开'
      },
      table: {
        table: '表格'
      },
      hr: {
        insert: '水平线'
      },
      style: {
        style: '样式',
        p: '普通',
        blockquote: '引用',
        pre: '代码',
        h1: '标题 1',
        h2: '标题 2',
        h3: '标题 3',
        h4: '标题 4',
        h5: '标题 5',
        h6: '标题 6'
      },
      lists: {
        unordered: '无序列表',
        ordered: '有序列表'
      },
      options: {
        help: '帮助',
        fullscreen: '全屏',
        codeview: '源代码'
      },
      paragraph: {
        paragraph: '段落',
        outdent: '减少缩进',
        indent: '增加缩进',
        left: '左对齐',
        center: '居中对齐',
        right: '右对齐',
        justify: '两端对齐'
      },
      color: {
        recent: '最近使用',
        more: '更多',
        background: '背景',
        foreground: '前景',
        transparent: '透明',
        setTransparent: '透明',
        reset: '重置',
        resetToDefault: '默认'
      },
      shortcut: {
        shortcuts: '快捷键',
        close: '关闭',
        textFormatting: '文本格式',
        action: '动作',
        paragraphFormatting: '段落格式',
        documentStyle: '文档样式',
        extraKeys: '额外按键'
      },
      history: {
        undo: '撤销',
        redo: '重做'
      }
    },
    'zh-TW': {
      font: {
        bold: '粗體',
        italic: '斜體',
        underline: '底線',
        clear: '清除格式',
        height: '行高',
        name: '字體',
        strikethrough: '刪除線',
        subscript: '下標',
        superscript: '上標',
        size: '字號'
      },
      image: {
        image: '圖片',
        insert: '插入圖片',
        resizeFull: '縮放至100%',
        resizeHalf: '縮放至 50%',
        resizeQuarter: '縮放至 25%',
        floatLeft: '靠左浮動',
        floatRight: '靠右浮動',
        floatNone: '取消浮動',
        shapeRounded: '形狀: 圓角',
        shapeCircle: '形狀: 圓',
        shapeThumbnail: '形狀: 縮略圖',
        shapeNone: '形狀: 無',
        dragImageHere: '將圖片拖曳至此處',
        selectFromFiles: '從本機上傳',
        maximumFileSize: '文件大小最大值',
        maximumFileSizeError: '文件大小超出最大值。',
        url: '圖片網址',
        remove: '移除圖片'
      },
      video: {
        video: '影片',
        videoLink: '影片連結',
        insert: '插入影片',
        url: '影片網址',
        providers: '(優酷, Instagram, DailyMotion, Youtube等)'
      },
      link: {
        link: '連結',
        insert: '插入連結',
        unlink: '取消連結',
        edit: '編輯連結',
        textToDisplay: '顯示文字',
        url: '連結網址',
        openInNewWindow: '在新視窗開啟'
      },
      table: {
        table: '表格'
      },
      hr: {
        insert: '水平線'
      },
      style: {
        style: '樣式',
        p: '一般',
        blockquote: '引用區塊',
        pre: '程式碼區塊',
        h1: '標題 1',
        h2: '標題 2',
        h3: '標題 3',
        h4: '標題 4',
        h5: '標題 5',
        h6: '標題 6'
      },
      lists: {
        unordered: '項目清單',
        ordered: '編號清單'
      },
      options: {
        help: '幫助',
        fullscreen: '全螢幕',
        codeview: '原始碼'
      },
      paragraph: {
        paragraph: '段落',
        outdent: '取消縮排',
        indent: '增加縮排',
        left: '靠右對齊',
        center: '靠中對齊',
        right: '靠右對齊',
        justify: '左右對齊'
      },
      color: {
        recent: '字型顏色',
        more: '更多',
        background: '背景',
        foreground: '前景',
        transparent: '透明',
        setTransparent: '透明',
        reset: '重設',
        resetToDefault: '默認'
      },
      shortcut: {
        shortcuts: '快捷鍵',
        close: '關閉',
        textFormatting: '文字格式',
        action: '動作',
        paragraphFormatting: '段落格式',
        documentStyle: '文件格式',
        extraKeys: '額外按鍵'
      },
      history: {
        undo: '復原',
        redo: '取消復原'
      }
    },
    'ar-AR': {
	  font: {
		bold: 'عريض',
		italic: 'مائل',
		underline: 'تحته خط',
		clear: 'مسح التنسيق',
		height: 'إرتفاع السطر',
		name: 'الخط',
		strikethrough: 'فى وسطه خط',
		size: 'الحجم'
	  },
	  image: {
		image: 'صورة',
		insert: 'إضافة صورة',
		resizeFull: 'الحجم بالكامل',
		resizeHalf: 'تصغير للنصف',
		resizeQuarter: 'تصغير للربع',
		floatLeft: 'تطيير لليسار',
		floatRight: 'تطيير لليمين',
		floatNone: 'ثابته',
		dragImageHere: 'إدرج الصورة هنا',
		selectFromFiles: 'حدد ملف',
		url: 'رابط الصورة',
		remove: 'حذف الصورة'
	  },
	  video: {
		video: 'فيديو',
		videoLink: 'رابط الفيديو',
		insert: 'إدراج الفيديو',
		url: 'رابط الفيديو',
		providers: '(YouTube, Vimeo, Vine, Instagram, DailyMotion ou Youku)'
	  },
	  link: {
		link: 'رابط رابط',
		insert: 'إدراج',
		unlink: 'حذف الرابط',
		edit: 'تعديل',
		textToDisplay: 'النص',
		url: 'مسار الرابط',
		openInNewWindow: 'فتح في نافذة جديدة'
	  },
	  table: {
		table: 'جدول'
	  },
	  hr: {
		insert: 'إدراج خط أفقي'
	  },
	  style: {
		style: 'تنسيق',
		p: 'عادي',
		blockquote: 'إقتباس',
		pre: 'شفيرة',
		h1: 'عنوان رئيسي 1',
		h2: 'عنوان رئيسي 2',
		h3: 'عنوان رئيسي 3',
		h4: 'عنوان رئيسي 4',
		h5: 'عنوان رئيسي 5',
		h6: 'عنوان رئيسي 6'
	  },
	  lists: {
		unordered: 'قائمة مُنقطة',
		ordered: 'قائمة مُرقمة'
	  },
	  options: {
		help: 'مساعدة',
		fullscreen: 'حجم الشاشة بالكامل',
		codeview: 'شفيرة المصدر'
	  },
	  paragraph: {
		paragraph: 'فقرة',
		outdent: 'محاذاة للخارج',
		indent: 'محاذاة للداخل',
		left: 'محاذاة لليسار',
		center: 'توسيط',
		right: 'محاذاة لليمين',
		justify: 'ملئ السطر'
	  },
	  color: {
		recent: 'تم إستخدامه',
		more: 'المزيد',
		background: 'لون الخلفية',
		foreground: 'لون النص',
		transparent: 'شفاف',
		setTransparent: 'بدون خلفية',
		reset: 'إعادة الضبط',
		resetToDefault: 'إعادة الضبط'
	  },
	  shortcut: {
		shortcuts: 'إختصارات',
		close: 'غلق',
		textFormatting: 'تنسيق النص',
		action: 'Action',
		paragraphFormatting: 'تنسيق الفقرة',
		documentStyle: 'تنسيق المستند'
	  },
	  history: {
		undo: 'تراجع',
		redo: 'إعادة'
	  }
	}
	});
})(jQuery);
