# -*- coding: utf-8 -*-
# Generated by Django 1.10.4 on 2017-03-10 22:13
from __future__ import unicode_literals

import chat.models
from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('subjects', '0014_auto_20170130_1828'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('categories', '0014_auto_20170224_0023'),
    ]

    operations = [
        migrations.CreateModel(
            name='ChatFavorites',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
            ],
        ),
        migrations.CreateModel(
            name='ChatVisualizations',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('viewed', models.BooleanField(default=False, verbose_name='Viewed')),
                ('date_viewed', models.DateTimeField(blank=True, null=True, verbose_name='Date/Time Viewed')),
            ],
        ),
        migrations.CreateModel(
            name='Conversation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('_my_subclass', models.CharField(max_length=200)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='TalkMessages',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('text', models.TextField(blank=True, verbose_name='Comment')),
                ('image', models.ImageField(blank=True, null=True, upload_to=chat.models.upload_filename, validators=[chat.models.validate_img_extension], verbose_name='Image')),
                ('create_date', models.DateTimeField(auto_now_add=True, verbose_name='Create Date')),
            ],
        ),
        migrations.CreateModel(
            name='CategoryTalk',
            fields=[
                ('conversation_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='chat.Conversation')),
                ('space', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='talk_category', to='categories.Category', verbose_name='Category')),
            ],
            options={
                'abstract': False,
            },
            bases=('chat.conversation',),
        ),
        migrations.CreateModel(
            name='GeneralTalk',
            fields=[
                ('conversation_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='chat.Conversation')),
                ('space', models.IntegerField(blank=True, default=0, verbose_name='Space')),
            ],
            options={
                'abstract': False,
            },
            bases=('chat.conversation',),
        ),
        migrations.CreateModel(
            name='SubjectTalk',
            fields=[
                ('conversation_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='chat.Conversation')),
                ('space', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='talk_subject', to='subjects.Subject', verbose_name='Subject')),
            ],
            options={
                'abstract': False,
            },
            bases=('chat.conversation',),
        ),
        migrations.AddField(
            model_name='talkmessages',
            name='talk',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='message_talk', to='chat.Conversation', verbose_name='Conversation'),
        ),
        migrations.AddField(
            model_name='talkmessages',
            name='user',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='message_user', to=settings.AUTH_USER_MODEL, verbose_name='User'),
        ),
        migrations.AddField(
            model_name='conversation',
            name='user_one',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='talk_user_start', to=settings.AUTH_USER_MODEL, verbose_name='User One'),
        ),
        migrations.AddField(
            model_name='conversation',
            name='user_two',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='talk_user_end', to=settings.AUTH_USER_MODEL, verbose_name='User Two'),
        ),
        migrations.AddField(
            model_name='chatvisualizations',
            name='message',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='chat_visualization_message', to='chat.TalkMessages', verbose_name='Message'),
        ),
        migrations.AddField(
            model_name='chatvisualizations',
            name='user',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='chat_visualization_user', to=settings.AUTH_USER_MODEL, verbose_name='User'),
        ),
        migrations.AddField(
            model_name='chatfavorites',
            name='message',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='chat_favorites_message', to='chat.TalkMessages', verbose_name='Message'),
        ),
        migrations.AddField(
            model_name='chatfavorites',
            name='user',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='chat_favorites_user', to=settings.AUTH_USER_MODEL, verbose_name='User'),
        ),
    ]
