# -*- coding: utf-8 -*-
# Generated by Django 1.10 on 2017-02-03 19:18
from __future__ import unicode_literals

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import mural.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('topics', '0007_auto_20170123_1911'),
        ('categories', '0013_auto_20170203_1618'),
        ('subjects', '0014_auto_20170130_1828'),
    ]

    operations = [
        migrations.CreateModel(
            name='Comment',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('comment', models.TextField(blank=True, verbose_name='Comment')),
                ('image', models.ImageField(blank=True, null=True, upload_to='posts/comments/', validators=[mural.models.validate_img_extension], verbose_name='Image')),
                ('create_date', models.DateTimeField(auto_now_add=True, verbose_name='Create Date')),
                ('last_update', models.DateTimeField(auto_now=True, verbose_name='Last Update')),
            ],
        ),
        migrations.CreateModel(
            name='Mural',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('_my_subclass', models.CharField(max_length=200)),
                ('action', models.CharField(blank=True, choices=[('comment', 'Comment'), ('help', 'Ask for Help')], max_length=100, verbose_name='Action')),
                ('post', models.TextField(blank=True, verbose_name='Post')),
                ('image', models.ImageField(blank=True, null=True, upload_to='posts/', validators=[mural.models.validate_img_extension], verbose_name='Image')),
                ('create_date', models.DateTimeField(auto_now_add=True, verbose_name='Create Date')),
                ('last_update', models.DateTimeField(auto_now=True, verbose_name='Last Update')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='CategoryPost',
            fields=[
                ('mural_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='mural.Mural')),
                ('space', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='post_category', to='categories.Category', verbose_name='Category')),
            ],
            options={
                'abstract': False,
            },
            bases=('mural.mural',),
        ),
        migrations.CreateModel(
            name='GeneralPost',
            fields=[
                ('mural_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='mural.Mural')),
                ('space', models.IntegerField(blank=True, default=0, verbose_name='Space')),
            ],
            options={
                'abstract': False,
            },
            bases=('mural.mural',),
        ),
        migrations.CreateModel(
            name='SubjectPost',
            fields=[
                ('mural_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='mural.Mural')),
                ('resource', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='post_resource', to='topics.Resource', verbose_name='Resource')),
                ('space', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='post_subject', to='subjects.Subject', verbose_name='Subject')),
            ],
            options={
                'abstract': False,
            },
            bases=('mural.mural',),
        ),
        migrations.AddField(
            model_name='mural',
            name='user',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='post_user', to=settings.AUTH_USER_MODEL, verbose_name='User'),
        ),
        migrations.AddField(
            model_name='comment',
            name='post',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='comment_post', to='mural.Mural', verbose_name='Post'),
        ),
        migrations.AddField(
            model_name='comment',
            name='user',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='comment_user', to=settings.AUTH_USER_MODEL, verbose_name='User'),
        ),
    ]
