# -*- coding: utf-8 -*-
# Generated by Django 1.10 on 2017-01-06 19:53
from __future__ import unicode_literals

from django.db import migrations

def forwards_func(apps, schema_editor):
    # We get the model from the versioned app registry;
    # if we directly import it, it'll be the wrong version
    MailSender = apps.get_model("mailsender", "MailSender")
    
    db_alias = schema_editor.connection.alias
    
    MailSender.objects.using(db_alias).bulk_create([
        MailSender(description="Example", hostname="example.com", port=25, username="example", password="example", crypto=1),
    ])

def reverse_func(apps, schema_editor):
    # forwards_func() creates two Country instances,
    # so reverse_func() should delete them.
    MailSender = apps.get_model("mailsender", "MailSender")
    
    db_alias = schema_editor.connection.alias
    
    MailSender.objects.using(db_alias).filter(description="Example", hostname="example.com", port=25, username="example", password="example", crypto=1).delete()

class Migration(migrations.Migration):

    dependencies = [
        ('mailsender', '0001_initial'),
    ]

    operations = [
        migrations.RunPython(forwards_func, reverse_func),
    ]