# -*- coding: utf-8 -*-
# Generated by Django 1.10.4 on 2017-04-08 00:54
from __future__ import unicode_literals

import autoslug.fields
from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import news.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='News',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=200, unique=True, verbose_name='Name')),
                ('slug', autoslug.fields.AutoSlugField(editable=False, populate_from='title', unique=True, verbose_name='Slug')),
                ('image', models.ImageField(upload_to='news/', validators=[news.models.validate_img_extension], verbose_name='News Image')),
                ('content', models.TextField(verbose_name='News Content')),
                ('create_date', models.DateTimeField(auto_now_add=True, verbose_name='Create Date')),
                ('creator', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='news_creator_user', to=settings.AUTH_USER_MODEL, verbose_name='Creator')),
            ],
            options={
                'verbose_name_plural': 'News',
                'verbose_name': 'News',
            },
        ),
    ]
