# -*- coding: utf-8 -*-
# Generated by Django 1.10 on 2016-12-26 20:21
from __future__ import unicode_literals

import autoslug.fields
from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('categories', '0003_auto_20161226_1358'),
    ]

    operations = [
        migrations.CreateModel(
            name='Subject',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=200, unique=True, verbose_name='Name')),
                ('slug', autoslug.fields.AutoSlugField(editable=False, populate_from='name', unique=True, verbose_name='Slug')),
                ('description_brief', models.CharField(max_length=100, verbose_name='simpler_description')),
                ('description', models.CharField(max_length=300, verbose_name='description')),
                ('visible', models.BooleanField(verbose_name='visible')),
                ('init_date', models.DateField(verbose_name='Begin of Subject Date')),
                ('end_date', models.DateField(verbose_name='End of Subject Date')),
                ('create_date', models.DateTimeField(auto_now_add=True, verbose_name='Creation Date')),
                ('update_date', models.DateTimeField(auto_now=True, verbose_name='Date of last update')),
                ('max_upload_size', models.IntegerField(verbose_name='Maximum upload size')),
                ('category', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='subject_category', to='categories.Category')),
                ('professor', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='professor', to=settings.AUTH_USER_MODEL)),
                ('students', models.ManyToManyField(blank=True, related_name='subject_student', to=settings.AUTH_USER_MODEL, verbose_name='Students')),
            ],
            options={
                'verbose_name_plural': 'Subjects',
                'verbose_name': 'Subject',
            },
        ),
    ]
