# -*- coding: utf-8 -*-
# Generated by Django 1.10 on 2017-01-10 21:09
from __future__ import unicode_literals

from django.db import migrations

def forwards_func(apps, schema_editor):
    # We get the model from the versioned app registry;
    # if we directly import it, it'll be the wrong version
    Themes = apps.get_model("themes", "Themes")
    
    db_alias = schema_editor.connection.alias
    
    Themes.objects.using(db_alias).bulk_create([
        Themes(title = 'Projeto Amadeus'),
    ])

def reverse_func(apps, schema_editor):
    # forwards_func() creates two Country instances,
    # so reverse_func() should delete them.
    Themes = apps.get_model("themes", "Themes")
    
    db_alias = schema_editor.connection.alias
    
    Themes.objects.using(db_alias).filter(title = 'Projeto Amadeus').delete()

class Migration(migrations.Migration):

    dependencies = [
        ('themes', '0001_initial'),
    ]

    operations = [
    	migrations.RunPython(forwards_func, reverse_func),
    ]
