/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.LoaderConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.Parser;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.loaders.CacheLoader;
import org.infinispan.loaders.CacheStore;
import org.infinispan.loaders.file.FileCacheStore;
import org.infinispan.loaders.jdbc.binary.JdbcBinaryCacheStore;
import org.infinispan.loaders.jdbc.connectionfactory.ManagedConnectionFactory;
import org.infinispan.loaders.jdbc.mixed.JdbcMixedCacheStore;
import org.infinispan.loaders.jdbc.stringbased.JdbcStringBasedCacheStore;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.tm.BatchModeTransactionManager;
import org.infinispan.util.TypedProperties;
import org.infinispan.util.concurrent.IsolationLevel;
import org.jboss.as.clustering.infinispan.InfinispanMessages;
import org.jboss.as.clustering.infinispan.RemoteCacheStore;
import org.jboss.as.clustering.infinispan.subsystem.CacheConfigurationService;
import org.jboss.as.clustering.infinispan.subsystem.CacheService;
import org.jboss.as.clustering.infinispan.subsystem.CommonAttributes;
import org.jboss.as.clustering.infinispan.subsystem.EmbeddedCacheManagerService;
import org.jboss.as.clustering.infinispan.subsystem.Indexing;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanJndiName;
import org.jboss.as.clustering.infinispan.subsystem.StartMode;
import org.jboss.as.clustering.infinispan.subsystem.TransactionMode;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.controller.services.path.PathManagerService;
import org.jboss.as.naming.ManagedReferenceInjector;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.service.BinderService;
import org.jboss.as.network.OutboundSocketBinding;
import org.jboss.as.server.Services;
import org.jboss.as.txn.service.TxnServices;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.logging.Logger;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;
import org.jboss.tm.XAResourceRecoveryRegistry;

public abstract class CacheAdd
extends AbstractAddStepHandler {
    private static final Logger log = Logger.getLogger((String)CacheAdd.class.getPackage().getName());
    private static final String DEFAULTS = "infinispan-defaults.xml";
    private static volatile Map<CacheMode, Configuration> defaults = null;
    final CacheMode mode;

    public static synchronized Configuration getDefaultConfiguration(CacheMode cacheMode) {
        if (defaults == null) {
            ConfigurationBuilderHolder holder = CacheAdd.load(DEFAULTS);
            Configuration defaultConfig = holder.getDefaultConfigurationBuilder().build();
            EnumMap<CacheMode, Configuration> map = new EnumMap<CacheMode, Configuration>(CacheMode.class);
            map.put(defaultConfig.clustering().cacheMode(), defaultConfig);
            for (ConfigurationBuilder builder : holder.getNamedConfigurationBuilders().values()) {
                Configuration config = builder.build();
                map.put(config.clustering().cacheMode(), config);
            }
            for (CacheMode mode : CacheMode.values()) {
                if (map.containsKey(mode)) continue;
                map.put(mode, new ConfigurationBuilder().read(defaultConfig).clustering().cacheMode(mode).build());
            }
            defaults = map;
        }
        return defaults.get(cacheMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ConfigurationBuilderHolder load(String resource) {
        ConfigurationBuilderHolder configurationBuilderHolder;
        URL url = CacheAdd.find(resource, CacheAdd.class.getClassLoader());
        log.debugf("Loading Infinispan defaults from %s", (Object)url.toString());
        InputStream input = url.openStream();
        Parser parser = new Parser(Parser.class.getClassLoader());
        try {
            configurationBuilderHolder = parser.parse(input);
        }
        catch (Throwable throwable) {
            try {
                try {
                    input.close();
                }
                catch (IOException e) {
                    log.warn((Object)e.getMessage(), (Throwable)e);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IllegalStateException(String.format("Failed to parse %s", url), e);
            }
        }
        try {
            input.close();
        }
        catch (IOException e) {
            log.warn((Object)e.getMessage(), (Throwable)e);
        }
        return configurationBuilderHolder;
    }

    private static URL find(String resource, ClassLoader ... loaders) {
        for (ClassLoader loader : loaders) {
            URL url;
            if (loader == null || (url = loader.getResource(resource)) == null) continue;
            return url;
        }
        throw new IllegalArgumentException(String.format("Failed to locate %s", resource));
    }

    CacheAdd(CacheMode mode) {
        this.mode = mode;
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        this.populate(operation, model);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        ModelNode cacheModel = Resource.Tools.readModel((Resource)context.readResource(PathAddress.EMPTY_ADDRESS));
        PathAddress containerAddress = this.getCacheContainerAddressFromOperation(operation);
        ModelNode containerModel = context.readResourceFromRoot(containerAddress).getModel();
        newControllers.addAll(this.installRuntimeServices(context, operation, containerModel, cacheModel, verificationHandler));
    }

    Collection<ServiceController<?>> installRuntimeServices(OperationContext context, ModelNode operation, ModelNode containerModel, ModelNode cacheModel, ServiceVerificationHandler verificationHandler) throws OperationFailedException {
        PathAddress cacheAddress = this.getCacheAddressFromOperation(operation);
        PathAddress containerAddress = this.getCacheContainerAddressFromOperation(operation);
        String cacheName = cacheAddress.getLastElement().getValue();
        String containerName = containerAddress.getLastElement().getValue();
        ModelNode resolvedValue = null;
        resolvedValue = CommonAttributes.JNDI_NAME.resolveModelAttribute(context, cacheModel);
        String jndiName = resolvedValue.isDefined() ? resolvedValue.asString() : null;
        ServiceController.Mode initialMode = StartMode.valueOf(CommonAttributes.START.resolveModelAttribute(context, cacheModel).asString()).getMode();
        resolvedValue = CommonAttributes.CACHE_MODULE.resolveModelAttribute(context, cacheModel);
        ModuleIdentifier moduleId = resolvedValue.isDefined() ? ModuleIdentifier.fromString((String)resolvedValue.asString()) : null;
        LinkedList dependencies = new LinkedList();
        ConfigurationBuilder builder = new ConfigurationBuilder().read(CacheAdd.getDefaultConfiguration(this.mode));
        this.processModelNode(context, containerName, cacheModel, builder, dependencies);
        String defaultCache = CommonAttributes.DEFAULT_CACHE.resolveModelAttribute(context, containerModel).asString();
        ServiceTarget target = context.getServiceTarget();
        Configuration config = builder.build();
        ArrayList controllers = new ArrayList(3);
        controllers.add(this.installCacheConfigurationService(target, containerName, cacheName, defaultCache, moduleId, builder, config, dependencies, verificationHandler));
        log.debugf("Cache configuration service for %s installed for container %s", (Object)cacheName, (Object)containerName);
        controllers.add(this.installCacheService(target, containerName, cacheName, defaultCache, initialMode, builder, config, verificationHandler));
        controllers.add(this.installJndiService(target, containerName, cacheName, jndiName, verificationHandler));
        log.debugf("Cache service for cache %s installed for container %s", (Object)cacheName, (Object)containerName);
        return controllers;
    }

    void removeRuntimeServices(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        PathAddress cacheAddress = this.getCacheAddressFromOperation(operation);
        PathAddress containerAddress = this.getCacheContainerAddressFromOperation(operation);
        String cacheName = cacheAddress.getLastElement().getValue();
        String containerName = containerAddress.getLastElement().getValue();
        ModelNode resolvedValue = null;
        resolvedValue = CommonAttributes.JNDI_NAME.resolveModelAttribute(context, model);
        String jndiNameString = resolvedValue.isDefined() ? resolvedValue.asString() : null;
        String jndiName = InfinispanJndiName.createCacheJndiNameOrDefault(jndiNameString, containerName, cacheName);
        ContextNames.BindInfo bindInfo = ContextNames.bindInfoFor((String)jndiName);
        context.removeService(bindInfo.getBinderServiceName());
        context.removeService(CacheService.getServiceName(containerName, cacheName));
        context.removeService(CacheConfigurationService.getServiceName(containerName, cacheName));
        log.debugf("cache %s removed for container %s", (Object)cacheName, (Object)containerName);
    }

    protected PathAddress getCacheAddressFromOperation(ModelNode operation) {
        return PathAddress.pathAddress((ModelNode)operation.get("address"));
    }

    protected PathAddress getCacheContainerAddressFromOperation(ModelNode operation) {
        PathAddress cacheAddress = this.getCacheAddressFromOperation(operation);
        PathAddress containerAddress = cacheAddress.subAddress(0, cacheAddress.size() - 1);
        return containerAddress;
    }

    ServiceController<?> installCacheConfigurationService(ServiceTarget target, String containerName, String cacheName, String defaultCache, ModuleIdentifier moduleId, ConfigurationBuilder builder, Configuration config, List<Dependency<?>> dependencies, ServiceVerificationHandler verificationHandler) {
        InjectedValue container = new InjectedValue();
        CacheConfigurationDependencies cacheConfigurationDependencies = new CacheConfigurationDependencies((Value<EmbeddedCacheManager>)container);
        CacheConfigurationService cacheConfigurationService = new CacheConfigurationService(cacheName, builder, moduleId, cacheConfigurationDependencies);
        ServiceBuilder configBuilder = target.addService(CacheConfigurationService.getServiceName(containerName, cacheName), (Service)cacheConfigurationService).addDependency(EmbeddedCacheManagerService.getServiceName(containerName), EmbeddedCacheManager.class, (Injector)container).addDependency(Services.JBOSS_SERVICE_MODULE_LOADER, ModuleLoader.class, cacheConfigurationDependencies.getModuleLoaderInjector()).setInitialMode(ServiceController.Mode.PASSIVE);
        if (config.invocationBatching().enabled()) {
            cacheConfigurationDependencies.getTransactionManagerInjector().inject((Object)BatchModeTransactionManager.getInstance());
        } else if (config.transaction().transactionMode() == org.infinispan.transaction.TransactionMode.TRANSACTIONAL) {
            configBuilder.addDependency(TxnServices.JBOSS_TXN_TRANSACTION_MANAGER, TransactionManager.class, cacheConfigurationDependencies.getTransactionManagerInjector());
            if (config.transaction().useSynchronization()) {
                configBuilder.addDependency(TxnServices.JBOSS_TXN_SYNCHRONIZATION_REGISTRY, TransactionSynchronizationRegistry.class, cacheConfigurationDependencies.getTransactionSynchronizationRegistryInjector());
            }
        }
        for (Dependency<?> dependency : dependencies) {
            this.addDependency(configBuilder, dependency);
        }
        if (cacheName.equals(defaultCache)) {
            configBuilder.addAliases(new ServiceName[]{CacheConfigurationService.getServiceName(containerName, null)});
        }
        return configBuilder.install();
    }

    ServiceController<?> installCacheService(ServiceTarget target, String containerName, String cacheName, String defaultCache, ServiceController.Mode initialMode, ConfigurationBuilder builder, Configuration config, ServiceVerificationHandler verificationHandler) {
        InjectedValue container = new InjectedValue();
        CacheDependencies cacheDependencies = new CacheDependencies((Value<EmbeddedCacheManager>)container);
        CacheService cacheService = new CacheService(cacheName, cacheDependencies);
        ServiceBuilder cacheBuilder = target.addService(CacheService.getServiceName(containerName, cacheName), cacheService).addDependency(CacheConfigurationService.getServiceName(containerName, cacheName)).addDependency(EmbeddedCacheManagerService.getServiceName(containerName), EmbeddedCacheManager.class, (Injector)container).setInitialMode(initialMode);
        if (config.transaction().recovery().enabled()) {
            cacheBuilder.addDependency(TxnServices.JBOSS_TXN_ARJUNA_RECOVERY_MANAGER, XAResourceRecoveryRegistry.class, cacheDependencies.getRecoveryRegistryInjector());
        }
        if (cacheName.equals(defaultCache)) {
            cacheBuilder.addAliases(new ServiceName[]{CacheService.getServiceName(containerName, null)});
        }
        if (initialMode == ServiceController.Mode.ACTIVE) {
            cacheBuilder.addListener((ServiceListener)verificationHandler);
        }
        return cacheBuilder.install();
    }

    ServiceController<?> installJndiService(ServiceTarget target, String containerName, String cacheName, String jndiNameString, ServiceVerificationHandler verificationHandler) {
        String jndiName = InfinispanJndiName.createCacheJndiNameOrDefault(jndiNameString, containerName, cacheName);
        ServiceName cacheServiceName = CacheService.getServiceName(containerName, cacheName);
        ContextNames.BindInfo bindInfo = ContextNames.bindInfoFor((String)jndiName);
        BinderService binder = new BinderService(bindInfo.getBindName());
        return target.addService(bindInfo.getBinderServiceName(), (Service)binder).addAliases(new ServiceName[]{ContextNames.JAVA_CONTEXT_SERVICE_NAME.append(new String[]{jndiName})}).addDependency(cacheServiceName, Cache.class, (Injector)new ManagedReferenceInjector(binder.getManagedObjectInjector())).addDependency(bindInfo.getParentContextServiceName(), ServiceBasedNamingStore.class, binder.getNamingStoreInjector()).setInitialMode(ServiceController.Mode.PASSIVE).install();
    }

    private <T> void addDependency(ServiceBuilder<?> builder, Dependency<T> dependency) {
        ServiceName name = dependency.getName();
        Injector<T> injector = dependency.getInjector();
        if (injector != null) {
            builder.addDependency(name, dependency.getType(), injector);
        } else {
            builder.addDependency(name);
        }
    }

    void populate(ModelNode fromModel, ModelNode toModel) throws OperationFailedException {
        CommonAttributes.START.validateAndSet(fromModel, toModel);
        CommonAttributes.BATCHING.validateAndSet(fromModel, toModel);
        CommonAttributes.INDEXING.validateAndSet(fromModel, toModel);
        CommonAttributes.JNDI_NAME.validateAndSet(fromModel, toModel);
        CommonAttributes.CACHE_MODULE.validateAndSet(fromModel, toModel);
    }

    void processModelNode(OperationContext context, String containerName, ModelNode cache, ConfigurationBuilder builder, List<Dependency<?>> dependencies) throws OperationFailedException {
        String storeKey;
        Indexing indexing = Indexing.valueOf(CommonAttributes.INDEXING.resolveModelAttribute(context, cache).asString());
        boolean batching = CommonAttributes.BATCHING.resolveModelAttribute(context, cache).asBoolean();
        builder.clustering().cacheMode(this.mode);
        builder.indexing().enabled(indexing.isEnabled()).indexLocalOnly(indexing.isLocalOnly());
        if (cache.hasDefined("locking") && cache.get(new String[]{"locking", "LOCKING"}).isDefined()) {
            ModelNode locking = cache.get(new String[]{"locking", "LOCKING"});
            IsolationLevel isolationLevel = IsolationLevel.valueOf((String)CommonAttributes.ISOLATION.resolveModelAttribute(context, locking).asString());
            boolean striping = CommonAttributes.STRIPING.resolveModelAttribute(context, locking).asBoolean();
            long acquireTimeout = CommonAttributes.ACQUIRE_TIMEOUT.resolveModelAttribute(context, locking).asLong();
            int concurrencyLevel = CommonAttributes.CONCURRENCY_LEVEL.resolveModelAttribute(context, locking).asInt();
            builder.locking().isolationLevel(isolationLevel).useLockStriping(striping).lockAcquisitionTimeout(acquireTimeout).concurrencyLevel(concurrencyLevel);
        }
        TransactionMode txMode = TransactionMode.NONE;
        LockingMode lockingMode = LockingMode.OPTIMISTIC;
        if (cache.hasDefined("transaction") && cache.get(new String[]{"transaction", "TRANSACTION"}).isDefined()) {
            ModelNode transaction = cache.get(new String[]{"transaction", "TRANSACTION"});
            long stopTimeout = CommonAttributes.STOP_TIMEOUT.resolveModelAttribute(context, transaction).asLong();
            txMode = TransactionMode.valueOf(CommonAttributes.MODE.resolveModelAttribute(context, transaction).asString());
            lockingMode = LockingMode.valueOf((String)CommonAttributes.LOCKING.resolveModelAttribute(context, transaction).asString());
            builder.transaction().cacheStopTimeout(stopTimeout);
        }
        builder.transaction().transactionMode(txMode.getMode()).lockingMode(lockingMode).useSynchronization(!txMode.isXAEnabled()).recovery().enabled(txMode.isRecoveryEnabled());
        if (txMode.isRecoveryEnabled()) {
            builder.transaction().syncCommitPhase(true).syncRollbackPhase(true);
        }
        if (batching) {
            builder.transaction().transactionMode(org.infinispan.transaction.TransactionMode.TRANSACTIONAL).invocationBatching().enable();
        } else {
            builder.transaction().invocationBatching().disable();
        }
        if (cache.hasDefined("eviction") && cache.get(new String[]{"eviction", "EVICTION"}).isDefined()) {
            ModelNode eviction = cache.get(new String[]{"eviction", "EVICTION"});
            EvictionStrategy strategy = EvictionStrategy.valueOf((String)CommonAttributes.EVICTION_STRATEGY.resolveModelAttribute(context, eviction).asString());
            builder.eviction().strategy(strategy);
            if (strategy.isEnabled()) {
                int maxEntries = CommonAttributes.MAX_ENTRIES.resolveModelAttribute(context, eviction).asInt();
                builder.eviction().maxEntries(maxEntries);
            }
        }
        if (cache.hasDefined("expiration") && cache.get(new String[]{"expiration", "EXPIRATION"}).isDefined()) {
            ModelNode expiration = cache.get(new String[]{"expiration", "EXPIRATION"});
            long maxIdle = CommonAttributes.MAX_IDLE.resolveModelAttribute(context, expiration).asLong();
            long lifespan = CommonAttributes.LIFESPAN.resolveModelAttribute(context, expiration).asLong();
            long interval = CommonAttributes.INTERVAL.resolveModelAttribute(context, expiration).asLong();
            builder.expiration().maxIdle(maxIdle).lifespan(lifespan).wakeUpInterval(interval);
            if (maxIdle > 0L || lifespan > 0L) {
                builder.expiration().enableReaper();
            } else {
                builder.expiration().disableReaper();
            }
        }
        if ((storeKey = this.findStoreKey(cache)) != null) {
            ModelNode store = this.getStoreModelNode(cache);
            boolean shared = CommonAttributes.SHARED.resolveModelAttribute(context, store).asBoolean();
            boolean preload = CommonAttributes.PRELOAD.resolveModelAttribute(context, store).asBoolean();
            boolean passivation = CommonAttributes.PASSIVATION.resolveModelAttribute(context, store).asBoolean();
            boolean fetchState = CommonAttributes.FETCH_STATE.resolveModelAttribute(context, store).asBoolean();
            boolean purge = CommonAttributes.PURGE.resolveModelAttribute(context, store).asBoolean();
            boolean singleton = CommonAttributes.SINGLETON.resolveModelAttribute(context, store).asBoolean();
            boolean async = store.hasDefined("write-behind") && store.get(new String[]{"write-behind", "WRITE_BEHIND"}).isDefined();
            builder.loaders().shared(shared).preload(preload).passivation(passivation);
            LoaderConfigurationBuilder storeBuilder = builder.loaders().addCacheLoader().fetchPersistentState(fetchState).purgeOnStartup(purge).purgeSynchronously(true);
            storeBuilder.singletonStore().enabled(singleton);
            if (async) {
                ModelNode writeBehind = store.get(new String[]{"write-behind", "WRITE_BEHIND"});
                storeBuilder.async().enable().flushLockTimeout(CommonAttributes.FLUSH_LOCK_TIMEOUT.resolveModelAttribute(context, writeBehind).asLong()).modificationQueueSize(CommonAttributes.MODIFICATION_QUEUE_SIZE.resolveModelAttribute(context, writeBehind).asInt()).shutdownTimeout(CommonAttributes.SHUTDOWN_TIMEOUT.resolveModelAttribute(context, writeBehind).asLong()).threadPoolSize(CommonAttributes.THREAD_POOL_SIZE.resolveModelAttribute(context, writeBehind).asInt());
            }
            this.buildCacheStore(context, storeBuilder, containerName, store, storeKey, dependencies);
        }
    }

    private String findStoreKey(ModelNode cache) {
        if (cache.hasDefined("store")) {
            return "store";
        }
        if (cache.hasDefined("file-store")) {
            return "file-store";
        }
        if (cache.hasDefined("string-keyed-jdbc-store")) {
            return "string-keyed-jdbc-store";
        }
        if (cache.hasDefined("binary-keyed-jdbc-store")) {
            return "binary-keyed-jdbc-store";
        }
        if (cache.hasDefined("mixed-keyed-jdbc-store")) {
            return "mixed-keyed-jdbc-store";
        }
        if (cache.hasDefined("remote-store")) {
            return "remote-store";
        }
        return null;
    }

    private ModelNode getStoreModelNode(ModelNode cache) {
        if (cache.hasDefined("store")) {
            return cache.get(new String[]{"store", "STORE"});
        }
        if (cache.hasDefined("file-store")) {
            return cache.get(new String[]{"file-store", "FILE_STORE"});
        }
        if (cache.hasDefined("string-keyed-jdbc-store")) {
            return cache.get(new String[]{"string-keyed-jdbc-store", "STRING_KEYED_JDBC_STORE"});
        }
        if (cache.hasDefined("binary-keyed-jdbc-store")) {
            return cache.get(new String[]{"binary-keyed-jdbc-store", "BINARY_KEYED_JDBC_STORE"});
        }
        if (cache.hasDefined("mixed-keyed-jdbc-store")) {
            return cache.get(new String[]{"mixed-keyed-jdbc-store", "MIXED_KEYED_JDBC_STORE"});
        }
        if (cache.hasDefined("remote-store")) {
            return cache.get(new String[]{"remote-store", "REMOTE_STORE"});
        }
        return null;
    }

    private void buildCacheStore(OperationContext context, LoaderConfigurationBuilder builder, String containerName, ModelNode store, String storeKey, List<Dependency<?>> dependencies) throws OperationFailedException {
        TypedProperties properties = new TypedProperties();
        if (store.hasDefined("property")) {
            for (Property property : store.get("property").asPropertyList()) {
                String propertyName = property.getName();
                Property complexValue = property.getValue().asProperty();
                String propertyValue = complexValue.getValue().asString();
                properties.setProperty(propertyName, propertyValue);
            }
        }
        builder.withProperties((Properties)properties);
        ModelNode resolvedValue = null;
        if (storeKey.equals("file-store")) {
            builder.cacheLoader((CacheLoader)new FileCacheStore());
            resolvedValue = CommonAttributes.PATH.resolveModelAttribute(context, store);
            String path = resolvedValue.isDefined() ? resolvedValue.asString() : "infinispan" + File.separatorChar + containerName;
            resolvedValue = CommonAttributes.RELATIVE_TO.resolveModelAttribute(context, store);
            final String relativeTo = resolvedValue.isDefined() ? resolvedValue.asString() : "jboss.server.data.dir";
            SimpleInjector<PathManager> injector = new SimpleInjector<PathManager>((Properties)properties, path){
                volatile PathManager.Callback.Handle callbackHandle;
                final /* synthetic */ Properties val$properties;
                final /* synthetic */ String val$path;
                {
                    this.val$properties = properties;
                    this.val$path = string2;
                }

                public void inject(PathManager value) {
                    this.callbackHandle = value.registerCallback(relativeTo, PathManager.ReloadServerCallback.create(), new PathManager.Event[]{PathManager.Event.UPDATED, PathManager.Event.REMOVED});
                    this.val$properties.setProperty("location", value.resolveRelativePathEntry(this.val$path, relativeTo));
                }

                @Override
                public void uninject() {
                    super.uninject();
                    if (this.callbackHandle != null) {
                        this.callbackHandle.remove();
                    }
                }
            };
            dependencies.add(new Dependency<PathManager>(PathManagerService.SERVICE_NAME, PathManager.class, injector));
            properties.setProperty("fsyncMode", "perWrite");
        } else if (storeKey.equals("string-keyed-jdbc-store") || storeKey.equals("binary-keyed-jdbc-store") || storeKey.equals("mixed-keyed-jdbc-store")) {
            builder.cacheLoader((CacheLoader)this.createJDBCStore((Properties)properties, context, store));
            String datasource = CommonAttributes.DATA_SOURCE.resolveModelAttribute(context, store).asString();
            dependencies.add(new Dependency(ServiceName.JBOSS.append(new String[]{"data-source", datasource})));
            properties.setProperty("datasourceJndiLocation", datasource);
            properties.setProperty("connectionFactoryClass", ManagedConnectionFactory.class.getName());
        } else if (storeKey.equals("remote-store")) {
            builder.cacheLoader((CacheLoader)new RemoteCacheStore());
            for (ModelNode server : store.require("remote-servers").asList()) {
                String outboundSocketBinding = server.get("outbound-socket-binding").asString();
                SimpleInjector<OutboundSocketBinding> injector = new SimpleInjector<OutboundSocketBinding>((Properties)properties){
                    final /* synthetic */ Properties val$properties;
                    {
                        this.val$properties = properties;
                    }

                    public void inject(OutboundSocketBinding value) {
                        try {
                            String address = value.getDestinationAddress().getHostAddress() + ":" + value.getDestinationPort();
                            String serverList = this.val$properties.getProperty("serverList");
                            this.val$properties.setProperty("serverList", serverList == null ? address : serverList + ";" + address);
                        }
                        catch (UnknownHostException e) {
                            throw InfinispanMessages.MESSAGES.failedToInjectSocketBinding(e, value);
                        }
                    }
                };
                dependencies.add(new Dependency<OutboundSocketBinding>(OutboundSocketBinding.OUTBOUND_SOCKET_BINDING_BASE_SERVICE_NAME.append(new String[]{outboundSocketBinding}), OutboundSocketBinding.class, injector));
            }
            if (store.hasDefined("cache")) {
                properties.setProperty("remoteCacheName", store.get("cache").asString());
                properties.setProperty("useDefaultRemoteCache", Boolean.toString(false));
            } else {
                properties.setProperty("useDefaultRemoteCache", Boolean.toString(true));
            }
            if (store.hasDefined("socket-timeout")) {
                properties.setProperty("soTimeout", store.require("socket-timeout").asString());
            }
            if (store.hasDefined("tcp-no-delay")) {
                properties.setProperty("tcpNoDelay", store.require("tcp-no-delay").asString());
            }
        } else {
            String className = store.require("class").asString();
            try {
                CacheLoader loader = CacheLoader.class.getClassLoader().loadClass(className).asSubclass(CacheLoader.class).newInstance();
                builder.cacheLoader(loader);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(String.format("%s is not a valid cache store", className), e);
            }
        }
    }

    private CacheStore createJDBCStore(Properties properties, OperationContext context, ModelNode store) throws OperationFailedException {
        boolean useStringKeyedTable = store.hasDefined("string-keyed-table");
        boolean useBinaryKeyedTable = store.hasDefined("binary-keyed-table");
        if (useStringKeyedTable && !useBinaryKeyedTable) {
            this.setStringKeyedTableProperties(properties, context, store.get("string-keyed-table"), "", "stringsTableNamePrefix");
            return new JdbcStringBasedCacheStore();
        }
        if (useBinaryKeyedTable && !useStringKeyedTable) {
            this.setBinaryKeyedTableProperties(properties, context, store.get("binary-keyed-table"), "", "bucketTableNamePrefix");
            return new JdbcBinaryCacheStore();
        }
        this.setStringKeyedTableProperties(properties, context, store.get("string-keyed-table"), "ForStrings", "tableNamePrefixForStrings");
        this.setBinaryKeyedTableProperties(properties, context, store.get("binary-keyed-table"), "ForBinary", "tableNamePrefixForBinary");
        return new JdbcMixedCacheStore();
    }

    private void setBinaryKeyedTableProperties(Properties properties, OperationContext context, ModelNode table, String propertySuffix, String tableNamePrefixProperty) throws OperationFailedException {
        this.setTableProperties(properties, context, table, propertySuffix, tableNamePrefixProperty, "ispn_bucket");
    }

    private void setStringKeyedTableProperties(Properties properties, OperationContext context, ModelNode table, String propertySuffix, String tableNamePrefixProperty) throws OperationFailedException {
        this.setTableProperties(properties, context, table, propertySuffix, tableNamePrefixProperty, "ispn_entry");
    }

    private void setTableProperties(Properties properties, OperationContext context, ModelNode table, String propertySuffix, String tableNamePrefixProperty, String defaultTableNamePrefix) throws OperationFailedException {
        int batchSize = CommonAttributes.BATCH_SIZE.resolveModelAttribute(context, table).asInt();
        int fetchSize = CommonAttributes.FETCH_SIZE.resolveModelAttribute(context, table).asInt();
        ModelNode resolvedValue = null;
        resolvedValue = CommonAttributes.PREFIX.resolveModelAttribute(context, table);
        String prefixString = resolvedValue.isDefined() ? resolvedValue.asString() : defaultTableNamePrefix;
        properties.setProperty("batchSize", Integer.toString(batchSize));
        properties.setProperty("fetchSize", Integer.toString(fetchSize));
        properties.setProperty(tableNamePrefixProperty, prefixString);
        properties.setProperty("idColumnName" + propertySuffix, this.getColumnProperty(table, "id-column", "name", "id"));
        properties.setProperty("idColumnType" + propertySuffix, this.getColumnProperty(table, "id-column", "type", "VARCHAR"));
        properties.setProperty("dataColumnName" + propertySuffix, this.getColumnProperty(table, "data-column", "name", "datum"));
        properties.setProperty("dataColumnType" + propertySuffix, this.getColumnProperty(table, "data-column", "type", "BINARY"));
        properties.setProperty("timestampColumnName" + propertySuffix, this.getColumnProperty(table, "timestamp-column", "name", "version"));
        properties.setProperty("timestampColumnType" + propertySuffix, this.getColumnProperty(table, "timestamp-column", "type", "BIGINT"));
    }

    private String getColumnProperty(ModelNode table, String columnKey, String key, String defaultValue) {
        if (!table.isDefined() || !table.hasDefined(columnKey)) {
            return defaultValue;
        }
        ModelNode column = table.get(columnKey);
        return column.hasDefined(key) ? column.get(key).asString() : defaultValue;
    }

    private static class CacheConfigurationDependencies
    implements CacheConfigurationService.Dependencies {
        private final Value<EmbeddedCacheManager> container;
        private final InjectedValue<TransactionManager> tm = new InjectedValue();
        private final InjectedValue<TransactionSynchronizationRegistry> tsr = new InjectedValue();
        private final InjectedValue<ModuleLoader> moduleLoader = new InjectedValue();

        CacheConfigurationDependencies(Value<EmbeddedCacheManager> container) {
            this.container = container;
        }

        Injector<TransactionManager> getTransactionManagerInjector() {
            return this.tm;
        }

        Injector<TransactionSynchronizationRegistry> getTransactionSynchronizationRegistryInjector() {
            return this.tsr;
        }

        Injector<ModuleLoader> getModuleLoaderInjector() {
            return this.moduleLoader;
        }

        @Override
        public EmbeddedCacheManager getCacheContainer() {
            return (EmbeddedCacheManager)this.container.getValue();
        }

        @Override
        public TransactionManager getTransactionManager() {
            return (TransactionManager)this.tm.getOptionalValue();
        }

        @Override
        public TransactionSynchronizationRegistry getTransactionSynchronizationRegistry() {
            return (TransactionSynchronizationRegistry)this.tsr.getOptionalValue();
        }

        @Override
        public ModuleLoader getModuleLoader() {
            return (ModuleLoader)this.moduleLoader.getValue();
        }
    }

    private static class CacheDependencies
    implements CacheService.Dependencies {
        private final Value<EmbeddedCacheManager> container;
        private final InjectedValue<XAResourceRecoveryRegistry> recoveryRegistry = new InjectedValue();

        CacheDependencies(Value<EmbeddedCacheManager> container) {
            this.container = container;
        }

        Injector<XAResourceRecoveryRegistry> getRecoveryRegistryInjector() {
            return this.recoveryRegistry;
        }

        @Override
        public EmbeddedCacheManager getCacheContainer() {
            return (EmbeddedCacheManager)this.container.getValue();
        }

        @Override
        public XAResourceRecoveryRegistry getRecoveryRegistry() {
            return (XAResourceRecoveryRegistry)this.recoveryRegistry.getOptionalValue();
        }
    }

    private abstract class SimpleInjector<I>
    implements Injector<I> {
        private SimpleInjector() {
        }

        public void uninject() {
        }
    }

    protected class Dependency<I> {
        private final ServiceName name;
        private final Class<I> type;
        private final Injector<I> target;

        Dependency(ServiceName name) {
            this(name, null, null);
        }

        Dependency(ServiceName name, Class<I> type, Injector<I> target) {
            this.name = name;
            this.type = type;
            this.target = target;
        }

        ServiceName getName() {
            return this.name;
        }

        public Class<I> getType() {
            return this.type;
        }

        public Injector<I> getInjector() {
            return this.target;
        }
    }
}

