/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cmp.jdbc.metadata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.as.cmp.CmpMessages;
import org.jboss.as.cmp.jdbc.metadata.JDBCEntityCommandMetaData;
import org.jboss.as.cmp.jdbc.metadata.JDBCEntityMetaData;
import org.jboss.as.cmp.jdbc.metadata.JDBCRelationMetaData;
import org.jboss.as.cmp.jdbc.metadata.JDBCRelationshipRoleMetaData;
import org.jboss.as.cmp.jdbc.metadata.JDBCTypeMappingMetaData;
import org.jboss.as.cmp.jdbc.metadata.JDBCUserTypeMappingMetaData;
import org.jboss.as.cmp.jdbc.metadata.JDBCValueClassMetaData;
import org.jboss.as.cmp.jdbc.metadata.parser.ParsedApplication;
import org.jboss.as.cmp.jdbc.metadata.parser.ParsedEntity;
import org.jboss.as.cmp.jdbc.metadata.parser.ParsedRelationship;
import org.jboss.metadata.ejb.spec.EjbJarMetaData;
import org.jboss.metadata.ejb.spec.EnterpriseBeanMetaData;
import org.jboss.metadata.ejb.spec.EntityBeanMetaData;
import org.jboss.metadata.ejb.spec.RelationMetaData;

public final class JDBCApplicationMetaData {
    private final ClassLoader classLoader;
    private final Map<String, JDBCUserTypeMappingMetaData> userTypeMappings = new HashMap<String, JDBCUserTypeMappingMetaData>();
    private final Map<String, JDBCTypeMappingMetaData> typeMappings = new HashMap<String, JDBCTypeMappingMetaData>();
    private final Map<String, JDBCEntityMetaData> entities = new HashMap<String, JDBCEntityMetaData>();
    private final Map<String, JDBCRelationMetaData> relationships = new HashMap<String, JDBCRelationMetaData>();
    private final Map<String, Set<JDBCRelationshipRoleMetaData>> entityRoles = new HashMap<String, Set<JDBCRelationshipRoleMetaData>>();
    private final Map<Class<?>, JDBCValueClassMetaData> valueClasses = new HashMap();
    private final Map<String, JDBCEntityMetaData> entitiesByAbstractSchemaName = new HashMap<String, JDBCEntityMetaData>();
    private final Map<Class<?>, JDBCEntityMetaData> entitiesByInterface = new HashMap();
    private final Map<String, JDBCEntityCommandMetaData> entityCommands = new HashMap<String, JDBCEntityCommandMetaData>();
    private JDBCEntityMetaData defaultEntity;

    public JDBCApplicationMetaData(EjbJarMetaData ejbJarMetaData, ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.defaultEntity = new JDBCEntityMetaData(this);
        for (EnterpriseBeanMetaData bean : ejbJarMetaData.getEnterpriseBeans()) {
            Class<?> local;
            Class<?> remote;
            EntityBeanMetaData entity;
            if (!bean.isEntity() || !(entity = (EntityBeanMetaData)EntityBeanMetaData.class.cast(bean)).isCMP()) continue;
            JDBCEntityMetaData jdbcEntity = new JDBCEntityMetaData(this, entity);
            this.entities.put(entity.getEjbName(), jdbcEntity);
            String schemaName = jdbcEntity.getAbstractSchemaName();
            if (schemaName != null) {
                this.entitiesByAbstractSchemaName.put(schemaName, jdbcEntity);
            }
            if ((remote = jdbcEntity.getRemoteClass()) != null) {
                this.entitiesByInterface.put(remote, jdbcEntity);
            }
            if ((local = jdbcEntity.getLocalClass()) != null) {
                this.entitiesByInterface.put(local, jdbcEntity);
            }
            this.entityRoles.put(entity.getEjbName(), new HashSet());
        }
        if (ejbJarMetaData.getRelationships() != null) {
            for (RelationMetaData relationMetaData : ejbJarMetaData.getRelationships()) {
                JDBCRelationMetaData jdbcRelation = new JDBCRelationMetaData(this, relationMetaData);
                this.relationships.put(jdbcRelation.getRelationName(), jdbcRelation);
                JDBCRelationshipRoleMetaData left = jdbcRelation.getLeftRelationshipRole();
                Set<JDBCRelationshipRoleMetaData> leftEntityRoles = this.entityRoles.get(left.getEntity().getName());
                leftEntityRoles.add(left);
                JDBCRelationshipRoleMetaData right = jdbcRelation.getRightRelationshipRole();
                Set<JDBCRelationshipRoleMetaData> rightEntityRoles = this.entityRoles.get(right.getEntity().getName());
                rightEntityRoles.add(right);
            }
        }
    }

    public JDBCApplicationMetaData(ParsedApplication parsed, JDBCApplicationMetaData defaultValues) {
        this.classLoader = defaultValues.classLoader;
        this.defaultEntity = parsed.getDefaultEntity() != null ? new JDBCEntityMetaData(this, parsed.getDefaultEntity(), defaultValues.getDefaultEntity()) : new JDBCEntityMetaData(this, defaultValues.getDefaultEntity());
        if (parsed.getUserTypeMappings() != null) {
            for (JDBCUserTypeMappingMetaData userTypeMapping : parsed.getUserTypeMappings()) {
                this.userTypeMappings.put(userTypeMapping.getJavaType(), userTypeMapping);
            }
        } else {
            this.userTypeMappings.putAll(defaultValues.userTypeMappings);
        }
        this.typeMappings.putAll(defaultValues.typeMappings);
        if (parsed.getTypeMappings() != null) {
            for (JDBCTypeMappingMetaData typeMapping : parsed.getTypeMappings()) {
                this.typeMappings.put(typeMapping.getName(), typeMapping);
            }
        }
        this.valueClasses.putAll(defaultValues.valueClasses);
        if (parsed.getValueClasses() != null) {
            for (JDBCValueClassMetaData valueClass : parsed.getValueClasses()) {
                this.valueClasses.put(valueClass.getJavaType(), valueClass);
            }
        }
        this.entityCommands.putAll(defaultValues.entityCommands);
        if (parsed.getEntityCommands() != null) {
            for (JDBCEntityCommandMetaData entityCommand : parsed.getEntityCommands()) {
                this.entityCommands.put(entityCommand.getCommandName(), entityCommand);
            }
        }
        this.entities.putAll(defaultValues.entities);
        this.entitiesByAbstractSchemaName.putAll(defaultValues.entitiesByAbstractSchemaName);
        this.entitiesByInterface.putAll(defaultValues.entitiesByInterface);
        if (parsed.getDefaultEntity() != null) {
            ArrayList<JDBCEntityMetaData> values = new ArrayList<JDBCEntityMetaData>(this.entities.values());
            for (JDBCEntityMetaData entityMetaData : values) {
                Class<?> local;
                Class<?> remote;
                entityMetaData = new JDBCEntityMetaData(this, parsed.getDefaultEntity(), entityMetaData);
                this.entities.put(entityMetaData.getName(), entityMetaData);
                String schemaName = entityMetaData.getAbstractSchemaName();
                if (schemaName != null) {
                    this.entitiesByAbstractSchemaName.put(schemaName, entityMetaData);
                }
                if ((remote = entityMetaData.getRemoteClass()) != null) {
                    this.entitiesByInterface.put(remote, entityMetaData);
                }
                if ((local = entityMetaData.getLocalClass()) == null) continue;
                this.entitiesByInterface.put(local, entityMetaData);
            }
        }
        if (parsed.getEntities() != null) {
            for (ParsedEntity parsedEntity : parsed.getEntities()) {
                Class<?> local;
                Class<?> remote;
                String ejbName = parsedEntity.getEntityName();
                JDBCEntityMetaData entityMetaData = this.getBeanByEjbName(ejbName);
                if (entityMetaData == null) {
                    throw CmpMessages.MESSAGES.entityNotFoundInEjbJarXml(ejbName);
                }
                entityMetaData = new JDBCEntityMetaData(this, parsedEntity, entityMetaData);
                this.entities.put(entityMetaData.getName(), entityMetaData);
                String schemaName = entityMetaData.getAbstractSchemaName();
                if (schemaName != null) {
                    this.entitiesByAbstractSchemaName.put(schemaName, entityMetaData);
                }
                if ((remote = entityMetaData.getRemoteClass()) != null) {
                    this.entitiesByInterface.put(remote, entityMetaData);
                }
                if ((local = entityMetaData.getLocalClass()) == null) continue;
                this.entitiesByInterface.put(local, entityMetaData);
            }
        }
        if (parsed.getDefaultEntity() == null) {
            this.relationships.putAll(defaultValues.relationships);
            this.entityRoles.putAll(defaultValues.entityRoles);
        } else {
            for (JDBCEntityMetaData entity : this.entities.values()) {
                this.entityRoles.put(entity.getName(), new HashSet());
            }
            for (JDBCRelationMetaData relationMetaData : defaultValues.relationships.values()) {
                relationMetaData = new JDBCRelationMetaData(this, parsed.getDefaultEntity(), relationMetaData);
                this.relationships.put(relationMetaData.getRelationName(), relationMetaData);
                JDBCRelationshipRoleMetaData left = relationMetaData.getLeftRelationshipRole();
                Set<JDBCRelationshipRoleMetaData> leftEntityRoles = this.entityRoles.get(left.getEntity().getName());
                leftEntityRoles.add(left);
                JDBCRelationshipRoleMetaData right = relationMetaData.getRightRelationshipRole();
                Set<JDBCRelationshipRoleMetaData> rightEntityRoles = this.entityRoles.get(right.getEntity().getName());
                rightEntityRoles.add(right);
            }
        }
        if (parsed.getRelationships() != null) {
            for (ParsedRelationship parsedRelationship : parsed.getRelationships()) {
                String relationName = parsedRelationship.getRelationName();
                JDBCRelationMetaData oldRelation = this.relationships.get(relationName);
                if (oldRelation == null) {
                    throw CmpMessages.MESSAGES.relationNotFoundInEjbJarXml(relationName);
                }
                JDBCRelationMetaData newRelation = new JDBCRelationMetaData(this, parsedRelationship, oldRelation);
                this.relationships.put(newRelation.getRelationName(), newRelation);
                JDBCRelationshipRoleMetaData newLeft = newRelation.getLeftRelationshipRole();
                Set<JDBCRelationshipRoleMetaData> leftEntityRoles = this.entityRoles.get(newLeft.getEntity().getName());
                leftEntityRoles.remove(oldRelation.getLeftRelationshipRole());
                leftEntityRoles.add(newLeft);
                JDBCRelationshipRoleMetaData newRight = newRelation.getRightRelationshipRole();
                Set<JDBCRelationshipRoleMetaData> rightEntityRoles = this.entityRoles.get(newRight.getEntity().getName());
                rightEntityRoles.remove(oldRelation.getRightRelationshipRole());
                rightEntityRoles.add(newRight);
            }
        }
    }

    public JDBCTypeMappingMetaData getTypeMappingByName(String name) {
        return this.typeMappings.get(name);
    }

    public Collection<JDBCRelationshipRoleMetaData> getRolesForEntity(String entityName) {
        Collection roles = this.entityRoles.get(entityName);
        return Collections.unmodifiableCollection(roles);
    }

    public Collection<JDBCValueClassMetaData> getValueClasses() {
        return Collections.unmodifiableCollection(this.valueClasses.values());
    }

    public JDBCEntityMetaData getBeanByEjbName(String name) {
        return this.entities.get(name);
    }

    public JDBCEntityCommandMetaData getEntityCommandByName(String name) {
        return this.entityCommands.get(name);
    }

    public Map<String, JDBCUserTypeMappingMetaData> getUserTypeMappings() {
        return Collections.unmodifiableMap(this.userTypeMappings);
    }

    public void addTypeMapping(JDBCTypeMappingMetaData metaData) {
        this.typeMappings.put(metaData.getName(), metaData);
    }

    public void addEntityCommand(JDBCEntityCommandMetaData entityCommand) {
        this.entityCommands.put(entityCommand.getCommandName(), entityCommand);
    }

    public void addRelationship(JDBCRelationMetaData relationMetaData) {
        Set<JDBCRelationshipRoleMetaData> rightRoles;
        JDBCRelationMetaData oldRelation = this.relationships.put(relationMetaData.getRelationName(), relationMetaData);
        Set<JDBCRelationshipRoleMetaData> leftRoles = this.entityRoles.get(relationMetaData.getLeftRelationshipRole().getRelationshipRoleName());
        if (leftRoles == null) {
            leftRoles = new HashSet<JDBCRelationshipRoleMetaData>();
            this.entityRoles.put(relationMetaData.getLeftRelationshipRole().getRelationshipRoleName(), leftRoles);
        }
        if ((rightRoles = this.entityRoles.get(relationMetaData.getRightRelationshipRole().getRelationshipRoleName())) == null) {
            rightRoles = new HashSet<JDBCRelationshipRoleMetaData>();
            this.entityRoles.put(relationMetaData.getRightRelationshipRole().getRelationshipRoleName(), rightRoles);
        }
        if (oldRelation != null) {
            leftRoles.remove(oldRelation.getLeftRelationshipRole());
            rightRoles.remove(oldRelation.getRightRelationshipRole());
        }
        leftRoles.add(relationMetaData.getLeftRelationshipRole());
        rightRoles.add(relationMetaData.getRightRelationshipRole());
    }

    public void addEntity(JDBCEntityMetaData entityMetaData) {
        this.entities.put(entityMetaData.getName(), entityMetaData);
        if (entityMetaData.getRemoteClass() != null) {
            this.entitiesByInterface.put(entityMetaData.getRemoteClass(), entityMetaData);
        }
        if (entityMetaData.getLocalClass() != null) {
            this.entitiesByInterface.put(entityMetaData.getLocalClass(), entityMetaData);
        }
    }

    public void addValueClass(JDBCValueClassMetaData jdbcValueClassMetaData) {
        this.valueClasses.put(jdbcValueClassMetaData.getJavaType(), jdbcValueClassMetaData);
    }

    public void addUserTypeMapping(JDBCUserTypeMappingMetaData jdbcUserTypeMappingMetaData) {
        this.userTypeMappings.put(jdbcUserTypeMappingMetaData.getJavaType(), jdbcUserTypeMappingMetaData);
    }

    public void addTypeMappings(Collection<JDBCTypeMappingMetaData> jdbcTypeMappingMetaDatas) {
        for (JDBCTypeMappingMetaData typeMappingMetaData : jdbcTypeMappingMetaDatas) {
            this.addTypeMapping(typeMappingMetaData);
        }
    }

    public Collection<JDBCTypeMappingMetaData> getTypeMappings() {
        return this.typeMappings.values();
    }

    public void addUserTypeMappings(List<JDBCUserTypeMappingMetaData> userTypeMappings) {
        for (JDBCUserTypeMappingMetaData userTypeMappingMetaData : userTypeMappings) {
            this.addUserTypeMapping(userTypeMappingMetaData);
        }
    }

    public void setUserTypeMappings(Map<String, JDBCUserTypeMappingMetaData> userTypeMappings) {
        this.userTypeMappings.putAll(userTypeMappings);
    }

    public void addValueClasses(Collection<JDBCValueClassMetaData> valueClasses) {
        for (JDBCValueClassMetaData valueClass : valueClasses) {
            this.addValueClass(valueClass);
        }
    }

    public Map<String, JDBCEntityCommandMetaData> getEntityCommands() {
        return Collections.unmodifiableMap(this.entityCommands);
    }

    public void addEntityCommands(Map<String, JDBCEntityCommandMetaData> commands) {
        this.entityCommands.putAll(commands);
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public Collection<JDBCEntityMetaData> getBeans() {
        return this.entities.values();
    }

    public JDBCRelationMetaData getRelationship(String relationName) {
        return this.relationships.get(relationName);
    }

    public JDBCEntityMetaData getDefaultEntity() {
        return this.defaultEntity;
    }

    public void setDefaultEntity(JDBCEntityMetaData defaultEntity) {
        this.defaultEntity = defaultEntity;
    }
}

