/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.repository;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.jboss.osgi.metadata.OSGiMetaData;
import org.jboss.osgi.metadata.OSGiMetaDataBuilder;
import org.jboss.osgi.repository.URLBasedResource;
import org.jboss.osgi.resolver.XIdentityCapability;
import org.jboss.osgi.resolver.XResource;
import org.jboss.osgi.resolver.XResourceBuilder;
import org.jboss.osgi.resolver.XResourceBuilderFactory;
import org.jboss.osgi.resolver.spi.AbstractResource;
import org.jboss.osgi.resolver.spi.AbstractResourceBuilder;
import org.osgi.framework.Version;

public final class URLBasedResourceBuilder {
    public static XResource createResource(URL baseURL, String contentPath) {
        final URLBasedResource urlres = new URLBasedResource(baseURL, contentPath);
        XResourceBuilderFactory factory = new XResourceBuilderFactory(){

            public AbstractResourceBuilder createResourceBuilder() {
                AbstractResourceBuilder builder = new AbstractResourceBuilder(this){

                    public XIdentityCapability addIdentityCapability(String symbolicName, Version version, String type, Map<String, Object> atts, Map<String, String> dirs) {
                        atts.put("content.url", urlres.getContentURL());
                        atts.put("content.path", urlres.getContentPath());
                        return super.addIdentityCapability(symbolicName, version, type, atts, dirs);
                    }
                };
                return builder;
            }

            public AbstractResource createResource() {
                return urlres;
            }
        };
        XResourceBuilder builder = XResourceBuilderFactory.create((XResourceBuilderFactory)factory);
        InputStream content = urlres.getContent();
        try {
            Manifest manifest = new JarInputStream(content).getManifest();
            OSGiMetaData metaData = OSGiMetaDataBuilder.load((Manifest)manifest);
            builder.loadFrom(metaData);
        }
        catch (Exception ex) {
            URL contentURL = urlres.getContentURL();
            throw new IllegalStateException("Cannot create capability from: " + contentURL, ex);
        }
        finally {
            if (content != null) {
                try {
                    content.close();
                }
                catch (IOException e) {}
            }
        }
        XResource resource = builder.getResource();
        return resource;
    }
}

