/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.resolver.impl;

import java.util.Map;
import org.apache.felix.resolver.FelixResolveContext;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;

public class HostedRequirement
implements Requirement {
    private final FelixResolveContext m_env;
    private final Resource m_host;
    private final Requirement m_req;

    public HostedRequirement(FelixResolveContext env, Resource host, Requirement req) {
        this.m_env = env;
        this.m_host = host;
        this.m_req = req;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HostedRequirement other = (HostedRequirement)obj;
        if (!(this.m_host == other.m_host || this.m_host != null && this.m_host.equals(other.m_host))) {
            return false;
        }
        return this.m_req == other.m_req || this.m_req != null && this.m_req.equals(other.m_req);
    }

    public int hashCode() {
        int hash = 7;
        hash = 37 * hash + (this.m_host != null ? this.m_host.hashCode() : 0);
        hash = 37 * hash + (this.m_req != null ? this.m_req.hashCode() : 0);
        return hash;
    }

    public Requirement getOriginalRequirement() {
        return this.m_req;
    }

    public Resource getResource() {
        return this.m_host;
    }

    public String getNamespace() {
        return this.m_req.getNamespace();
    }

    public Map<String, String> getDirectives() {
        return this.m_req.getDirectives();
    }

    public Map<String, Object> getAttributes() {
        return this.m_req.getAttributes();
    }

    public boolean matches(Capability capability) {
        return this.m_env.matches(this.m_req, capability);
    }

    public String toString() {
        return "[" + this.m_host + "] " + this.getNamespace() + "; " + this.getDirectives().get("filter");
    }
}

