/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.resolver.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.felix.resolver.FelixCapability;
import org.apache.felix.resolver.FelixResolveContext;
import org.apache.felix.resolver.FelixResolver;
import org.apache.felix.resolver.Logger;
import org.apache.felix.resolver.impl.Candidates;
import org.apache.felix.resolver.impl.HostResource;
import org.apache.felix.resolver.impl.HostedCapability;
import org.apache.felix.resolver.impl.HostedRequirement;
import org.apache.felix.resolver.impl.Util;
import org.apache.felix.resolver.impl.WireImpl;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.resource.Wire;
import org.osgi.resource.Wiring;
import org.osgi.service.resolver.ResolutionException;

public class ResolverImpl
implements FelixResolver {
    private final Logger m_logger;
    private final List<Candidates> m_usesPermutations = new ArrayList<Candidates>();
    private final List<Candidates> m_importPermutations = new ArrayList<Candidates>();
    private Map<Capability, List<Capability>> m_packageSourcesCache = new HashMap<Capability, List<Capability>>();

    public ResolverImpl(Logger logger) {
        this.m_logger = logger != null ? logger : new Logger(){

            @Override
            public boolean isEnabled(int level) {
                return false;
            }

            @Override
            public void log(int level, String msg) {
            }

            @Override
            public void log(int level, String msg, Throwable throwable) {
            }
        };
    }

    @Override
    public Map<Resource, List<Wire>> resolve(FelixResolveContext env) throws ResolutionException {
        Collection mandatory = env.getMandatoryResources();
        Collection optional = env.getOptionalResources();
        return this.resolve(env, mandatory, optional, Collections.EMPTY_SET);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public Map<Resource, List<Wire>> resolve(FelixResolveContext env, Collection<? extends Resource> mandatoryRevisions, Collection<? extends Resource> optionalRevisions, Collection<? extends Resource> ondemandFragments) throws ResolutionException {
        boolean retry;
        Map<Resource, List<Wire>> wireMap = new HashMap<Resource, List<Wire>>();
        HashMap<Resource, Packages> revisionPkgMap = new HashMap<Resource, Packages>();
        if (mandatoryRevisions == null) {
            mandatoryRevisions = Collections.emptySet();
        }
        if (optionalRevisions == null) {
            optionalRevisions = Collections.emptySet();
        }
        if (ondemandFragments == null) {
            ondemandFragments = Collections.emptySet();
        }
        mandatoryRevisions = new ArrayList<Resource>(mandatoryRevisions);
        do {
            retry = false;
            try {
                List hostReq;
                Resource target;
                Iterator i$;
                void var10_10;
                Candidates allCandidates = new Candidates(this.m_logger);
                Iterator<? extends Resource> it = mandatoryRevisions.iterator();
                while (it.hasNext()) {
                    Resource resource = it.next();
                    if (Util.isFragment(resource) || !env.getWirings().containsKey(resource)) {
                        allCandidates.populate(env, resource, 0);
                        continue;
                    }
                    it.remove();
                }
                if (optionalRevisions != null) {
                    for (Resource resource : optionalRevisions) {
                        boolean bl = Util.isFragment(resource);
                        if (!bl && env.getWirings().containsKey(resource)) continue;
                        allCandidates.populate(env, resource, 1);
                    }
                }
                for (Resource resource : ondemandFragments) {
                    boolean bl = Util.isFragment(resource);
                    if (!bl) continue;
                    allCandidates.populate(env, resource, 2);
                }
                allCandidates.prepare(env);
                HashSet<? extends Resource> allRevisions = new HashSet<Resource>(mandatoryRevisions);
                for (Resource resource : optionalRevisions) {
                    if (!allCandidates.isPopulated(resource)) continue;
                    allRevisions.add((Resource)resource);
                }
                this.m_usesPermutations.add(allCandidates);
                Object var10_18 = null;
                HashMap<Resource, List> hashMap = new HashMap<Resource, List>();
                for (Resource resource : allRevisions) {
                    if (!Util.isFragment(resource)) continue;
                    hashMap.put(resource, resource.getRequirements("osgi.wiring.host"));
                }
                do {
                    Object var10_20 = null;
                    revisionPkgMap.clear();
                    this.m_packageSourcesCache.clear();
                    allCandidates = this.m_usesPermutations.size() > 0 ? this.m_usesPermutations.remove(0) : this.m_importPermutations.remove(0);
                    i$ = allRevisions.iterator();
                    while (i$.hasNext()) {
                        Resource resource;
                        target = resource = (Resource)i$.next();
                        hostReq = (List)hashMap.get(resource);
                        if (hostReq != null) {
                            target = allCandidates.getCandidates((Requirement)hostReq.get(0)).iterator().next().getResource();
                        }
                        this.calculatePackageSpaces(env, allCandidates.getWrappedHost(target), allCandidates, revisionPkgMap, new HashMap<Capability, List<Resource>>(), new HashSet<Resource>());
                        if (this.m_logger.isEnabled(5)) {
                            this.dumpRevisionPkgMap(env, revisionPkgMap);
                        }
                        try {
                            this.checkPackageSpaceConsistency(env, false, allCandidates.getWrappedHost(target), allCandidates, revisionPkgMap, new HashMap<Resource, Object>());
                        }
                        catch (ResolutionException ex) {
                            ResolutionException resolutionException = ex;
                        }
                    }
                } while (var10_10 != null && (this.m_usesPermutations.size() > 0 || this.m_importPermutations.size() > 0));
                if (var10_10 != null) {
                    Resource faultyRevision;
                    Collection exReqs = var10_10.getUnresolvedRequirements();
                    Requirement requirement = exReqs == null || exReqs.isEmpty() ? null : (Requirement)exReqs.iterator().next();
                    Resource resource = faultyRevision = requirement == null ? null : ResolverImpl.getActualResource(requirement.getResource());
                    if (requirement instanceof HostedRequirement) {
                        faultyRevision = ((HostedRequirement)requirement).getOriginalRequirement().getResource();
                    }
                    if (optionalRevisions.remove(faultyRevision)) {
                        retry = true;
                        continue;
                    }
                    if (ondemandFragments.remove(faultyRevision)) {
                        retry = true;
                        continue;
                    }
                    throw var10_10;
                }
                i$ = allRevisions.iterator();
                while (i$.hasNext()) {
                    Resource resource;
                    target = resource = (Resource)i$.next();
                    hostReq = (List)hashMap.get(resource);
                    if (hostReq != null) {
                        target = allCandidates.getCandidates((Requirement)hostReq.get(0)).iterator().next().getResource();
                    }
                    if (!allCandidates.isPopulated(target)) continue;
                    wireMap = ResolverImpl.populateWireMap(env, allCandidates.getWrappedHost(target), revisionPkgMap, wireMap, allCandidates);
                }
            }
            finally {
                this.m_usesPermutations.clear();
                this.m_importPermutations.clear();
            }
        } while (retry);
        return wireMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Resource, List<Wire>> resolve(FelixResolveContext env, Resource resource, Requirement req, List<Capability> candidates, Collection<? extends Resource> ondemandFragments) throws ResolutionException {
        if (env.getWirings().containsKey(resource) && !candidates.isEmpty()) {
            boolean retry;
            Candidates allCandidates = new Candidates(this.m_logger);
            allCandidates.populateDynamic(env, resource, req, candidates);
            Map<Resource, List<Wire>> wireMap = new HashMap<Resource, List<Wire>>();
            HashMap<Resource, Packages> resourcePkgMap = new HashMap<Resource, Packages>();
            do {
                retry = false;
                try {
                    for (Resource resource2 : ondemandFragments) {
                        if (!Util.isFragment(resource2)) continue;
                        allCandidates.populate(env, resource2, 2);
                    }
                    allCandidates.prepare(env);
                    this.m_usesPermutations.add(allCandidates);
                    ResolutionException rethrow = null;
                    do {
                        rethrow = null;
                        resourcePkgMap.clear();
                        this.m_packageSourcesCache.clear();
                        Candidates candidates2 = allCandidates = this.m_usesPermutations.size() > 0 ? this.m_usesPermutations.remove(0) : this.m_importPermutations.remove(0);
                        if (this.m_logger.isEnabled(5)) {
                            allCandidates.dump(env);
                        }
                        this.calculatePackageSpaces(env, resource, allCandidates, resourcePkgMap, new HashMap<Capability, List<Resource>>(), new HashSet<Resource>());
                        if (this.m_logger.isEnabled(5)) {
                            this.dumpRevisionPkgMap(env, resourcePkgMap);
                        }
                        try {
                            this.checkPackageSpaceConsistency(env, false, resource, allCandidates, resourcePkgMap, new HashMap<Resource, Object>());
                        }
                        catch (ResolutionException resolutionException) {
                            rethrow = resolutionException;
                        }
                    } while (rethrow != null && (this.m_usesPermutations.size() > 0 || this.m_importPermutations.size() > 0));
                    if (rethrow != null) {
                        Collection map = rethrow.getUnresolvedRequirements();
                        Requirement faultyReq = map == null || map.isEmpty() ? null : (Requirement)map.iterator().next();
                        Resource faultyResource = null;
                        if (faultyReq instanceof HostedRequirement) {
                            faultyResource = ((HostedRequirement)faultyReq).getOriginalRequirement().getResource();
                        }
                        if (ondemandFragments.remove(faultyResource)) {
                            retry = true;
                            continue;
                        }
                        throw rethrow;
                    }
                    Map<Resource, List<Wire>> map = wireMap = ResolverImpl.populateDynamicWireMap(env, resource, req, resourcePkgMap, wireMap, allCandidates);
                    return map;
                }
                finally {
                    this.m_usesPermutations.clear();
                    this.m_importPermutations.clear();
                }
            } while (retry);
        }
        return null;
    }

    private void calculatePackageSpaces(FelixResolveContext env, Resource resource, Candidates allCandidates, Map<Resource, Packages> revisionPkgMap, Map<Capability, List<Resource>> usesCycleMap, Set<Resource> cycle) {
        Requirement req;
        int i;
        Capability cap;
        if (cycle.contains(resource)) {
            return;
        }
        cycle.add(resource);
        ArrayList<Requirement> reqs = new ArrayList<Requirement>();
        ArrayList<Capability> caps = new ArrayList<Capability>();
        boolean isDynamicImporting = false;
        Wiring wiring = (Wiring)env.getWirings().get(resource);
        if (wiring != null) {
            for (Wire wire : wiring.getRequiredResourceWires(null)) {
                Capability c;
                Requirement r = wire.getRequirement();
                if (!r.getResource().equals(wire.getRequirer()) || r.getDirectives().get("resolution") != null && ((String)r.getDirectives().get("resolution")).equals("dynamic")) {
                    r = new HostedRequirement(env, wire.getRequirer(), r);
                }
                if (!(c = wire.getCapability()).getResource().equals(wire.getProvider())) {
                    c = new HostedCapability(wire.getProvider(), c);
                }
                reqs.add(r);
                caps.add(c);
            }
            for (Requirement req2 : Util.getDynamicRequirements(wiring.getResourceRequirements(null))) {
                List<Capability> candCaps = allCandidates.getCandidates(req2);
                if (candCaps == null) continue;
                cap = candCaps.iterator().next();
                reqs.add(req2);
                caps.add(cap);
                isDynamicImporting = true;
                break;
            }
        } else {
            for (Requirement req2 : resource.getRequirements(null)) {
                List<Capability> candCaps;
                String resolution = (String)req2.getDirectives().get("resolution");
                if (resolution != null && resolution.equals("dynamic") || (candCaps = allCandidates.getCandidates(req2)) == null) continue;
                Capability cap2 = candCaps.iterator().next();
                reqs.add(req2);
                caps.add(cap2);
            }
        }
        ResolverImpl.calculateExportedPackages(env, resource, allCandidates, revisionPkgMap);
        Packages revisionPkgs = revisionPkgMap.get(resource);
        for (i = 0; i < reqs.size(); ++i) {
            req = (Requirement)reqs.get(i);
            cap = (Capability)caps.get(i);
            ResolverImpl.calculateExportedPackages(env, cap.getResource(), allCandidates, revisionPkgMap);
            this.mergeCandidatePackages(env, resource, req, cap, revisionPkgMap, allCandidates, new HashMap<Resource, List<Capability>>());
        }
        for (i = 0; i < caps.size(); ++i) {
            this.calculatePackageSpaces(env, ((Capability)caps.get(i)).getResource(), allCandidates, revisionPkgMap, usesCycleMap, cycle);
        }
        if (wiring == null || isDynamicImporting) {
            ArrayList<Requirement> blameReqs;
            for (i = 0; i < reqs.size(); ++i) {
                req = (Requirement)reqs.get(i);
                cap = (Capability)caps.get(i);
                if (req.getNamespace().equals("osgi.wiring.bundle") || req.getNamespace().equals("osgi.wiring.package")) continue;
                ArrayList<Requirement> blameReqs2 = new ArrayList<Requirement>();
                blameReqs2.add(req);
                this.mergeUses(env, resource, revisionPkgs, cap, blameReqs2, revisionPkgMap, allCandidates, usesCycleMap);
            }
            for (Map.Entry<String, List<Blame>> entry : revisionPkgs.m_importedPkgs.entrySet()) {
                for (Blame blame : entry.getValue()) {
                    if (blame.m_cap.getResource().equals(resource)) continue;
                    blameReqs = new ArrayList<Requirement>();
                    blameReqs.add(blame.m_reqs.get(0));
                    this.mergeUses(env, resource, revisionPkgs, blame.m_cap, blameReqs, revisionPkgMap, allCandidates, usesCycleMap);
                }
            }
            for (Map.Entry<String, List<Blame>> entry : revisionPkgs.m_requiredPkgs.entrySet()) {
                for (Blame blame : entry.getValue()) {
                    blameReqs = new ArrayList();
                    blameReqs.add(blame.m_reqs.get(0));
                    this.mergeUses(env, resource, revisionPkgs, blame.m_cap, blameReqs, revisionPkgMap, allCandidates, usesCycleMap);
                }
            }
        }
    }

    private void mergeCandidatePackages(FelixResolveContext env, Resource current, Requirement currentReq, Capability candCap, Map<Resource, Packages> revisionPkgMap, Candidates allCandidates, Map<Resource, List<Capability>> cycles) {
        List<Capability> cycleCaps = cycles.get(current);
        if (cycleCaps == null) {
            cycleCaps = new ArrayList<Capability>();
            cycles.put(current, cycleCaps);
        }
        if (cycleCaps.contains(candCap)) {
            return;
        }
        cycleCaps.add(candCap);
        if (candCap.getNamespace().equals("osgi.wiring.package")) {
            this.mergeCandidatePackage(current, false, currentReq, candCap, revisionPkgMap);
        } else if (candCap.getNamespace().equals("osgi.wiring.bundle")) {
            ResolverImpl.calculateExportedPackages(env, candCap.getResource(), allCandidates, revisionPkgMap);
            Packages candPkgs = revisionPkgMap.get(candCap.getResource());
            for (Map.Entry<String, Blame> entry : candPkgs.m_exportedPkgs.entrySet()) {
                this.mergeCandidatePackage(current, true, currentReq, entry.getValue().m_cap, revisionPkgMap);
            }
            Wiring candWiring = (Wiring)env.getWirings().get(candCap.getResource());
            if (candWiring != null) {
                for (Wire bw : candWiring.getRequiredResourceWires(null)) {
                    String value;
                    if (!bw.getRequirement().getNamespace().equals("osgi.wiring.bundle") || (value = (String)bw.getRequirement().getDirectives().get("visibility")) == null || !value.equals("reexport")) continue;
                    this.mergeCandidatePackages(env, current, currentReq, bw.getCapability(), revisionPkgMap, allCandidates, cycles);
                }
            } else {
                for (Requirement req : candCap.getResource().getRequirements(null)) {
                    String value;
                    if (!req.getNamespace().equals("osgi.wiring.bundle") || (value = (String)req.getDirectives().get("visibility")) == null || !value.equals("reexport") || allCandidates.getCandidates(req) == null) continue;
                    this.mergeCandidatePackages(env, current, currentReq, allCandidates.getCandidates(req).iterator().next(), revisionPkgMap, allCandidates, cycles);
                }
            }
        }
        cycles.remove(current);
    }

    private void mergeCandidatePackage(Resource current, boolean requires, Requirement currentReq, Capability candCap, Map<Resource, Packages> revisionPkgMap) {
        if (candCap.getNamespace().equals("osgi.wiring.package")) {
            String pkgName = (String)candCap.getAttributes().get("osgi.wiring.package");
            ArrayList<Requirement> blameReqs = new ArrayList<Requirement>();
            blameReqs.add(currentReq);
            Packages currentPkgs = revisionPkgMap.get(current);
            Map<String, List<Blame>> packages = requires ? currentPkgs.m_requiredPkgs : currentPkgs.m_importedPkgs;
            List<Blame> blames = packages.get(pkgName);
            if (blames == null) {
                blames = new ArrayList<Blame>();
                packages.put(pkgName, blames);
            }
            blames.add(new Blame(candCap, blameReqs));
        }
    }

    private void mergeUses(FelixResolveContext env, Resource current, Packages currentPkgs, Capability mergeCap, List<Requirement> blameReqs, Map<Resource, Packages> revisionPkgMap, Candidates allCandidates, Map<Capability, List<Resource>> cycleMap) {
        if (current.equals(mergeCap.getResource())) {
            return;
        }
        ArrayList<Resource> list = cycleMap.get(mergeCap);
        if (list != null && list.contains(current)) {
            return;
        }
        list = list == null ? new ArrayList<Resource>() : list;
        list.add(current);
        cycleMap.put(mergeCap, list);
        for (Capability candSourceCap : this.getPackageSources(env, mergeCap, revisionPkgMap)) {
            List<String> uses;
            if (candSourceCap instanceof FelixCapability) {
                uses = ((FelixCapability)candSourceCap).getUses();
            } else {
                uses = Collections.EMPTY_LIST;
                String s = (String)candSourceCap.getDirectives().get("uses");
                if (s != null) {
                    StringTokenizer tok = new StringTokenizer(s, ",");
                    uses = new ArrayList<String>(tok.countTokens());
                    while (tok.hasMoreTokens()) {
                        uses.add(tok.nextToken().trim());
                    }
                }
            }
            for (String usedPkgName : uses) {
                Packages candSourcePkgs = revisionPkgMap.get(candSourceCap.getResource());
                List<Blame> candSourceBlames = null;
                Blame candExportedBlame = candSourcePkgs.m_exportedPkgs.get(usedPkgName);
                List<Blame> candImportedBlame = candSourcePkgs.m_importedPkgs.get(usedPkgName);
                if (candExportedBlame != null && candImportedBlame == null) {
                    candSourceBlames = new ArrayList<Blame>(1);
                    candSourceBlames.add(candExportedBlame);
                } else {
                    candSourceBlames = candSourcePkgs.m_requiredPkgs.get(usedPkgName);
                    List<Blame> list2 = candSourceBlames = candSourceBlames != null ? candSourceBlames : candSourcePkgs.m_importedPkgs.get(usedPkgName);
                }
                if (candSourceBlames == null) continue;
                List<Blame> usedCaps = currentPkgs.m_usedPkgs.get(usedPkgName);
                if (usedCaps == null) {
                    usedCaps = new ArrayList<Blame>();
                    currentPkgs.m_usedPkgs.put(usedPkgName, usedCaps);
                }
                for (Blame blame : candSourceBlames) {
                    if (blame.m_reqs != null) {
                        ArrayList<Requirement> blameReqs2 = new ArrayList<Requirement>(blameReqs);
                        blameReqs2.add(blame.m_reqs.get(blame.m_reqs.size() - 1));
                        usedCaps.add(new Blame(blame.m_cap, blameReqs2));
                        this.mergeUses(env, current, currentPkgs, blame.m_cap, blameReqs2, revisionPkgMap, allCandidates, cycleMap);
                        continue;
                    }
                    usedCaps.add(new Blame(blame.m_cap, blameReqs));
                    this.mergeUses(env, current, currentPkgs, blame.m_cap, blameReqs, revisionPkgMap, allCandidates, cycleMap);
                }
            }
        }
    }

    private void checkPackageSpaceConsistency(FelixResolveContext env, boolean isDynamicImporting, Resource revision, Candidates allCandidates, Map<Resource, Packages> revisionPkgMap, Map<Resource, Object> resultCache) throws ResolutionException {
        if (env.getWirings().containsKey(revision) && !isDynamicImporting) {
            return;
        }
        if (resultCache.containsKey(revision)) {
            return;
        }
        Packages pkgs = revisionPkgMap.get(revision);
        ResolutionException rethrow = null;
        Candidates permutation = null;
        Set mutated = null;
        for (Map.Entry<String, List<Blame>> entry : pkgs.m_importedPkgs.entrySet()) {
            if (entry.getValue().size() <= 1) continue;
            Blame sourceBlame = null;
            for (Blame blame : entry.getValue()) {
                if (sourceBlame == null) {
                    sourceBlame = blame;
                    continue;
                }
                if (sourceBlame.m_cap.getResource().equals(blame.m_cap.getResource())) continue;
                ResolverImpl.permutate(allCandidates, blame.m_reqs.get(0), this.m_importPermutations);
                ResolverImpl.permutate(allCandidates, sourceBlame.m_reqs.get(0), this.m_importPermutations);
                ResolutionException ex = new ResolutionException("Uses constraint violation. Unable to resolve bundle revision " + Util.getSymbolicName(revision) + " [" + revision + "] because it is exposed to package '" + entry.getKey() + "' from bundle revisions " + Util.getSymbolicName(sourceBlame.m_cap.getResource()) + " [" + sourceBlame.m_cap.getResource() + "] and " + Util.getSymbolicName(blame.m_cap.getResource()) + " [" + blame.m_cap.getResource() + "] via two dependency chains.\n\nChain 1:\n" + ResolverImpl.toStringBlame(env, sourceBlame) + "\n\nChain 2:\n" + ResolverImpl.toStringBlame(env, blame), null, Collections.singleton(blame.m_reqs.get(0)));
                this.m_logger.log(4, "Candidate permutation failed due to a conflict with a fragment import; will try another if possible.", ex);
                throw ex;
            }
        }
        for (Map.Entry<String, Object> entry : pkgs.m_exportedPkgs.entrySet()) {
            String pkgName = entry.getKey();
            Blame exportBlame = (Blame)entry.getValue();
            if (!pkgs.m_usedPkgs.containsKey(pkgName)) continue;
            block5: for (Blame usedBlame : pkgs.m_usedPkgs.get(pkgName)) {
                Requirement req;
                if (this.isCompatible(env, exportBlame.m_cap, usedBlame.m_cap, revisionPkgMap)) continue;
                permutation = permutation != null ? permutation : allCandidates.copy();
                rethrow = rethrow != null ? rethrow : new ResolutionException("Uses constraint violation. Unable to resolve bundle revision " + Util.getSymbolicName(revision) + " [" + revision + "] because it exports package '" + pkgName + "' and is also exposed to it from bundle revision " + Util.getSymbolicName(usedBlame.m_cap.getResource()) + " [" + usedBlame.m_cap.getResource() + "] via the following dependency chain:\n\n" + ResolverImpl.toStringBlame(env, usedBlame), null, null);
                mutated = mutated != null ? mutated : new HashSet();
                for (int reqIdx = usedBlame.m_reqs.size() - 1; reqIdx >= 0 && !mutated.contains(req = usedBlame.m_reqs.get(reqIdx)); --reqIdx) {
                    List<Capability> candidates = permutation.getCandidates(req);
                    if (candidates == null || candidates.size() <= 1) continue;
                    mutated.add(req);
                    Iterator<Capability> it = candidates.iterator();
                    it.next();
                    it.remove();
                    continue block5;
                }
            }
            if (rethrow == null) continue;
            if (mutated.size() > 0) {
                this.m_usesPermutations.add(permutation);
            }
            this.m_logger.log(4, "Candidate permutation failed due to a conflict between an export and import; will try another if possible.", rethrow);
            throw rethrow;
        }
        for (Map.Entry<String, Object> entry : pkgs.m_importedPkgs.entrySet()) {
            for (Blame importBlame : (List)entry.getValue()) {
                Requirement req;
                String pkgName = entry.getKey();
                if (!pkgs.m_usedPkgs.containsKey(pkgName)) continue;
                block9: for (Blame usedBlame : pkgs.m_usedPkgs.get(pkgName)) {
                    Requirement req2;
                    if (this.isCompatible(env, importBlame.m_cap, usedBlame.m_cap, revisionPkgMap)) continue;
                    permutation = permutation != null ? permutation : allCandidates.copy();
                    rethrow = rethrow != null ? rethrow : new ResolutionException("Uses constraint violation. Unable to resolve bundle revision " + Util.getSymbolicName(revision) + " [" + revision + "] because it is exposed to package '" + pkgName + "' from bundle revisions " + Util.getSymbolicName(importBlame.m_cap.getResource()) + " [" + importBlame.m_cap.getResource() + "] and " + Util.getSymbolicName(usedBlame.m_cap.getResource()) + " [" + usedBlame.m_cap.getResource() + "] via two dependency chains.\n\nChain 1:\n" + ResolverImpl.toStringBlame(env, importBlame) + "\n\nChain 2:\n" + ResolverImpl.toStringBlame(env, usedBlame), null, null);
                    mutated = mutated != null ? mutated : new HashSet();
                    for (int reqIdx = usedBlame.m_reqs.size() - 1; reqIdx >= 0 && !mutated.contains(req2 = usedBlame.m_reqs.get(reqIdx)); --reqIdx) {
                        List<Capability> candidates = permutation.getCandidates(req2);
                        if (candidates == null || candidates.size() <= 1) continue;
                        mutated.add(req2);
                        Iterator<Capability> it = candidates.iterator();
                        it.next();
                        it.remove();
                        continue block9;
                    }
                }
                if (rethrow == null) continue;
                if (mutated.size() > 0) {
                    this.m_usesPermutations.add(permutation);
                }
                if (!mutated.contains(req = importBlame.m_reqs.get(0))) {
                    ResolverImpl.permutateIfNeeded(allCandidates, req, this.m_importPermutations);
                }
                this.m_logger.log(4, "Candidate permutation failed due to a conflict between imports; will try another if possible.", rethrow);
                throw rethrow;
            }
        }
        resultCache.put(revision, Boolean.TRUE);
        int permCount = this.m_usesPermutations.size() + this.m_importPermutations.size();
        for (Map.Entry<String, List<Blame>> entry : pkgs.m_importedPkgs.entrySet()) {
            for (Blame importBlame : entry.getValue()) {
                if (revision.equals(importBlame.m_cap.getResource())) continue;
                try {
                    this.checkPackageSpaceConsistency(env, false, importBlame.m_cap.getResource(), allCandidates, revisionPkgMap, resultCache);
                }
                catch (ResolutionException ex) {
                    if (permCount == this.m_usesPermutations.size() + this.m_importPermutations.size()) {
                        Requirement req = importBlame.m_reqs.get(0);
                        ResolverImpl.permutate(allCandidates, req, this.m_importPermutations);
                    }
                    throw ex;
                }
            }
        }
    }

    private static void permutate(Candidates allCandidates, Requirement req, List<Candidates> permutations) {
        List<Capability> candidates = allCandidates.getCandidates(req);
        if (candidates.size() > 1) {
            Candidates perm = allCandidates.copy();
            candidates = perm.getCandidates(req);
            Iterator<Capability> it = candidates.iterator();
            it.next();
            it.remove();
            permutations.add(perm);
        }
    }

    private static void permutateIfNeeded(Candidates allCandidates, Requirement req, List<Candidates> permutations) {
        List<Capability> candidates = allCandidates.getCandidates(req);
        if (candidates.size() > 1) {
            boolean permutated = false;
            for (Candidates existingPerm : permutations) {
                List<Capability> existingPermCands = existingPerm.getCandidates(req);
                if (existingPermCands.iterator().next().equals(candidates.iterator().next())) continue;
                permutated = true;
            }
            if (!permutated) {
                ResolverImpl.permutate(allCandidates, req, permutations);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void calculateExportedPackages(FelixResolveContext env, Resource revision, Candidates allCandidates, Map<Resource, Packages> revisionPkgMap) {
        Packages packages = revisionPkgMap.get(revision);
        if (packages != null) {
            return;
        }
        packages = new Packages(revision);
        Wiring wiring = (Wiring)env.getWirings().get(revision);
        List caps = wiring != null ? wiring.getResourceCapabilities(null) : revision.getCapabilities(null);
        HashMap<String, void> exports = new HashMap<String, void>(caps.size());
        for (Capability capability : caps) {
            void var9_9;
            if (!capability.getNamespace().equals("osgi.wiring.package")) continue;
            if (!capability.getResource().equals(revision)) {
                HostedCapability hostedCapability = new HostedCapability(revision, capability);
            }
            exports.put((String)var9_9.getAttributes().get("osgi.wiring.package"), var9_9);
        }
        if (!exports.isEmpty()) {
            if (wiring == null) {
                for (Requirement requirement : revision.getRequirements(null)) {
                    List<Capability> cands;
                    if (!requirement.getNamespace().equals("osgi.wiring.package") || (cands = allCandidates.getCandidates(requirement)) == null || cands.isEmpty()) continue;
                    String pkgName = (String)cands.iterator().next().getAttributes().get("osgi.wiring.package");
                    exports.remove(pkgName);
                }
            }
            for (Map.Entry entry : exports.entrySet()) {
                packages.m_exportedPkgs.put((String)entry.getKey(), new Blame((Capability)entry.getValue(), null));
            }
        }
        revisionPkgMap.put(revision, packages);
    }

    private boolean isCompatible(FelixResolveContext env, Capability currentCap, Capability candCap, Map<Resource, Packages> revisionPkgMap) {
        if (currentCap != null && candCap != null) {
            List<Capability> candSources;
            if (currentCap.equals(candCap)) {
                return true;
            }
            List<Capability> currentSources = this.getPackageSources(env, currentCap, revisionPkgMap);
            return currentSources.containsAll(candSources = this.getPackageSources(env, candCap, revisionPkgMap)) || candSources.containsAll(currentSources);
        }
        return true;
    }

    private List<Capability> getPackageSources(FelixResolveContext env, Capability cap, Map<Resource, Packages> revisionPkgMap) {
        if (cap.getNamespace().equals("osgi.wiring.package")) {
            List<Capability> sources = this.m_packageSourcesCache.get(cap);
            if (sources == null) {
                sources = ResolverImpl.getPackageSourcesInternal(env, cap, revisionPkgMap, new ArrayList<Capability>(), new HashSet<Capability>());
                this.m_packageSourcesCache.put(cap, sources);
            }
            return sources;
        }
        String uses = (String)cap.getDirectives().get("uses");
        if (uses != null && uses.length() > 0) {
            return Collections.singletonList(cap);
        }
        return Collections.EMPTY_LIST;
    }

    private static List<Capability> getPackageSourcesInternal(FelixResolveContext env, Capability cap, Map<Resource, Packages> revisionPkgMap, List<Capability> sources, Set<Capability> cycleMap) {
        if (cap.getNamespace().equals("osgi.wiring.package")) {
            if (cycleMap.contains(cap)) {
                return sources;
            }
            cycleMap.add(cap);
            String pkgName = cap.getAttributes().get("osgi.wiring.package").toString();
            Wiring wiring = (Wiring)env.getWirings().get(cap.getResource());
            List caps = wiring != null ? wiring.getResourceCapabilities(null) : cap.getResource().getCapabilities(null);
            for (int capIdx = 0; capIdx < caps.size(); ++capIdx) {
                if (!((Capability)caps.get(capIdx)).getNamespace().equals("osgi.wiring.package") || !((Capability)caps.get(capIdx)).getAttributes().get("osgi.wiring.package").equals(pkgName)) continue;
                sources.add((Capability)caps.get(capIdx));
            }
            Packages pkgs = revisionPkgMap.get(cap.getResource());
            List<Blame> required = pkgs.m_requiredPkgs.get(pkgName);
            if (required != null) {
                for (Blame blame : required) {
                    ResolverImpl.getPackageSourcesInternal(env, blame.m_cap, revisionPkgMap, sources, cycleMap);
                }
            }
        }
        return sources;
    }

    private static Resource getActualResource(Resource br) {
        if (br instanceof HostResource) {
            return ((HostResource)br).getHost();
        }
        return br;
    }

    private static Capability getActualCapability(Capability c) {
        if (c instanceof HostedCapability) {
            return ((HostedCapability)c).getOriginalCapability();
        }
        return c;
    }

    private static Requirement getActualRequirement(Requirement r) {
        if (r instanceof HostedRequirement) {
            return ((HostedRequirement)r).getOriginalRequirement();
        }
        return r;
    }

    private static Map<Resource, List<Wire>> populateWireMap(FelixResolveContext env, Resource resource, Map<Resource, Packages> revisionPkgMap, Map<Resource, List<Wire>> wireMap, Candidates allCandidates) {
        Resource unwrappedResource = ResolverImpl.getActualResource(resource);
        if (!env.getWirings().containsKey(unwrappedResource) && !wireMap.containsKey(unwrappedResource)) {
            wireMap.put(unwrappedResource, Collections.EMPTY_LIST);
            ArrayList<WireImpl> packageWires = new ArrayList<WireImpl>();
            ArrayList<WireImpl> bundleWires = new ArrayList<WireImpl>();
            ArrayList<WireImpl> capabilityWires = new ArrayList<WireImpl>();
            for (Requirement req : resource.getRequirements(null)) {
                Capability cand;
                List<Capability> cands = allCandidates.getCandidates(req);
                if (cands == null || cands.size() <= 0 || resource.equals((cand = cands.iterator().next()).getResource())) continue;
                if (!env.getWirings().containsKey(cand.getResource())) {
                    ResolverImpl.populateWireMap(env, cand.getResource(), revisionPkgMap, wireMap, allCandidates);
                }
                Packages candPkgs = revisionPkgMap.get(cand.getResource());
                WireImpl wire = new WireImpl(unwrappedResource, ResolverImpl.getActualRequirement(req), ResolverImpl.getActualResource(cand.getResource()), ResolverImpl.getActualCapability(cand));
                if (req.getNamespace().equals("osgi.wiring.package")) {
                    packageWires.add(wire);
                    continue;
                }
                if (req.getNamespace().equals("osgi.wiring.bundle")) {
                    bundleWires.add(wire);
                    continue;
                }
                capabilityWires.add(wire);
            }
            packageWires.addAll(bundleWires);
            packageWires.addAll(capabilityWires);
            wireMap.put(unwrappedResource, packageWires);
            if (resource instanceof HostResource) {
                List<Resource> fragments = ((HostResource)resource).getFragments();
                for (Resource fragment : fragments) {
                    List<Wire> hostWires = wireMap.get(fragment);
                    if (hostWires == null) {
                        hostWires = new ArrayList<Wire>();
                        wireMap.put(fragment, hostWires);
                    }
                    hostWires.add(new WireImpl(ResolverImpl.getActualResource(fragment), (Requirement)fragment.getRequirements("osgi.wiring.host").get(0), unwrappedResource, (Capability)unwrappedResource.getCapabilities("osgi.wiring.host").get(0)));
                }
            }
        }
        return wireMap;
    }

    private static Map<Resource, List<Wire>> populateDynamicWireMap(FelixResolveContext env, Resource resource, Requirement dynReq, Map<Resource, Packages> revisionPkgMap, Map<Resource, List<Wire>> wireMap, Candidates allCandidates) {
        wireMap.put(resource, Collections.EMPTY_LIST);
        ArrayList<WireImpl> packageWires = new ArrayList<WireImpl>();
        List<Capability> candCaps = allCandidates.getCandidates(dynReq);
        Capability dynCand = candCaps.get(0);
        if (!env.getWirings().containsKey(dynCand.getResource())) {
            ResolverImpl.populateWireMap(env, dynCand.getResource(), revisionPkgMap, wireMap, allCandidates);
        }
        packageWires.add(new WireImpl(resource, dynReq, ResolverImpl.getActualResource(dynCand.getResource()), ResolverImpl.getActualCapability(dynCand)));
        wireMap.put(resource, packageWires);
        return wireMap;
    }

    private static Set<String> calculatePackageSpace(FelixResolveContext env, Resource resource, Wiring wiring) {
        if (Util.isFragment(resource)) {
            return Collections.EMPTY_SET;
        }
        HashSet<String> pkgSpace = new HashSet<String>();
        for (Wire wire : wiring.getRequiredResourceWires(null)) {
            if (wire.getCapability().getNamespace().equals("osgi.wiring.package")) {
                pkgSpace.add((String)wire.getCapability().getAttributes().get("osgi.wiring.package"));
                continue;
            }
            if (!wire.getCapability().getNamespace().equals("osgi.wiring.bundle")) continue;
            Set<String> pkgs = ResolverImpl.calculateExportedAndReexportedPackages(env, wire.getProvider(), new HashSet<String>(), new HashSet<Resource>());
            pkgSpace.addAll(pkgs);
        }
        return pkgSpace;
    }

    private static Set<String> calculateExportedAndReexportedPackages(FelixResolveContext env, Resource res, Set<String> pkgs, Set<Resource> cycles) {
        if (!cycles.contains(res)) {
            cycles.add(res);
            for (Capability cap : res.getCapabilities(null)) {
                if (!cap.getNamespace().equals("osgi.wiring.package")) continue;
                pkgs.add((String)cap.getAttributes().get("osgi.wiring.package"));
            }
            for (Wire wire : ((Wiring)env.getWirings().get(res)).getRequiredResourceWires(null)) {
                String dir;
                if (!wire.getCapability().getNamespace().equals("osgi.wiring.bundle") || (dir = (String)wire.getRequirement().getDirectives().get("visibility")) == null || !dir.equals("reexport")) continue;
                ResolverImpl.calculateExportedAndReexportedPackages(env, wire.getProvider(), pkgs, cycles);
            }
        }
        return pkgs;
    }

    private void dumpRevisionPkgMap(FelixResolveContext env, Map<Resource, Packages> revisionPkgMap) {
        this.m_logger.log(5, "+++ PACKAGE SPACES START +++");
        for (Map.Entry<Resource, Packages> entry : revisionPkgMap.entrySet()) {
            this.dumpRevisionPkgs(env, entry.getKey(), entry.getValue());
        }
        this.m_logger.log(5, "+++ PACKAGE SPACES END +++");
    }

    private void dumpRevisionPkgs(FelixResolveContext env, Resource resource, Packages packages) {
        Wiring wiring = (Wiring)env.getWirings().get(resource);
        this.m_logger.log(5, resource + " (" + (wiring != null ? "RESOLVED)" : "UNRESOLVED)"));
        this.m_logger.log(5, "  EXPORTED");
        for (Map.Entry<String, Blame> entry : packages.m_exportedPkgs.entrySet()) {
            this.m_logger.log(5, "    " + entry.getKey() + " - " + entry.getValue());
        }
        this.m_logger.log(5, "  IMPORTED");
        for (Map.Entry<String, Object> entry : packages.m_importedPkgs.entrySet()) {
            this.m_logger.log(5, "    " + entry.getKey() + " - " + entry.getValue());
        }
        this.m_logger.log(5, "  REQUIRED");
        for (Map.Entry<String, Object> entry : packages.m_requiredPkgs.entrySet()) {
            this.m_logger.log(5, "    " + entry.getKey() + " - " + entry.getValue());
        }
        this.m_logger.log(5, "  USED");
        for (Map.Entry<String, Object> entry : packages.m_usedPkgs.entrySet()) {
            this.m_logger.log(5, "    " + entry.getKey() + " - " + entry.getValue());
        }
    }

    private static String toStringBlame(FelixResolveContext env, Blame blame) {
        StringBuffer sb = new StringBuffer();
        if (blame.m_reqs != null && !blame.m_reqs.isEmpty()) {
            for (int i = 0; i < blame.m_reqs.size(); ++i) {
                Requirement req = blame.m_reqs.get(i);
                sb.append("  ");
                sb.append(Util.getSymbolicName(req.getResource()));
                sb.append(" [");
                sb.append(req.getResource().toString());
                sb.append("]\n");
                if (req.getNamespace().equals("osgi.wiring.package")) {
                    sb.append("    import: ");
                } else {
                    sb.append("    require: ");
                }
                sb.append((String)req.getDirectives().get("filter"));
                sb.append("\n     |");
                if (req.getNamespace().equals("osgi.wiring.package")) {
                    sb.append("\n    export: ");
                } else {
                    sb.append("\n    provide: ");
                }
                if (i + 1 < blame.m_reqs.size()) {
                    Capability cap = Util.getSatisfyingCapability(env, blame.m_reqs.get(i + 1).getResource(), blame.m_reqs.get(i));
                    if (cap.getNamespace().equals("osgi.wiring.package")) {
                        sb.append("osgi.wiring.package");
                        sb.append("=");
                        sb.append(cap.getAttributes().get("osgi.wiring.package").toString());
                        Capability usedCap = i + 2 < blame.m_reqs.size() ? Util.getSatisfyingCapability(env, blame.m_reqs.get(i + 2).getResource(), blame.m_reqs.get(i + 1)) : Util.getSatisfyingCapability(env, blame.m_cap.getResource(), blame.m_reqs.get(i + 1));
                        sb.append("; uses:=");
                        sb.append(usedCap.getAttributes().get("osgi.wiring.package"));
                    } else {
                        sb.append(cap);
                    }
                    sb.append("\n");
                    continue;
                }
                Capability export = Util.getSatisfyingCapability(env, blame.m_cap.getResource(), blame.m_reqs.get(i));
                sb.append(export.getNamespace());
                sb.append("=");
                sb.append(export.getAttributes().get(export.getNamespace()).toString());
                if (export.getNamespace().equals("osgi.wiring.package") && !export.getAttributes().get("osgi.wiring.package").equals(blame.m_cap.getAttributes().get("osgi.wiring.package"))) {
                    sb.append("; uses:=");
                    sb.append(blame.m_cap.getAttributes().get("osgi.wiring.package"));
                    sb.append("\n    export: ");
                    sb.append("osgi.wiring.package");
                    sb.append("=");
                    sb.append(blame.m_cap.getAttributes().get("osgi.wiring.package").toString());
                }
                sb.append("\n  ");
                sb.append(Util.getSymbolicName(blame.m_cap.getResource()));
                sb.append(" [");
                sb.append(blame.m_cap.getResource().toString());
                sb.append("]");
            }
        } else {
            sb.append(blame.m_cap.getResource().toString());
        }
        return sb.toString();
    }

    private static class Blame {
        public final Capability m_cap;
        public final List<Requirement> m_reqs;

        public Blame(Capability cap, List<Requirement> reqs) {
            this.m_cap = cap;
            this.m_reqs = reqs;
        }

        public String toString() {
            return this.m_cap.getResource() + "." + this.m_cap.getAttributes().get("osgi.wiring.package") + (this.m_reqs == null || this.m_reqs.isEmpty() ? " NO BLAME" : " BLAMED ON " + this.m_reqs);
        }

        public boolean equals(Object o) {
            return o instanceof Blame && ((Object)this.m_reqs).equals(((Blame)o).m_reqs) && this.m_cap.equals(((Blame)o).m_cap);
        }
    }

    private static class Packages {
        private final Resource m_revision;
        public final Map<String, Blame> m_exportedPkgs = new HashMap<String, Blame>();
        public final Map<String, List<Blame>> m_importedPkgs = new HashMap<String, List<Blame>>();
        public final Map<String, List<Blame>> m_requiredPkgs = new HashMap<String, List<Blame>>();
        public final Map<String, List<Blame>> m_usedPkgs = new HashMap<String, List<Blame>>();

        public Packages(Resource revision) {
            this.m_revision = revision;
        }
    }
}

