/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.wstrust;

import java.net.URI;
import java.security.KeyPair;
import java.security.Principal;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.util.List;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.picketlink.identity.federation.core.exceptions.ProcessingException;
import org.picketlink.identity.federation.core.saml.v2.util.DocumentUtil;
import org.picketlink.identity.federation.core.sts.PicketLinkCoreSTS;
import org.picketlink.identity.federation.core.util.Base64;
import org.picketlink.identity.federation.core.util.XMLEncryptionUtil;
import org.picketlink.identity.federation.core.util.XMLSignatureUtil;
import org.picketlink.identity.federation.core.wstrust.ClaimsProcessor;
import org.picketlink.identity.federation.core.wstrust.STSConfiguration;
import org.picketlink.identity.federation.core.wstrust.SecurityToken;
import org.picketlink.identity.federation.core.wstrust.WSTrustException;
import org.picketlink.identity.federation.core.wstrust.WSTrustRequestContext;
import org.picketlink.identity.federation.core.wstrust.WSTrustRequestHandler;
import org.picketlink.identity.federation.core.wstrust.WSTrustUtil;
import org.picketlink.identity.federation.core.wstrust.wrappers.RequestSecurityToken;
import org.picketlink.identity.federation.core.wstrust.wrappers.RequestSecurityTokenResponse;
import org.picketlink.identity.federation.ws.policy.AppliesTo;
import org.picketlink.identity.federation.ws.trust.BinarySecretType;
import org.picketlink.identity.federation.ws.trust.ClaimsType;
import org.picketlink.identity.federation.ws.trust.ComputedKeyType;
import org.picketlink.identity.federation.ws.trust.EntropyType;
import org.picketlink.identity.federation.ws.trust.RequestedProofTokenType;
import org.picketlink.identity.federation.ws.trust.RequestedSecurityTokenType;
import org.picketlink.identity.federation.ws.trust.RequestedTokenCancelledType;
import org.picketlink.identity.federation.ws.trust.StatusType;
import org.picketlink.identity.federation.ws.trust.UseKeyType;
import org.picketlink.identity.xmlsec.w3.xmldsig.KeyInfoType;
import org.picketlink.identity.xmlsec.w3.xmldsig.X509DataType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class StandardRequestHandler
implements WSTrustRequestHandler {
    private static Logger log = Logger.getLogger(StandardRequestHandler.class);
    private final boolean trace = log.isTraceEnabled();
    private static long KEY_SIZE = 128L;
    private STSConfiguration configuration;

    public void initialize(STSConfiguration configuration) {
        this.configuration = configuration;
    }

    public RequestSecurityTokenResponse issue(RequestSecurityToken request, Principal callerPrincipal) throws WSTrustException {
        long keySize;
        URI keyType;
        String serviceName;
        if (this.trace) {
            log.trace((Object)("Issuing token for principal " + callerPrincipal));
        }
        AppliesTo appliesTo = request.getAppliesTo();
        PublicKey providerPublicKey = null;
        if (appliesTo != null && (serviceName = WSTrustUtil.parseAppliesTo(appliesTo)) != null) {
            String tokenTypeFromServiceName = this.configuration.getTokenTypeForService(serviceName);
            if (request.getTokenType() == null && tokenTypeFromServiceName != null) {
                request.setTokenType(URI.create(tokenTypeFromServiceName));
            }
            providerPublicKey = this.configuration.getServiceProviderPublicKey(serviceName);
        }
        WSTrustRequestContext requestContext = new WSTrustRequestContext(request, callerPrincipal);
        requestContext.setTokenIssuer(this.configuration.getSTSName());
        if (request.getLifetime() == null && this.configuration.getIssuedTokenTimeout() != 0L) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Lifetime has not been specified. Using the default timeout value.");
            }
            request.setLifetime(WSTrustUtil.createDefaultLifetime(this.configuration.getIssuedTokenTimeout()));
        }
        requestContext.setServiceProviderPublicKey(providerPublicKey);
        if (request.getClaims() != null) {
            ClaimsType claims = request.getClaims();
            ClaimsProcessor processor = this.configuration.getClaimsProcessor(claims.getDialect());
            if (processor != null) {
                requestContext.setClaimedAttributes(processor.processClaims(claims, callerPrincipal));
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("Claims have been specified in the request but no processor was found for dialect " + claims.getDialect()));
            }
        }
        if (request.getOnBehalfOf() != null) {
            Principal onBehalfOfPrincipal = WSTrustUtil.getOnBehalfOfPrincipal(request.getOnBehalfOf());
            requestContext.setOnBehalfOfPrincipal(onBehalfOfPrincipal);
        }
        if ((keyType = request.getKeyType()) == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"No key type could be found in the request. Using the default BEARER type.");
            }
            keyType = URI.create("http://docs.oasis-open.org/ws-sx/ws-trust/200512/Bearer");
            request.setKeyType(keyType);
        }
        if ((keySize = request.getKeySize()) == 0L) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("No key size could be found in the request. Using the default size. (" + KEY_SIZE + ")"));
            }
            keySize = KEY_SIZE;
            request.setKeySize(keySize);
        }
        URI keyWrapAlgo = request.getKeyWrapAlgorithm();
        RequestedProofTokenType requestedProofToken = null;
        EntropyType serverEntropy = null;
        if ("http://docs.oasis-open.org/ws-sx/ws-trust/200512/SymmetricKey".equalsIgnoreCase(keyType.toString())) {
            requestedProofToken = new RequestedProofTokenType();
            byte[] serverSecret = WSTrustUtil.createRandomSecret((int)keySize / 8);
            BinarySecretType serverBinarySecret = new BinarySecretType();
            serverBinarySecret.setType("http://docs.oasis-open.org/ws-sx/ws-trust/200512/Nonce");
            serverBinarySecret.setValue(Base64.encodeBytes(serverSecret).getBytes());
            byte[] clientSecret = null;
            EntropyType clientEntropy = request.getEntropy();
            if (clientEntropy != null) {
                clientSecret = Base64.decode(new String(WSTrustUtil.getBinarySecret(clientEntropy)));
                serverEntropy = new EntropyType();
                serverEntropy.addAny(serverBinarySecret);
            }
            if (clientSecret != null && clientSecret.length != 0) {
                requestedProofToken.add(new ComputedKeyType("http://docs.oasis-open.org/ws-sx/ws-trust/200512/CK/PSHA1"));
                byte[] combinedSecret = null;
                try {
                    combinedSecret = Base64.encodeBytes(WSTrustUtil.P_SHA1(clientSecret, serverSecret, (int)keySize / 8)).getBytes();
                }
                catch (Exception e) {
                    throw new WSTrustException("PL00006: Error generating combined secret key:", e);
                }
                requestContext.setProofTokenInfo(WSTrustUtil.createKeyInfo(combinedSecret, providerPublicKey, keyWrapAlgo));
            } else {
                requestedProofToken.add(serverBinarySecret);
                requestContext.setProofTokenInfo(WSTrustUtil.createKeyInfo(serverBinarySecret.getValue(), providerPublicKey, keyWrapAlgo));
            }
        } else if ("http://docs.oasis-open.org/ws-sx/ws-trust/200512/PublicKey".equalsIgnoreCase(keyType.toString())) {
            Certificate certificate = this.configuration.getCertificate(callerPrincipal.getName());
            if (certificate != null) {
                requestContext.setProofTokenInfo(WSTrustUtil.createKeyInfo(certificate));
            } else if (request.getUseKey() != null) {
                UseKeyType useKeyType = request.getUseKey();
                List<Object> theList = useKeyType.getAny();
                for (Object value : theList) {
                    if (value instanceof Element) {
                        String elementName = ((Element)value).getLocalName();
                        if (elementName.equals("X509Certificate")) {
                            X509DataType data = new X509DataType();
                            data.add(value);
                            value = data;
                        }
                        KeyInfoType keyInfo = new KeyInfoType();
                        keyInfo.addContent(value);
                        requestContext.setProofTokenInfo(keyInfo);
                        continue;
                    }
                    if (value instanceof KeyInfoType) {
                        requestContext.setProofTokenInfo((KeyInfoType)value);
                        continue;
                    }
                    throw new WSTrustException("PL00069: Parser: Type not supported:" + value);
                }
            } else {
                throw new WSTrustException("PL00008: Unable to locate client public key");
            }
        }
        try {
            if (request.getTokenType() != null) {
                requestContext.setTokenType(request.getTokenType().toString());
            }
            PicketLinkCoreSTS sts = PicketLinkCoreSTS.instance();
            sts.initialize(this.configuration);
            sts.issueToken(requestContext);
        }
        catch (ProcessingException e) {
            throw new WSTrustException(e.getMessage(), e);
        }
        if (requestContext.getSecurityToken() == null) {
            throw new WSTrustException("PL00092: Null Value:Token issued by STS");
        }
        RequestedSecurityTokenType requestedSecurityToken = new RequestedSecurityTokenType();
        SecurityToken contextSecurityToken = requestContext.getSecurityToken();
        if (contextSecurityToken == null) {
            throw new WSTrustException("PL00092: Null Value:Security Token from context");
        }
        requestedSecurityToken.add(contextSecurityToken.getTokenValue());
        RequestSecurityTokenResponse response = new RequestSecurityTokenResponse();
        if (request.getContext() != null) {
            response.setContext(request.getContext());
        }
        response.setTokenType(request.getTokenType());
        response.setLifetime(request.getLifetime());
        response.setAppliesTo(appliesTo);
        response.setKeySize(keySize);
        response.setKeyType(keyType);
        response.setRequestedSecurityToken(requestedSecurityToken);
        if (requestedProofToken != null) {
            response.setRequestedProofToken(requestedProofToken);
        }
        if (serverEntropy != null) {
            response.setEntropy(serverEntropy);
        }
        if (requestContext.getAttachedReference() != null) {
            response.setRequestedAttachedReference(requestContext.getAttachedReference());
        }
        if (requestContext.getUnattachedReference() != null) {
            response.setRequestedUnattachedReference(requestContext.getUnattachedReference());
        }
        return response;
    }

    public RequestSecurityTokenResponse renew(RequestSecurityToken request, Principal callerPrincipal) throws WSTrustException {
        Node securityToken;
        block18: {
            if (this.trace) {
                log.trace((Object)("Validating token for renew request " + request.getContext()));
            }
            if (request.getRenewTargetElement() == null) {
                throw new WSTrustException("PL00092: Null Value:Unable to renew token: request does not have a renew target");
            }
            securityToken = request.getRenewTargetElement().getFirstChild();
            if (securityToken == null) {
                throw new WSTrustException("PL00092: Null Value:Unable to renew token: security token is null");
            }
            if (this.configuration.signIssuedToken() && this.configuration.getSTSKeyPair() != null) {
                KeyPair keyPair = this.configuration.getSTSKeyPair();
                try {
                    Document tokenDocument = DocumentUtil.createDocument();
                    Node importedNode = tokenDocument.importNode(securityToken, true);
                    tokenDocument.appendChild(importedNode);
                    if (!XMLSignatureUtil.validate(tokenDocument, keyPair.getPublic())) {
                        throw new WSTrustException("PL00009: Invalid Digital Signature:Validation failure during renewal");
                    }
                    break block18;
                }
                catch (Exception e) {
                    throw new WSTrustException("PL00009: Invalid Digital Signature:Validation failure during renewal:", e);
                }
            }
            if (this.trace) {
                log.trace((Object)"Security Token digital signature has NOT been verified. Either the STS has been configurednot to sign tokens or the STS key pair has not been properly specified.");
            }
        }
        if (request.getLifetime() == null && this.configuration.getIssuedTokenTimeout() != 0L) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Lifetime has not been specified. Using the default timeout value.");
            }
            request.setLifetime(WSTrustUtil.createDefaultLifetime(this.configuration.getIssuedTokenTimeout()));
        }
        WSTrustRequestContext context = new WSTrustRequestContext(request, callerPrincipal);
        context.setTokenIssuer(this.configuration.getSTSName());
        if (request.getOnBehalfOf() != null) {
            Principal onBehalfOfPrincipal = WSTrustUtil.getOnBehalfOfPrincipal(request.getOnBehalfOf());
            context.setOnBehalfOfPrincipal(onBehalfOfPrincipal);
        }
        try {
            if (securityToken != null) {
                String ns = securityToken.getNamespaceURI();
                context.setQName(new QName(ns, securityToken.getLocalName()));
            }
            PicketLinkCoreSTS sts = PicketLinkCoreSTS.instance();
            sts.initialize(this.configuration);
            sts.renewToken(context);
        }
        catch (ProcessingException e) {
            throw new WSTrustException(e.getMessage(), e);
        }
        RequestedSecurityTokenType requestedSecurityToken = new RequestedSecurityTokenType();
        SecurityToken contextSecurityToken = context.getSecurityToken();
        if (contextSecurityToken == null) {
            throw new WSTrustException("PL00092: Null Value:Security Token from context");
        }
        requestedSecurityToken.add(contextSecurityToken.getTokenValue());
        RequestSecurityTokenResponse response = new RequestSecurityTokenResponse();
        if (request.getContext() != null) {
            response.setContext(request.getContext());
        }
        response.setTokenType(request.getTokenType());
        response.setLifetime(request.getLifetime());
        response.setRequestedSecurityToken(requestedSecurityToken);
        if (context.getAttachedReference() != null) {
            response.setRequestedAttachedReference(context.getAttachedReference());
        }
        if (context.getUnattachedReference() != null) {
            response.setRequestedUnattachedReference(context.getUnattachedReference());
        }
        return response;
    }

    public RequestSecurityTokenResponse validate(RequestSecurityToken request, Principal callerPrincipal) throws WSTrustException {
        Node securityToken;
        if (this.trace) {
            log.trace((Object)("Started validation for request " + request.getContext()));
        }
        if (request.getValidateTargetElement() == null) {
            throw new WSTrustException("PL00092: Null Value:request does not have a validate target. Unable to validate token");
        }
        if (request.getTokenType() == null) {
            request.setTokenType(URI.create("http://docs.oasis-open.org/ws-sx/ws-trust/200512/RSTR/Status"));
        }
        if ((securityToken = request.getValidateTargetElement().getFirstChild()) == null) {
            throw new WSTrustException("PL00092: Null Value:security token:Unable to validate token");
        }
        WSTrustRequestContext context = new WSTrustRequestContext(request, callerPrincipal);
        if (request.getOnBehalfOf() != null) {
            Principal onBehalfOfPrincipal = WSTrustUtil.getOnBehalfOfPrincipal(request.getOnBehalfOf());
            context.setOnBehalfOfPrincipal(onBehalfOfPrincipal);
        }
        StatusType status = null;
        if (this.configuration.signIssuedToken() && this.configuration.getSTSKeyPair() != null) {
            KeyPair keyPair = this.configuration.getSTSKeyPair();
            try {
                if (this.trace) {
                    try {
                        log.trace((Object)("Going to validate:" + DocumentUtil.getNodeAsString(securityToken)));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                Document tokenDocument = DocumentUtil.createDocument();
                Node importedNode = tokenDocument.importNode(securityToken, true);
                tokenDocument.appendChild(importedNode);
                if (!XMLSignatureUtil.validate(tokenDocument, keyPair.getPublic())) {
                    status = new StatusType();
                    status.setCode("http://docs.oasis-open.org/ws-sx/ws-trust/200512/status/invalid");
                    status.setReason("Validation failure: digital signature is invalid");
                }
            }
            catch (Exception e) {
                status = new StatusType();
                status.setCode("http://docs.oasis-open.org/ws-sx/ws-trust/200512/status/invalid");
                status.setReason("Validation failure: unable to verify digital signature: " + e.getMessage());
            }
        } else if (this.trace) {
            log.trace((Object)"Security Token digital signature has NOT been verified. Either the STS has been configurednot to sign tokens or the STS key pair has not been properly specified.");
        }
        if (status == null) {
            if (this.trace) {
                log.trace((Object)"Delegating token validation to token provider");
            }
            try {
                if (securityToken != null) {
                    context.setQName(new QName(securityToken.getNamespaceURI(), securityToken.getLocalName()));
                }
                PicketLinkCoreSTS sts = PicketLinkCoreSTS.instance();
                sts.initialize(this.configuration);
                sts.validateToken(context);
            }
            catch (ProcessingException e) {
                throw new WSTrustException(e.getMessage(), e);
            }
            status = context.getStatus();
        }
        RequestSecurityTokenResponse response = new RequestSecurityTokenResponse();
        if (request.getContext() != null) {
            response.setContext(request.getContext());
        }
        response.setTokenType(request.getTokenType());
        response.setStatus(status);
        return response;
    }

    public RequestSecurityTokenResponse cancel(RequestSecurityToken request, Principal callerPrincipal) throws WSTrustException {
        if (request.getCancelTargetElement() == null) {
            throw new WSTrustException("PL00092: Null Value:request does not have a cancel target. Unable to cancel token");
        }
        Node securityToken = request.getCancelTargetElement().getFirstChild();
        if (securityToken == null) {
            throw new WSTrustException("PL00092: Null Value:security token. Unable to cancel token");
        }
        WSTrustRequestContext context = new WSTrustRequestContext(request, callerPrincipal);
        if (request.getOnBehalfOf() != null) {
            Principal onBehalfOfPrincipal = WSTrustUtil.getOnBehalfOfPrincipal(request.getOnBehalfOf());
            context.setOnBehalfOfPrincipal(onBehalfOfPrincipal);
        }
        try {
            if (securityToken != null) {
                context.setQName(new QName(securityToken.getNamespaceURI(), securityToken.getLocalName()));
            }
            PicketLinkCoreSTS sts = PicketLinkCoreSTS.instance();
            sts.initialize(this.configuration);
            sts.cancelToken(context);
        }
        catch (ProcessingException e) {
            throw new WSTrustException(e.getMessage(), e);
        }
        RequestSecurityTokenResponse response = new RequestSecurityTokenResponse();
        if (request.getContext() != null) {
            response.setContext(request.getContext());
        }
        response.setRequestedTokenCancelled(new RequestedTokenCancelledType());
        return response;
    }

    public Document postProcess(Document rstrDocument, RequestSecurityToken request) throws WSTrustException {
        if ("http://docs.oasis-open.org/ws-sx/ws-trust/200512/Issue".equals(request.getRequestType().toString()) || "http://docs.oasis-open.org/ws-sx/ws-trust/200512/Renew".equals(request.getRequestType().toString())) {
            rstrDocument = DocumentUtil.normalizeNamespaces(rstrDocument);
            if (this.configuration.signIssuedToken() && this.configuration.getSTSKeyPair() != null) {
                KeyPair keyPair = this.configuration.getSTSKeyPair();
                URI signatureURI = request.getSignatureAlgorithm();
                String signatureMethod = signatureURI != null ? signatureURI.toString() : "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
                try {
                    Node rst = rstrDocument.getElementsByTagNameNS("http://docs.oasis-open.org/ws-sx/ws-trust/200512", "RequestedSecurityToken").item(0);
                    Element tokenElement = (Element)rst.getFirstChild();
                    if (this.trace) {
                        log.trace((Object)("NamespaceURI of element to be signed:" + tokenElement.getNamespaceURI()));
                    }
                    XMLSignatureUtil.setCanonicalizationMethodType(this.configuration.getXMLDSigCanonicalizationMethod());
                    rstrDocument = XMLSignatureUtil.sign(rstrDocument, tokenElement, keyPair, "http://www.w3.org/2000/09/xmldsig#sha1", signatureMethod, "");
                    if (this.trace) {
                        try {
                            log.trace((Object)("Signed Token:" + DocumentUtil.getNodeAsString(tokenElement)));
                            Document tokenDocument = DocumentUtil.createDocument();
                            tokenDocument.appendChild(tokenDocument.importNode(tokenElement, true));
                            log.trace((Object)("valid=" + XMLSignatureUtil.validate(tokenDocument, keyPair.getPublic())));
                        }
                        catch (Exception ignore) {}
                    }
                }
                catch (Exception e) {
                    throw new WSTrustException("PL00100: Signing Process Failure:", e);
                }
            }
            if (this.configuration.encryptIssuedToken()) {
                PublicKey providerPublicKey = null;
                if (request.getAppliesTo() != null) {
                    String serviceName = WSTrustUtil.parseAppliesTo(request.getAppliesTo());
                    if (this.trace) {
                        log.trace((Object)("Locating public key for service provider " + serviceName));
                    }
                    if (serviceName != null) {
                        providerPublicKey = this.configuration.getServiceProviderPublicKey(serviceName);
                    }
                }
                if (providerPublicKey == null) {
                    log.warn((Object)"Security token should be encrypted but no encrypting key could be found");
                } else {
                    long keySize = request.getKeySize();
                    byte[] secret = WSTrustUtil.createRandomSecret((int)keySize / 8);
                    SecretKeySpec secretKey = new SecretKeySpec(secret, "AES");
                    Node rst = rstrDocument.getElementsByTagNameNS("http://docs.oasis-open.org/ws-sx/ws-trust/200512", "RequestedSecurityToken").item(0);
                    Element tokenElement = (Element)rst.getFirstChild();
                    try {
                        XMLEncryptionUtil.encryptElement(rstrDocument, tokenElement, providerPublicKey, secretKey, (int)keySize);
                    }
                    catch (ProcessingException e) {
                        throw new WSTrustException("PL00101: Encryption Process Failure:", e);
                    }
                }
            }
        }
        return rstrDocument;
    }
}

