/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.web.process;

import java.io.IOException;
import java.io.InputStream;
import java.security.PublicKey;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import org.picketlink.identity.federation.api.saml.v2.response.SAML2Response;
import org.picketlink.identity.federation.api.saml.v2.sig.SAML2Signature;
import org.picketlink.identity.federation.core.exceptions.ConfigurationException;
import org.picketlink.identity.federation.core.exceptions.ParsingException;
import org.picketlink.identity.federation.core.exceptions.ProcessingException;
import org.picketlink.identity.federation.core.interfaces.TrustKeyConfigurationException;
import org.picketlink.identity.federation.core.interfaces.TrustKeyProcessingException;
import org.picketlink.identity.federation.core.saml.v2.common.SAMLDocumentHolder;
import org.picketlink.identity.federation.core.saml.v2.exceptions.IssuerNotTrustedException;
import org.picketlink.identity.federation.core.saml.v2.impl.DefaultSAML2HandlerResponse;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2Handler;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerRequest;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerResponse;
import org.picketlink.identity.federation.core.util.StringUtil;
import org.picketlink.identity.federation.web.core.HTTPContext;
import org.picketlink.identity.federation.web.process.SAMLHandlerChainProcessor;
import org.picketlink.identity.federation.web.process.ServiceProviderBaseProcessor;
import org.picketlink.identity.federation.web.util.PostBindingUtil;
import org.picketlink.identity.federation.web.util.RedirectBindingSignatureUtil;
import org.picketlink.identity.federation.web.util.RedirectBindingUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceProviderSAMLResponseProcessor
extends ServiceProviderBaseProcessor {
    private boolean validateSignature = false;
    private boolean idpPostBinding = false;

    public void setIdpPostBinding(boolean idpPostBinding) {
        this.idpPostBinding = idpPostBinding;
    }

    public ServiceProviderSAMLResponseProcessor(boolean postBinding, String serviceURL) {
        super(postBinding, serviceURL);
    }

    public void setValidateSignature(boolean validateSignature) {
        this.validateSignature = validateSignature;
    }

    public SAML2HandlerResponse process(String samlResponse, HTTPContext httpContext, Set<SAML2Handler> handlers, Lock chainLock) throws ProcessingException, IOException, ParsingException, ConfigurationException {
        SAMLDocumentHolder documentHolder = this.getSAMLDocumentHolder(samlResponse);
        this.validateSignature(httpContext, documentHolder);
        SAML2HandlerResponse saml2HandlerResponse = this.processHandlersChain(httpContext, handlers, chainLock, documentHolder);
        return saml2HandlerResponse;
    }

    private SAML2HandlerResponse processHandlersChain(HTTPContext httpContext, Set<SAML2Handler> handlers, Lock chainLock, SAMLDocumentHolder documentHolder) throws ConfigurationException, ProcessingException, TrustKeyConfigurationException, TrustKeyProcessingException, IOException {
        SAML2HandlerRequest saml2HandlerRequest = this.getSAML2HandlerRequest(documentHolder, httpContext);
        DefaultSAML2HandlerResponse saml2HandlerResponse = new DefaultSAML2HandlerResponse();
        SAMLHandlerChainProcessor chainProcessor = new SAMLHandlerChainProcessor(handlers);
        if (this.spConfiguration != null) {
            HashMap<String, Object> requestOptions = new HashMap<String, Object>();
            requestOptions.put("CONFIGURATION", this.spConfiguration);
            if (this.keyManager != null) {
                PublicKey validatingKey = this.getIDPPublicKey();
                requestOptions.put("SENDER_PUBLIC_KEY", validatingKey);
                requestOptions.put("DECRYPTING_KEY", this.keyManager.getSigningKey());
            }
            saml2HandlerRequest.setOptions(requestOptions);
        }
        chainProcessor.callHandlerChain(documentHolder.getSamlObject(), saml2HandlerRequest, saml2HandlerResponse, httpContext, chainLock);
        return saml2HandlerResponse;
    }

    private boolean isPostBinding() {
        return this.postBinding || this.idpPostBinding;
    }

    private void validateSignature(HTTPContext httpContext, SAMLDocumentHolder documentHolder) throws ProcessingException {
        if (this.validateSignature) {
            try {
                if (this.isPostBinding()) {
                    this.verifyPostBindingSignature(documentHolder);
                } else {
                    this.verifyRedirectBindingSignature(httpContext);
                }
            }
            catch (IssuerNotTrustedException e) {
                throw new ProcessingException("PL00009: Invalid Digital Signature:Signature Validation failed. Issuer is not trusted by this Service Provider", e);
            }
            catch (Exception e) {
                throw new ProcessingException("PL00009: Invalid Digital Signature:Signature Validation failed", e);
            }
        }
    }

    private SAMLDocumentHolder getSAMLDocumentHolder(String samlResponse) throws ParsingException, ConfigurationException, ProcessingException {
        SAML2Response saml2Response = new SAML2Response();
        InputStream dataStream = null;
        dataStream = this.isPostBinding() ? PostBindingUtil.base64DecodeAsStream(samlResponse) : RedirectBindingUtil.base64DeflateDecode(samlResponse);
        saml2Response.getSAML2ObjectFromStream(dataStream);
        return saml2Response.getSamlDocumentHolder();
    }

    private void verifyRedirectBindingSignature(HTTPContext httpContext) throws IssuerNotTrustedException, ProcessingException {
        if (this.keyManager == null) {
            throw new IllegalStateException("PL000023: Trust Key Manager Missing");
        }
        boolean isValidSignature = false;
        try {
            String queryString = httpContext.getRequest().getQueryString();
            byte[] sigValue = RedirectBindingSignatureUtil.getSignatureValueFromSignedURL(queryString);
            if (sigValue == null) {
                throw new ProcessingException("PL00009: Invalid Digital Signature:Signature Validation failed. Signature is not present. Check if the IDP is supporting signatures.");
            }
            isValidSignature = RedirectBindingSignatureUtil.validateSignature(queryString, this.getIDPPublicKey(), sigValue);
        }
        catch (Exception e) {
            throw new ProcessingException("PL00009: Invalid Digital Signature:Signature Validation failed", e);
        }
        if (!isValidSignature) {
            throw new IssuerNotTrustedException("PL00009: Invalid Digital Signature:Signature Validation failed");
        }
    }

    private PublicKey getIDPPublicKey() throws TrustKeyConfigurationException, TrustKeyProcessingException {
        if (this.keyManager == null) {
            throw new TrustKeyConfigurationException("PL000023: Trust Key Manager Missing");
        }
        String idpValidatingAlias = (String)this.keyManager.getAdditionalOption("idp.key");
        if (StringUtil.isNullOrEmpty(idpValidatingAlias)) {
            idpValidatingAlias = this.safeURL(this.spConfiguration.getIdentityURL()).getHost();
        }
        return this.keyManager.getValidatingKey(idpValidatingAlias);
    }

    private void verifyPostBindingSignature(SAMLDocumentHolder samlDocumentHolder) throws IssuerNotTrustedException, ProcessingException {
        if (this.keyManager == null) {
            throw new IllegalStateException("PL000023: Trust Key Manager Missing");
        }
        boolean sigResult = false;
        try {
            PublicKey publicKey = this.getIDPPublicKey();
            if (this.trace) {
                log.trace((Object)"Going to verify signature in the saml response from IDP");
            }
            sigResult = new SAML2Signature().validate(samlDocumentHolder.getSamlDocument(), publicKey);
            if (this.trace) {
                log.trace((Object)("Signature verification=" + sigResult));
            }
        }
        catch (Exception e) {
            throw new ProcessingException("PL00009: Invalid Digital Signature:Signature Validation failed", e);
        }
        if (!sigResult) {
            throw new IssuerNotTrustedException("PL00009: Invalid Digital Signature:Signature Validation failed");
        }
    }
}

