/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.service;

import java.io.File;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.management.MBeanServer;
import javax.naming.spi.ObjectFactory;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.jmx.MBeanServerService;
import org.jboss.as.naming.InitialContext;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.osgi.OSGiConstants;
import org.jboss.as.osgi.OSGiLogger;
import org.jboss.as.osgi.OSGiMessages;
import org.jboss.as.osgi.management.OSGiRuntimeResource;
import org.jboss.as.osgi.parser.SubsystemState;
import org.jboss.as.osgi.service.AutoInstallIntegration;
import org.jboss.as.osgi.service.BundleReferenceClassLoader;
import org.jboss.as.osgi.service.JAXPServiceProvider;
import org.jboss.as.osgi.service.ModuleIdentityArtifactProvider;
import org.jboss.as.osgi.service.ModuleLoaderIntegration;
import org.jboss.as.osgi.service.RepositoryProvider;
import org.jboss.as.osgi.service.ResolverService;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.ServerEnvironmentService;
import org.jboss.modules.DependencySpec;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleClassLoaderFactory;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.ModuleSpec;
import org.jboss.modules.filter.PathFilter;
import org.jboss.modules.filter.PathFilters;
import org.jboss.modules.log.ModuleLogger;
import org.jboss.msc.service.AbstractService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.framework.BundleManager;
import org.jboss.osgi.framework.FrameworkModuleProvider;
import org.jboss.osgi.framework.IntegrationServices;
import org.jboss.osgi.framework.Services;
import org.jboss.osgi.framework.SystemPathsProvider;
import org.jboss.osgi.framework.SystemServicesProvider;
import org.jboss.osgi.framework.internal.FrameworkBuilder;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public class FrameworkBootstrapService
implements Service<Void> {
    static final ServiceName FRAMEWORK_BOOTSTRAP = OSGiConstants.FRAMEWORK_BASE_NAME.append(new String[]{"bootstrap"});
    static final String MAPPED_OSGI_SOCKET_BINDINGS = "org.jboss.as.osgi.socket.bindings";
    private final InjectedValue<ServerEnvironment> injectedServerEnvironment = new InjectedValue();
    private final InjectedValue<SubsystemState> injectedSubsystemState = new InjectedValue();
    private final InjectedValue<SocketBinding> httpServerPortBinding = new InjectedValue();
    private final OSGiRuntimeResource resource;

    public static ServiceController<Void> addService(ServiceTarget target, OSGiRuntimeResource resource, ServiceVerificationHandler verificationHandler) {
        FrameworkBootstrapService service = new FrameworkBootstrapService(resource);
        ServiceBuilder builder = target.addService(FRAMEWORK_BOOTSTRAP, (Service)service);
        builder.addDependency(ServerEnvironmentService.SERVICE_NAME, ServerEnvironment.class, service.injectedServerEnvironment);
        builder.addDependency(SubsystemState.SERVICE_NAME, SubsystemState.class, service.injectedSubsystemState);
        builder.addDependency(SocketBinding.JBOSS_BINDING_NAME.append(new String[]{"osgi-http"}), SocketBinding.class, service.httpServerPortBinding);
        builder.addListener((org.jboss.msc.service.ServiceListener)verificationHandler);
        return builder.install();
    }

    private FrameworkBootstrapService(OSGiRuntimeResource resource) {
        this.resource = resource;
    }

    public synchronized void start(StartContext context) throws StartException {
        ServiceController controller = context.getController();
        OSGiLogger.LOGGER.tracef("Starting: %s in mode %s", controller.getName(), controller.getMode());
        try {
            ServiceContainer serviceContainer = context.getController().getServiceContainer();
            SubsystemState subsystemState = (SubsystemState)this.injectedSubsystemState.getValue();
            HashMap<String, Object> props = new HashMap<String, Object>(subsystemState.getProperties());
            this.setupIntegrationProperties(context, props);
            Module coreFrameworkModule = ((ModuleClassLoader)FrameworkBuilder.class.getClassLoader()).getModule();
            Module.registerURLStreamHandlerFactoryModule((Module)coreFrameworkModule);
            Module.registerContentHandlerFactoryModule((Module)coreFrameworkModule);
            ServiceTarget serviceTarget = context.getChildTarget();
            AutoInstallIntegration.addService(serviceTarget);
            FrameworkModuleIntegration.addService(serviceTarget, props);
            JAXPServiceProvider.addService(serviceTarget);
            ModuleLoaderIntegration.addService(serviceTarget);
            ModuleIdentityArtifactProvider.addService(serviceTarget);
            RepositoryProvider.addService(serviceTarget);
            ResolverService.addService(serviceTarget);
            SystemServicesIntegration.addService(serviceTarget, this.resource);
            SubsystemState.Activation activation = subsystemState.getActivationPolicy();
            ServiceController.Mode initialMode = activation == SubsystemState.Activation.EAGER ? ServiceController.Mode.ACTIVE : ServiceController.Mode.ON_DEMAND;
            FrameworkBuilder builder = new FrameworkBuilder(props, initialMode);
            builder.setServiceContainer(serviceContainer);
            builder.setServiceTarget(serviceTarget);
            builder.createFrameworkServices(true);
        }
        catch (Throwable th) {
            throw OSGiMessages.MESSAGES.startFailedToCreateFrameworkServices(th);
        }
    }

    public synchronized void stop(StopContext context) {
        ServiceController controller = context.getController();
        OSGiLogger.LOGGER.tracef("Stopping: %s in mode %s", controller.getName(), controller.getMode());
    }

    public Void getValue() throws IllegalStateException {
        return null;
    }

    private void setupIntegrationProperties(StartContext context, Map<String, Object> props) {
        String extrapackages;
        String syspackages;
        String sysmodules;
        ModuleLogger moduleLogger;
        props.put("org.osgi.service.http.port", "" + ((SocketBinding)this.httpServerPortBinding.getValue()).getSocketAddress().getPort());
        String storage = (String)props.get("org.osgi.framework.storage");
        if (storage == null) {
            ServerEnvironment environment = (ServerEnvironment)this.injectedServerEnvironment.getValue();
            File dataDir = environment.getServerDataDir();
            storage = dataDir.getAbsolutePath() + File.separator + "osgi-store";
            props.put("org.osgi.framework.storage", storage);
        }
        if ((moduleLogger = Module.getModuleLogger()) != null) {
            props.put(ModuleLogger.class.getName(), moduleLogger.getClass().getName());
        }
        if ((sysmodules = (String)props.get("org.jboss.osgi.system.modules")) == null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("javax.api,");
            buffer.append("javax.inject.api,");
            buffer.append("org.apache.xerces,");
            buffer.append("org.jboss.as.configadmin,");
            buffer.append("org.jboss.as.osgi,");
            buffer.append("org.jboss.logging,");
            buffer.append("org.jboss.modules,");
            buffer.append("org.jboss.msc,");
            buffer.append("org.jboss.osgi.framework,");
            buffer.append("org.jboss.osgi.repository,");
            buffer.append("org.slf4j");
            props.put("org.jboss.osgi.system.modules", buffer.toString());
        }
        if ((syspackages = (String)props.get("org.jboss.osgi.system.packages")) == null) {
            LinkedHashSet<String> sysPackages = new LinkedHashSet<String>();
            sysPackages.addAll(Arrays.asList(SystemPathsProvider.DEFAULT_SYSTEM_PACKAGES));
            sysPackages.addAll(Arrays.asList(SystemPathsProvider.DEFAULT_FRAMEWORK_PACKAGES));
            sysPackages.add("javax.inject");
            sysPackages.add("org.apache.xerces.jaxp");
            sysPackages.add("org.jboss.as.configadmin.service");
            sysPackages.add("org.jboss.as.osgi.service");
            sysPackages.add("org.jboss.logging;version=3.1.0");
            sysPackages.add("org.jboss.osgi.repository;version=1.0");
            sysPackages.add("org.osgi.service.repository;version=1.0");
            sysPackages.add("org.slf4j;version=1.6.1");
            syspackages = ((Object)sysPackages).toString();
            syspackages = syspackages.substring(1, syspackages.length() - 1);
            props.put("org.jboss.osgi.system.packages", syspackages);
        }
        if ((extrapackages = (String)props.get("org.osgi.framework.system.packages.extra")) != null) {
            syspackages = syspackages + "," + extrapackages;
        }
        props.put("org.osgi.framework.system.packages.extra", syspackages);
    }

    private static class JNDIServiceListener
    implements ServiceListener {
        private static final String OSGI_JNDI_URL_SCHEME = "osgi.jndi.url.scheme";
        private final BundleContext bundleContext;

        public JNDIServiceListener(BundleContext bundleContext) {
            this.bundleContext = bundleContext;
            try {
                ServiceReference[] refs = bundleContext.getServiceReferences(ObjectFactory.class.getName(), null);
                if (refs != null) {
                    for (ServiceReference ref : refs) {
                        this.handleJNDIRegistration(ref, true);
                    }
                }
            }
            catch (InvalidSyntaxException ex) {
                throw new IllegalStateException(ex);
            }
        }

        public void serviceChanged(ServiceEvent event) {
            ServiceReference ref = event.getServiceReference();
            switch (event.getType()) {
                case 1: {
                    this.handleJNDIRegistration(ref, true);
                    break;
                }
                case 4: {
                    this.handleJNDIRegistration(ref, false);
                }
            }
        }

        private void handleJNDIRegistration(ServiceReference ref, boolean register) {
            String[] objClasses;
            for (String objClass : objClasses = (String[])ref.getProperty("objectClass")) {
                if (!ObjectFactory.class.getName().equals(objClass)) continue;
                for (String scheme : JNDIServiceListener.getStringPlusProperty(ref.getProperty(OSGI_JNDI_URL_SCHEME))) {
                    if (register) {
                        InitialContext.addUrlContextFactory((String)scheme, (ObjectFactory)((ObjectFactory)this.bundleContext.getService(ref)));
                        continue;
                    }
                    InitialContext.removeUrlContextFactory((String)scheme, (ObjectFactory)((ObjectFactory)this.bundleContext.getService(ref)));
                }
            }
        }

        private static Collection<String> getStringPlusProperty(Object property) {
            if (property instanceof Collection) {
                return (Collection)property;
            }
            if (property instanceof String[]) {
                return Arrays.asList((String[])property);
            }
            if (property instanceof String) {
                return Collections.singleton((String)property);
            }
            return Collections.emptyList();
        }
    }

    private static final class FrameworkModuleIntegration
    implements FrameworkModuleProvider {
        private final Map<String, Object> props;
        private Module frameworkModule;

        private static ServiceController<?> addService(ServiceTarget target, Map<String, Object> props) {
            FrameworkModuleIntegration service = new FrameworkModuleIntegration(props);
            ServiceBuilder builder = target.addService(IntegrationServices.FRAMEWORK_MODULE_PROVIDER, (Service)service);
            builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
            return builder.install();
        }

        private FrameworkModuleIntegration(Map<String, Object> props) {
            this.props = props;
        }

        public void start(StartContext context) throws StartException {
            ServiceController controller = context.getController();
            OSGiLogger.LOGGER.tracef("Starting: %s in mode %s", controller.getName(), controller.getMode());
        }

        public void stop(StopContext context) {
            ServiceController controller = context.getController();
            OSGiLogger.LOGGER.tracef("Stopping: %s in mode %s", controller.getName(), controller.getMode());
            this.frameworkModule = null;
        }

        public FrameworkModuleProvider getValue() throws IllegalStateException {
            return this;
        }

        public Module getFrameworkModule(Bundle systemBundle) {
            if (this.frameworkModule == null) {
                this.frameworkModule = this.createFrameworkModule(systemBundle);
            }
            return this.frameworkModule;
        }

        private Module createFrameworkModule(Bundle systemBundle) {
            String extramodules;
            ModuleSpec.Builder specBuilder = ModuleSpec.build((ModuleIdentifier)ModuleIdentifier.create((String)"jbosgi.framework"));
            String sysmodules = (String)this.props.get("org.jboss.osgi.system.modules");
            if (sysmodules == null) {
                sysmodules = "";
            }
            if ((extramodules = (String)this.props.get("org.jboss.osgi.system.modules.extra")) != null) {
                sysmodules = sysmodules + "," + extramodules;
            }
            ModuleLoader bootLoader = Module.getBootModuleLoader();
            PathFilter acceptAll = PathFilters.acceptAll();
            for (String modid : sysmodules.split(",")) {
                if ((modid = modid.trim()).length() <= 0) continue;
                ModuleIdentifier identifier = ModuleIdentifier.create((String)modid);
                specBuilder.addDependency(DependencySpec.createModuleDependencySpec((PathFilter)acceptAll, (PathFilter)acceptAll, (ModuleLoader)bootLoader, (ModuleIdentifier)identifier, (boolean)false));
            }
            specBuilder.setModuleClassLoaderFactory((ModuleClassLoaderFactory)new BundleReferenceClassLoader.Factory(systemBundle));
            try {
                final ModuleSpec moduleSpec = specBuilder.create();
                ModuleLoader moduleLoader = new ModuleLoader(){

                    protected ModuleSpec findModule(ModuleIdentifier identifier) throws ModuleLoadException {
                        return moduleSpec.getModuleIdentifier().equals(identifier) ? moduleSpec : null;
                    }

                    public String toString() {
                        return "FrameworkModuleLoader";
                    }
                };
                return moduleLoader.loadModule(specBuilder.getIdentifier());
            }
            catch (ModuleLoadException ex) {
                throw new IllegalStateException(ex);
            }
        }
    }

    private static final class SystemServicesIntegration
    implements Service<SystemServicesProvider>,
    SystemServicesProvider {
        private final InjectedValue<MBeanServer> injectedMBeanServer = new InjectedValue();
        private final InjectedValue<BundleManager> injectedBundleManager = new InjectedValue();
        private final InjectedValue<BundleContext> injectedBundleContext = new InjectedValue();
        private final OSGiRuntimeResource resource;
        private ServiceContainer serviceContainer;
        private JNDIServiceListener jndiServiceListener;

        public static ServiceController<?> addService(ServiceTarget target, OSGiRuntimeResource resource) {
            SystemServicesIntegration service = new SystemServicesIntegration(resource);
            ServiceBuilder builder = target.addService(IntegrationServices.SYSTEM_SERVICES_PROVIDER, (Service)service);
            builder.addDependency(MBeanServerService.SERVICE_NAME, MBeanServer.class, service.injectedMBeanServer);
            builder.addDependency(Services.BUNDLE_MANAGER, BundleManager.class, service.injectedBundleManager);
            builder.addDependency(Services.SYSTEM_CONTEXT, BundleContext.class, service.injectedBundleContext);
            builder.addDependency(Services.FRAMEWORK_CREATE);
            builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
            return builder.install();
        }

        private SystemServicesIntegration(OSGiRuntimeResource resource) {
            this.resource = resource;
        }

        public void start(StartContext context) throws StartException {
            ServiceController controller = context.getController();
            OSGiLogger.LOGGER.tracef("Starting: %s in mode %s", controller.getName(), controller.getMode());
            this.serviceContainer = context.getController().getServiceContainer();
            final BundleContext syscontext = (BundleContext)this.injectedBundleContext.getValue();
            BundleManager bundleManager = (BundleManager)this.injectedBundleManager.getValue();
            this.resource.getInjectedBundleManager().inject((Object)bundleManager);
            this.jndiServiceListener = new JNDIServiceListener(syscontext);
            try {
                String filter = "(objectClass=" + ObjectFactory.class.getName() + ")";
                syscontext.addServiceListener((ServiceListener)this.jndiServiceListener, filter);
            }
            catch (InvalidSyntaxException e) {
                // empty catch block
            }
            String bindingNames = syscontext.getProperty(FrameworkBootstrapService.MAPPED_OSGI_SOCKET_BINDINGS);
            if (bindingNames != null) {
                final HashSet<ServiceName> socketBindingNames = new HashSet<ServiceName>();
                for (String suffix : bindingNames.split(",")) {
                    socketBindingNames.add(SocketBinding.JBOSS_BINDING_NAME.append(new String[]{suffix}));
                }
                ServiceTarget serviceTarget = context.getChildTarget();
                ServiceName serviceName = IntegrationServices.SYSTEM_SERVICES_PROVIDER.append(new String[]{"BINDINGS"});
                ServiceBuilder builder = serviceTarget.addService(serviceName, (Service)new AbstractService<Void>(){

                    public void start(StartContext context) throws StartException {
                        for (ServiceName serviceName : socketBindingNames) {
                            SocketBinding binding = (SocketBinding)SystemServicesIntegration.this.serviceContainer.getRequiredService(serviceName).getValue();
                            Hashtable<String, String> props = new Hashtable<String, String>();
                            ((Dictionary)props).put("socketBinding", serviceName.getSimpleName());
                            InetSocketAddress value = binding.getSocketAddress();
                            syscontext.registerService(InetSocketAddress.class.getName(), (Object)value, props);
                        }
                    }
                });
                ServiceName[] serviceNameArray = socketBindingNames.toArray(new ServiceName[socketBindingNames.size()]);
                builder.addDependencies(serviceNameArray);
                builder.install();
            }
        }

        public void stop(StopContext context) {
            ServiceController controller = context.getController();
            OSGiLogger.LOGGER.tracef("Stopping: %s in mode %s", controller.getName(), controller.getMode());
            ((BundleContext)this.injectedBundleContext.getValue()).removeServiceListener((ServiceListener)this.jndiServiceListener);
            this.resource.getInjectedBundleManager().uninject();
        }

        public SystemServicesProvider getValue() {
            return this;
        }

        public void registerSystemServices(BundleContext context) {
            MBeanServer mbeanServer = (MBeanServer)this.injectedMBeanServer.getValue();
            context.registerService(MBeanServer.class.getName(), (Object)mbeanServer, null);
            context.registerService(ServiceContainer.class.getName(), (Object)this.serviceContainer, null);
        }
    }
}

