/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.spi.internal;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import org.jboss.osgi.spi.framework.OSGiBootstrapProvider;
import org.jboss.osgi.spi.framework.PropertiesBootstrapProvider;
import org.jboss.osgi.spi.internal.SPILogger;
import org.jboss.osgi.spi.internal.SPIMessages;
import org.jboss.osgi.spi.util.ServiceLoader;
import org.osgi.framework.BundleException;
import org.osgi.framework.launch.Framework;

public class OSGiBootstrapBean {
    public void run() {
        this.initBootstrap();
        OSGiBootstrapProvider bootProvider = OSGiBootstrapBean.getBootstrapProvider();
        Framework framework = bootProvider.getFramework();
        Runtime runtime = Runtime.getRuntime();
        runtime.addShutdownHook(new ShutdownThread(framework));
        StartupThread thread = new StartupThread(framework);
        thread.start();
    }

    private void initBootstrap() {
        Properties defaults = new Properties();
        SPILogger.LOGGER.debugf("JBoss OSGi System Properties", new Object[0]);
        Enumeration<?> defaultNames = defaults.propertyNames();
        while (defaultNames.hasMoreElements()) {
            String propName = (String)defaultNames.nextElement();
            String sysValue = System.getProperty(propName);
            if (sysValue != null) continue;
            String propValue = defaults.getProperty(propName);
            System.setProperty(propName, propValue);
            SPILogger.LOGGER.debugf("   %s=%s", propName, propValue);
        }
    }

    public static OSGiBootstrapProvider getBootstrapProvider() {
        OSGiBootstrapProvider provider = null;
        List<OSGiBootstrapProvider> providers = ServiceLoader.loadServices(OSGiBootstrapProvider.class);
        for (OSGiBootstrapProvider aux : providers) {
            try {
                aux.configure();
                provider = aux;
                break;
            }
            catch (Exception ex) {
                SPILogger.LOGGER.debugf(ex, "Cannot configure [%s]", aux.getClass().getName());
            }
        }
        if (provider == null) {
            provider = new PropertiesBootstrapProvider();
            SPILogger.LOGGER.debugf("Using default: %s", PropertiesBootstrapProvider.class.getName());
        }
        return provider;
    }

    class ShutdownThread
    extends Thread {
        private Framework framework;

        public ShutdownThread(Framework framework) {
            this.framework = framework;
        }

        @Override
        public void run() {
            SPILogger.LOGGER.infoInitiatingShutdown();
            try {
                this.framework.stop();
                this.framework.waitForStop(5000L);
            }
            catch (Exception ex) {
                SPILogger.LOGGER.errorCannotStopFramework(ex);
            }
            SPILogger.LOGGER.infoShutdownComplete();
        }
    }

    class StartupThread
    extends Thread {
        private Framework framework;

        public StartupThread(Framework framework) {
            this.framework = framework;
        }

        @Override
        public void run() {
            long beforeStart = System.currentTimeMillis();
            try {
                this.framework.start();
            }
            catch (BundleException ex) {
                throw SPIMessages.MESSAGES.illegalStateCannotStartFramework(ex);
            }
            float diff = (float)(System.currentTimeMillis() - beforeStart) / 1000.0f;
            SPILogger.LOGGER.infoRuntimeBooted(diff);
            InputStreamReader br = new InputStreamReader(System.in);
            try {
                int inByte = ((Reader)br).read();
                while (inByte != -1) {
                    inByte = ((Reader)br).read();
                }
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
    }
}

