/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.transaction;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.versioning.EntryVersionsMap;
import org.infinispan.transaction.xa.CacheTransaction;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public abstract class AbstractCacheTransaction
implements CacheTransaction {
    protected final GlobalTransaction tx;
    private static Log log = LogFactory.getLog(AbstractCacheTransaction.class);
    private static final boolean trace = log.isTraceEnabled();
    private static final int INITIAL_LOCK_CAPACITY = 4;
    protected List<WriteCommand> modifications;
    protected HashMap<Object, CacheEntry> lookedUpEntries;
    protected Set<Object> affectedKeys = null;
    protected Set<Object> lockedKeys;
    protected Set<Object> backupKeyLocks = null;
    private boolean txComplete = false;
    protected volatile boolean prepared;
    private volatile boolean needToNotifyWaiters = false;
    final int viewId;
    private EntryVersionsMap updatedEntryVersions;

    public AbstractCacheTransaction(GlobalTransaction tx, int viewId) {
        this.tx = tx;
        this.viewId = viewId;
    }

    @Override
    public GlobalTransaction getGlobalTransaction() {
        return this.tx;
    }

    @Override
    public List<WriteCommand> getModifications() {
        return this.modifications;
    }

    public void setModifications(WriteCommand[] modifications) {
        this.modifications = Arrays.asList(modifications);
    }

    @Override
    public Map<Object, CacheEntry> getLookedUpEntries() {
        return this.lookedUpEntries;
    }

    @Override
    public CacheEntry lookupEntry(Object key) {
        if (this.lookedUpEntries == null) {
            return null;
        }
        return this.lookedUpEntries.get(key);
    }

    @Override
    public void removeLookedUpEntry(Object key) {
        if (this.lookedUpEntries != null) {
            this.lookedUpEntries.remove(key);
        }
    }

    @Override
    public void clearLookedUpEntries() {
        this.lookedUpEntries = null;
    }

    @Override
    public boolean ownsLock(Object key) {
        return this.getLockedKeys().contains(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyOnTransactionFinished() {
        if (trace) {
            log.tracef("Transaction %s has completed, notifying listening threads.", this.tx);
        }
        this.txComplete = true;
        if (this.needToNotifyWaiters) {
            AbstractCacheTransaction abstractCacheTransaction = this;
            synchronized (abstractCacheTransaction) {
                this.txComplete = true;
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean waitForLockRelease(Object key, long lockAcquisitionTimeout) throws InterruptedException {
        if (this.txComplete) {
            return true;
        }
        boolean potentiallyLocked = this.hasLockOrIsLockBackup(key);
        if (trace) {
            log.tracef("Transaction gtx=%s potentially locks key %s? %s", this.tx, key, potentiallyLocked);
        }
        if (potentiallyLocked) {
            AbstractCacheTransaction abstractCacheTransaction = this;
            synchronized (abstractCacheTransaction) {
                this.needToNotifyWaiters = true;
                if (this.txComplete) {
                    this.needToNotifyWaiters = false;
                    return true;
                }
                this.wait(lockAcquisitionTimeout);
                return this.txComplete;
            }
        }
        return true;
    }

    @Override
    public int getViewId() {
        return this.viewId;
    }

    @Override
    public void addBackupLockForKey(Object key) {
        if (this.backupKeyLocks == null) {
            this.backupKeyLocks = new HashSet<Object>(4);
        }
        this.backupKeyLocks.add(key);
    }

    public void registerLockedKey(Object key) {
        if (this.lockedKeys == null) {
            this.lockedKeys = new HashSet<Object>(4);
        }
        if (trace) {
            log.tracef("Registering locked key: %s", key);
        }
        this.lockedKeys.add(key);
    }

    @Override
    public Set<Object> getLockedKeys() {
        return this.lockedKeys == null ? Collections.emptySet() : this.lockedKeys;
    }

    @Override
    public void clearLockedKeys() {
        if (trace) {
            log.tracef("Clearing locked keys: %s", this.lockedKeys);
        }
        this.lockedKeys = null;
    }

    private boolean hasLockOrIsLockBackup(Object key) {
        return this.lockedKeys != null && this.lockedKeys.contains(key) || this.backupKeyLocks != null && this.backupKeyLocks.contains(key);
    }

    public Set<Object> getAffectedKeys() {
        return this.affectedKeys == null ? Collections.emptySet() : this.affectedKeys;
    }

    public void addAffectedKey(Object key) {
        this.initAffectedKeys();
        this.affectedKeys.add(key);
    }

    public void addAllAffectedKeys(Collection<Object> keys) {
        this.initAffectedKeys();
        this.affectedKeys.addAll(keys);
    }

    private void initAffectedKeys() {
        if (this.affectedKeys == null) {
            this.affectedKeys = new HashSet<Object>(4);
        }
    }

    @Override
    public EntryVersionsMap getUpdatedEntryVersions() {
        return this.updatedEntryVersions;
    }

    @Override
    public void setUpdatedEntryVersions(EntryVersionsMap updatedEntryVersions) {
        this.updatedEntryVersions = updatedEntryVersions;
    }

    @Override
    public void addReadKey(Object key) {
    }

    @Override
    public boolean keyRead(Object key) {
        return false;
    }
}

