/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.naming.directory.DirContext;
import javax.servlet.ServletException;
import org.apache.catalina.Cluster;
import org.apache.catalina.Container;
import org.apache.catalina.ContainerEvent;
import org.apache.catalina.ContainerListener;
import org.apache.catalina.Context;
import org.apache.catalina.Globals;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Loader;
import org.apache.catalina.Manager;
import org.apache.catalina.Pipeline;
import org.apache.catalina.Realm;
import org.apache.catalina.Valve;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardEngine;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.core.StandardPipeline;
import org.apache.catalina.core.StandardWrapper;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.util.StringManager;
import org.apache.naming.resources.ProxyDirContext;
import org.apache.tomcat.util.Constants;
import org.apache.tomcat.util.modeler.Registry;
import org.jboss.logging.Logger;

public abstract class ContainerBase
implements Container,
Lifecycle,
Pipeline,
MBeanRegistration {
    private static Logger log = Logger.getLogger(ContainerBase.class);
    protected static final Container[] CONTAINER_ARRAY = new Container[0];
    protected static final ContainerListener[] LISTENER_ARRAY = new ContainerListener[0];
    protected Map<String, Container> children = new ConcurrentHashMap<String, Container>();
    protected int backgroundProcessorDelay = -1;
    protected LifecycleSupport lifecycle = new LifecycleSupport(this);
    protected List<ContainerListener> listeners = new CopyOnWriteArrayList<ContainerListener>();
    protected Loader loader = null;
    protected Logger logger = null;
    protected String logName = null;
    protected Manager manager = null;
    protected Cluster cluster = null;
    protected String name = null;
    protected Container parent = null;
    protected ClassLoader parentClassLoader = null;
    protected Pipeline pipeline = new StandardPipeline(this);
    protected Realm realm = null;
    protected DirContext resources = null;
    protected static StringManager sm = StringManager.getManager("org.apache.catalina.core");
    protected boolean started = false;
    protected boolean initialized = false;
    protected boolean startChildren = true;
    protected PropertyChangeSupport support = new PropertyChangeSupport(this);
    private Thread thread = null;
    private boolean threadDone = false;
    protected String type;
    protected String domain;
    protected String suffix;
    protected ObjectName oname;
    protected ObjectName controller;
    protected MBeanServer mserver;

    @Override
    public boolean isStarted() {
        return this.started;
    }

    @Override
    public int getBackgroundProcessorDelay() {
        return this.backgroundProcessorDelay;
    }

    @Override
    public void setBackgroundProcessorDelay(int delay) {
        this.backgroundProcessorDelay = delay;
    }

    @Override
    public String getInfo() {
        return this.getClass().getName();
    }

    @Override
    public Loader getLoader() {
        if (this.loader != null) {
            return this.loader;
        }
        if (this.parent != null) {
            return this.parent.getLoader();
        }
        return null;
    }

    @Override
    public synchronized void setLoader(Loader loader) {
        Loader oldLoader = this.loader;
        if (oldLoader == loader) {
            return;
        }
        this.loader = loader;
        if (this.started && oldLoader != null && oldLoader instanceof Lifecycle) {
            try {
                ((Lifecycle)((Object)oldLoader)).stop();
            }
            catch (LifecycleException e) {
                log.error((Object)"ContainerBase.setLoader: stop: ", (Throwable)e);
            }
        }
        if (loader != null) {
            loader.setContainer(this);
        }
        if (this.started && loader != null && loader instanceof Lifecycle) {
            try {
                ((Lifecycle)((Object)loader)).start();
            }
            catch (LifecycleException e) {
                log.error((Object)"ContainerBase.setLoader: start: ", (Throwable)e);
            }
        }
        this.support.firePropertyChange("loader", oldLoader, this.loader);
    }

    @Override
    public Logger getLogger() {
        if (this.logger != null) {
            return this.logger;
        }
        this.logger = Logger.getLogger((String)this.logName());
        return this.logger;
    }

    @Override
    public Manager getManager() {
        if (this.manager != null) {
            return this.manager;
        }
        if (this.parent != null) {
            return this.parent.getManager();
        }
        return null;
    }

    @Override
    public synchronized void setManager(Manager manager) {
        Manager oldManager = this.manager;
        if (oldManager == manager) {
            return;
        }
        this.manager = manager;
        if (this.started && oldManager != null && oldManager instanceof Lifecycle) {
            try {
                ((Lifecycle)((Object)oldManager)).stop();
            }
            catch (LifecycleException e) {
                log.error((Object)"ContainerBase.setManager: stop: ", (Throwable)e);
            }
        }
        if (manager != null) {
            manager.setContainer(this);
        }
        if (this.started && manager != null && manager instanceof Lifecycle) {
            try {
                ((Lifecycle)((Object)manager)).start();
            }
            catch (LifecycleException e) {
                log.error((Object)"ContainerBase.setManager: start: ", (Throwable)e);
            }
        }
        this.support.firePropertyChange("manager", oldManager, this.manager);
    }

    @Override
    public Object getMappingObject() {
        return this;
    }

    @Override
    public Cluster getCluster() {
        if (this.cluster != null) {
            return this.cluster;
        }
        if (this.parent != null) {
            return this.parent.getCluster();
        }
        return null;
    }

    @Override
    public synchronized void setCluster(Cluster cluster) {
        Cluster oldCluster = this.cluster;
        if (oldCluster == cluster) {
            return;
        }
        this.cluster = cluster;
        if (this.started && oldCluster != null && oldCluster instanceof Lifecycle) {
            try {
                ((Lifecycle)((Object)oldCluster)).stop();
            }
            catch (LifecycleException e) {
                log.error((Object)"ContainerBase.setCluster: stop: ", (Throwable)e);
            }
        }
        if (cluster != null) {
            cluster.setContainer(this);
        }
        if (this.started && cluster != null && cluster instanceof Lifecycle) {
            try {
                ((Lifecycle)((Object)cluster)).start();
            }
            catch (LifecycleException e) {
                log.error((Object)"ContainerBase.setCluster: start: ", (Throwable)e);
            }
        }
        this.support.firePropertyChange("cluster", oldCluster, this.cluster);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        String oldName = this.name;
        this.name = name;
        this.support.firePropertyChange("name", oldName, this.name);
    }

    public boolean getStartChildren() {
        return this.startChildren;
    }

    public void setStartChildren(boolean startChildren) {
        boolean oldStartChildren = this.startChildren;
        this.startChildren = startChildren;
        this.support.firePropertyChange("startChildren", oldStartChildren, this.startChildren);
    }

    @Override
    public Container getParent() {
        return this.parent;
    }

    @Override
    public void setParent(Container container) {
        Container oldParent = this.parent;
        this.parent = container;
        this.support.firePropertyChange("parent", oldParent, this.parent);
    }

    @Override
    public ClassLoader getParentClassLoader() {
        if (this.parentClassLoader != null) {
            return this.parentClassLoader;
        }
        if (this.parent != null) {
            return this.parent.getParentClassLoader();
        }
        return ClassLoader.getSystemClassLoader();
    }

    @Override
    public void setParentClassLoader(ClassLoader parent) {
        ClassLoader oldParentClassLoader = this.parentClassLoader;
        this.parentClassLoader = parent;
        this.support.firePropertyChange("parentClassLoader", oldParentClassLoader, this.parentClassLoader);
    }

    @Override
    public Pipeline getPipeline() {
        return this.pipeline;
    }

    @Override
    public Realm getRealm() {
        if (this.realm != null) {
            return this.realm;
        }
        if (this.parent != null) {
            return this.parent.getRealm();
        }
        return null;
    }

    @Override
    public synchronized void setRealm(Realm realm) {
        Realm oldRealm = this.realm;
        if (oldRealm == realm) {
            return;
        }
        this.realm = realm;
        if (this.started && oldRealm != null && oldRealm instanceof Lifecycle) {
            try {
                ((Lifecycle)((Object)oldRealm)).stop();
            }
            catch (LifecycleException e) {
                log.error((Object)"ContainerBase.setRealm: stop: ", (Throwable)e);
            }
        }
        if (realm != null) {
            realm.setContainer(this);
        }
        if (this.started && realm != null && realm instanceof Lifecycle) {
            try {
                ((Lifecycle)((Object)realm)).start();
            }
            catch (LifecycleException e) {
                log.error((Object)"ContainerBase.setRealm: start: ", (Throwable)e);
            }
        }
        this.support.firePropertyChange("realm", oldRealm, this.realm);
    }

    @Override
    public DirContext getResources() {
        if (this.resources != null) {
            return this.resources;
        }
        if (this.parent != null) {
            return this.parent.getResources();
        }
        return null;
    }

    @Override
    public synchronized void setResources(DirContext resources) {
        DirContext oldResources = this.resources;
        if (oldResources == resources) {
            return;
        }
        Hashtable<String, Object> env = new Hashtable<String, Object>();
        if (this.getParent() != null) {
            env.put("host", this.getParent().getName());
        }
        env.put("context", this.getName());
        this.resources = new ProxyDirContext(env, resources);
        this.support.firePropertyChange("resources", oldResources, this.resources);
    }

    @Override
    public void addChild(Container child) {
        if (Globals.IS_SECURITY_ENABLED) {
            PrivilegedAddChild dp = new PrivilegedAddChild(child);
            AccessController.doPrivileged(dp);
        } else {
            this.addChildInternal(child);
        }
    }

    private synchronized void addChildInternal(Container child) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Add child " + child + " " + this));
        }
        if (child.getName() == null) {
            throw new IllegalArgumentException(sm.getString("containerBase.addChild.nullName"));
        }
        if (this.children.get(child.getName()) != null) {
            throw new IllegalArgumentException(sm.getString("containerBase.addChild.notUnique", child.getName()));
        }
        child.setParent(this);
        this.children.put(child.getName(), child);
        if (this.started && this.startChildren && child instanceof Lifecycle) {
            boolean success = false;
            try {
                ((Lifecycle)((Object)child)).start();
                success = true;
            }
            catch (LifecycleException e) {
                throw new IllegalStateException(sm.getString("containerBase.addChild.start", child.getName()), e);
            }
            finally {
                if (!success) {
                    this.children.remove(child.getName());
                }
            }
        }
        this.fireContainerEvent("addChild", child);
    }

    @Override
    public void addContainerListener(ContainerListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    @Override
    public Container findChild(String name) {
        if (name == null) {
            return null;
        }
        return this.children.get(name);
    }

    @Override
    public Container[] findChildren() {
        return this.children.values().toArray(CONTAINER_ARRAY);
    }

    @Override
    public ContainerListener[] findContainerListeners() {
        return this.listeners.toArray(LISTENER_ARRAY);
    }

    @Override
    public void invoke(Request request, Response response) throws IOException, ServletException {
        this.pipeline.getFirst().invoke(request, response);
    }

    @Override
    public synchronized void removeChild(Container child) {
        if (this.children.get(child.getName()) == null) {
            return;
        }
        if (this.children.get(child.getName()) != child) {
            return;
        }
        this.children.remove(child.getName());
        if (this.started && child instanceof Lifecycle) {
            try {
                if (child instanceof ContainerBase) {
                    if (((ContainerBase)child).started) {
                        ((Lifecycle)((Object)child)).stop();
                    }
                } else {
                    ((Lifecycle)((Object)child)).stop();
                }
            }
            catch (LifecycleException e) {
                log.error((Object)"ContainerBase.removeChild: stop: ", (Throwable)e);
            }
        }
        this.fireContainerEvent("removeChild", child);
    }

    @Override
    public void removeContainerListener(ContainerListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    @Override
    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    @Override
    public LifecycleListener[] findLifecycleListeners() {
        return this.lifecycle.findLifecycleListeners();
    }

    @Override
    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    @Override
    public synchronized void start() throws LifecycleException {
        if (this.started) {
            if (log.isInfoEnabled()) {
                log.info((Object)sm.getString("containerBase.alreadyStarted", this.logName()));
            }
            return;
        }
        this.lifecycle.fireLifecycleEvent("before_start", null);
        this.started = true;
        if (this.loader != null && this.loader instanceof Lifecycle) {
            ((Lifecycle)((Object)this.loader)).start();
        }
        this.logger = null;
        this.getLogger();
        if (this.logger != null && this.logger instanceof Lifecycle) {
            ((Lifecycle)this.logger).start();
        }
        if (this.manager != null && this.manager instanceof Lifecycle) {
            ((Lifecycle)((Object)this.manager)).start();
        }
        if (this.cluster != null && this.cluster instanceof Lifecycle) {
            ((Lifecycle)((Object)this.cluster)).start();
        }
        if (this.realm != null && this.realm instanceof Lifecycle) {
            ((Lifecycle)((Object)this.realm)).start();
        }
        if (this.resources != null && this.resources instanceof Lifecycle) {
            ((Lifecycle)((Object)this.resources)).start();
        }
        Container[] children = this.findChildren();
        for (int i = 0; i < children.length; ++i) {
            if (!(children[i] instanceof Lifecycle)) continue;
            ((Lifecycle)((Object)children[i])).start();
        }
        if (this.pipeline instanceof Lifecycle) {
            ((Lifecycle)((Object)this.pipeline)).start();
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        this.threadStart();
        this.lifecycle.fireLifecycleEvent("after_start", null);
    }

    @Override
    public synchronized void stop() throws LifecycleException {
        int i;
        if (!this.started) {
            if (log.isInfoEnabled()) {
                log.info((Object)sm.getString("containerBase.notStarted", this.logName()));
            }
            return;
        }
        this.lifecycle.fireLifecycleEvent("before_stop", null);
        this.threadStop();
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
        if (this.pipeline instanceof Lifecycle) {
            ((Lifecycle)((Object)this.pipeline)).stop();
        }
        Container[] children = this.findChildren();
        for (i = 0; i < children.length; ++i) {
            if (!(children[i] instanceof Lifecycle)) continue;
            ((Lifecycle)((Object)children[i])).stop();
        }
        children = this.findChildren();
        for (i = 0; i < children.length; ++i) {
            this.removeChild(children[i]);
        }
        if (this.resources != null && this.resources instanceof Lifecycle) {
            ((Lifecycle)((Object)this.resources)).stop();
        }
        if (this.realm != null && this.realm instanceof Lifecycle) {
            ((Lifecycle)((Object)this.realm)).stop();
        }
        if (this.cluster != null && this.cluster instanceof Lifecycle) {
            ((Lifecycle)((Object)this.cluster)).stop();
        }
        if (this.manager != null && this.manager instanceof Lifecycle) {
            ((Lifecycle)((Object)this.manager)).stop();
        }
        if (this.logger != null && this.logger instanceof Lifecycle) {
            ((Lifecycle)this.logger).stop();
        }
        if (this.loader != null && this.loader instanceof Lifecycle) {
            ((Lifecycle)((Object)this.loader)).stop();
        }
        this.lifecycle.fireLifecycleEvent("after_stop", null);
    }

    public void init() throws Exception {
        ObjectName parentName;
        if (this.getParent() == null && (parentName = this.getParentName()) != null && this.mserver.isRegistered(parentName)) {
            this.mserver.invoke(parentName, "addChild", new Object[]{this}, new String[]{"org.apache.catalina.Container"});
        }
        this.initialized = true;
    }

    public ObjectName getParentName() throws MalformedObjectNameException {
        return null;
    }

    public void destroy() throws Exception {
        if (this.started) {
            this.stop();
        }
        this.initialized = false;
        if (Constants.ENABLE_MODELER && this.oname != null) {
            try {
                if (this.controller == this.oname) {
                    Registry.getRegistry(null, null).unregisterComponent(this.oname);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("unregistering " + this.oname));
                    }
                }
            }
            catch (Throwable t) {
                log.error((Object)"Error unregistering ", t);
            }
        }
        if (this.parent != null) {
            this.parent.removeChild(this);
        }
        Container[] children = this.findChildren();
        for (int i = 0; i < children.length; ++i) {
            this.removeChild(children[i]);
        }
    }

    @Override
    public synchronized void addValve(Valve valve) {
        this.pipeline.addValve(valve);
        this.fireContainerEvent("addValve", valve);
    }

    public ObjectName[] getValveObjectNames() {
        return ((StandardPipeline)this.pipeline).getValveObjectNames();
    }

    @Override
    public Valve getBasic() {
        return this.pipeline.getBasic();
    }

    @Override
    public Valve getFirst() {
        return this.pipeline.getFirst();
    }

    @Override
    public Valve[] getValves() {
        return this.pipeline.getValves();
    }

    @Override
    public synchronized void removeValve(Valve valve) {
        this.pipeline.removeValve(valve);
        this.fireContainerEvent("removeValve", valve);
    }

    @Override
    public void setBasic(Valve valve) {
        this.pipeline.setBasic(valve);
    }

    @Override
    public void backgroundProcess() {
        if (!this.started) {
            return;
        }
        if (this.cluster != null) {
            try {
                this.cluster.backgroundProcess();
            }
            catch (Exception e) {
                log.warn((Object)sm.getString("containerBase.backgroundProcess.cluster", this.cluster), (Throwable)e);
            }
        }
        if (this.loader != null) {
            try {
                this.loader.backgroundProcess();
            }
            catch (Exception e) {
                log.warn((Object)sm.getString("containerBase.backgroundProcess.loader", this.loader), (Throwable)e);
            }
        }
        if (this.manager != null) {
            try {
                this.manager.backgroundProcess();
            }
            catch (Exception e) {
                log.warn((Object)sm.getString("containerBase.backgroundProcess.manager", this.manager), (Throwable)e);
            }
        }
        if (this.realm != null) {
            try {
                this.realm.backgroundProcess();
            }
            catch (Exception e) {
                log.warn((Object)sm.getString("containerBase.backgroundProcess.realm", this.realm), (Throwable)e);
            }
        }
        for (Valve current = this.pipeline.getFirst(); current != null; current = current.getNext()) {
            try {
                current.backgroundProcess();
                continue;
            }
            catch (Exception e) {
                log.warn((Object)sm.getString("containerBase.backgroundProcess.valve", current), (Throwable)e);
            }
        }
        this.lifecycle.fireLifecycleEvent("periodic", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fireContainerEvent(String type, Object data) {
        if (this.listeners.size() < 1) {
            return;
        }
        ContainerEvent event = new ContainerEvent(this, type, data);
        ContainerListener[] list = new ContainerListener[]{};
        List<ContainerListener> list2 = this.listeners;
        synchronized (list2) {
            list = this.listeners.toArray(list);
        }
        for (int i = 0; i < list.length; ++i) {
            list[i].containerEvent(event);
        }
    }

    protected String logName() {
        if (this.logName != null) {
            return this.logName;
        }
        String loggerName = null;
        for (Container current = this; current != null; current = current.getParent()) {
            String name = current.getName();
            if (name == null || name.equals("")) {
                name = "/";
            }
            loggerName = "[" + name + "]" + (loggerName != null ? "." + loggerName : "");
        }
        this.logName = ContainerBase.class.getName() + "." + loggerName;
        return this.logName;
    }

    public ObjectName getJmxName() {
        return this.oname;
    }

    @Override
    public String getObjectName() {
        if (this.oname != null) {
            return this.oname.toString();
        }
        return null;
    }

    public String getDomain() {
        if (this.domain == null) {
            Container parent;
            for (parent = this; parent != null && !(parent instanceof StandardEngine); parent = parent.getParent()) {
            }
            if (parent instanceof StandardEngine) {
                this.domain = ((StandardEngine)parent).getDomain();
            }
        }
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getType() {
        return this.type;
    }

    protected String getJSR77Suffix() {
        return this.suffix;
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.oname = name;
        this.mserver = server;
        if (name == null) {
            return null;
        }
        this.domain = name.getDomain();
        this.type = name.getKeyProperty("type");
        if (this.type == null) {
            this.type = name.getKeyProperty("j2eeType");
        }
        String j2eeApp = name.getKeyProperty("J2EEApplication");
        String j2eeServer = name.getKeyProperty("J2EEServer");
        if (j2eeApp == null) {
            j2eeApp = "none";
        }
        if (j2eeServer == null) {
            j2eeServer = "none";
        }
        this.suffix = ",J2EEApplication=" + j2eeApp + ",J2EEServer=" + j2eeServer;
        return name;
    }

    @Override
    public void postRegister(Boolean registrationDone) {
    }

    @Override
    public void preDeregister() throws Exception {
    }

    @Override
    public void postDeregister() {
    }

    public ObjectName[] getChildren() {
        ObjectName[] result = new ObjectName[this.children.size()];
        Iterator<Container> it = this.children.values().iterator();
        int i = 0;
        while (it.hasNext()) {
            Container next = it.next();
            if (!(next instanceof ContainerBase)) continue;
            result[i++] = ((ContainerBase)next).getJmxName();
        }
        return result;
    }

    public ObjectName createObjectName(String domain, ObjectName parent) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Create ObjectName " + domain + " " + parent));
        }
        return null;
    }

    public String getContainerSuffix() {
        ContainerBase container = this;
        Container context = null;
        Container host = null;
        ContainerBase servlet = null;
        StringBuilder suffix = new StringBuilder();
        if (container instanceof StandardHost) {
            host = container;
        } else if (container instanceof StandardContext) {
            host = container.getParent();
            context = container;
        } else if (container instanceof StandardWrapper) {
            context = container.getParent();
            host = context.getParent();
            servlet = container;
        }
        if (context != null) {
            String path = ((StandardContext)context).getPath();
            suffix.append(",path=").append(path.equals("") ? "/" : path);
        }
        if (host != null) {
            suffix.append(",host=").append(host.getName());
        }
        if (servlet != null) {
            String name = container.getName();
            suffix.append(",servlet=");
            suffix.append(name == "" ? "/" : name);
        }
        return suffix.toString();
    }

    protected void threadStart() {
        if (this.thread != null) {
            return;
        }
        if (this.backgroundProcessorDelay <= 0) {
            return;
        }
        this.threadDone = false;
        String threadName = "ContainerBackgroundProcessor[" + this.toString() + "]";
        this.thread = new Thread((Runnable)new ContainerBackgroundProcessor(), threadName);
        this.thread.setDaemon(true);
        this.thread.start();
    }

    protected void threadStop() {
        if (this.thread == null) {
            return;
        }
        this.threadDone = true;
        this.thread.interrupt();
        try {
            this.thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.thread = null;
    }

    protected class ContainerBackgroundProcessor
    implements Runnable {
        protected ContainerBackgroundProcessor() {
        }

        @Override
        public void run() {
            while (!ContainerBase.this.threadDone) {
                try {
                    Thread.sleep((long)ContainerBase.this.backgroundProcessorDelay * 1000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (ContainerBase.this.threadDone) continue;
                Container parent = (Container)ContainerBase.this.getMappingObject();
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                if (parent.getLoader() != null) {
                    cl = parent.getLoader().getClassLoader();
                }
                this.processChildren(parent, cl);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void processChildren(Container container, ClassLoader cl) {
            try {
                if (container.getLoader() != null) {
                    Thread.currentThread().setContextClassLoader(container.getLoader().getClassLoader());
                }
                if (container instanceof Context) {
                    ((Context)container).getThreadBindingListener().bind();
                }
                container.backgroundProcess();
            }
            catch (Throwable t) {
                log.error((Object)"Exception invoking periodic operation: ", t);
            }
            finally {
                if (container instanceof Context) {
                    ((Context)container).getThreadBindingListener().unbind();
                }
                Thread.currentThread().setContextClassLoader(cl);
            }
            Container[] children = container.findChildren();
            for (int i = 0; i < children.length; ++i) {
                if (children[i].getBackgroundProcessorDelay() > 0) continue;
                this.processChildren(children[i], cl);
            }
        }
    }

    protected class PrivilegedAddChild
    implements PrivilegedAction {
        private Container child;

        PrivilegedAddChild(Container child) {
            this.child = child;
        }

        public Object run() {
            ContainerBase.this.addChildInternal(this.child);
            return null;
        }
    }
}

