/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.NoRouteToHostException;
import java.net.SocketException;
import java.util.List;
import java.util.Map;
import org.jgroups.PhysicalAddress;
import org.jgroups.annotations.Property;
import org.jgroups.protocols.TP;
import org.jgroups.stack.IpAddress;
import org.jgroups.util.Util;

public class UDP
extends TP {
    @Property(description="Traffic class for sending unicast and multicast datagrams. Default is 8")
    protected int tos = 8;
    @Property(name="mcast_addr", description="The multicast address used for sending and receiving packets. Default is 228.8.8.8", defaultValueIPv4="228.8.8.8", defaultValueIPv6="ff0e::8:8:8", systemProperty={"jgroups.udp.mcast_addr"}, writable=false)
    protected InetAddress mcast_group_addr = null;
    @Property(description="The multicast port used for sending and receiving packets. Default is 7600", systemProperty={"jgroups.udp.mcast_port"}, writable=false)
    protected int mcast_port = 7600;
    @Property(description="Multicast toggle. If false multiple unicast datagrams are sent instead of one multicast. Default is true", writable=false)
    protected boolean ip_mcast = true;
    @Property(description="The time-to-live (TTL) for multicast datagram packets. Default is 8", systemProperty={"jgroups.udp.ip_ttl"})
    protected int ip_ttl = 8;
    @Property(description="Send buffer size of the multicast datagram socket. Default is 100'000 bytes")
    protected int mcast_send_buf_size = 100000;
    @Property(description="Receive buffer size of the multicast datagram socket. Default is 500'000 bytes")
    protected int mcast_recv_buf_size = 500000;
    @Property(description="Send buffer size of the unicast datagram socket. Default is 100'000 bytes")
    protected int ucast_send_buf_size = 100000;
    @Property(description="Receive buffer size of the unicast datagram socket. Default is 64'000 bytes")
    protected int ucast_recv_buf_size = 64000;
    @Property(description="If true, disables IP_MULTICAST_LOOP on the MulticastSocket (for sending and receiving of multicast packets). IP multicast packets send on a host P will therefore not be received by anyone on P. Use with caution.")
    protected boolean disable_loopback = false;
    protected IpAddress mcast_addr = null;
    protected DatagramSocket sock = null;
    protected MulticastSocket mcast_sock = null;
    protected PacketReceiver mcast_receiver = null;
    protected PacketReceiver ucast_receiver = null;

    @Override
    public boolean supportsMulticasting() {
        return this.ip_mcast;
    }

    public void setMulticastAddress(InetAddress addr) {
        this.mcast_group_addr = addr;
    }

    public InetAddress getMulticastAddress() {
        return this.mcast_group_addr;
    }

    public int getMulticastPort() {
        return this.mcast_port;
    }

    public void setMulticastPort(int mcast_port) {
        this.mcast_port = mcast_port;
    }

    public void setMcastPort(int mcast_port) {
        this.mcast_port = mcast_port;
    }

    public void setMulticastTTL(int ttl) throws IOException {
        this.ip_ttl = ttl;
        this.mcast_sock.setTimeToLive((byte)ttl);
    }

    public int getMulticastTTL() {
        return this.ip_ttl;
    }

    @Override
    @Property(name="max_bundle_size", description="Maximum number of bytes for messages to be queued until they are sent")
    public void setMaxBundleSize(int size) {
        super.setMaxBundleSize(size);
        if (size > 65536) {
            throw new IllegalArgumentException("max_bundle_size (" + size + ") cannot exceed the max datagram " + "packet size of " + 65536);
        }
    }

    @Override
    public String getInfo() {
        StringBuilder sb = new StringBuilder();
        sb.append("group_addr=").append(this.mcast_group_addr.getHostName()).append(':').append(this.mcast_port).append("\n");
        return sb.toString();
    }

    @Override
    public void sendMulticast(byte[] data, int offset, int length) throws Exception {
        if (this.ip_mcast && this.mcast_addr != null) {
            this._send(this.mcast_addr.getIpAddress(), this.mcast_addr.getPort(), true, data, offset, length);
        } else {
            this.sendToAllPhysicalAddresses(data, offset, length);
        }
    }

    @Override
    public void sendUnicast(PhysicalAddress dest, byte[] data, int offset, int length) throws Exception {
        this._send(((IpAddress)dest).getIpAddress(), ((IpAddress)dest).getPort(), false, data, offset, length);
    }

    protected void _send(InetAddress dest, int port, boolean mcast, byte[] data, int offset, int length) throws Exception {
        DatagramPacket packet = new DatagramPacket(data, offset, length, dest, port);
        try {
            if (mcast) {
                if (this.mcast_sock != null && !this.mcast_sock.isClosed()) {
                    try {
                        this.mcast_sock.send(packet);
                    }
                    catch (NoRouteToHostException e) {
                        this.log.warn(e.getMessage() + ", reset interface");
                        this.mcast_sock.setInterface(this.mcast_sock.getInterface());
                    }
                }
            } else if (this.sock != null && !this.sock.isClosed()) {
                this.sock.send(packet);
            }
        }
        catch (Exception ex) {
            throw new Exception("dest=" + dest + ":" + port + " (" + length + " bytes)", ex);
        }
    }

    @Override
    public void start() throws Exception {
        this.createSockets();
        super.start();
        this.ucast_receiver = new PacketReceiver(this.sock, "unicast receiver", new Runnable(){

            @Override
            public void run() {
                UDP.this.closeUnicastSocket();
            }
        });
        if (this.ip_mcast) {
            this.mcast_receiver = new PacketReceiver(this.mcast_sock, "multicast receiver", new Runnable(){

                @Override
                public void run() {
                    UDP.this.closeMulticastSocket();
                }
            });
        }
    }

    @Override
    public void stop() {
        if (this.log.isDebugEnabled()) {
            this.log.debug("closing sockets and stopping threads");
        }
        this.stopThreads();
        super.stop();
    }

    @Override
    public void destroy() {
        super.destroy();
        this.destroySockets();
    }

    @Override
    protected void handleConnect() throws Exception {
        if (this.isSingleton()) {
            if (this.connect_count == 0) {
                this.startThreads();
            }
            super.handleConnect();
        } else {
            this.startThreads();
        }
    }

    @Override
    protected void handleDisconnect() {
        if (this.isSingleton()) {
            super.handleDisconnect();
            if (this.connect_count == 0) {
                this.stopThreads();
            }
        } else {
            this.stopThreads();
        }
    }

    protected void createSockets() throws Exception {
        if (this.bind_addr == null) {
            throw new IllegalArgumentException("bind_addr cannot be null");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("sockets will use interface " + this.bind_addr.getHostAddress());
        }
        this.sock = this.bind_port > 0 ? this.createDatagramSocketWithBindPort() : this.createEphemeralDatagramSocket();
        if (this.tos > 0) {
            try {
                this.sock.setTrafficClass(this.tos);
            }
            catch (SocketException e) {
                this.log.warn("traffic class of " + this.tos + " could not be set, will be ignored: " + e);
            }
        }
        if (this.sock == null) {
            throw new Exception("socket is null");
        }
        if (this.ip_mcast) {
            this.mcast_sock = can_bind_to_mcast_addr ? Util.createMulticastSocket(this.getSocketFactory(), "jgroups.udp.mcast_sock", this.mcast_group_addr, this.mcast_port, this.log) : this.getSocketFactory().createMulticastSocket("jgroups.udp.mcast_sock", this.mcast_port);
            if (this.disable_loopback) {
                this.mcast_sock.setLoopbackMode(this.disable_loopback);
            }
            this.mcast_sock.setTimeToLive(this.ip_ttl);
            this.mcast_addr = new IpAddress(this.mcast_group_addr, this.mcast_port);
            if (this.enable_diagnostics && (this.diagnostics_addr != null && this.diagnostics_addr.equals(this.mcast_group_addr) || this.diagnostics_port == this.mcast_port)) {
                throw new IllegalArgumentException("diagnostics_addr / diagnostics_port and mcast_addr / mcast_port have to be different");
            }
            if (this.tos > 0) {
                try {
                    this.mcast_sock.setTrafficClass(this.tos);
                }
                catch (SocketException e) {
                    this.log.warn("traffic class of " + this.tos + " could not be set, will be ignored: " + e);
                }
            }
            if (this.receive_on_all_interfaces || this.receive_interfaces != null && !this.receive_interfaces.isEmpty()) {
                List interfaces = this.receive_interfaces != null ? this.receive_interfaces : Util.getAllAvailableInterfaces();
                this.bindToInterfaces(interfaces, this.mcast_sock, this.mcast_addr.getIpAddress());
            } else {
                if (this.bind_addr != null) {
                    this.mcast_sock.setInterface(this.bind_addr);
                }
                this.mcast_sock.joinGroup(this.mcast_group_addr);
            }
        }
        this.setBufferSizes();
        if (this.log.isDebugEnabled()) {
            this.log.debug("socket information:\n" + this.dumpSocketInfo());
        }
    }

    protected void destroySockets() {
        this.closeMulticastSocket();
        this.closeUnicastSocket();
    }

    protected IpAddress createLocalAddress() {
        if (this.sock == null || this.sock.isClosed()) {
            return null;
        }
        if (this.external_addr != null) {
            if (this.external_port > 0) {
                return new IpAddress(this.external_addr, this.external_port);
            }
            return new IpAddress(this.external_addr, this.sock.getLocalPort());
        }
        return new IpAddress(this.sock.getLocalAddress(), this.sock.getLocalPort());
    }

    @Override
    protected PhysicalAddress getPhysicalAddress() {
        return this.createLocalAddress();
    }

    protected void bindToInterfaces(List<NetworkInterface> interfaces, MulticastSocket s, InetAddress mcastAddr) {
        InetSocketAddress tmp_mcast_addr = new InetSocketAddress(mcastAddr, this.mcast_port);
        for (NetworkInterface intf : interfaces) {
            try {
                s.joinGroup(tmp_mcast_addr, intf);
                if (!this.log.isTraceEnabled()) continue;
                this.log.trace("joined " + tmp_mcast_addr + " on " + intf.getName());
            }
            catch (IOException e) {
                if (!this.log.isWarnEnabled()) continue;
                this.log.warn("Could not join " + tmp_mcast_addr + " on interface " + intf.getName());
            }
        }
    }

    protected DatagramSocket createEphemeralDatagramSocket() throws SocketException {
        DatagramSocket tmp;
        int localPort = 0;
        while (true) {
            try {
                tmp = this.getSocketFactory().createDatagramSocket("jgroups.udp.unicast_sock", localPort, this.bind_addr);
            }
            catch (SocketException socket_ex) {
                ++localPort;
                continue;
            }
            break;
        }
        localPort = tmp.getLocalPort();
        return tmp;
    }

    protected DatagramSocket createDatagramSocketWithBindPort() throws Exception {
        DatagramSocket tmp = null;
        int rcv_port = this.bind_port;
        int max_port = this.bind_port + this.port_range;
        while (rcv_port <= max_port) {
            try {
                tmp = this.getSocketFactory().createDatagramSocket("jgroups.udp.unicast_sock", rcv_port, this.bind_addr);
                return tmp;
            }
            catch (SocketException bind_ex) {
                ++rcv_port;
            }
            catch (SecurityException sec_ex) {
                ++rcv_port;
            }
        }
        if (rcv_port >= max_port + 1) {
            throw new Exception("failed to open a port in range " + this.bind_port + '-' + max_port);
        }
        return tmp;
    }

    protected String dumpSocketInfo() throws Exception {
        StringBuilder sb = new StringBuilder(128);
        sb.append(", mcast_addr=").append(this.mcast_addr);
        sb.append(", bind_addr=").append(this.bind_addr);
        sb.append(", ttl=").append(this.ip_ttl);
        if (this.sock != null) {
            sb.append("\nsock: bound to ");
            sb.append(this.sock.getLocalAddress().getHostAddress()).append(':').append(this.sock.getLocalPort());
            sb.append(", receive buffer size=").append(this.sock.getReceiveBufferSize());
            sb.append(", send buffer size=").append(this.sock.getSendBufferSize());
        }
        if (this.mcast_sock != null) {
            sb.append("\nmcast_sock: bound to ");
            sb.append(this.mcast_sock.getInterface().getHostAddress()).append(':').append(this.mcast_sock.getLocalPort());
            sb.append(", send buffer size=").append(this.mcast_sock.getSendBufferSize());
            sb.append(", receive buffer size=").append(this.mcast_sock.getReceiveBufferSize());
        }
        return sb.toString();
    }

    void setBufferSizes() {
        if (this.sock != null) {
            this.setBufferSize(this.sock, this.ucast_send_buf_size, this.ucast_recv_buf_size);
        }
        if (this.mcast_sock != null) {
            this.setBufferSize(this.mcast_sock, this.mcast_send_buf_size, this.mcast_recv_buf_size);
        }
    }

    protected void setBufferSize(DatagramSocket sock, int send_buf_size, int recv_buf_size) {
        block7: {
            int actual_size;
            block6: {
                try {
                    sock.setSendBufferSize(send_buf_size);
                    actual_size = sock.getSendBufferSize();
                    if (actual_size < send_buf_size && this.log.isWarnEnabled()) {
                        this.log.warn("send buffer of socket " + sock + " was set to " + Util.printBytes(send_buf_size) + ", but the OS only allocated " + Util.printBytes(actual_size) + ". This might lead to performance problems. Please set your " + "max send buffer in the OS correctly (e.g. net.core.wmem_max on Linux)");
                    }
                }
                catch (Throwable ex) {
                    if (!this.log.isWarnEnabled()) break block6;
                    this.log.warn("failed setting send buffer size of " + send_buf_size + " in " + sock + ": " + ex);
                }
            }
            try {
                sock.setReceiveBufferSize(recv_buf_size);
                actual_size = sock.getReceiveBufferSize();
                if (actual_size < recv_buf_size && this.log.isWarnEnabled()) {
                    this.log.warn("receive buffer of socket " + sock + " was set to " + Util.printBytes(recv_buf_size) + ", but the OS only allocated " + Util.printBytes(actual_size) + ". This might lead to performance problems. Please set your " + "max receive buffer in the OS correctly (e.g. net.core.rmem_max on Linux)");
                }
            }
            catch (Throwable ex) {
                if (!this.log.isWarnEnabled()) break block7;
                this.log.warn("failed setting receive buffer size of " + recv_buf_size + " in " + sock + ": " + ex);
            }
        }
    }

    void closeMulticastSocket() {
        if (this.mcast_sock != null) {
            try {
                if (this.mcast_addr != null) {
                    this.mcast_sock.leaveGroup(this.mcast_addr.getIpAddress());
                }
                this.getSocketFactory().close(this.mcast_sock);
                this.mcast_sock = null;
                if (this.log.isDebugEnabled()) {
                    this.log.debug("multicast socket closed");
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.mcast_addr = null;
        }
    }

    protected void closeUnicastSocket() {
        this.getSocketFactory().close(this.sock);
    }

    void startThreads() throws Exception {
        this.ucast_receiver.start();
        if (this.mcast_receiver != null) {
            this.mcast_receiver.start();
        }
    }

    void stopThreads() {
        if (this.mcast_receiver != null) {
            this.mcast_receiver.stop();
        }
        this.ucast_receiver.stop();
    }

    protected void handleConfigEvent(Map<String, Object> map) {
        boolean set_buffers = false;
        if (map == null) {
            return;
        }
        if (map.containsKey("send_buf_size")) {
            this.ucast_send_buf_size = this.mcast_send_buf_size = ((Integer)map.get("send_buf_size")).intValue();
            set_buffers = true;
        }
        if (map.containsKey("recv_buf_size")) {
            this.ucast_recv_buf_size = this.mcast_recv_buf_size = ((Integer)map.get("recv_buf_size")).intValue();
            set_buffers = true;
        }
        if (set_buffers) {
            this.setBufferSizes();
        }
    }

    public class PacketReceiver
    implements Runnable {
        private Thread thread = null;
        private final DatagramSocket receiver_socket;
        private final String name;
        private final Runnable close_strategy;

        public PacketReceiver(DatagramSocket socket, String name, Runnable close_strategy) {
            this.receiver_socket = socket;
            this.name = name;
            this.close_strategy = close_strategy;
        }

        public synchronized void start() {
            if (this.thread == null || !this.thread.isAlive()) {
                this.thread = UDP.this.getThreadFactory().newThread(this, this.name);
                this.thread.start();
                if (UDP.this.log.isDebugEnabled()) {
                    UDP.this.log.debug("created " + this.name + " thread ");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void stop() {
            try {
                this.close_strategy.run();
            }
            catch (Exception e1) {
            }
            finally {
                Util.close(this.receiver_socket);
            }
            if (this.thread != null && this.thread.isAlive()) {
                Thread tmp = this.thread;
                this.thread = null;
                tmp.interrupt();
                try {
                    tmp.join(300L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            this.thread = null;
        }

        @Override
        public void run() {
            byte[] receive_buf = new byte[66000];
            DatagramPacket packet = new DatagramPacket(receive_buf, receive_buf.length);
            while (this.thread != null && Thread.currentThread().equals(this.thread)) {
                try {
                    this.receiver_socket.receive(packet);
                    int len = packet.getLength();
                    if (len > receive_buf.length && UDP.this.log.isErrorEnabled()) {
                        UDP.this.log.error("size of the received packet (" + len + ") is bigger than allocated buffer (" + receive_buf.length + "): will not be able to handle packet. " + "Use the FRAG2 protocol and make its frag_size lower than " + receive_buf.length);
                    }
                    UDP.this.receive(new IpAddress(packet.getAddress(), packet.getPort()), receive_buf, packet.getOffset(), len);
                }
                catch (SocketException sock_ex) {
                    if (!UDP.this.log.isDebugEnabled()) break;
                    UDP.this.log.debug("receiver socket is closed, exception=" + sock_ex);
                    break;
                }
                catch (Throwable ex) {
                    if (!UDP.this.log.isErrorEnabled()) continue;
                    UDP.this.log.error("failed receiving packet", ex);
                }
            }
            if (UDP.this.log.isDebugEnabled()) {
                UDP.this.log.debug(this.name + " thread terminated");
            }
        }

        public String toString() {
            return this.receiver_socket != null ? this.receiver_socket.getLocalSocketAddress().toString() : "null";
        }
    }
}

