/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.deployers;

import java.lang.reflect.Modifier;
import java.util.List;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.as.webservices.WSLogger;
import org.jboss.as.webservices.injection.WSComponentDescription;
import org.jboss.as.webservices.service.EndpointService;
import org.jboss.as.webservices.util.ASHelper;
import org.jboss.as.webservices.util.DotNames;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;

public abstract class AbstractIntegrationProcessorJAXWS
implements DeploymentUnitProcessor {
    private final DotName[] dotNames;

    protected AbstractIntegrationProcessorJAXWS(DotName ... dotNames) {
        this.dotNames = dotNames;
    }

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit unit = phaseContext.getDeploymentUnit();
        if (DeploymentTypeMarker.isType((DeploymentType)DeploymentType.EAR, (DeploymentUnit)unit)) {
            return;
        }
        CompositeIndex index = (CompositeIndex)unit.getAttachment(org.jboss.as.server.deployment.Attachments.COMPOSITE_ANNOTATION_INDEX);
        if (index == null) {
            WSLogger.ROOT_LOGGER.skippingAnnotationProcessing(unit.getName());
        } else {
            for (DotName dotName : this.dotNames) {
                List wsAnnotations = index.getAnnotations(dotName);
                if (wsAnnotations.isEmpty()) continue;
                for (AnnotationInstance wsAnnotation : wsAnnotations) {
                    ClassInfo classInfo;
                    AnnotationTarget target = wsAnnotation.target();
                    if (!(target instanceof ClassInfo) || !AbstractIntegrationProcessorJAXWS.isJaxwsEndpoint(classInfo = (ClassInfo)target, index)) continue;
                    this.processAnnotation(unit, classInfo, wsAnnotation, index);
                }
            }
        }
    }

    public void undeploy(DeploymentUnit unit) {
    }

    protected abstract void processAnnotation(DeploymentUnit var1, ClassInfo var2, AnnotationInstance var3, CompositeIndex var4) throws DeploymentUnitProcessingException;

    private static boolean isJaxwsEndpoint(ClassInfo clazz, CompositeIndex index) {
        short flags = clazz.flags();
        if (Modifier.isInterface(flags)) {
            return false;
        }
        if (Modifier.isAbstract(flags)) {
            return false;
        }
        if (!Modifier.isPublic(flags)) {
            return false;
        }
        if (ASHelper.isJaxwsService(clazz, index)) {
            return false;
        }
        boolean hasWebServiceAnnotation = clazz.annotations().containsKey(DotNames.WEB_SERVICE_ANNOTATION);
        boolean hasWebServiceProviderAnnotation = clazz.annotations().containsKey(DotNames.WEB_SERVICE_PROVIDER_ANNOTATION);
        if (!hasWebServiceAnnotation && !hasWebServiceProviderAnnotation) {
            return false;
        }
        if (hasWebServiceAnnotation && hasWebServiceProviderAnnotation) {
            WSLogger.ROOT_LOGGER.mutuallyExclusiveAnnotations(clazz.name().toString());
            return false;
        }
        if (Modifier.isFinal(flags)) {
            WSLogger.ROOT_LOGGER.finalEndpointClassDetected(clazz.name().toString());
            return false;
        }
        return true;
    }

    static ComponentDescription createComponentDescription(DeploymentUnit unit, String componentName, String componentClassName, String dependsOnEndpointClassName) {
        EEModuleDescription moduleDescription = (EEModuleDescription)ASHelper.getRequiredAttachment(unit, Attachments.EE_MODULE_DESCRIPTION);
        ComponentDescription componentDescription = moduleDescription.getComponentByName(componentName);
        if (componentDescription == null) {
            componentDescription = new WSComponentDescription(componentName, componentClassName, moduleDescription, unit.getServiceName());
            moduleDescription.addComponent(componentDescription);
            ServiceName endpointServiceName = EndpointService.getServiceName(unit, dependsOnEndpointClassName);
            componentDescription.addDependency(endpointServiceName, ServiceBuilder.DependencyType.REQUIRED);
        }
        return componentDescription;
    }

    static boolean isEjb3(ClassInfo clazz) {
        boolean isStateless = clazz.annotations().containsKey(DotNames.STATELESS_ANNOTATION);
        boolean isSingleton = clazz.annotations().containsKey(DotNames.SINGLETON_ANNOTATION);
        return isStateless || isSingleton;
    }
}

