/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.bindings.jboss.auth;

import java.security.Principal;
import java.security.acl.Group;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import org.jboss.security.SimpleGroup;
import org.jboss.security.SimplePrincipal;
import org.jboss.security.auth.spi.UsernamePasswordLoginModule;
import org.picketlink.identity.federation.bindings.tomcat.sp.holder.ServiceProviderSAMLContext;
import org.picketlink.identity.federation.core.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SAML2CommonLoginModule
extends UsernamePasswordLoginModule {
    protected String groupName = "Roles";

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        super.initialize(subject, callbackHandler, sharedState, options);
        String groupNameStr = (String)options.get("groupPrincipalName");
        if (StringUtil.isNotNull((String)groupNameStr)) {
            this.groupName = groupNameStr.trim();
        }
    }

    protected Principal getIdentity() {
        return new SimplePrincipal(ServiceProviderSAMLContext.getUserName());
    }

    protected Group[] getRoleSets() throws LoginException {
        SimpleGroup group = new SimpleGroup(this.groupName);
        List<String> roles = ServiceProviderSAMLContext.getRoles();
        if (roles != null) {
            for (String role : roles) {
                group.addMember((Principal)new SimplePrincipal(role));
            }
        }
        return new Group[]{group};
    }

    protected String getUsersPassword() throws LoginException {
        return "EMPTY_STR";
    }
}

