/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.workmanager;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.resource.spi.work.ExecutionContext;
import javax.resource.spi.work.HintsContext;
import javax.resource.spi.work.SecurityContext;
import javax.resource.spi.work.TransactionContext;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkCompletedException;
import javax.resource.spi.work.WorkContext;
import javax.resource.spi.work.WorkContextLifecycleListener;
import javax.resource.spi.work.WorkContextProvider;
import javax.resource.spi.work.WorkException;
import javax.resource.spi.work.WorkListener;
import javax.resource.spi.work.WorkRejectedException;
import org.jboss.jca.core.CoreBundle;
import org.jboss.jca.core.CoreLogger;
import org.jboss.jca.core.api.workmanager.WorkManager;
import org.jboss.jca.core.spi.security.Callback;
import org.jboss.jca.core.spi.transaction.xa.XATerminator;
import org.jboss.jca.core.workmanager.ClassUtil;
import org.jboss.jca.core.workmanager.WorkWrapper;
import org.jboss.logging.Logger;
import org.jboss.logging.Messages;
import org.jboss.threads.BlockingExecutor;

public class WorkManagerImpl
implements WorkManager {
    private static CoreLogger log = (CoreLogger)Logger.getMessageLogger(CoreLogger.class, (String)WorkManagerImpl.class.getName());
    private static boolean trace = log.isTraceEnabled();
    private static CoreBundle bundle = (CoreBundle)Messages.getBundle(CoreBundle.class);
    private static final String RUN_METHOD_NAME = "run";
    private static final String RELEASE_METHOD_NAME = "release";
    private static final Set<Class<? extends WorkContext>> SUPPORTED_WORK_CONTEXT_CLASSES = new HashSet<Class<? extends WorkContext>>(3);
    private String id = null;
    private String name = null;
    private boolean specCompliant = true;
    private BlockingExecutor shortRunningExecutor;
    private BlockingExecutor longRunningExecutor;
    private XATerminator xaTerminator;
    private Set<String> validatedWork = new HashSet<String>();
    private Callback callbackSecurity;
    private AtomicBoolean shutdown = new AtomicBoolean(false);
    private Set<WorkWrapper> activeWorkWrappers = new HashSet<WorkWrapper>();

    public String getId() {
        if (this.id == null) {
            return this.name;
        }
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String v) {
        this.name = v;
    }

    public BlockingExecutor getShortRunningThreadPool() {
        return this.shortRunningExecutor;
    }

    public void setShortRunningThreadPool(BlockingExecutor executor) {
        this.shortRunningExecutor = executor;
    }

    public BlockingExecutor getLongRunningThreadPool() {
        return this.longRunningExecutor;
    }

    public void setLongRunningThreadPool(BlockingExecutor executor) {
        this.longRunningExecutor = executor;
    }

    public XATerminator getXATerminator() {
        return this.xaTerminator;
    }

    public void setXATerminator(XATerminator xaTerminator) {
        this.xaTerminator = xaTerminator;
    }

    public boolean isSpecCompliant() {
        return this.specCompliant;
    }

    public void setSpecCompliant(boolean v) {
        this.specCompliant = v;
    }

    public Callback getCallbackSecurity() {
        return this.callbackSecurity;
    }

    public void setCallbackSecurity(Callback v) {
        this.callbackSecurity = v;
    }

    public WorkManager clone() throws CloneNotSupportedException {
        WorkManager wm = (WorkManager)super.clone();
        wm.setName(this.getName());
        wm.setShortRunningThreadPool(this.getShortRunningThreadPool());
        wm.setLongRunningThreadPool(this.getLongRunningThreadPool());
        wm.setXATerminator(this.getXATerminator());
        wm.setSpecCompliant(this.isSpecCompliant());
        wm.setCallbackSecurity(this.getCallbackSecurity());
        return wm;
    }

    public void doWork(Work work) throws WorkException {
        this.doWork(work, Long.MAX_VALUE, null, null);
    }

    /*
     * Exception decompiling
     */
    public void doWork(Work work, long startTimeout, ExecutionContext execContext, WorkListener workListener) throws WorkException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public long startWork(Work work) throws WorkException {
        return this.startWork(work, Long.MAX_VALUE, null, null);
    }

    /*
     * Exception decompiling
     */
    public long startWork(Work work, long startTimeout, ExecutionContext execContext, WorkListener workListener) throws WorkException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void scheduleWork(Work work) throws WorkException {
        this.scheduleWork(work, Long.MAX_VALUE, null, null);
    }

    /*
     * Exception decompiling
     */
    public void scheduleWork(Work work, long startTimeout, ExecutionContext execContext, WorkListener workListener) throws WorkException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void prepareShutdown() {
        this.shutdown.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.prepareShutdown();
        Set<WorkWrapper> set = this.activeWorkWrappers;
        synchronized (set) {
            for (WorkWrapper ww : this.activeWorkWrappers) {
                ww.getWork().release();
            }
        }
    }

    public boolean isShutdown() {
        return this.shutdown.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addWorkWrapper(WorkWrapper ww) {
        Set<WorkWrapper> set = this.activeWorkWrappers;
        synchronized (set) {
            this.activeWorkWrappers.add(ww);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeWorkWrapper(WorkWrapper ww) {
        Set<WorkWrapper> set = this.activeWorkWrappers;
        synchronized (set) {
            this.activeWorkWrappers.remove(ww);
        }
    }

    private BlockingExecutor getExecutor(Work work) {
        WorkContextProvider wcProvider;
        List contexts;
        BlockingExecutor executor = this.shortRunningExecutor;
        if (work instanceof WorkContextProvider && (contexts = (wcProvider = (WorkContextProvider)work).getWorkContexts()) != null && contexts.size() > 0) {
            boolean found = false;
            Iterator it = contexts.iterator();
            while (!found && it.hasNext()) {
                HintsContext hc;
                WorkContext wc = (WorkContext)it.next();
                if (!(wc instanceof HintsContext) || !(hc = (HintsContext)wc).getHints().containsKey("javax.resource.LongRunning")) continue;
                executor = this.longRunningExecutor;
                found = true;
            }
        }
        return executor;
    }

    private void checkAndVerifyWork(Work work, ExecutionContext executionContext) throws WorkException {
        if (this.specCompliant) {
            this.verifyWork(work);
        }
        if (work instanceof WorkContextProvider && executionContext != null) {
            throw new WorkRejectedException(bundle.workExecutionContextMustNullImplementsWorkContextProvider());
        }
    }

    private void verifyWork(Work work) throws WorkException {
        if (!this.validatedWork.contains(work.getClass().getName())) {
            Class<?> workClass = work.getClass();
            boolean result = false;
            result = this.verifyWorkMethods(workClass, RUN_METHOD_NAME, null, workClass.getName() + ": Run method is not defined");
            if (!result) {
                throw new WorkException(bundle.runMethodIsSynchronized(workClass.getName()));
            }
            result = this.verifyWorkMethods(workClass, RELEASE_METHOD_NAME, null, workClass.getName() + ": Release method is not defined");
            if (!result) {
                throw new WorkException(bundle.releaseMethodIsSynchronized(workClass.getName()));
            }
            this.validatedWork.add(work.getClass().getName());
        }
    }

    private boolean verifyWorkMethods(Class<?> workClass, String methodName, Class<?>[] parameterTypes, String errorMessage) throws WorkException {
        Method method = null;
        try {
            method = ClassUtil.getClassMethod(workClass, methodName, null);
            if (ClassUtil.modifiersHasSynchronizedKeyword(method.getModifiers())) {
                return false;
            }
        }
        catch (NoSuchMethodException nsme) {
            throw new WorkException(errorMessage);
        }
        return true;
    }

    private void checkWorkCompletionException(WorkWrapper wrapper) throws WorkException {
        if (wrapper.getWorkException() != null) {
            if (trace) {
                log.tracef("Exception %s for %s", (Object)wrapper.getWorkException(), this);
            }
            throw wrapper.getWorkException();
        }
    }

    private void setup(WorkWrapper wrapper) throws WorkException {
        WorkContextProvider wcProvider;
        List contexts;
        Work work;
        if (trace) {
            log.trace("Setting up work contexts " + wrapper);
        }
        if ((work = wrapper.getWork()) instanceof WorkContextProvider && (contexts = (wcProvider = (WorkContextProvider)work).getWorkContexts()) != null && contexts.size() > 0) {
            boolean isTransactionContext = false;
            boolean isSecurityContext = false;
            boolean isHintcontext = false;
            for (WorkContext context : contexts) {
                Class<?> contextType = null;
                contextType = this.getSupportedWorkContextClass(context.getClass());
                if (contextType == null) {
                    if (trace) {
                        log.trace("Not supported work context class : " + context.getClass().getName());
                    }
                    this.fireWorkContextSetupFailed(context, "1");
                    throw new WorkCompletedException(bundle.unsupportedWorkContextClass(context.getClass().getName()), "1");
                }
                if (this.isTransactionContext(contextType)) {
                    if (isTransactionContext) {
                        if (trace) {
                            log.trace("Duplicate transaction work context : " + context.getClass().getName());
                        }
                        this.fireWorkContextSetupFailed(context, "2");
                        throw new WorkCompletedException(bundle.duplicateTransactionWorkContextClass(context.getClass().getName()), "2");
                    }
                    isTransactionContext = true;
                } else if (this.isSecurityContext(contextType)) {
                    if (isSecurityContext) {
                        if (trace) {
                            log.trace("Duplicate security work context : " + context.getClass().getName());
                        }
                        this.fireWorkContextSetupFailed(context, "2");
                        throw new WorkCompletedException(bundle.duplicateSecurityWorkContextClass(context.getClass().getName()), "2");
                    }
                    isSecurityContext = true;
                } else if (this.isHintContext(contextType)) {
                    if (isHintcontext) {
                        if (trace) {
                            log.trace("Duplicate hint work context : " + context.getClass().getName());
                        }
                        this.fireWorkContextSetupFailed(context, "2");
                        throw new WorkCompletedException(bundle.duplicateHintWorkContextClass(context.getClass().getName()), "2");
                    }
                    isHintcontext = true;
                } else {
                    this.fireWorkContextSetupFailed(context, "1");
                    throw new WorkCompletedException(bundle.unsupportedWorkContextClass(context.getClass().getName()), "1");
                }
                wrapper.addWorkContext(contextType, context);
            }
        }
        if (trace) {
            log.trace("Setted up work contexts " + wrapper);
        }
    }

    private void fireWorkContextSetupFailed(Object workContext, String errorCode) {
        if (workContext instanceof WorkContextLifecycleListener) {
            WorkContextLifecycleListener listener = (WorkContextLifecycleListener)workContext;
            listener.contextSetupFailed(errorCode);
        }
    }

    private boolean isTransactionContext(Class<? extends WorkContext> workContextType) {
        return workContextType.isAssignableFrom(TransactionContext.class);
    }

    private boolean isSecurityContext(Class<? extends WorkContext> workContextType) {
        return workContextType.isAssignableFrom(SecurityContext.class);
    }

    private boolean isHintContext(Class<? extends WorkContext> workContextType) {
        return workContextType.isAssignableFrom(HintsContext.class);
    }

    private <T extends WorkContext> Class<T> getSupportedWorkContextClass(Class<T> adaptorWorkContext) {
        for (Class<? extends WorkContext> supportedWorkContext : SUPPORTED_WORK_CONTEXT_CLASSES) {
            if (!supportedWorkContext.isAssignableFrom(adaptorWorkContext)) continue;
            for (Class<T> clz = adaptorWorkContext; clz != null; clz = clz.getSuperclass()) {
                if (!clz.equals(supportedWorkContext)) continue;
                return clz;
            }
        }
        return null;
    }

    static {
        SUPPORTED_WORK_CONTEXT_CLASSES.add(TransactionContext.class);
        SUPPORTED_WORK_CONTEXT_CLASSES.add(SecurityContext.class);
        SUPPORTED_WORK_CONTEXT_CLASSES.add(HintsContext.class);
    }
}

