/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.framework.internal.AbstractBundleRevision;
import org.jboss.osgi.framework.internal.FragmentBundleState;
import org.jboss.osgi.framework.internal.FrameworkMessages;
import org.jboss.osgi.framework.internal.HostBundleRevision;
import org.jboss.osgi.framework.internal.UserBundleRevision;
import org.osgi.framework.BundleException;

final class FragmentBundleRevision
extends UserBundleRevision {
    private Set<HostBundleRevision> attachedHosts;

    FragmentBundleRevision(FragmentBundleState bundleState, Deployment dep) throws BundleException {
        super(bundleState, dep);
    }

    static FragmentBundleRevision assertFragmentRevision(AbstractBundleRevision bundleRev) {
        assert (bundleRev != null) : "Null bundleRev";
        assert (bundleRev instanceof FragmentBundleRevision) : "Not an FragmentRevision: " + (Object)((Object)bundleRev);
        return (FragmentBundleRevision)bundleRev;
    }

    @Override
    FragmentBundleState getBundleState() {
        return (FragmentBundleState)super.getBundleState();
    }

    @Override
    void refreshRevisionInternal() {
        this.attachedHosts = null;
    }

    Set<HostBundleRevision> getAttachedHosts() {
        if (this.attachedHosts == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.attachedHosts);
    }

    @Override
    Class<?> loadClass(String className) throws ClassNotFoundException {
        throw FrameworkMessages.MESSAGES.cannotLoadClassFromFragment(this);
    }

    @Override
    URL getResource(String resourceName) {
        return null;
    }

    @Override
    Enumeration<URL> getResources(String resourceName) throws IOException {
        return null;
    }

    void attachToHost(HostBundleRevision hostRev) {
        if (this.attachedHosts == null) {
            this.attachedHosts = new HashSet<HostBundleRevision>();
        }
        hostRev.attachFragment(this);
        this.attachedHosts.add(hostRev);
    }

    @Override
    URL getLocalizationEntry(String path) {
        URL result = null;
        boolean fallbackToFragment = true;
        if (this.isResolved()) {
            HostBundleRevision highest = null;
            for (HostBundleRevision hostrev : this.getAttachedHosts()) {
                if (highest == null) {
                    highest = hostrev;
                }
                if (highest.getVersion().compareTo((Object)hostrev.getVersion()) >= 0) continue;
                highest = hostrev;
            }
            if (highest == null) {
                throw FrameworkMessages.MESSAGES.illegalStateCannotObtainAttachedHost(this);
            }
            boolean hostUninstalled = highest.getBundleState().isUninstalled();
            URL uRL = result = hostUninstalled ? this.getEntry(path) : highest.getLocalizationEntry(path);
            if (result != null || !fallbackToFragment) {
                return result;
            }
        }
        result = this.getEntry(path);
        return result;
    }
}

