/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.framework.Services;
import org.jboss.osgi.framework.internal.AbstractPluginService;
import org.jboss.osgi.framework.internal.BundleManagerPlugin;
import org.jboss.osgi.framework.internal.BundleStoragePlugin;
import org.jboss.osgi.framework.internal.FrameworkMessages;
import org.jboss.osgi.framework.internal.HostBundleRevision;
import org.jboss.osgi.framework.internal.HostBundleState;
import org.jboss.osgi.framework.internal.InternalServices;
import org.jboss.osgi.framework.internal.NativeLibraryProvider;
import org.jboss.osgi.framework.internal.UserBundleRevision;
import org.jboss.osgi.framework.internal.UserBundleState;
import org.jboss.osgi.metadata.NativeLibrary;
import org.jboss.osgi.metadata.NativeLibraryMetaData;
import org.jboss.osgi.metadata.OSGiMetaData;
import org.jboss.osgi.metadata.Parameter;
import org.jboss.osgi.metadata.ParameterizedAttribute;
import org.jboss.osgi.metadata.VersionRange;
import org.jboss.osgi.vfs.VFSUtils;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.Version;

final class NativeCodePlugin
extends AbstractPluginService<NativeCodePlugin> {
    private static final String ABSPATH_VARIABLE = "${abspath}";
    private static Map<String, String> processorAlias = new HashMap<String, String>();
    private static Map<String, String> osAlias;
    private final InjectedValue<BundleManagerPlugin> injectedBundleManager = new InjectedValue();

    static void addService(ServiceTarget serviceTarget) {
        NativeCodePlugin service = new NativeCodePlugin();
        ServiceBuilder builder = serviceTarget.addService(InternalServices.NATIVE_CODE_PLUGIN, (Service)service);
        builder.addDependency(Services.BUNDLE_MANAGER, BundleManagerPlugin.class, service.injectedBundleManager);
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
        builder.install();
    }

    private NativeCodePlugin() {
    }

    public NativeCodePlugin getValue() {
        return this;
    }

    void deployNativeCode(Deployment dep) {
        NativeLibraryMetaData nativeLibraries = new NativeLibraryMetaData();
        dep.addAttachment(NativeLibraryMetaData.class, (Object)nativeLibraries);
    }

    void resolveNativeCode(UserBundleRevision userRev) throws BundleException {
        OSGiMetaData osgiMetaData = userRev.getOSGiMetaData();
        List params = osgiMetaData.getBundleNativeCode();
        if (params == null) {
            throw FrameworkMessages.MESSAGES.bundleCannotFindNativeCodeHeader(userRev);
        }
        ArrayList<ParameterizedAttribute> matchedParams = new ArrayList<ParameterizedAttribute>();
        for (ParameterizedAttribute param : params) {
            if (!this.matchParameter(param)) continue;
            matchedParams.add(param);
        }
        Deployment dep = userRev.getDeployment();
        NativeLibraryMetaData nativeLibraries = (NativeLibraryMetaData)dep.getAttachment(NativeLibraryMetaData.class);
        if (matchedParams.size() == 0) {
            if (params.size() > 0 && "*".equals(((ParameterizedAttribute)params.get(params.size() - 1)).getAttribute())) {
                dep.removeAttachment(NativeLibraryMetaData.class);
                return;
            }
            throw FrameworkMessages.MESSAGES.bundleNoNativeCodeClauseSelected(params);
        }
        for (ParameterizedAttribute param : matchedParams) {
            String libpath = param.getAttribute();
            NativeLibrary library = new NativeLibrary(libpath);
            nativeLibraries.addNativeLibrary(library);
        }
    }

    private List<String> getCollection(Object value) {
        if (value == null) {
            return Collections.emptyList();
        }
        if (value instanceof Collection) {
            return new ArrayList<String>((Collection)value);
        }
        return Collections.singletonList(value.toString());
    }

    private boolean matchParameter(ParameterizedAttribute param) throws BundleException {
        Parameter procParam;
        boolean match;
        Parameter osnameParam = param.getAttribute("osname");
        BundleManagerPlugin bundleManager = (BundleManagerPlugin)this.injectedBundleManager.getValue();
        BundleContext systemContext = bundleManager.getSystemBundle().getBundleContext();
        boolean bl = match = osnameParam != null;
        if (match && osnameParam != null) {
            String osname;
            String fwOSName = systemContext.getProperty("org.osgi.framework.os.name");
            boolean osmatch = false;
            List<String> osNames = this.getCollection(osnameParam.getValue());
            Iterator i$ = osNames.iterator();
            while (i$.hasNext() && !(osmatch = (osname = (String)i$.next()).equalsIgnoreCase(fwOSName) || osname.equalsIgnoreCase(osAlias.get(fwOSName)))) {
            }
            match &= osmatch;
        }
        if ((match &= (procParam = param.getAttribute("processor")) != null) && procParam != null) {
            String proc;
            String fwProcessor = systemContext.getProperty("org.osgi.framework.processor");
            boolean procmatch = false;
            List<String> processors = this.getCollection(procParam.getValue());
            Iterator<String> i$ = processors.iterator();
            while (i$.hasNext() && !(procmatch = (proc = i$.next()).equals(fwProcessor) || proc.equals(processorAlias.get(fwProcessor)))) {
            }
            match &= procmatch;
        }
        Parameter osversionParam = param.getAttribute("osversion");
        if (match && osversionParam != null) {
            String fwOSVersion = systemContext.getProperty("org.osgi.framework.os.version");
            boolean versionMatch = false;
            Version currentVersion = Version.parseVersion((String)fwOSVersion);
            for (String versionRange : this.getCollection(osversionParam.getValue())) {
                VersionRange vr = VersionRange.parse((String)versionRange);
                if (!vr.isInRange(currentVersion)) continue;
                versionMatch = true;
                break;
            }
            match &= versionMatch;
        }
        Parameter languageParam = param.getAttribute("language");
        if (match && languageParam != null) {
            String fwLanguage = systemContext.getProperty("org.osgi.framework.language");
            boolean languageMatch = false;
            for (String language : this.getCollection(languageParam.getValue())) {
                if (!language.equals(fwLanguage)) continue;
                languageMatch = true;
                break;
            }
            match &= languageMatch;
        }
        Parameter filterSelectionParam = param.getAttribute("selection-filter");
        if (match && filterSelectionParam != null) {
            boolean filterMatch = false;
            Hashtable<String, Object> frameworkProps = new Hashtable<String, Object>(bundleManager.getProperties());
            for (String filterSpec : this.getCollection(filterSelectionParam.getValue())) {
                try {
                    Filter filter = FrameworkUtil.createFilter((String)filterSpec);
                    if (!filter.match(frameworkProps)) continue;
                    filterMatch = true;
                    break;
                }
                catch (InvalidSyntaxException ex) {
                    throw FrameworkMessages.MESSAGES.bundleInvalidFilterExpression(ex, filterSpec);
                }
            }
            match &= filterMatch;
        }
        return match;
    }

    static {
        processorAlias.put("amd64", "x86-64");
        processorAlias.put("em64t", "x86-64");
        processorAlias.put("i386", "x86");
        processorAlias.put("i486", "x86");
        processorAlias.put("i586", "x86");
        processorAlias.put("i686", "x86");
        processorAlias.put("pentium", "x86");
        processorAlias.put("x86_64", "x86-64");
        osAlias = new HashMap<String, String>();
        osAlias.put("hp-ux", "HPUX");
        osAlias.put("Mac OS", "MacOS");
        osAlias.put("Mac OS X", "MacOSX");
        osAlias.put("OS/2", "OS2");
        osAlias.put("procnto", "QNX");
        osAlias.put("SymbianOS", "Epoc32");
        osAlias.put("Win2000", "Windows2000");
        osAlias.put("Win2003", "Windows2003");
        osAlias.put("Win32", "Windows");
        osAlias.put("Win95", "Windows95");
        osAlias.put("Win98", "Windows98");
        osAlias.put("WinCE", "WindowsCE");
        osAlias.put("Windows 2000", "Windows2000");
        osAlias.put("Windows 2003", "Windows2003");
        osAlias.put("Windows 7", "Windows7");
        osAlias.put("Windows 95", "Windows95");
        osAlias.put("Windows 98", "Windows98");
        osAlias.put("Windows CE", "WindowsCE");
        osAlias.put("Windows NT", "WindowsNT");
        osAlias.put("Windows Server 2003", "Windows2003");
        osAlias.put("Windows Vista", "WindowsVista");
        osAlias.put("Windows XP", "WindowsXP");
        osAlias.put("WinNT", "WindowsNT");
        osAlias.put("WinVista", "WindowsVista");
        osAlias.put("WinXP", "WindowsXP");
    }

    static class BundleNativeLibraryProvider
    implements NativeLibraryProvider {
        private final HostBundleState hostBundle;
        private final String libname;
        private final String libpath;
        private final URL libURL;
        private File libraryFile;

        BundleNativeLibraryProvider(HostBundleRevision hostrev, String libname, String libpath) {
            String filename;
            String path;
            this.hostBundle = hostrev.getBundleState();
            this.libpath = libpath;
            this.libname = libname;
            int idx = libpath.lastIndexOf(47);
            if (idx >= 0) {
                path = libpath.substring(0, idx);
                filename = libpath.substring(idx + 1);
            } else {
                path = "";
                filename = libpath;
            }
            Enumeration<URL> urls = hostrev.findResolvedEntries(path, filename, false);
            if (urls == null || !urls.hasMoreElements()) {
                throw FrameworkMessages.MESSAGES.illegalStateCannotFindNativeLibrary(libpath);
            }
            this.libURL = urls.nextElement();
        }

        @Override
        public String getLibraryName() {
            return this.libname;
        }

        @Override
        public String getLibraryPath() {
            return this.libpath;
        }

        @Override
        public File getLibraryLocation() throws IOException {
            if (this.libraryFile == null) {
                this.libraryFile = this.getUniqueLibraryFile(this.hostBundle, this.libpath);
                this.libraryFile.deleteOnExit();
                FileOutputStream fos = new FileOutputStream(this.libraryFile);
                VFSUtils.copyStream((InputStream)this.libURL.openStream(), (OutputStream)fos);
                fos.close();
                this.handleExecPermission();
            }
            return this.libraryFile;
        }

        private void handleExecPermission() throws IOException {
            String epProp = this.hostBundle.getBundleContext().getProperty("org.osgi.framework.command.execpermission");
            if (epProp == null) {
                return;
            }
            StringBuilder command = new StringBuilder(epProp);
            int idx = command.indexOf(NativeCodePlugin.ABSPATH_VARIABLE);
            if (idx >= 0) {
                command.replace(idx, idx + NativeCodePlugin.ABSPATH_VARIABLE.length(), this.libraryFile.getAbsolutePath());
            }
            Process process = Runtime.getRuntime().exec(command.toString());
            try {
                process.waitFor();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }

        private File getUniqueLibraryFile(UserBundleState userBundle, String libpath) {
            BundleStoragePlugin storagePlugin = userBundle.getFrameworkState().getBundleStoragePlugin();
            return storagePlugin.getDataFile(userBundle.getBundleId(), libpath);
        }
    }
}

