/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.framework.Services;
import org.jboss.osgi.framework.internal.AbstractBundleState;
import org.jboss.osgi.framework.internal.AbstractExecutorService;
import org.jboss.osgi.framework.internal.BundleManagerPlugin;
import org.jboss.osgi.framework.internal.BundleStoragePlugin;
import org.jboss.osgi.framework.internal.FrameworkEventsPlugin;
import org.jboss.osgi.framework.internal.FrameworkLogger;
import org.jboss.osgi.framework.internal.FrameworkMessages;
import org.jboss.osgi.framework.internal.HostBundleState;
import org.jboss.osgi.framework.internal.InternalServices;
import org.jboss.osgi.framework.internal.SystemBundleState;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.launch.Framework;
import org.osgi.service.startlevel.StartLevel;

public final class StartLevelPlugin
extends AbstractExecutorService<StartLevel>
implements StartLevel {
    static final int BUNDLE_STARTLEVEL_UNSPECIFIED = -1;
    private final InjectedValue<BundleManagerPlugin> injectedBundleManager = new InjectedValue();
    private final InjectedValue<SystemBundleState> injectedSystemBundle = new InjectedValue();
    private final InjectedValue<FrameworkEventsPlugin> injectedFrameworkEvents = new InjectedValue();
    private int initialBundleStartLevel = 1;
    private ServiceRegistration registration;
    private int startLevel = 0;

    static void addService(ServiceTarget serviceTarget) {
        StartLevelPlugin service = new StartLevelPlugin();
        ServiceBuilder builder = serviceTarget.addService(Services.START_LEVEL, (Service)service);
        builder.addDependency(Services.BUNDLE_MANAGER, BundleManagerPlugin.class, service.injectedBundleManager);
        builder.addDependency(InternalServices.FRAMEWORK_EVENTS_PLUGIN, FrameworkEventsPlugin.class, service.injectedFrameworkEvents);
        builder.addDependency(Services.SYSTEM_BUNDLE, SystemBundleState.class, service.injectedSystemBundle);
        builder.addDependency(Services.FRAMEWORK_CREATE);
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
        builder.install();
    }

    private StartLevelPlugin() {
    }

    @Override
    public void start(StartContext context) throws StartException {
        super.start(context);
        BundleContext systemContext = ((SystemBundleState)this.injectedSystemBundle.getValue()).getBundleContext();
        this.registration = systemContext.registerService(StartLevel.class.getName(), (Object)this, null);
    }

    @Override
    public void stop(StopContext context) {
        super.stop(context);
        this.registration.unregister();
        this.registration = null;
    }

    public StartLevelPlugin getValue() {
        return this;
    }

    @Override
    ExecutorService createExecutorService() {
        return Executors.newSingleThreadExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable run) {
                Thread thread = new Thread(run);
                thread.setName("OSGi StartLevel Thread");
                thread.setDaemon(true);
                return thread;
            }
        });
    }

    public synchronized int getStartLevel() {
        return this.startLevel;
    }

    public synchronized void setStartLevel(final int level) {
        final FrameworkEventsPlugin eventsPlugin = (FrameworkEventsPlugin)((Object)this.injectedFrameworkEvents.getValue());
        final AbstractBundleState bundleState = (AbstractBundleState)this.injectedSystemBundle.getValue();
        if (level > this.getStartLevel()) {
            this.getExecutorService().execute(new Runnable(){

                @Override
                public void run() {
                    FrameworkLogger.LOGGER.infoIncreasingStartLevel(StartLevelPlugin.this.getStartLevel(), level);
                    StartLevelPlugin.this.increaseStartLevel(level);
                    eventsPlugin.fireFrameworkEvent(bundleState, 8, null);
                }
            });
        } else if (level < this.getStartLevel()) {
            this.getExecutorService().execute(new Runnable(){

                @Override
                public void run() {
                    FrameworkLogger.LOGGER.infoDecreasingStartLevel(StartLevelPlugin.this.getStartLevel(), level);
                    StartLevelPlugin.this.decreaseStartLevel(level);
                    eventsPlugin.fireFrameworkEvent(bundleState, 8, null);
                }
            });
        }
    }

    public int getBundleStartLevel(Bundle bundle2) {
        if (bundle2 instanceof Framework) {
            return 0;
        }
        AbstractBundleState b = AbstractBundleState.assertBundleState(bundle2);
        if (b instanceof SystemBundleState) {
            return 0;
        }
        if (b instanceof HostBundleState) {
            return ((HostBundleState)b).getStartLevel();
        }
        return -1;
    }

    public void setBundleStartLevel(Bundle bundle2, int level) {
        if (bundle2.getBundleId() == 0L) {
            throw FrameworkMessages.MESSAGES.illegalArgumentStartLevelOnSystemBundles();
        }
        final FrameworkEventsPlugin eventsPlugin = (FrameworkEventsPlugin)((Object)this.injectedFrameworkEvents.getValue());
        final HostBundleState hostBundle = HostBundleState.assertBundleState(bundle2);
        hostBundle.setStartLevel(level);
        if (level <= this.getStartLevel() && hostBundle.isPersistentlyStarted()) {
            if ((bundle2.getState() & 0x28) > 0) {
                return;
            }
            FrameworkLogger.LOGGER.infoStartingBundleDueToStartLevel(hostBundle);
            this.getExecutorService().execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        int opts = 1;
                        if (StartLevelPlugin.this.isBundleActivationPolicyUsed(hostBundle)) {
                            opts |= 2;
                        }
                        hostBundle.start(opts);
                    }
                    catch (BundleException e) {
                        eventsPlugin.fireFrameworkEvent(hostBundle, 2, e);
                    }
                }
            });
        } else {
            if ((bundle2.getState() & 0x28) == 0) {
                return;
            }
            FrameworkLogger.LOGGER.infoStoppingBundleDueToStartLevel(hostBundle);
            this.getExecutorService().execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        hostBundle.stop(1);
                    }
                    catch (BundleException e) {
                        eventsPlugin.fireFrameworkEvent(hostBundle, 2, e);
                    }
                }
            });
        }
    }

    public synchronized int getInitialBundleStartLevel() {
        return this.initialBundleStartLevel;
    }

    public synchronized void setInitialBundleStartLevel(int startlevel) {
        this.initialBundleStartLevel = startlevel;
    }

    public boolean isBundlePersistentlyStarted(Bundle bundle2) {
        AbstractBundleState bundleState = AbstractBundleState.assertBundleState(bundle2);
        BundleStoragePlugin.InternalStorageState storageState = bundleState.getStorageState();
        return storageState.isPersistentlyStarted();
    }

    public boolean isBundleActivationPolicyUsed(Bundle bundle2) {
        AbstractBundleState bundleState = AbstractBundleState.assertBundleState(bundle2);
        BundleStoragePlugin.InternalStorageState storageState = bundleState.getStorageState();
        return storageState.isBundleActivationPolicyUsed();
    }

    synchronized void increaseStartLevel(int level) {
        BundleManagerPlugin bundleManager = (BundleManagerPlugin)this.injectedBundleManager.getValue();
        Set<Bundle> bundles = bundleManager.getBundles();
        while (this.startLevel < level) {
            ++this.startLevel;
            FrameworkLogger.LOGGER.infoStartingBundlesForStartLevel(level);
            for (Bundle bundle2 : bundles) {
                HostBundleState hostBundle;
                if (!(bundle2 instanceof HostBundleState) || (hostBundle = (HostBundleState)bundle2).getStartLevel() != this.startLevel || !hostBundle.isPersistentlyStarted()) continue;
                try {
                    int opts = 1;
                    if (this.isBundleActivationPolicyUsed(bundle2)) {
                        opts |= 2;
                    }
                    bundle2.start(opts);
                }
                catch (Throwable e) {
                    FrameworkEventsPlugin eventsPlugin = (FrameworkEventsPlugin)((Object)this.injectedFrameworkEvents.getValue());
                    eventsPlugin.fireFrameworkEvent(bundle2, 2, e);
                }
            }
        }
    }

    synchronized void decreaseStartLevel(int level) {
        BundleManagerPlugin bundleManager = (BundleManagerPlugin)this.injectedBundleManager.getValue();
        while (this.startLevel > level) {
            FrameworkLogger.LOGGER.infoStoppingBundlesForStartLevel(level);
            Set<Bundle> bundles = bundleManager.getBundles();
            for (Bundle bundle2 : bundles) {
                HostBundleState hostBundle;
                if (!(bundle2 instanceof HostBundleState) || (hostBundle = (HostBundleState)bundle2).getStartLevel() != this.startLevel) continue;
                try {
                    hostBundle.stopInternal(1);
                }
                catch (Throwable e) {
                    FrameworkEventsPlugin eventsPlugin = (FrameworkEventsPlugin)((Object)this.injectedFrameworkEvents.getValue());
                    eventsPlugin.fireFrameworkEvent(bundle2, 2, e);
                }
            }
            --this.startLevel;
        }
    }
}

