/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import org.jboss.modules.Module;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceName;
import org.jboss.osgi.framework.FrameworkModuleProvider;
import org.jboss.osgi.framework.Services;
import org.jboss.osgi.framework.TypeAdaptor;
import org.jboss.osgi.framework.internal.AbstractBundleContext;
import org.jboss.osgi.framework.internal.AbstractBundleRevision;
import org.jboss.osgi.framework.internal.AbstractBundleState;
import org.jboss.osgi.framework.internal.BundleStoragePlugin;
import org.jboss.osgi.framework.internal.FrameworkMessages;
import org.jboss.osgi.framework.internal.FrameworkState;
import org.jboss.osgi.framework.internal.SystemBundleContext;
import org.jboss.osgi.framework.internal.SystemBundleRevision;
import org.jboss.osgi.metadata.OSGiMetaData;
import org.jboss.osgi.resolver.XEnvironment;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;

final class SystemBundleState
extends AbstractBundleState
implements TypeAdaptor {
    private final FrameworkModuleProvider frameworkModuleProvider;
    private BundleStoragePlugin.InternalStorageState storageState;
    private SystemBundleRevision revision;

    SystemBundleState(FrameworkState frameworkState, FrameworkModuleProvider frameworkModuleProvider) {
        super(frameworkState, 0L, "system.bundle");
        this.frameworkModuleProvider = frameworkModuleProvider;
    }

    static SystemBundleState assertBundleState(Bundle bundle2) {
        bundle2 = AbstractBundleState.assertBundleState(bundle2);
        assert (bundle2 instanceof SystemBundleState) : "Not an SystemBundleState: " + bundle2;
        return (SystemBundleState)bundle2;
    }

    Module getFrameworkModule() {
        return this.frameworkModuleProvider.getFrameworkModule(this);
    }

    SystemBundleRevision createBundleRevision(OSGiMetaData metadata) throws BundleException {
        this.revision = new SystemBundleRevision(this, metadata);
        return this.revision;
    }

    @Override
    List<AbstractBundleRevision> getAllBundleRevisions() {
        return Collections.singletonList(this.revision);
    }

    void createStorageState(BundleStoragePlugin storagePlugin) {
        try {
            this.storageState = storagePlugin.createStorageState(0L, "System Bundle", 0, null);
        }
        catch (IOException ex) {
            throw FrameworkMessages.MESSAGES.illegalStateCannotCreateSystemBundleStorage(ex);
        }
    }

    @Override
    ServiceName getServiceName(int state) {
        return Services.SYSTEM_BUNDLE;
    }

    public String getLocation() {
        return "System Bundle";
    }

    @Override
    public Version getVersion() {
        return Version.emptyVersion;
    }

    @Override
    AbstractBundleContext createContextInternal() {
        return new SystemBundleContext(this);
    }

    @Override
    SystemBundleRevision getCurrentBundleRevision() {
        return this.revision;
    }

    @Override
    BundleStoragePlugin.InternalStorageState getStorageState() {
        return this.storageState;
    }

    @Override
    public <T> T adapt(Class<T> type) {
        ServiceContainer result = null;
        if (type.isAssignableFrom(ServiceContainer.class)) {
            result = this.getBundleManager().getServiceContainer();
        } else if (type.isAssignableFrom(XEnvironment.class)) {
            result = this.getFrameworkState().getEnvironment();
        }
        return (T)result;
    }

    @Override
    boolean isFragment() {
        return false;
    }

    @Override
    boolean isSingleton() {
        return true;
    }

    @Override
    SystemBundleRevision getBundleRevisionById(int revisionId) {
        assert (revisionId == 0) : "System bundle does not have a revision with id: " + revisionId;
        return this.revision;
    }

    @Override
    void startInternal(int options) throws BundleException {
    }

    @Override
    void stopInternal(int options) throws BundleException {
    }

    @Override
    void updateInternal(InputStream input) throws BundleException {
    }

    @Override
    void uninstallInternal() throws BundleException {
        throw FrameworkMessages.MESSAGES.bundleCannotUninstallSystemBundle();
    }
}

