/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.EscapeSelector;
import org.jboss.as.cli.SecurityActions;
import org.jboss.as.cli.operation.OperationFormatException;
import org.jboss.as.cli.operation.OperationRequestAddress;
import org.jboss.as.cli.operation.impl.DefaultOperationRequestBuilder;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public class Util {
    public static final String ACCESS_TYPE = "access-type";
    public static final String ADD = "add";
    public static final String ADDRESS = "address";
    public static final String ALLOWED = "allowed";
    public static final String ALLOW_RESOURCE_SERVICE_RESTART = "allow-resource-service-restart";
    public static final String ARCHIVE = "archive";
    public static final String ATTRIBUTES = "attributes";
    public static final String BYTES = "bytes";
    public static final String CHILDREN = "children";
    public static final String CHILD_TYPE = "child-type";
    public static final String COMPOSITE = "composite";
    public static final String CONCURRENT_GROUPS = "concurrent-groups";
    public static final String CONTENT = "content";
    public static final String DATASOURCES = "datasources";
    public static final String DEPLOY = "deploy";
    public static final String DEPLOYMENT = "deployment";
    public static final String DEPLOYMENT_NAME = "deployment-name";
    public static final String DESCRIPTION = "description";
    public static final String DOMAIN_FAILURE_DESCRIPTION = "domain-failure-description";
    public static final String DOMAIN_RESULTS = "domain-results";
    public static final String DRIVER_MODULE_NAME = "driver-module-name";
    public static final String DRIVER_NAME = "driver-name";
    public static final String ENABLED = "enabled";
    public static final String EXPRESSIONS_ALLOWED = "expressions-allowed";
    public static final String FAILURE_DESCRIPTION = "failure-description";
    public static final String FULL_REPLACE_DEPLOYMENT = "full-replace-deployment";
    public static final String FALSE = "false";
    public static final String HEAD_COMMENT_ALLOWED = "head-comment-allowed";
    public static final String HOST = "host";
    public static final String ID = "id";
    public static final String IN_SERIES = "in-series";
    public static final String INCLUDE_DEFAULTS = "include-defaults";
    public static final String INCLUDE_RUNTIME = "include-runtime";
    public static final String INPUT_STREAM_INDEX = "input-stream-index";
    public static final String INSTALLED_DRIVERS_LIST = "installed-drivers-list";
    public static final String MANAGEMENT_CLIENT_CONTENT = "management-client-content";
    public static final String MAX_FAILED_SERVERS = "max-failed-servers";
    public static final String MAX_FAILURE_PERCENTAGE = "max-failure-percentage";
    public static final String MAX_OCCURS = "max-occurs";
    public static final String MIN_OCCURS = "min-occurs";
    public static final String MODULE_SLOT = "module-slot";
    public static final String NAME = "name";
    public static final String NILLABLE = "nillable";
    public static final String OPERATION = "operation";
    public static final String OPERATION_HEADERS = "operation-headers";
    public static final String OUTCOME = "outcome";
    public static final String PATH = "path";
    public static final String PERSISTENT = "persistent";
    public static final String PRODUCT_NAME = "product-name";
    public static final String PRODUCT_VERSION = "product-version";
    public static final String PROFILE = "profile";
    public static final String READ_ATTRIBUTE = "read-attribute";
    public static final String READ_CHILDREN_NAMES = "read-children-names";
    public static final String READ_CHILDREN_RESOURCES = "read-children-resources";
    public static final String READ_CHILDREN_TYPES = "read-children-types";
    public static final String READ_ONLY = "read-only";
    public static final String READ_OPERATION_DESCRIPTION = "read-operation-description";
    public static final String READ_OPERATION_NAMES = "read-operation-names";
    public static final String READ_WRITE = "read-write";
    public static final String READ_RESOURCE = "read-resource";
    public static final String READ_RESOURCE_DESCRIPTION = "read-resource-description";
    public static final String RELEASE_CODENAME = "release-codename";
    public static final String RELEASE_VERSION = "release-version";
    public static final String REPLY_PROPERTIES = "reply-properties";
    public static final String REQUEST_PROPERTIES = "request-properties";
    public static final String REQUIRED = "required";
    public static final String RESTART_REQUIRED = "restart-required";
    public static final String RESULT = "result";
    public static final String ROLLBACK_ACROSS_GROUPS = "rollback-across-groups";
    public static final String ROLLBACK_ON_RUNTIME_FAILURE = "rollback-on-runtime-failure";
    public static final String ROLLING_TO_SERVERS = "rolling-to-servers";
    public static final String ROLLOUT_PLAN = "rollout-plan";
    public static final String ROLLOUT_PLANS = "rollout-plans";
    public static final String RUNTIME_NAME = "runtime-name";
    public static final String SERVER = "server";
    public static final String SERVER_GROUP = "server-group";
    public static final String STATUS = "status";
    public static final String STEP_1 = "step-1";
    public static final String STEP_2 = "step-2";
    public static final String STEP_3 = "step-3";
    public static final String STEPS = "steps";
    public static final String STORAGE = "storage";
    public static final String SUBSYSTEM = "subsystem";
    public static final String SUCCESS = "success";
    public static final String TAIL_COMMENT_ALLOWED = "tail-comment-allowed";
    public static final String TRUE = "true";
    public static final String TYPE = "type";
    public static final String UNDEFINE_ATTRIBUTE = "undefine-attribute";
    public static final String VALID = "valid";
    public static final String VALIDATE_ADDRESS = "validate-address";
    public static final String VALUE = "value";
    public static final String VALUE_TYPE = "value-type";
    public static final String WRITE_ATTRIBUTE = "write-attribute";

    public static boolean isWindows() {
        return SecurityActions.getSystemProperty("os.name").toLowerCase(Locale.ENGLISH).indexOf("windows") >= 0;
    }

    public static boolean isSuccess(ModelNode operationResult) {
        if (operationResult != null) {
            return operationResult.hasDefined(OUTCOME) && operationResult.get(OUTCOME).asString().equals(SUCCESS);
        }
        return false;
    }

    public static String getFailureDescription(ModelNode operationResult) {
        if (operationResult == null) {
            return null;
        }
        ModelNode descr = operationResult.get(FAILURE_DESCRIPTION);
        if (descr == null) {
            return null;
        }
        if (descr.hasDefined(DOMAIN_FAILURE_DESCRIPTION)) {
            descr = descr.get(DOMAIN_FAILURE_DESCRIPTION);
        }
        return descr.asString();
    }

    public static List<String> getList(ModelNode operationResult) {
        if (!operationResult.hasDefined(RESULT)) {
            return Collections.emptyList();
        }
        List nodeList = operationResult.get(RESULT).asList();
        if (nodeList.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> list = new ArrayList<String>(nodeList.size());
        for (ModelNode node : nodeList) {
            list.add(node.asString());
        }
        return list;
    }

    public static boolean listContains(ModelNode operationResult, String item) {
        if (!operationResult.hasDefined(RESULT)) {
            return false;
        }
        List nodeList = operationResult.get(RESULT).asList();
        if (nodeList.isEmpty()) {
            return false;
        }
        for (ModelNode node : nodeList) {
            if (!node.asString().equals(item)) continue;
            return true;
        }
        return false;
    }

    public static List<String> getRequestPropertyNames(ModelNode operationResult) {
        if (!operationResult.hasDefined(RESULT)) {
            return Collections.emptyList();
        }
        ModelNode result = operationResult.get(RESULT);
        if (!result.hasDefined(REQUEST_PROPERTIES)) {
            return Collections.emptyList();
        }
        List nodeList = result.get(REQUEST_PROPERTIES).asPropertyList();
        if (nodeList.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> list = new ArrayList<String>(nodeList.size());
        for (Property node : nodeList) {
            list.add(node.getName());
        }
        return list;
    }

    public static boolean isDeploymentInRepository(String name, ModelControllerClient client) {
        return Util.getDeployments(client).contains(name);
    }

    public static boolean isDeployedAndEnabledInStandalone(String name, ModelControllerClient client) {
        ModelNode outcome;
        ModelNode request;
        DefaultOperationRequestBuilder builder;
        block12: {
            builder = new DefaultOperationRequestBuilder();
            try {
                builder.setOperationName(READ_CHILDREN_NAMES);
                builder.addProperty(CHILD_TYPE, DEPLOYMENT);
                request = builder.buildRequest();
            }
            catch (OperationFormatException e) {
                throw new IllegalStateException("Failed to build operation", e);
            }
            try {
                outcome = client.execute(request);
                if (Util.isSuccess(outcome)) {
                    if (!Util.listContains(outcome, name)) {
                        return false;
                    }
                    break block12;
                }
                return false;
            }
            catch (Exception e) {
                return false;
            }
        }
        builder = new DefaultOperationRequestBuilder();
        builder.addNode(DEPLOYMENT, name);
        builder.setOperationName(READ_ATTRIBUTE);
        builder.addProperty(NAME, ENABLED);
        try {
            request = builder.buildRequest();
        }
        catch (OperationFormatException e) {
            throw new IllegalStateException("Failed to build operation", e);
        }
        try {
            outcome = client.execute(request);
            if (Util.isSuccess(outcome)) {
                if (!outcome.hasDefined(RESULT)) {
                    return false;
                }
                return outcome.get(RESULT).asBoolean();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return false;
    }

    public static List<String> getAllEnabledServerGroups(String deploymentName, ModelControllerClient client) {
        List<String> serverGroups = Util.getServerGroups(client);
        if (serverGroups.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String serverGroup : serverGroups) {
            ModelNode outcome;
            ModelNode request;
            DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
            try {
                builder.setOperationName(READ_CHILDREN_NAMES);
                builder.addNode(SERVER_GROUP, serverGroup);
                builder.addProperty(CHILD_TYPE, DEPLOYMENT);
                request = builder.buildRequest();
            }
            catch (OperationFormatException e) {
                throw new IllegalStateException("Failed to build operation", e);
            }
            try {
                outcome = client.execute(request);
                if (!Util.isSuccess(outcome)) continue;
                if (!Util.listContains(outcome, deploymentName)) {
                }
            }
            catch (Exception e) {}
            continue;
            builder = new DefaultOperationRequestBuilder();
            builder.addNode(SERVER_GROUP, serverGroup);
            builder.addNode(DEPLOYMENT, deploymentName);
            builder.setOperationName(READ_ATTRIBUTE);
            builder.addProperty(NAME, ENABLED);
            try {
                request = builder.buildRequest();
            }
            catch (OperationFormatException e) {
                throw new IllegalStateException("Failed to build operation", e);
            }
            try {
                outcome = client.execute(request);
                if (!Util.isSuccess(outcome) || !outcome.hasDefined(RESULT) || !outcome.get(RESULT).asBoolean()) continue;
                result.add(serverGroup);
            }
            catch (Exception e) {}
        }
        return result;
    }

    public static List<String> getAllReferencingServerGroups(String deploymentName, ModelControllerClient client) {
        List<String> serverGroups = Util.getServerGroups(client);
        if (serverGroups.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String serverGroup : serverGroups) {
            ModelNode request;
            DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
            try {
                builder.setOperationName(READ_CHILDREN_NAMES);
                builder.addNode(SERVER_GROUP, serverGroup);
                builder.addProperty(CHILD_TYPE, DEPLOYMENT);
                request = builder.buildRequest();
            }
            catch (OperationFormatException e) {
                throw new IllegalStateException("Failed to build operation", e);
            }
            try {
                ModelNode outcome = client.execute(request);
                if (!Util.isSuccess(outcome) || !Util.listContains(outcome, deploymentName)) continue;
                result.add(serverGroup);
            }
            catch (Exception e) {}
        }
        return result;
    }

    public static List<String> getDeployments(ModelControllerClient client) {
        ModelNode request;
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        try {
            builder.setOperationName(READ_CHILDREN_NAMES);
            builder.addProperty(CHILD_TYPE, DEPLOYMENT);
            request = builder.buildRequest();
        }
        catch (OperationFormatException e) {
            throw new IllegalStateException("Failed to build operation", e);
        }
        try {
            ModelNode outcome = client.execute(request);
            if (Util.isSuccess(outcome)) {
                return Util.getList(outcome);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Collections.emptyList();
    }

    public static List<String> getServerGroups(ModelControllerClient client) {
        ModelNode request;
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        try {
            builder.setOperationName(READ_CHILDREN_NAMES);
            builder.addProperty(CHILD_TYPE, SERVER_GROUP);
            request = builder.buildRequest();
        }
        catch (OperationFormatException e) {
            throw new IllegalStateException("Failed to build operation", e);
        }
        try {
            ModelNode outcome = client.execute(request);
            if (Util.isSuccess(outcome)) {
                return Util.getList(outcome);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Collections.emptyList();
    }

    public static List<String> getNodeTypes(ModelControllerClient client, OperationRequestAddress address) {
        List<String> result;
        ModelNode request;
        if (client == null) {
            return Collections.emptyList();
        }
        if (address.endsOnType()) {
            throw new IllegalArgumentException("The prefix isn't expected to end on a type.");
        }
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder(address);
        try {
            builder.setOperationName(READ_CHILDREN_TYPES);
            request = builder.buildRequest();
        }
        catch (OperationFormatException e1) {
            throw new IllegalStateException("Failed to build operation", e1);
        }
        try {
            ModelNode outcome = client.execute(request);
            result = !Util.isSuccess(outcome) ? Collections.emptyList() : Util.getList(outcome);
        }
        catch (Exception e) {
            result = Collections.emptyList();
        }
        return result;
    }

    public static List<String> getNodeNames(ModelControllerClient client, OperationRequestAddress address, String type) {
        List<String> result;
        ModelNode request;
        if (client == null) {
            return Collections.emptyList();
        }
        if (address != null && address.endsOnType()) {
            throw new IllegalArgumentException("The address isn't expected to end on a type.");
        }
        DefaultOperationRequestBuilder builder = address == null ? new DefaultOperationRequestBuilder() : new DefaultOperationRequestBuilder(address);
        try {
            builder.setOperationName(READ_CHILDREN_NAMES);
            builder.addProperty(CHILD_TYPE, type);
            request = builder.buildRequest();
        }
        catch (OperationFormatException e1) {
            throw new IllegalStateException("Failed to build operation", e1);
        }
        try {
            ModelNode outcome = client.execute(request);
            result = !Util.isSuccess(outcome) ? Collections.emptyList() : Util.getList(outcome);
        }
        catch (Exception e) {
            result = Collections.emptyList();
        }
        return result;
    }

    public static List<String> getJmsResources(ModelControllerClient client, String profile, String type) {
        ModelNode request;
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        try {
            if (profile != null) {
                builder.addNode(PROFILE, profile);
            }
            builder.addNode(SUBSYSTEM, "messaging");
            builder.setOperationName(READ_CHILDREN_NAMES);
            builder.addProperty(CHILD_TYPE, type);
            request = builder.buildRequest();
        }
        catch (OperationFormatException e) {
            throw new IllegalStateException("Failed to build operation", e);
        }
        try {
            ModelNode outcome = client.execute(request);
            if (Util.isSuccess(outcome)) {
                return Util.getList(outcome);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return Collections.emptyList();
    }

    public static List<String> getDatasources(ModelControllerClient client, String profile, String dsType) {
        ModelNode request;
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        try {
            if (profile != null) {
                builder.addNode(PROFILE, profile);
            }
            builder.addNode(SUBSYSTEM, DATASOURCES);
            builder.setOperationName(READ_CHILDREN_NAMES);
            builder.addProperty(CHILD_TYPE, dsType);
            request = builder.buildRequest();
        }
        catch (OperationFormatException e) {
            throw new IllegalStateException("Failed to build operation", e);
        }
        try {
            ModelNode outcome = client.execute(request);
            if (Util.isSuccess(outcome)) {
                return Util.getList(outcome);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return Collections.emptyList();
    }

    public static boolean isTopic(ModelControllerClient client, String name) {
        List<String> topics = Util.getJmsResources(client, null, "jms-topic");
        return topics.contains(name);
    }

    public static boolean isQueue(ModelControllerClient client, String name) {
        List<String> queues = Util.getJmsResources(client, null, "jms-queue");
        return queues.contains(name);
    }

    public static boolean isConnectionFactory(ModelControllerClient client, String name) {
        List<String> cf = Util.getJmsResources(client, null, "connection-factory");
        return cf.contains(name);
    }

    public static ModelNode configureDeploymentOperation(String operationName, String uniqueName, String serverGroup) {
        ModelNode op = new ModelNode();
        op.get(OPERATION).set(operationName);
        if (serverGroup != null) {
            op.get(ADDRESS).add(SERVER_GROUP, serverGroup);
        }
        op.get(ADDRESS).add(DEPLOYMENT, uniqueName);
        return op;
    }

    public static String getCommonStart(List<String> list) {
        int size = list.size();
        if (size == 0) {
            return null;
        }
        if (size == 1) {
            return list.get(0);
        }
        String first = list.get(0);
        String last = list.get(size - 1);
        int minSize = Math.min(first.length(), last.length());
        for (int i = 0; i < minSize; ++i) {
            if (first.charAt(i) == last.charAt(i)) continue;
            if (i == 0) {
                return null;
            }
            return first.substring(0, i);
        }
        return first.substring(0, minSize);
    }

    public static String escapeString(String name, EscapeSelector selector) {
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (!selector.isEscape(ch)) continue;
            StringBuilder builder = new StringBuilder();
            builder.append(name, 0, i);
            builder.append('\\').append(ch);
            for (int j = i + 1; j < name.length(); ++j) {
                ch = name.charAt(j);
                if (selector.isEscape(ch)) {
                    builder.append('\\');
                }
                builder.append(ch);
            }
            return builder.toString();
        }
        return name;
    }

    public static void sortAndEscape(List<String> candidates, EscapeSelector selector) {
        Collections.sort(candidates);
        String common = Util.getCommonStart(candidates);
        if (common != null) {
            String escapedCommon = Util.escapeString(common, selector);
            if (common.length() != escapedCommon.length()) {
                for (int i = 0; i < candidates.size(); ++i) {
                    candidates.set(i, escapedCommon + candidates.get(i).substring(common.length()));
                }
            }
        }
    }

    public static void setRequestProperty(ModelNode request, String name, String value) {
        if (name == null || name.trim().isEmpty()) {
            throw new IllegalArgumentException("The argument name is not specified: '" + name + "'");
        }
        if (value == null || value.trim().isEmpty()) {
            throw new IllegalArgumentException("The argument value is not specified: '" + value + "'");
        }
        ModelNode toSet = null;
        try {
            toSet = ModelNode.fromString((String)value);
        }
        catch (Exception e) {
            toSet = new ModelNode().set(value);
        }
        request.get(name).set(toSet);
    }

    public static ModelNode buildRequest(CommandContext ctx, OperationRequestAddress address, String operation) throws CommandFormatException {
        ModelNode request = new ModelNode();
        request.get(OPERATION).set(operation);
        ModelNode addressNode = request.get(ADDRESS);
        if (address.isEmpty()) {
            addressNode.setEmptyList();
        } else {
            if (address.endsOnType()) {
                throw new CommandFormatException("The address ends on a type: " + address.getNodeType());
            }
            for (OperationRequestAddress.Node node : address) {
                addressNode.add(node.getType(), node.getName());
            }
        }
        return request;
    }

    public static ModelNode getRolloutPlan(ModelControllerClient client, String name) throws CommandFormatException {
        ModelNode response;
        ModelNode request = new ModelNode();
        request.get(OPERATION).set(READ_ATTRIBUTE);
        ModelNode addr = request.get(ADDRESS);
        addr.add(MANAGEMENT_CLIENT_CONTENT, ROLLOUT_PLANS);
        addr.add(ROLLOUT_PLAN, name);
        request.get(NAME).set(CONTENT);
        try {
            response = client.execute(request);
        }
        catch (IOException e) {
            throw new CommandFormatException("Failed to execute request: " + e.getMessage(), e);
        }
        if (!response.hasDefined(OUTCOME)) {
            throw new CommandFormatException("Operation response if missing outcome: " + response);
        }
        if (!response.get(OUTCOME).asString().equals(SUCCESS)) {
            throw new CommandFormatException("Failed to load rollout plan: " + response);
        }
        if (!response.hasDefined(RESULT)) {
            throw new CommandFormatException("Operation response is missing result.");
        }
        return response.get(RESULT);
    }
}

