/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.journal.impl.dataformat;

import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.core.journal.EncodingSupport;
import org.hornetq.core.journal.impl.dataformat.JournalInternalRecord;

public class JournalCompleteRecordTX
extends JournalInternalRecord {
    private final boolean isCommit;
    public final long txID;
    private final EncodingSupport transactionData;
    private int numberOfRecords;

    public JournalCompleteRecordTX(boolean isCommit, long txID, EncodingSupport transactionData) {
        this.isCommit = isCommit;
        this.txID = txID;
        this.transactionData = transactionData;
    }

    @Override
    public void encode(HornetQBuffer buffer) {
        if (this.isCommit) {
            buffer.writeByte((byte)18);
        } else {
            buffer.writeByte((byte)17);
        }
        buffer.writeInt(this.fileID);
        buffer.writeByte(this.compactCount);
        buffer.writeLong(this.txID);
        buffer.writeInt(this.numberOfRecords);
        if (this.transactionData != null) {
            buffer.writeInt(this.transactionData.getEncodeSize());
        }
        if (this.transactionData != null) {
            this.transactionData.encode(buffer);
        }
        buffer.writeInt(this.getEncodeSize());
    }

    @Override
    public void setNumberOfRecords(int records) {
        this.numberOfRecords = records;
    }

    @Override
    public int getNumberOfRecords() {
        return this.numberOfRecords;
    }

    @Override
    public int getEncodeSize() {
        if (this.isCommit) {
            return 22;
        }
        return 25 + (this.transactionData != null ? this.transactionData.getEncodeSize() : 0) + 1;
    }
}

