/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web;

import java.lang.reflect.InvocationTargetException;
import javax.naming.NamingException;
import javax.servlet.Servlet;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Loader;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.startup.ContextConfig;
import org.apache.tomcat.InstanceManager;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.server.mgmt.domain.HttpManagement;
import org.jboss.as.web.VirtualHost;
import org.jboss.as.web.WebLogger;
import org.jboss.as.web.WebMessages;
import org.jboss.as.web.WelcomeContextConsoleServlet;
import org.jboss.as.web.deployment.WebCtxLoader;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

class WelcomeContextService
implements Service<Context> {
    private final StandardContext context;
    private final InjectedValue<PathManager> pathManagerInjector = new InjectedValue();
    private final InjectedValue<VirtualHost> hostInjector = new InjectedValue();
    private final InjectedValue<HttpManagement> httpManagementInjector = new InjectedValue();
    private final String homeDirPathName;
    private PathManager.Callback.Handle callbackHandle;

    public WelcomeContextService(String homeDirPathName) {
        this.context = new StandardContext();
        this.homeDirPathName = homeDirPathName;
    }

    public synchronized void start(StartContext startContext) throws StartException {
        HttpManagement httpManagement = (HttpManagement)this.httpManagementInjector.getOptionalValue();
        try {
            this.context.setPath("");
            this.context.addLifecycleListener((LifecycleListener)new ContextConfig());
            this.context.setDocBase(((PathManager)this.pathManagerInjector.getValue()).resolveRelativePathEntry("welcome-content", this.homeDirPathName));
            this.callbackHandle = ((PathManager)this.pathManagerInjector.getValue()).registerCallback(this.homeDirPathName, PathManager.ReloadServerCallback.create(), new PathManager.Event[]{PathManager.Event.UPDATED, PathManager.Event.REMOVED});
            WebCtxLoader loader = new WebCtxLoader(this.getClass().getClassLoader());
            Host host = ((VirtualHost)this.hostInjector.getValue()).getHost();
            loader.setContainer((Container)host);
            this.context.setLoader((Loader)loader);
            this.context.setInstanceManager((InstanceManager)new LocalInstanceManager(httpManagement));
            this.context.setReplaceWelcomeFiles(true);
            if (httpManagement != null) {
                this.context.addWelcomeFile("index.html");
            } else {
                this.context.addWelcomeFile("index_noconsole.html");
            }
            Wrapper wrapper = this.context.createWrapper();
            wrapper.setName("default");
            wrapper.setServletClass("org.apache.catalina.servlets.DefaultServlet");
            this.context.addChild((Container)wrapper);
            this.context.addServletMapping("/", "default");
            this.context.addMimeMapping("html", "text/html");
            this.context.addMimeMapping("jpg", "image/jpeg");
            WelcomeContextConsoleServlet wccs = new WelcomeContextConsoleServlet(httpManagement);
            Wrapper wccsWrapper = this.context.createWrapper();
            wccsWrapper.setName("WelcomeContextConsoleServlet");
            wccsWrapper.setServlet((Servlet)wccs);
            wccsWrapper.setServletClass(((Object)((Object)wccs)).getClass().getName());
            this.context.addChild((Container)wccsWrapper);
            this.context.addServletMapping("/console", "WelcomeContextConsoleServlet");
            host.addChild((Container)this.context);
            this.context.create();
        }
        catch (Exception e) {
            throw new StartException(WebMessages.MESSAGES.createWelcomeContextFailed(), (Throwable)e);
        }
        try {
            this.context.start();
        }
        catch (LifecycleException e) {
            throw new StartException(WebMessages.MESSAGES.startWelcomeContextFailed(), (Throwable)e);
        }
    }

    public synchronized void stop(StopContext stopContext) {
        if (this.callbackHandle != null) {
            this.callbackHandle.remove();
        }
        try {
            ((VirtualHost)this.hostInjector.getValue()).getHost().removeChild((Container)this.context);
            this.context.stop();
        }
        catch (LifecycleException e) {
            WebLogger.WEB_LOGGER.stopWelcomeContextFailed(e);
        }
        try {
            this.context.destroy();
        }
        catch (Exception e) {
            WebLogger.WEB_LOGGER.destroyWelcomeContextFailed(e);
        }
    }

    public synchronized Context getValue() throws IllegalStateException {
        StandardContext context = this.context;
        if (context == null) {
            throw WebMessages.MESSAGES.nullValue();
        }
        return context;
    }

    public InjectedValue<PathManager> getPathManagerInjector() {
        return this.pathManagerInjector;
    }

    public InjectedValue<VirtualHost> getHostInjector() {
        return this.hostInjector;
    }

    public Injector<HttpManagement> getHttpManagementInjector() {
        return this.httpManagementInjector;
    }

    private static class LocalInstanceManager
    implements InstanceManager {
        private final HttpManagement httpManagement;

        LocalInstanceManager(HttpManagement httpManagement) {
            this.httpManagement = httpManagement;
        }

        public Object newInstance(String className) throws IllegalAccessException, InvocationTargetException, NamingException, InstantiationException, ClassNotFoundException {
            if (!className.equals(WelcomeContextConsoleServlet.class.getName())) {
                return Class.forName(className).newInstance();
            }
            WelcomeContextConsoleServlet wccs = new WelcomeContextConsoleServlet(this.httpManagement);
            return wccs;
        }

        public Object newInstance(String fqcn, ClassLoader classLoader) throws IllegalAccessException, InvocationTargetException, NamingException, InstantiationException, ClassNotFoundException {
            return Class.forName(fqcn, false, classLoader).newInstance();
        }

        public Object newInstance(Class<?> c) throws IllegalAccessException, InvocationTargetException, NamingException, InstantiationException {
            return c.newInstance();
        }

        public void newInstance(Object o) throws IllegalAccessException, InvocationTargetException, NamingException {
            throw new IllegalStateException();
        }

        public void destroyInstance(Object o) throws IllegalAccessException, InvocationTargetException {
        }
    }
}

