/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.txn.subsystem;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.txn.subsystem.LogStoreConstants;
import org.jboss.as.txn.subsystem.LogStoreResource;
import org.jboss.as.txn.subsystem.TransactionExtension;
import org.jboss.dmr.ModelNode;

public class LogStoreProbeHandler
implements OperationStepHandler {
    static final LogStoreProbeHandler INSTANCE = new LogStoreProbeHandler();
    static final String osMBeanName = "jboss.jta:type=ObjectStore";
    static final String JNDI_PROPNAME = LogStoreConstants.MODEL_TO_JMX_PARTICIPANT_NAMES.get("jndi-name");

    private Map<String, String> getMBeanValues(MBeanServerConnection cnx, ObjectName on, String ... attributeNames) throws InstanceNotFoundException, IOException, ReflectionException, IntrospectionException {
        if (attributeNames == null) {
            MBeanInfo info = cnx.getMBeanInfo(on);
            MBeanAttributeInfo[] attributeArray = info.getAttributes();
            int i = 0;
            attributeNames = new String[attributeArray.length];
            for (MBeanAttributeInfo ai : attributeArray) {
                attributeNames[i++] = ai.getName();
            }
        }
        AttributeList attributes = cnx.getAttributes(on, attributeNames);
        HashMap<String, String> values = new HashMap<String, String>();
        for (Attribute attribute : attributes.asList()) {
            Object value = attribute.getValue();
            values.put(attribute.getName(), value == null ? "" : value.toString());
        }
        return values;
    }

    private void addAttributes(ModelNode node, Map<String, String> model2JmxNames, Map<String, String> attributes) {
        for (Map.Entry<String, String> e : model2JmxNames.entrySet()) {
            String attributeValue = attributes.get(e.getValue());
            if (attributeValue == null) continue;
            node.get(e.getKey()).set(attributeValue);
        }
    }

    private void addParticipants(Resource parent, Set<ObjectInstance> participants, MBeanServer mbs) throws IntrospectionException, InstanceNotFoundException, IOException, ReflectionException {
        int i = 1;
        for (ObjectInstance participant : participants) {
            LogStoreResource.LogStoreRuntimeResource resource = new LogStoreResource.LogStoreRuntimeResource(participant.getObjectName());
            ModelNode model = resource.getModel();
            Map<String, String> pAttributes = this.getMBeanValues(mbs, participant.getObjectName(), LogStoreConstants.PARTICIPANT_JMX_NAMES);
            String pAddress = pAttributes.get(JNDI_PROPNAME);
            if (pAddress == null || pAddress.length() == 0) {
                pAttributes.put(JNDI_PROPNAME, String.valueOf(i++));
                pAddress = pAttributes.get(JNDI_PROPNAME);
            }
            this.addAttributes(model, LogStoreConstants.MODEL_TO_JMX_PARTICIPANT_NAMES, pAttributes);
            PathElement element = PathElement.pathElement((String)"participants", (String)pAddress);
            parent.registerChild(element, (Resource)resource);
        }
    }

    private void addTransactions(Resource parent, Set<ObjectInstance> transactions, MBeanServer mbs) throws IntrospectionException, InstanceNotFoundException, IOException, ReflectionException, MalformedObjectNameException {
        for (ObjectInstance oi : transactions) {
            String transactionId = oi.getObjectName().getCanonicalName();
            if (transactionId.contains("puid") || !transactionId.contains("itype")) continue;
            LogStoreResource.LogStoreRuntimeResource transaction = new LogStoreResource.LogStoreRuntimeResource(oi.getObjectName());
            ModelNode model = transaction.getModel();
            Map<String, String> tAttributes = this.getMBeanValues(mbs, oi.getObjectName(), LogStoreConstants.TXN_JMX_NAMES);
            String txnId = tAttributes.get("Id");
            this.addAttributes(model, LogStoreConstants.MODEL_TO_JMX_TXN_NAMES, tAttributes);
            String participantQuery = transactionId + ",puid=*";
            Set<ObjectInstance> participants = mbs.queryMBeans(new ObjectName(participantQuery), null);
            this.addParticipants((Resource)transaction, participants, mbs);
            PathElement element = PathElement.pathElement((String)"transactions", (String)txnId);
            parent.registerChild(element, (Resource)transaction);
        }
    }

    private Resource probeTransactions(MBeanServer mbs) throws OperationFailedException {
        try {
            ObjectName on = new ObjectName(osMBeanName);
            mbs.invoke(on, "probe", null, null);
            Set<ObjectInstance> transactions = mbs.queryMBeans(new ObjectName("jboss.jta:type=ObjectStore,*"), null);
            Resource resource = Resource.Factory.create();
            this.addTransactions(resource, transactions, mbs);
            return resource;
        }
        catch (JMException e) {
            throw new OperationFailedException("Transaction discovery error: ", (Throwable)e);
        }
        catch (IOException e) {
            throw new OperationFailedException("Transaction discovery error: ", (Throwable)e);
        }
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        if (!context.isNormalServer()) {
            context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
            return;
        }
        MBeanServer mbs = TransactionExtension.getMBeanServer(context);
        if (mbs != null) {
            Resource resource = context.readResource(PathAddress.EMPTY_ADDRESS);
            assert (resource instanceof LogStoreResource);
            LogStoreResource logStore = (LogStoreResource)resource;
            context.acquireControllerLock();
            Resource storeModel = this.probeTransactions(mbs);
            logStore.update(storeModel);
        }
        context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
    }
}

