/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.plugins;

import java.security.Principal;
import javax.security.auth.Subject;
import org.jboss.logging.Logger;
import org.jboss.security.AuthenticationManager;
import org.jboss.security.ISecurityManagement;
import org.jboss.security.SubjectFactory;
import org.jboss.security.auth.callback.JBossCallbackHandler;
import org.jboss.security.plugins.DefaultSecurityManagement;
import org.jboss.security.plugins.SubjectActions;

public class JBossSecuritySubjectFactory
implements SubjectFactory {
    private static Logger log = Logger.getLogger(JBossSecuritySubjectFactory.class);
    private ISecurityManagement securityManagement;

    public Subject createSubject() {
        return this.createSubject("other");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Subject createSubject(String securityDomainName) {
        if (this.securityManagement == null) {
            log.warn((Object)"SecurityManagement is not set. Creating a default one");
            this.securityManagement = new DefaultSecurityManagement(new JBossCallbackHandler());
        }
        Subject subject = new Subject();
        Principal principal = SubjectActions.getPrincipal();
        AuthenticationManager authenticationManager = this.securityManagement.getAuthenticationManager(securityDomainName);
        if (authenticationManager == null) {
            String defaultSecurityDomain = "other";
            if (log.isTraceEnabled()) {
                log.trace((Object)("AuthenticationManager for " + securityDomainName + " not found. Using " + defaultSecurityDomain));
            }
            authenticationManager = this.securityManagement.getAuthenticationManager(defaultSecurityDomain);
        }
        ClassLoader tccl = SubjectActions.getContextClassLoader();
        try {
            SubjectActions.setContextClassLoader(this.getClass().getClassLoader());
            if (!authenticationManager.isValid(principal, SubjectActions.getCredential(), subject)) {
                throw new SecurityException("PB00024: Access Denied:Unauthenticated caller:" + principal);
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            SubjectActions.setContextClassLoader(tccl);
            throw throwable;
        }
        SubjectActions.setContextClassLoader(tccl);
        return subject;
    }

    public void setSecurityManagement(ISecurityManagement securityManagement) {
        this.securityManagement = securityManagement;
    }
}

